/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import common.vis.ColorMaps;
import inferno.data2.ANode;
import inferno.geom.ConnectedMesh;
import inferno.geom.ValueFld;
import inferno.sim.KB;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RenderUtil;
import java.nio.DoubleBuffer;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;

public class RendNode
implements IRenderer<ANode> {
    private ColorMaps.IColorMap d_colors = ColorMaps.RAINBOW2;
    private final WeakHashMap<ANode, Float> d_maxDists = new WeakHashMap();
    private final DoubleBuffer d_matrixBuffer = RenderUtil.toGLTransform(GeomConstants.IDENTITY4d);

    @Override
    public void renderOpaque(GLView view, KB kb, ANode obj) throws Exception {
        boolean showAllDoorDists;
        if (!RenderUtil.isVisible(view, kb, obj)) {
            return;
        }
        ANode.SubMesh subMesh = obj.hasSubMesh() ? obj.getSubMesh(kb) : null;
        boolean animating = RenderUtil.isAnimating(view, kb, obj);
        if (animating) {
            GL11.glPushMatrix();
            GL11.glMultMatrix(RenderUtil.toGLTransform(obj.getAnimXform(), this.d_matrixBuffer));
        }
        boolean showDoorDists = !view.getFilters().isFilteringAllOf(FILTER_DOOR_DISTS.class) && obj.hasDoorDistMap();
        boolean bl = showAllDoorDists = !view.getFilters().isFilteringAllOf(FILTER_ALL_DOOR_DISTS.class) && obj.hasAllDoorDistMap(kb);
        if (subMesh != null) {
            Consumer<ValueFld> showDists = dists -> {
                GL11.glPushAttrib(9);
                float maxDist = this.d_maxDists.computeIfAbsent(obj, n -> Float.valueOf((float)IntStream.range(0, dists.mesh.verts.length).mapToDouble(dists.vertVals).parallel().max().orElse(0.0))).floatValue();
                float imaxdist = maxDist == 0.0f ? 0.0f : 1.0f / maxDist;
                GL11.glEnable(32823);
                GL11.glPolygonOffset(-1.0f, -1.0f);
                GL11.glPolygonMode(1032, 6914);
                GL11.glBegin(4);
                float[] color = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
                for (ConnectedMesh.Tri tri : subMesh.mesh.tris) {
                    for (ConnectedMesh.Vertex vert : tri.verts) {
                        float dist = (float)dists.vertVals.applyAsDouble(vert.id);
                        float intensity = dist * imaxdist;
                        this.d_colors.getColor(intensity, color);
                        GL11.glColor4f(color[0], color[1], color[2], color[3]);
                        GL11.glVertex3d(vert.p.x, vert.p.y, vert.p.z);
                    }
                }
                GL11.glEnd();
                GL11.glPopAttrib();
            };
            if (showDoorDists) {
                showDists.accept(obj.getDoorDistMap((KB)kb).dists);
            } else if (showAllDoorDists) {
                showDists.accept(obj.getAllDoorsDistMap((KB)kb).dists);
            }
        }
        if (!view.getFilters().isFilteringAllOf(FILTER_SUBMESH.class) && subMesh != null) {
            GL11.glPushAttrib(11);
            GL11.glColor4f(0.0f, 0.0f, 0.0f, 1.0f);
            GL11.glEnable(10754);
            GL11.glPolygonOffset(-2.0f, -2.0f);
            GL11.glPolygonMode(1032, 6913);
            GL11.glBegin(4);
            for (ConnectedMesh.Tri tri : subMesh.mesh.tris) {
                for (ConnectedMesh.Vertex vert : tri.verts) {
                    GL11.glVertex3d(vert.p.x, vert.p.y, vert.p.z);
                }
            }
            GL11.glEnd();
            GL11.glPopAttrib();
        }
        if (animating) {
            GL11.glPopMatrix();
        }
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, ANode obj) throws Exception {
    }

    @Override
    public AABox getBounds(ANode obj) {
        return obj.getGeometryBounds();
    }

    public static class FILTER_ALL_DOOR_DISTS {
    }

    public static class FILTER_DOOR_DISTS {
    }

    public static class FILTER_SUBMESH {
    }
}

