/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis.rend;

import common.vis.ColorMaps;
import inferno.data2.AttractorSim;
import inferno.sim.KB;
import inferno.sim.KnownFuncs;
import inferno.vis.GLView;
import inferno.vis.rend.IRenderer;
import inferno.vis.rend.RenderUtil;
import java.awt.Color;
import javax.vecmath.Point3d;
import org.lwjgl.opengl.GL11;
import thunderheadeng.geometry.AABox;

public class RendAttractor
implements IRenderer<AttractorSim> {
    private static final double DEFAULT_RADIUS = 1.0;
    private static final Color COLOR = Color.orange;
    private int d_diskId = -1;
    private int d_outlineId = -1;

    private int getDisk() {
        if (this.d_diskId == -1) {
            this.d_diskId = GL11.glGenLists(1);
            GL11.glNewList(this.d_diskId, 4864);
            RenderUtil.renderDisk(1.0);
            GL11.glEndList();
        }
        return this.d_diskId;
    }

    private int getOutline() {
        if (this.d_outlineId == -1) {
            this.d_outlineId = GL11.glGenLists(1);
            GL11.glNewList(this.d_outlineId, 4864);
            RenderUtil.renderCircle(1.0, 16);
            GL11.glEndList();
        }
        return this.d_outlineId;
    }

    @Override
    public void renderOpaque(GLView view, KB kb, AttractorSim obj) throws Exception {
    }

    @Override
    public void renderTranslucent(GLView view, KB kb, AttractorSim obj) throws Exception {
        if (!view.testFilter(FILTER.class)) {
            return;
        }
        GL11.glPushMatrix();
        Point3d p = obj.getLocation().p;
        GL11.glTranslated(p.x, p.y, p.z + 0.05);
        double radius = obj.awareness == AttractorSim.Awareness.LINE_OF_SIGHT ? obj.influenceRadius : 1.0;
        GL11.glScaled(radius, radius, 1.0);
        if (view.testFilter(INFLUENCE.class)) {
            double intensity = KnownFuncs.linInterp(0.0, 0.0, 1.0, 1.0, obj.getInfluence());
            float[] c = new float[3];
            ColorMaps.RAINBOW2.getColor((float)intensity, c);
            GL11.glColor4f(c[0], c[1], c[2], (float)COLOR.getAlpha() / 255.0f);
        } else {
            RenderUtil.glColor4(COLOR);
        }
        GL11.glCallList(this.getDisk());
        RenderUtil.glColor4(Color.BLACK);
        GL11.glCallList(this.getOutline());
        GL11.glPopMatrix();
    }

    @Override
    public AABox getBounds(AttractorSim obj) {
        Point3d p = obj.getLocation().p;
        double radius = obj.awareness == AttractorSim.Awareness.LINE_OF_SIGHT ? obj.influenceRadius : 1.0;
        return new AABox(p.x - radius, p.y - radius, p.z, p.x + radius, p.y + radius, p.z);
    }

    public static final class INFLUENCE {
    }

    public static final class FILTER {
    }
}

