/*
 * Decompiled with CFR 0.152.
 */
package inferno.vis;

import inferno.data2.Tag;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.vis.AbstractTable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import thunderheadeng.util.theUtil;

public class CalculatedTable
extends AbstractTable {
    public CalculatedTable(KB kb) {
        super(kb);
    }

    @Override
    public void initModel(String className) throws SecurityException, ClassNotFoundException {
        this.d_values = new Object[1][1];
        this.d_columnNames = new String[]{"Property", "Value"};
        this.d_values = new Object[Value.values().length][2];
        for (int row = 0; row < Value.values().length; ++row) {
            Value val = Value.values()[row];
            this.d_values[row][0] = val.name;
        }
    }

    @Override
    public void update(List<Object> data) {
        if (data != null && !data.isEmpty()) {
            OccAgent agent = (OccAgent)data.get(0);
            for (int row = 0; row < Value.values().length; ++row) {
                Value val = Value.values()[row];
                this.d_tableModel.setValueAt(val.calc.apply(this.d_kb, agent), row, 1);
            }
        } else {
            for (int row = 0; row < Value.values().length; ++row) {
                this.d_tableModel.setValueAt("", row, 1);
            }
        }
        this.d_tableModel.fireTableDataChanged();
        this.d_table.repaint();
    }

    private static String calcTags(KB kb, OccAgent agent) {
        ArrayList<Tag> tagged = new ArrayList<Tag>();
        for (Tag tag : kb.getTags()) {
            if (!tag.isTagged(agent)) continue;
            tagged.add(tag);
        }
        tagged.sort((t1, t2) -> Double.compare(t1.getInfo((OccAgent)agent).tLastTagged, t2.getInfo((OccAgent)agent).tLastTagged));
        return String.join((CharSequence)", ", theUtil.map(tagged, t -> t.name));
    }

    private static enum Value {
        TAGS("Tags", (x$0, x$1) -> CalculatedTable.calcTags(x$0, x$1));

        public final String name;
        public final BiFunction<KB, OccAgent, String> calc;

        private Value(String name, BiFunction<KB, OccAgent, String> calc) {
            this.name = name;
            this.calc = calc;
        }
    }
}

