/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.steering;

import inferno.data2.OccTarget;
import inferno.data2.OccTargets;
import inferno.data2.TriPoint;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.OccTargetGoal;
import inferno.data2.seekarea.IdleParams;
import inferno.geom.SeekCurve;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.EdgeFilters;
import inferno.sim.path.PathChange;
import inferno.sim.path.PathGen;
import inferno.sim.path.TriFilters;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.LostException;
import inferno.sim.steering.Steer;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import inferno.sim.steering.simple.MaintainVel;
import inferno.sim.steering.simple.ProxySteeringBehavior;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class OccTargetSteeringBehavior
extends ProxySteeringBehavior {
    private static final long serialVersionUID = 1L;
    private static final int MIN_CONFLICT_COUNT = Math.max(theUtil.getSystemInt("OccTarget.MIN_CONFLICT_COUNT", 1), 1);
    private final OccTargetGoal.DistancePref distPref;
    private final OccTargetGoal.PriorityPref priorityPref;
    private final List<OccTarget> d_targets;
    private final IdleParams d_idleParams;
    private final IdleParams d_idleParamsReserve;
    private State d_state;
    private double d_tStateChange;
    private List<OccTarget> d_reservations = Collections.emptyList();
    private int d_reserveCounts = 1;
    private OccTarget d_chosenTarget;
    private Map<OccTarget, Double> d_unreachedTargetTimes = new LinkedIdentityHashMap<OccTarget, Double>();
    private double d_oldestUnreachedTime = Double.POSITIVE_INFINITY;

    public OccTargetSteeringBehavior(KB kb, OccAgent occ, OccTargetGoal.DistancePref distPref, OccTargetGoal.PriorityPref priorityPref, List<OccTarget> targets, IdleParams idleParams, IdleParams idleParamsReserve) {
        super(new MaintainVel());
        this.distPref = distPref;
        this.priorityPref = priorityPref;
        this.d_targets = targets;
        this.d_idleParams = idleParams;
        this.d_idleParamsReserve = idleParamsReserve;
        this.d_tStateChange = Double.MAX_VALUE;
    }

    public State getState() {
        return this.d_state;
    }

    public OccTarget getCurrentTarget() {
        return this.d_chosenTarget;
    }

    @Override
    public void done(KB kb, OccAgent occ, boolean interrupted) {
        super.done(kb, occ, interrupted);
        this.cancelReservations(kb, occ, true);
    }

    @Override
    public SeekCurve generateSeekCurve(KB kb, OccAgent agent) throws LostException {
        if (this.d_state == null) {
            this.setState(kb, State.RESERVING);
            this.updateSteering(kb, agent);
        }
        this.update(kb, agent);
        try {
            return super.generateSeekCurve(kb, agent);
        }
        catch (LostException e) {
            if (this.d_chosenTarget != null) {
                this.addUnreachableTarget(kb, this.d_chosenTarget);
            }
            this.cancelReservations(kb, agent, false);
            throw e;
        }
    }

    private static boolean isInGroup(KB kb, OccAgent agent) {
        return agent.getGroup().filter(g -> g.getCurrentSize() > 1).isPresent();
    }

    private void update(KB kb, OccAgent oa) {
        if (OccTargetSteeringBehavior.isInGroup(kb, oa)) {
            return;
        }
        List<OccTarget> targets = this.d_targets;
        OccTarget currTarget = this.d_chosenTarget;
        if (!Double.isInfinite(this.d_oldestUnreachedTime) && oa.isPathingModifiedSince(kb, this.d_oldestUnreachedTime)) {
            boolean modified = false;
            Iterator<Map.Entry<OccTarget, Double>> iterator = this.d_unreachedTargetTimes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<OccTarget, Double> entry = iterator.next();
                if (!oa.isPathingModifiedSince(kb, entry.getValue())) continue;
                iterator.remove();
                modified = true;
            }
            if (modified) {
                this.d_oldestUnreachedTime = this.d_unreachedTargetTimes.values().stream().mapToDouble(d -> d).min().orElse(Double.POSITIVE_INFINITY);
            }
        }
        switch (this.d_state) {
            case RESERVING: {
                assert (currTarget == null);
                if (!this.d_reservations.isEmpty()) {
                    for (OccTarget occTarget : this.d_reservations) {
                        if (!occTarget.isReserved(oa)) continue;
                        currTarget = occTarget;
                        break;
                    }
                    if (currTarget != null) {
                        OccTargets occTargets = kb.getOccTargets();
                        for (OccTarget target3 : this.d_reservations) {
                            if (target3 == currTarget) continue;
                            occTargets.cancelReservation(kb, oa, target3);
                        }
                    } else if (this.distPref == OccTargetGoal.DistancePref.RANDOM && this.priorityPref == OccTargetGoal.PriorityPref.NONE) {
                        this.d_reserveCounts = 1;
                    } else {
                        double d2;
                        double tResolveRemaining;
                        double timestepsRemaining;
                        int nConflicts = this.d_reservations.stream().mapToInt(OccTarget::getNumReserveConflicts).max().getAsInt();
                        assert (nConflicts >= 1);
                        this.d_reserveCounts = nConflicts <= 1 ? 1 : ((timestepsRemaining = Math.ceil((tResolveRemaining = Math.max(0.0, (d2 = this.d_tStateChange + kb.getParams().occtarget_conflict_resolve_time) - kb.getCurrentSimTime())) / kb.getDt())) == 0.0 ? nConflicts : Math.max(MIN_CONFLICT_COUNT, (int)Math.ceil((double)nConflicts / timestepsRemaining)));
                    }
                    this.d_reservations = Collections.emptyList();
                }
                assert (this.d_reservations.isEmpty());
                if (currTarget == null) {
                    OccTarget existing = this.pickReservationFromExisting(kb, oa);
                    if (existing != null) {
                        currTarget = existing;
                    } else {
                        List<OccTarget> list = targets.stream().filter(target -> !target.isReserved() && !this.d_unreachedTargetTimes.containsKey(target)).collect(Collectors.toList());
                        if (list.size() == 1) {
                            this.d_reservations = this.makeSingleReservation(kb, oa, (OccTarget)list.get(0));
                        } else if (!list.isEmpty()) {
                            List<OccTarget> rtargets = list;
                            if (this.priorityPref == OccTargetGoal.PriorityPref.HIGHER) {
                                rtargets = theUtil.reverse(rtargets);
                            }
                            BiPredicate<OccTarget, OccTarget> equalPriority = (r1, r2) -> r1.priority == r2.priority;
                            switch (this.distPref) {
                                case RANDOM: {
                                    switch (this.priorityPref) {
                                        case HIGHER: 
                                        case LOWER: {
                                            int remaining = Math.min(this.d_reserveCounts, rtargets.size());
                                            int offset = 0;
                                            ArrayList<OccTarget> newReservations = new ArrayList<OccTarget>(remaining);
                                            while (remaining > 0) {
                                                List<OccTarget> remainingTargets = rtargets.subList(offset, rtargets.size());
                                                int nUniform = theUtil.getUniformCount(remainingTargets, equalPriority);
                                                List<OccTarget> priorityTargets = rtargets.subList(offset, offset + nUniform);
                                                int toReserve = Math.min(nUniform, remaining);
                                                newReservations.addAll(this.makeRandomReservation(kb, oa, priorityTargets, toReserve));
                                                remaining -= toReserve;
                                                offset += nUniform;
                                            }
                                            this.d_reservations = newReservations;
                                            break;
                                        }
                                        case NONE: {
                                            this.d_reservations = this.makeRandomReservation(kb, oa, rtargets, 1);
                                        }
                                    }
                                    break;
                                }
                                case NEAREST: {
                                    switch (this.priorityPref) {
                                        case HIGHER: 
                                        case LOWER: {
                                            int offset;
                                            int nUniform;
                                            for (offset = 0; offset < this.d_reserveCounts && offset < rtargets.size(); offset += nUniform) {
                                                List<OccTarget> subset = rtargets.subList(offset, rtargets.size());
                                                nUniform = theUtil.getUniformCount(subset, equalPriority);
                                                assert (nUniform != 0);
                                            }
                                            rtargets = rtargets.subList(0, offset);
                                            break;
                                        }
                                    }
                                    this.d_reservations = this.makeReservationsToNearest(kb, oa, rtargets, this.d_reserveCounts);
                                }
                            }
                        }
                    }
                }
                if (currTarget == this.d_chosenTarget) break;
                this.d_chosenTarget = currTarget;
                this.setState(kb, currTarget != null ? State.NAVIGATING : State.RESERVING);
                this.updateSteering(kb, oa);
                break;
            }
            case NAVIGATING: {
                OccTarget target4 = this.d_chosenTarget;
                if (!target4.asSeekArea().intersects(kb, oa.getShape(), oa.getPos()) || kb.getMesh().isPathObstructed(oa.getLoc(), target4.location, 0.0, EdgeFilters.acceptAll())) break;
                this.setState(kb, State.IDLING);
                this.updateSteering(kb, oa);
                break;
            }
        }
    }

    private void updateSteering(KB kb, OccAgent agent) {
        switch (this.d_state) {
            case RESERVING: {
                ISteeringBehavior idleSteer = IGoalInstance.getCurrentAreaAsRoom(kb, agent).getIdleSteer(kb, agent, this.d_idleParamsReserve);
                this.setBase(kb, agent, idleSteer, false);
                break;
            }
            case NAVIGATING: {
                PointTarget target = new PointTarget(this.d_chosenTarget.location);
                LocallyQuickest lq = new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), target);
                this.setBase(kb, agent, SteerUtil.newSeekSteer(kb, agent, lq), false);
                break;
            }
            case IDLING: {
                this.setBase(kb, agent, this.d_chosenTarget.asSeekArea().getIdleSteer(kb, agent, this.d_idleParams), false);
            }
        }
    }

    private void addUnreachableTarget(KB kb, OccTarget target) {
        this.addUnreachableTarget(kb.getCurrentSimTime(), target);
    }

    private void addUnreachableTarget(double simTime, OccTarget target) {
        this.d_unreachedTargetTimes.put(target, simTime);
        this.d_oldestUnreachedTime = Math.min(simTime, this.d_oldestUnreachedTime);
    }

    private void cancelReservations(KB kb, OccAgent agent, boolean requestsOnly) {
        OccTargets occTargets = kb.getOccTargets();
        occTargets.cancelReservations(kb, agent, false, true);
        this.d_reservations = Collections.emptyList();
        this.d_reserveCounts = 1;
        if (!requestsOnly && this.d_chosenTarget != null) {
            kb.getOccTargets().cancelReservation(kb, agent, this.d_chosenTarget);
            this.d_chosenTarget = null;
            this.setState(kb, State.RESERVING);
            this.updateSteering(kb, agent);
        }
    }

    private void setState(KB kb, State state) {
        if (state == this.d_state) {
            return;
        }
        this.d_state = state;
        this.d_tStateChange = kb.getCurrentSimTime();
    }

    private static Predicate<PathChange> getPathFilter(KB kb, OccAgent agent) {
        return agent.generatePathFilter(kb, TriFilters.rejectClosed(), Predicates.alwaysTrue(), OccAgent.PathFilterType.POINT_TO_POINT);
    }

    private OccTarget pickReservationFromExisting(KB kb, OccAgent agent) {
        List currReservations = kb.getOccTargets().getReservations(agent);
        if (currReservations.isEmpty()) {
            return null;
        }
        IdentityHashSet<OccTarget> currSet = new IdentityHashSet<OccTarget>(this.d_targets);
        if ((currReservations = (List)currReservations.stream().filter(loc -> currSet.contains(loc) && !this.d_unreachedTargetTimes.containsKey(loc)).collect(Collectors.toCollection(() -> new ArrayList()))).isEmpty()) {
            return null;
        }
        if (currReservations.size() == 1) {
            return (OccTarget)currReservations.get(0);
        }
        OccTarget mostRecent = agent.getOcc().mostRecentOccTarget;
        if (mostRecent != null && mostRecent.isReserved(agent) && currReservations.contains(mostRecent)) {
            List<OccTarget> result = this.makeSingleReservation(kb, agent, mostRecent);
            if (!result.isEmpty()) {
                return mostRecent;
            }
            currReservations.remove(mostRecent);
        }
        if (this.priorityPref != OccTargetGoal.PriorityPref.NONE) {
            Comparator comp = null;
            switch (this.priorityPref) {
                case HIGHER: {
                    comp = (t1, t2) -> Double.compare(t2.priority, t1.priority);
                    break;
                }
                case LOWER: {
                    comp = (t1, t2) -> Double.compare(t1.priority, t2.priority);
                    break;
                }
                case NONE: {
                    assert (false);
                    break;
                }
            }
            assert (comp != null);
            Collections.sort(currReservations, comp);
            int numUniform = theUtil.getUniformCount(theUtil.map(currReservations, t -> t.priority));
            assert (numUniform != 0);
            currReservations = currReservations.subList(0, numUniform);
        }
        switch (this.distPref) {
            case RANDOM: {
                List<OccTarget> result = this.makeRandomReservation(kb, agent, currReservations, 1);
                return result.isEmpty() ? null : result.get(0);
            }
            case NEAREST: {
                PathGen.MultiPointGoal goal = new PathGen.MultiPointGoal(theUtil.map(currReservations, loc -> loc.location));
                Pair<OccTarget, Double> chosen = this.getDist(kb, agent, goal, OccTargetSteeringBehavior.getPathFilter(kb, agent), currReservations);
                return chosen != null ? (OccTarget)chosen.v1 : null;
            }
        }
        assert (false);
        return null;
    }

    private Pair<OccTarget, Double> getDist(KB kb, OccAgent agent, PathGen.IPathGoal goal, Predicate<PathChange> pathFilter, Collection<OccTarget> availTargets) {
        PathGen.IPathResult result = PathGen.getPath(kb.getMesh(), agent.getOcc().tri, null, null, agent.getPos(), goal, agent.getGeometryRadius(), Double.MAX_VALUE, pathFilter, null);
        if (!result.isSuccessful()) {
            double simTime = kb.getCurrentSimTime();
            for (OccTarget target : availTargets) {
                this.addUnreachableTarget(simTime, target);
            }
            return null;
        }
        List<TriPoint> resultPoints = result.getPoints();
        assert (!resultPoints.isEmpty());
        TriPoint destPt = resultPoints.get(resultPoints.size() - 1);
        for (OccTarget target : availTargets) {
            if (!target.location.tolEquals(destPt, 1.0E-6)) continue;
            return new Pair<OccTarget, Double>(target, result.getLength());
        }
        assert (false);
        return null;
    }

    private List<OccTarget> makeSingleReservation(KB kb, OccAgent agent, OccTarget target) {
        Pair<OccTarget, Double> result = this.getDist(kb, agent, new PathGen.PointGoal(target.location), OccTargetSteeringBehavior.getPathFilter(kb, agent), Collections.singletonList(target));
        if (result == null) {
            return Collections.emptyList();
        }
        assert (result.v1 == target);
        kb.getOccTargets().requestReservation(kb, agent, target, (Double)result.v2, OccTargets.ReservationType.SINGLE);
        return Collections.singletonList(target);
    }

    private List<OccTarget> makeRandomReservation(KB kb, OccAgent agent, List<OccTarget> availTargets, int count) {
        ArrayList<OccTarget> randomizedTargets;
        if ((count = Math.min(count, availTargets.size())) == 0) {
            return Collections.emptyList();
        }
        if (count == availTargets.size()) {
            ArrayList<OccTarget> targets = new ArrayList<OccTarget>(availTargets.size());
            for (OccTarget target : availTargets) {
                targets.addAll(this.makeSingleReservation(kb, agent, target));
            }
            return targets;
        }
        Random r = kb.getTimeBasedRandom(agent.getOcc(), 125590255966963L);
        if (count == 1) {
            OccTarget firstTested = availTargets.get(r.nextInt(availTargets.size()));
            List<OccTarget> result = this.makeSingleReservation(kb, agent, firstTested);
            if (!result.isEmpty()) {
                return result;
            }
            randomizedTargets = new ArrayList(availTargets.size() - 1);
            for (OccTarget target : availTargets) {
                if (target == firstTested) continue;
                randomizedTargets.add(target);
            }
        } else {
            randomizedTargets = new ArrayList<OccTarget>(availTargets);
        }
        Collections.shuffle(randomizedTargets, r);
        ArrayList result = new ArrayList(count);
        for (int m = 0; m < randomizedTargets.size() && result.size() < count; ++m) {
            OccTarget target = (OccTarget)randomizedTargets.get(m);
            result.addAll(this.makeSingleReservation(kb, agent, target));
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    private List<OccTarget> makeReservationsToNearest(KB kb, OccAgent agent, List<OccTarget> availLocs, int count) {
        int maxReservations = Math.min(availLocs.size(), this.d_reserveCounts);
        LinkedIdentityHashSet<OccTarget> locsSet = new LinkedIdentityHashSet<OccTarget>((Collection<OccTarget>)availLocs);
        boolean pathingToAll = availLocs.size() == maxReservations;
        Predicate<PathChange> pathFilter = OccTargetSteeringBehavior.getPathFilter(kb, agent);
        OccTargets occTargets = kb.getOccTargets();
        ArrayList<Pair<OccTarget, Double>> reservations = new ArrayList<Pair<OccTarget, Double>>(maxReservations);
        while (!locsSet.isEmpty() && reservations.size() < maxReservations) {
            Set<OccTarget> goalLocs;
            PathGen.IPathGoal goal;
            if (pathingToAll) {
                OccTarget next = (OccTarget)locsSet.iterator().next();
                goal = new PathGen.PointGoal(next.location);
                goalLocs = Collections.singleton(next);
            } else {
                goal = new PathGen.MultiPointGoal(theUtil.map(locsSet, loc -> loc.location));
                goalLocs = locsSet;
            }
            Pair<OccTarget, Double> result = this.getDist(kb, agent, goal, pathFilter, goalLocs);
            if (result == null) {
                if (pathingToAll) {
                    locsSet.removeAll(goalLocs);
                    continue;
                }
                return Collections.emptyList();
            }
            OccTarget target = (OccTarget)result.v1;
            reservations.add(new Pair<OccTarget, Double>(target, (Double)result.v2));
            locsSet.remove(target);
        }
        if (reservations.isEmpty()) {
            return Collections.emptyList();
        }
        Collections.sort(reservations, (e1, e2) -> Double.compare((Double)e1.v2, (Double)e2.v2));
        reservations.forEach(entry -> occTargets.requestReservation(kb, agent, (OccTarget)entry.v1, (Double)entry.v2, OccTargets.ReservationType.SINGLE));
        return new ArrayList<OccTarget>(theUtil.map(reservations, entry -> (OccTarget)entry.v1));
    }

    @Override
    public Steer steer(KB world, OccAgent agent, SeekCurve seek) {
        Steer result = super.steer(world, agent, seek);
        if (this.d_chosenTarget != null) {
            return result.applyPostOp(new SetMostRecentTargetOp(this.d_chosenTarget));
        }
        return result;
    }

    private static class SetMostRecentTargetOp
    implements Steer.IPostOp {
        private static final long serialVersionUID = 1L;
        public final OccTarget target;

        public SetMostRecentTargetOp(OccTarget target) {
            this.target = target;
        }

        @Override
        public void accept(KB t, OccAgent oa) {
            oa.getOcc().mostRecentOccTarget = this.target;
        }
    }

    public static enum State {
        RESERVING,
        NAVIGATING,
        IDLING;

    }
}

