/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ASplitComponent;
import inferno.data2.Mesh;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.WingedEdge;
import inferno.sim.path.PathGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class StringPull {
    private static Point3d[] getClosestPointsLineSegLineSeg(Point3d p1a, Point3d p2a, Point3d p1b, Point3d p2b) {
        Point3d[] point3dArray;
        double smallestDistSq = Double.POSITIVE_INFINITY;
        Point3d pa = null;
        Point3d pb = null;
        block8: for (int m = 0; m < 4; ++m) {
            Point3d l2;
            Point3d l1;
            Point3d tp;
            switch (m) {
                case 0: {
                    tp = p1a;
                    l1 = p1b;
                    l2 = p2b;
                    break;
                }
                case 1: {
                    tp = p2a;
                    l1 = p1b;
                    l2 = p2b;
                    break;
                }
                case 2: {
                    tp = p1b;
                    l1 = p1a;
                    l2 = p2a;
                    break;
                }
                default: {
                    tp = p2b;
                    l1 = p1a;
                    l2 = p2a;
                }
            }
            Point3d nearp = Inter3D.nearestPointOnLineSeg(l1, l2, tp);
            double distsq = tp.distanceSquared(nearp);
            if (!(distsq < smallestDistSq)) continue;
            smallestDistSq = distsq;
            switch (m) {
                case 0: 
                case 1: {
                    pa = tp;
                    pb = nearp;
                    continue block8;
                }
                default: {
                    pa = nearp;
                    pb = tp;
                }
            }
        }
        if (pa == null) {
            point3dArray = null;
        } else {
            Point3d[] point3dArray2 = new Point3d[2];
            point3dArray2[0] = pa;
            point3dArray = point3dArray2;
            point3dArray2[1] = pb;
        }
        return point3dArray;
    }

    public static List<TriPoint> stringPullSlidingEndPoints(Mesh mesh, List<TriEdge> edges, PathGen.IPathGoal goal, PathGen.GoalDest goalReached, double radius, double abortDist) {
        ArrayList<TriPoint> points;
        TriPoint endPoint;
        assert (edges.size() >= 1);
        if (edges.isEmpty()) {
            return null;
        }
        assert (goalReached != null);
        SplitEdge[] shortenedEdges = mesh.getShortenedEdges(radius);
        TriEdge startEdge = edges.get(0);
        TriEdge endEdge = edges.get(edges.size() - 1);
        List<TriEdge> pullEdges = new ReverseList<TriEdge>(edges);
        Tri endTri = endEdge.getValidTri();
        if (goalReached.point != null) {
            endPoint = goalReached.point;
            assert (endPoint != null);
            if (endPoint.tri != endTri) {
                endPoint = new TriPoint(endTri, endPoint.p);
            }
        } else {
            assert (goalReached.edge == endEdge.edge);
            Point3d[] initEndPoints = StringPull.getClosestPointsLineSegLineSeg(startEdge.edge.base.n1.p, startEdge.edge.base.n2.p, endEdge.edge.base.n1.p, endEdge.edge.base.n2.p);
            endPoint = StringPull.getWalkablePointOnEdge(shortenedEdges, endEdge.edge, new TriPoint(endTri, initEndPoints[1], endEdge.edge));
            if (endPoint == null) {
                System.err.println("endPoint is null");
                return null;
            }
            if (edges.size() < 2) {
                return Arrays.asList(endPoint);
            }
            if (goalReached.edge == endEdge.edge) {
                pullEdges = pullEdges.subList(1, edges.size());
            }
        }
        if ((points = StringPull.stringPullImpl(shortenedEdges, pullEdges, goalReached, endPoint, new PathGen.EdgeGoal(startEdge.edge))) == null || points.isEmpty()) {
            return null;
        }
        TriPoint startPoint = (TriPoint)points.get(points.size() - 1);
        pullEdges = edges.subList(1, edges.size());
        points = StringPull.stringPullImpl(shortenedEdges, pullEdges, goalReached, startPoint, goal);
        if (points == null || points.isEmpty()) {
            return null;
        }
        return points;
    }

    public static List<TriPoint> stringPullFixedStartPoint(Mesh mesh, List<TriEdge> edges, PathGen.GoalDest goalReached, TriPoint startPoint, PathGen.IPathGoal goal, double radius) {
        SplitEdge[] shortenedEdges = mesh.getShortenedEdges(radius);
        if (edges.isEmpty()) {
            TriPoint endPoint = goal.project(goalReached, shortenedEdges, startPoint.p);
            if (endPoint == null) {
                return null;
            }
            assert (endPoint.tri == startPoint.tri || endPoint.tri.isPhysicallyAdjacent(startPoint.tri));
            if (!startPoint.p.epsilonEquals(endPoint.p, 1.0E-6)) {
                return Arrays.asList(startPoint, endPoint);
            }
            return Arrays.asList(startPoint);
        }
        return StringPull.stringPullImpl(shortenedEdges, edges, goalReached, startPoint, goal);
    }

    private static ArrayList<TriPoint> stringPullImpl(SplitEdge[] shortenedEdges, List<TriEdge> edges, PathGen.GoalDest goalReached, TriPoint startPoint, PathGen.IPathGoal goal) {
        int endIx = edges.size() - 1;
        Optional<Object> endTri = Optional.empty();
        if (!edges.isEmpty() && goalReached.edge != null && goalReached.edge == edges.get((int)(edges.size() - 1)).edge) {
            --endIx;
            if (!goalReached.edge.isExit()) {
                endTri = Optional.of(edges.get((int)(edges.size() - 1)).tri);
            }
        }
        ArrayList<TriPoint> points = new ArrayList<TriPoint>();
        points.add(startPoint);
        ArrayList<TriPoint> revPoints = new ArrayList<TriPoint>();
        TriPoint previous = startPoint;
        for (int m = 0; m <= endIx + 1; ++m) {
            TriPoint endPoint = goal.project(goalReached, shortenedEdges, previous.p);
            if (endPoint == null) {
                return null;
            }
            if (endTri.isPresent()) {
                endPoint = endPoint.setToAdjacentTri((Tri)endTri.get());
            }
            if ((m = StringPull.stringPullNext(edges, m, endIx, previous, endPoint, shortenedEdges, revPoints)) == -1) {
                return null;
            }
            for (int n = revPoints.size() - 1; n >= 0; --n) {
                TriPoint nextPoint = (TriPoint)revPoints.get(n);
                if (previous.getEdge() == nextPoint.getEdge() && previous.tri == nextPoint.tri && (n != 0 || m != endIx + 1 || goalReached.point == null)) continue;
                points.add(nextPoint);
                previous = nextPoint;
            }
        }
        return points;
    }

    private static boolean eq2d(Point3d p1, Point3d p2, double tol) {
        return Math.max(Math.abs(p1.x - p2.x), Math.abs(p1.y - p2.y)) <= tol;
    }

    private static int stringPullNext(List<TriEdge> edges, int edgesBeginIx, int edgesEndIx, TriPoint startPoint, TriPoint endPoint, SplitEdge[] shortenedEdges, final List<TriPoint> revPoints) {
        ASplitComponent.ILocResolver<WingedEdge> resolver = new ASplitComponent.ILocResolver<WingedEdge>(){

            @Override
            public double resolve(ASplitComponent<WingedEdge> sedge, double t1, double t2, double t) {
                double distsq2;
                assert (!revPoints.isEmpty());
                Point3d pathEnd = ((TriPoint)revPoints.get((int)(revPoints.size() - 1))).p;
                Point3d p1 = sedge.get(t1);
                Point3d p2 = sedge.get(t2);
                double distsq1 = p1.distanceSquared(pathEnd);
                return distsq1 <= (distsq2 = p2.distanceSquared(pathEnd)) ? t1 : t2;
            }
        };
        double[] st = new double[2];
        TriPoint pnext = endPoint;
        revPoints.clear();
        revPoints.add(pnext);
        int nextBendIx = edgesEndIx + 1;
        for (int m = edgesEndIx; m >= edgesBeginIx; --m) {
            TriEdge triEdge = edges.get(m);
            WingedEdge edge = triEdge.edge;
            Pair<Boolean, Point3d> cresult = StringPull.classifySPEdge(startPoint.p, pnext.p, edge, shortenedEdges, resolver, st);
            if (cresult == null) {
                return -1;
            }
            TriPoint epoint = new TriPoint(triEdge.getValidTri(), (Point3d)cresult.v2, edge);
            if (((Boolean)cresult.v1).booleanValue()) {
                nextBendIx = m;
                revPoints.clear();
                pnext = epoint;
            }
            revPoints.add(epoint);
            if (startPoint.getEdge() == triEdge.edge && startPoint.p.equals(epoint.p)) break;
        }
        return nextBendIx;
    }

    private static Inter3D.LinesegClassify getNearestT(Point3d l1, Point3d l2, WingedEdge edge, double[] st) {
        double tol = 1.0E-9;
        Point3d e1 = edge.base.n1.p;
        Point3d e2 = edge.base.n2.p;
        if (StringPull.eq2d(l1, l2, 1.0E-9) || StringPull.eq2d(e1, e2, 1.0E-9)) {
            return Inter3D.getNearestTLinesegLineSeg(l1, l2, e1, e2, tol, st);
        }
        return Inter3D.getNearestTLinesegLineSeg(l1.x, l1.y, 0.0, l2.x, l2.y, 0.0, e1.x, e1.y, 0.0, e2.x, e2.y, 0.0, tol, st);
    }

    public static Pair<Boolean, Point3d> classifySPEdge(Point3d startPoint, Point3d endPoint, WingedEdge edge, SplitEdge[] sedges, double[] st) {
        return StringPull.classifySPEdge(startPoint, endPoint, edge, sedges, SplitEdge.defLocResolver(), st);
    }

    private static Pair<Boolean, Point3d> classifySPEdge(Point3d startPoint, Point3d endPoint, WingedEdge edge, SplitEdge[] sedges, ASplitComponent.ILocResolver<WingedEdge> resolver, double[] st) {
        double t;
        Inter3D.LinesegClassify lsc = StringPull.getNearestT(startPoint, endPoint, edge, st);
        SplitEdge sedge = sedges[edge.id];
        double d = t = sedge != null ? sedge.findClosest(st[1], resolver) : st[1];
        if (Double.isNaN(t)) {
            return null;
        }
        Point3d p = edge.get(t);
        boolean corner = lsc == Inter3D.LinesegClassify.NO_INTERSECT || !theUtil.eq(t, st[1], 1.0E-9);
        Boolean bcorner = corner ? Boolean.TRUE : Boolean.FALSE;
        return new Pair<Boolean, Point3d>(bcorner, p);
    }

    private static TriPoint getWalkablePointOnEdge(SplitEdge[] shortenedEdges, WingedEdge edge, TriPoint tp) {
        SplitEdge sedge = shortenedEdges[edge.id];
        return sedge == null ? tp : sedge.findClosest(tp);
    }

    private static TriPoint getWalkablePointOnEdge(SplitEdge[] shortenedEdges, WingedEdge edge, Tri tri, double t) {
        if (Double.isNaN(t = StringPull.getWalkableTOnEdge(shortenedEdges, edge, t, SplitEdge.defLocResolver()))) {
            return null;
        }
        return new TriPoint(tri, Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, t), edge);
    }

    private static double getWalkableTOnEdge(SplitEdge[] shortenedEdges, WingedEdge edge, double t, ASplitComponent.ILocResolver<WingedEdge> resolver) {
        SplitEdge sedge = shortenedEdges[edge.id];
        if (sedge != null) {
            t = sedge.findClosest(t, resolver);
        }
        return t;
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> d_baseList;

        public ReverseList(List<T> baseList) {
            this.d_baseList = baseList;
        }

        @Override
        public T get(int index) {
            return this.d_baseList.get(this.d_baseList.size() - index - 1);
        }

        @Override
        public int size() {
            return this.d_baseList.size();
        }
    }
}

