/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.path;

import inferno.data2.ANode;
import inferno.data2.DoorDir;
import inferno.data2.Mesh;
import inferno.data2.SplitEdge;
import inferno.data2.Tri;
import inferno.data2.TriEdge;
import inferno.data2.TriPoint;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.data2.ai.GoalUtil;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.path.AStar;
import inferno.sim.path.DoorSeek;
import inferno.sim.path.ExitSeek;
import inferno.sim.path.IPath;
import inferno.sim.path.IPathSeek;
import inferno.sim.path.Path;
import inferno.sim.path.PathChange;
import inferno.sim.path.StringPull;
import inferno.sim.path.WaypointSeek;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.geodesics.GeodesicPlanner;
import inferno.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.BiIntToDoubleFunction;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class PathGen
implements Serializable {
    static final long serialVersionUID = 1L;
    public static GeneratorType DEFAULT_GEN_TYPE = GeneratorType.ASTAR;
    public static final DefaultDistFactor DEFAULT_DIST_FACTOR = new DefaultDistFactor();
    private static final boolean DEBUG_PRINT = false;

    private PathGen() {
    }

    public static int prunePoints(IPath path, int fromIx, boolean pruneDoors) {
        int ptCount = path.getNumPoints(false);
        return PathGen.prunePoints(ptCount, i -> path.pointAt(i).getSeekPt(), fromIx, pruneDoors);
    }

    public static int prunePoints(List<TriPoint> path, int fromIx, boolean pruneDoors) {
        return PathGen.prunePoints(path.size(), path::get, fromIx, pruneDoors);
    }

    public static int prunePoints(int ptCount, IntFunction<TriPoint> path, int fromIx, boolean pruneDoors) {
        int startIx;
        WingedEdge edge;
        TriPoint currSeek;
        Point2d curr;
        int nextIx;
        if (ptCount == 0) {
            return -1;
        }
        if (fromIx >= ptCount - 2) {
            return ptCount - 1;
        }
        TriPoint seek = path.apply(fromIx);
        Point2d from = PathGen.p2d(seek);
        WingedEdge e = seek.getEdge();
        boolean fromTransportDoor = e != null && e.isTransportDoor();
        for (nextIx = fromIx + 1; !(nextIx >= ptCount || !from.epsilonEquals(curr = PathGen.p2d(currSeek = path.apply(nextIx)), 1.0E-12) || fromTransportDoor && (edge = currSeek.getEdge()) != null && edge.isTransportDoor()); ++nextIx) {
        }
        if (nextIx == ptCount - 1) {
            return nextIx;
        }
        if (nextIx >= ptCount) {
            return ptCount - 1;
        }
        Point2d next = PathGen.p2d(path.apply(nextIx));
        Vector2d dir = Util2D.vector(from, next);
        double prevt = 1.0;
        for (int m = startIx = pruneDoors ? nextIx + 1 : nextIx; m < ptCount; ++m) {
            TriPoint currSeek2 = path.apply(m);
            Point2d curr2 = PathGen.p2d(currSeek2);
            double t = Inter2D.nearestTOnLine(from, dir, curr2);
            if (theUtil.lt(t, prevt, 1.0E-9) || curr2.distanceSquared(Util2D.linePoint(from, dir, t)) > 1.0E-12) {
                return m - 1;
            }
            if (!pruneDoors && currSeek2.getEdge() != null && currSeek2.getEdge().isDoor()) {
                return m;
            }
            prevt = t;
        }
        return ptCount - 1;
    }

    private static Point2d p2d(TriPoint tp) {
        return new Point2d(tp.p.x, tp.p.y);
    }

    public static IPath getPrunedPath(KB kb, IPath path, boolean pruneDoors) {
        int ptCount = path.getNumPoints(false);
        if (ptCount == 0) {
            return null;
        }
        ArrayList<IPathSeek> newPath = new ArrayList<IPathSeek>();
        newPath.add(path.pointAt(0));
        int fromix = 0;
        while (fromix < ptCount - 1) {
            int nextix = PathGen.prunePoints(path, fromix, pruneDoors);
            if (nextix != fromix) {
                newPath.add(path.pointAt(nextix));
            }
            fromix = nextix;
        }
        if (newPath.size() < 2) {
            return null;
        }
        return new Path(newPath, path.getDebugInfo());
    }

    public static SearchConnection physicalConnection(WingedEdgeUse eu, Tri tri) {
        return new SearchConnection(eu, tri, false, DEFAULT_DIST_FACTOR);
    }

    public static SearchConnection virtualConnection(WingedEdgeUse eu, Tri tri, IDistFactor distFactor) {
        return new SearchConnection(eu, tri, true, distFactor);
    }

    public static IEdgeGoal newEdgeGoal(WingedEdge ... edges) {
        return edges.length == 1 ? new EdgeGoal(edges[0]) : new MultiEdgeGoal(edges);
    }

    public static IEdgeGoal newEdgeGoal(Collection<WingedEdge> edges) {
        return edges.size() == 1 ? new EdgeGoal(edges.iterator().next()) : new MultiEdgeGoal(edges);
    }

    public static IEdgeGoal newDoorGoal(Collection<ANode> doors) {
        Collection<WingedEdge> edges = theUtil.flatMap(doors, d -> d.getDoorEdges());
        return PathGen.newEdgeGoal(edges);
    }

    public static IEdgeGoal newDoorGoal(ANode door) {
        return PathGen.newEdgeGoal(door.getDoorEdges());
    }

    public static IPathGoal newPointGoal(Collection<? extends ITpSource> points) {
        return points.size() == 1 ? new PointGoal(points.iterator().next()) : new MultiPointGoal(points);
    }

    public static DoorDir getInferredEdgeDir(List<TriPoint> pathPoints, WingedEdge endEdge) {
        if (endEdge.isExit()) {
            return endEdge.getExitDir();
        }
        if (pathPoints.isEmpty()) {
            return DoorDir.POSITIVE;
        }
        for (int m = pathPoints.size() - 1; m >= 0; --m) {
            TriPoint pathPt = pathPoints.get(m);
            WingedEdge edge = pathPt.getEdge();
            if (edge != endEdge) continue;
            if (m > 0) {
                TriPoint prevPt = pathPoints.get(m - 1);
                return endEdge.getDir(endEdge.getAdjTri(prevPt.tri));
            }
            return endEdge.getDir(pathPt.tri);
        }
        assert (false) : "doorEdge needs to be in pathEdges";
        return DoorDir.POSITIVE;
    }

    private static Point3d getWalkablePointOnEdge(SplitEdge[] shortenedEdges, WingedEdge edge, Point3d p) {
        SplitEdge sedge = shortenedEdges[edge.id];
        return sedge == null ? p : sedge.findClosest(p);
    }

    private static boolean isTravellable(SplitEdge[] sedges, WingedEdge edge) {
        SplitEdge sedge = sedges[edge.id];
        return sedge == null || sedge.isTravellable();
    }

    public static IPathResult getPath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        return PathGen.getPath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, DEFAULT_GEN_TYPE);
    }

    public static IPathResult getPath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo, GeneratorType algorithm) {
        Object timer = null;
        IPathResult result = algorithm.algorithm.generatePath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
        return result;
    }

    private static IPathResult getPathAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        IPathResult result = PathGen.getPathAStar(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, AStar.DEFAULT_ASTAR_TYPE);
        return result;
    }

    private static IPathResult compareAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo, AStar.IAStar test) {
        IPathResult shortest = PathGen.getPathAStar(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, new AStar.AStarSampled(1, Integer.MAX_VALUE, 0.1));
        if (!shortest.isSuccessful()) {
            return shortest;
        }
        IPathResult testAlg = PathGen.getPathAStar(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo, test);
        System.out.printf("path diff: %g m%n", testAlg.getLength() - shortest.getLength());
        return shortest;
    }

    private static IPathResult getPathAStar(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo, AStar.IAStar algorithm) {
        IPathResult result = algorithm.generatePath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
        if (result instanceof AStar.AStarSuccess) {
            PathSuccess path = PathGen.getPath(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, pathFilter, (AStar.AStarSuccess)result);
            if (path == null) {
                return new PathFailure(1);
            }
            return path;
        }
        return result;
    }

    private static IPathResult getPathGeodesic(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        GeodesicPlanner gp = new GeodesicPlanner(navMesh);
        return gp.getPath(startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter);
    }

    public static IPathResult testPath(Mesh navMesh, Tri startTri, WingedEdge startEdge, Vertex startVertex, Point3d startPt, IPathGoal goal, double radius, double abortDist, Predicate<PathChange> pathFilter, Consumer<AStar.DebugInfo> dbgInfo) {
        return AStar.getPathAStarDetailed(navMesh, startTri, startEdge, startVertex, startPt, goal, radius, abortDist, pathFilter, dbgInfo);
    }

    private static PathSuccess getPath(Mesh mesh, Tri startTri, WingedEdge startEdge, Vertex startVert, Point3d startingPt, IPathGoal goal, double radius, Predicate<PathChange> pathFilter, AStar.AStarSuccess astar) {
        Tri firstTriCorrection;
        TriPoint startPt;
        if (astar == null) {
            return null;
        }
        Pair<AStar.MTSearchNode, List<TriEdge>> path = AStar.getPathEdgePointsAndRootNode(astar.node);
        AStar.MTSearchNode root = (AStar.MTSearchNode)path.v1;
        List<TriEdge> forwardEdges = (List<TriEdge>)path.v2;
        List<TriEdge> spEdges = root.edge != null && forwardEdges.size() >= 2 ? forwardEdges.subList(1, forwardEdges.size()) : forwardEdges;
        List<TriPoint> pts = StringPull.stringPullFixedStartPoint(mesh, spEdges, astar.goalReached, startPt = new TriPoint(firstTriCorrection = root.edge != null ? ((TriEdge)forwardEdges.get((int)0)).tri : startTri, startingPt, root.edge), goal, radius);
        if (pts == null) {
            return null;
        }
        if (pts.get((int)0).tri != firstTriCorrection) {
            pts = new ArrayList<TriPoint>(pts);
            pts.set(0, new TriPoint(firstTriCorrection, pts.get((int)0).p, root.edge));
        }
        PathSuccess result = new PathSuccess(pts, astar.goalReached, astar.getLength(), astar.getCost());
        if (astar.needsCleanup) {
            result = PathGen.cleanupPath(mesh, startEdge, startVert, astar.goalReached, radius, pathFilter, result);
        }
        return result;
    }

    public static boolean mightNeedCleanup(Mesh mesh, double radius, PathSuccess path) {
        SplitEdge[] sedges = mesh.getShortenedEdges(radius);
        for (TriEdge edge : path.getEdges()) {
            SplitEdge sedge = sedges[edge.edge.id];
            if (sedge == null) {
                return true;
            }
            if (!sedge.isTravellable() || !theUtil.eq0(sedge.splits[0], 1.0E-6) && !theUtil.eq(sedge.splits[sedge.splits.length - 1], 1.0, 1.0E-6)) continue;
            return true;
        }
        return false;
    }

    public static PathSuccess cleanupPath(Mesh mesh, WingedEdge startEdge, Vertex startVert, GoalDest goalReached, double radius, Predicate<PathChange> pathFilter, PathSuccess dirtyPath) {
        switch (mesh.getParam().path_cleanup) {
            case DISABLED: {
                return dirtyPath;
            }
            case IF_NECESSARY: {
                if (PathGen.mightNeedCleanup(mesh, radius, dirtyPath)) break;
                return dirtyPath;
            }
        }
        if (dirtyPath.points.size() <= 2) {
            return dirtyPath;
        }
        ArrayList<Integer> corners = new ArrayList<Integer>();
        corners.add(0);
        int ix = 0;
        while (ix < dirtyPath.points.size() - 1) {
            int nextIx = PathGen.prunePoints(dirtyPath.points, ix, false);
            if (nextIx != ix) {
                corners.add(nextIx);
            }
            ix = nextIx;
        }
        if (corners.isEmpty()) {
            return dirtyPath;
        }
        if ((Integer)corners.get(corners.size() - 1) != dirtyPath.points.size() - 1) {
            corners.add(dirtyPath.points.size() - 1);
        }
        if (corners.size() <= 2) {
            return dirtyPath;
        }
        ArrayList<TriPoint> resultPoints = new ArrayList<TriPoint>();
        boolean resultModified = false;
        BiPredicate<TriPoint, TriPoint> equalPoints = (p1, p2) -> p1.tolEquals((TriPoint)p2, 1.0E-12);
        Consumer<List> addPathPoints = subPath -> {
            assert (!subPath.isEmpty());
            if (!resultPoints.isEmpty() && equalPoints.test((TriPoint)resultPoints.get(resultPoints.size() - 1), (TriPoint)subPath.get(0))) {
                subPath = subPath.subList(1, subPath.size());
            }
            resultPoints.addAll((Collection<TriPoint>)subPath);
        };
        IntConsumer addPointsToNextCorner = currCorner -> {
            int fromIx = (Integer)corners.get(currCorner);
            int toIx = (Integer)corners.get(currCorner + 1);
            addPathPoints.accept(dirtyPath.points.subList(fromIx, toIx + 1));
        };
        BiIntToDoubleFunction getExistingCost = (fromCorner, toCorner) -> {
            int fromIx = (Integer)corners.get(fromCorner);
            int toIx = (Integer)corners.get(toCorner);
            List<TriPoint> path = dirtyPath.points.subList(fromIx, toIx + 1);
            return PathGen.getPathCost(path);
        };
        int cornerIx = 0;
        while (cornerIx < corners.size() - 1) {
            double existingCost;
            Vertex sVert;
            WingedEdge sEdge;
            int corner = (Integer)corners.get(cornerIx);
            TriPoint startPt = dirtyPath.points.get(corner);
            if (cornerIx == corners.size() - 2) {
                addPointsToNextCorner.accept(cornerIx);
                break;
            }
            if (corner == 0) {
                sEdge = startEdge;
                sVert = startVert;
            } else if (!resultPoints.isEmpty()) {
                TriPoint prevPt = (TriPoint)resultPoints.get(resultPoints.size() - 1);
                sEdge = prevPt.getEdge();
                sVert = null;
            } else {
                sEdge = null;
                sVert = null;
            }
            Pair[] resultPath = new Pair[]{null};
            int searchResult = Collections.binarySearch(corners.subList(cornerIx + 2, corners.size()), -1, (i1, i2) -> {
                int nextCorner = i1 >= 0 ? i1 : i2;
                TriPoint destPt = dirtyPath.points.get(nextCorner);
                IPathGoal goal = nextCorner < dirtyPath.points.size() - 1 ? new PointGoal(destPt) : (goalReached.edge != null ? new EdgeGoal(goalReached.edge) : new PointGoal(goalReached.point));
                GetNodeAlongLine nextNode = new GetNodeAlongLine(startPt.p, Util3D.vectorN(startPt.p, destPt.p));
                AStar.AStarSingle astar = new AStar.AStarSingle(nextNode);
                IPathResult visResult = astar.generatePath(mesh, startPt.tri, sEdge, sVert, startPt.p, goal, radius, Double.POSITIVE_INFINITY, pathFilter, null);
                if (!visResult.isSuccessful()) {
                    return 1;
                }
                resultPath[0] = new Pair<AStar.AStarSuccess, Integer>((AStar.AStarSuccess)visResult, nextCorner);
                return -1;
            });
            assert (searchResult < 0);
            int firstNonVis = -searchResult - 1;
            if (firstNonVis == 0) {
                assert (resultPath[0] == null);
                addPointsToNextCorner.accept(cornerIx);
                ++cornerIx;
                continue;
            }
            assert (resultPath[0] != null);
            int nextVisCorner = cornerIx + 2 + firstNonVis - 1;
            assert (((Integer)corners.get(nextVisCorner)).intValue() == ((Integer)resultPath[0].v2).intValue());
            List<TriPoint> newPath = ((AStar.AStarSuccess)resultPath[0].v1).getPoints();
            double nextVisCost = ((AStar.AStarSuccess)resultPath[0].v1).getCost();
            if (theUtil.le(nextVisCost, existingCost = getExistingCost.applyAsDouble(cornerIx, nextVisCorner), 0.001)) {
                addPathPoints.accept(newPath);
                cornerIx = nextVisCorner;
                resultModified = true;
                continue;
            }
            addPointsToNextCorner.accept(cornerIx);
            ++cornerIx;
        }
        if (!resultModified) {
            return dirtyPath;
        }
        if (goalReached.edge != null) {
            TriPoint lastDirtyPoint = dirtyPath.points.get(dirtyPath.points.size() - 1);
            assert (goalReached.edge == lastDirtyPoint.getEdge());
            TriPoint lastNewPoint = (TriPoint)resultPoints.get(resultPoints.size() - 1);
            assert (lastDirtyPoint.tri == lastNewPoint.tri);
            if (lastNewPoint.getEdge() != lastDirtyPoint.getEdge()) {
                resultPoints.add(lastDirtyPoint);
            }
        }
        if (!IPathResult.testPathPoints(resultPoints, goalReached)) {
            return dirtyPath;
        }
        return new PathSuccess(resultPoints, goalReached);
    }

    public static double getPathLength(List<TriPoint> pts) {
        if (pts.size() < 2) {
            return 0.0;
        }
        double len = 0.0;
        Iterator<TriPoint> it = pts.iterator();
        TriPoint ptLast = it.next();
        while (it.hasNext()) {
            TriPoint pt = it.next();
            len += ptLast.p.distance(pt.p);
            ptLast = pt;
        }
        return len;
    }

    public static double getPathCost(List<TriPoint> pts) {
        if (pts.size() < 2) {
            return 0.0;
        }
        double cost = 0.0;
        Iterator<TriPoint> it = pts.iterator();
        TriPoint ptLast = it.next();
        while (it.hasNext()) {
            TriPoint pt = it.next();
            cost += PathGen.getCost(ptLast.tri, ptLast.p.distance(pt.p));
            ptLast = pt;
        }
        return cost;
    }

    public static double getCost(Tri crossedTri, double crossDist) {
        if (crossedTri != null && crossedTri.terrain != null) {
            crossDist *= crossedTri.getSpeedModifier().getDistanceFactorHACK();
        }
        return crossDist;
    }

    private static /* synthetic */ void lambda$getPath$2(AStar.DebugInfo[] di, Consumer odbg, AStar.DebugInfo info) {
        di[0] = info;
        odbg.accept(info);
    }

    public static class NodeDistFactor
    implements IDistFactor {
        private static final long serialVersionUID = 1L;
        public final Map<ANode, Double> factors;

        public NodeDistFactor(Map<ANode, Double> factors) {
            this.factors = factors;
        }

        @Override
        public double getDistFactor(Tri tri) {
            Double factor = this.factors.get(tri.node);
            if (factor != null) {
                return factor;
            }
            return DEFAULT_DIST_FACTOR.getDistFactor(tri);
        }
    }

    public static class DefaultDistFactor
    implements IDistFactor {
        private static final long serialVersionUID = 1L;

        @Override
        public double getDistFactor(Tri tri) {
            if (tri != null && tri.terrain != null) {
                return tri.getSpeedModifier().getDistanceFactorHACK();
            }
            return 1.0;
        }
    }

    public static interface IDistFactor
    extends Serializable {
        public double getDistFactor(Tri var1);
    }

    public static interface IPathGen {
        public IPathResult generatePath(Mesh var1, Tri var2, WingedEdge var3, Vertex var4, Point3d var5, IPathGoal var6, double var7, double var9, Predicate<PathChange> var11, Consumer<AStar.DebugInfo> var12);
    }

    public static class PathFailure
    implements IPathResult {
        public final int types;

        public PathFailure(int types) {
            this.types = types;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        @Override
        public double getLength() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double getCost() {
            return Double.POSITIVE_INFINITY;
        }

        public List<TriEdge> getEdges() {
            return null;
        }

        @Override
        public List<TriPoint> getPoints() {
            return null;
        }

        @Override
        public int getFailureCodes() {
            return this.types;
        }
    }

    public static class PathSuccess
    implements IPathResult {
        public final List<TriPoint> points;
        public final GoalDest goal;
        private final double d_cost;
        private final double d_length;

        public PathSuccess(List<TriPoint> points, GoalDest goal) {
            this(points, goal, Double.NaN, Double.NaN);
        }

        public PathSuccess(List<TriPoint> points, GoalDest goal, double length, double cost) {
            assert (IPathResult.testPathPoints(points, goal));
            this.points = points;
            this.goal = goal;
            this.d_cost = cost;
            this.d_length = length;
        }

        public GoalDest getGoalReached() {
            return this.goal;
        }

        @Override
        public boolean isSuccessful() {
            return true;
        }

        @Override
        public double getLength() {
            return !Double.isNaN(this.d_length) ? this.d_length : PathGen.getPathLength(this.points);
        }

        @Override
        public double getCost() {
            return !Double.isNaN(this.d_cost) ? this.d_cost : PathGen.getPathCost(this.points);
        }

        @Override
        public List<TriPoint> getPoints() {
            return this.points;
        }

        @Override
        public int getFailureCodes() {
            return 0;
        }
    }

    public static interface IPathResult {
        public static final int BOUNDARY = 1;
        public static final int PATH_TOO_NARROW = 2;
        public static final int EDGE_FILTERED = 4;
        public static final int TOO_FAR = 8;

        public boolean isSuccessful();

        public double getLength();

        public double getCost();

        public List<TriPoint> getPoints();

        public static boolean testPathPoints(List<TriPoint> points, GoalDest goal) {
            if (points.size() < 2) {
                return true;
            }
            BiPredicate<TriPoint, TriPoint> testAdjTris = (prev, curr) -> prev.tri != curr.tri && prev.tri.isAdjacent(curr.tri);
            TriPoint prev2 = points.get(0);
            int lastIx = points.size() - 1;
            for (int m = 1; m < lastIx; ++m) {
                TriPoint next = points.get(m);
                if (!testAdjTris.test(prev2, next)) {
                    return false;
                }
                prev2 = next;
            }
            TriPoint last = points.get(lastIx);
            if (goal.point != null || goal.edge.isExit() ? prev2.tri != last.tri : !testAdjTris.test(prev2, last)) {
                return false;
            }
            return goal.edge == null || goal.edge == last.getEdge();
        }

        default public Collection<TriEdge> getEdges() {
            List<TriPoint> points = this.getPoints();
            if (points == null) {
                return null;
            }
            return theUtil.flatMap(this.getPoints(), p -> {
                WingedEdge e = p.getEdge();
                return e != null ? Collections.singleton(new TriEdge(p.tri, e)) : Collections.emptyList();
            });
        }

        public int getFailureCodes();

        default public boolean test(int type) {
            return (this.getFailureCodes() & type) == type;
        }

        default public boolean testBoundary() {
            return this.test(1);
        }

        default public boolean testPathTooNarrow() {
            return this.test(2);
        }

        default public boolean testEdgeFiltered() {
            return this.test(4);
        }

        default public boolean testTooFar() {
            return this.test(8);
        }
    }

    private static class GetNodeAlongLine
    implements AStar.IGetNextNode {
        public final Point3d p;
        public final Vector3d v;

        public GetNodeAlongLine(Point3d p, Vector3d v) {
            this.p = p;
            this.v = v;
        }

        @Override
        public AStar.MTSearchNode get(Mesh mesh, SplitEdge[] sedges, TriPoint startPt, IPathGoal goal, double radius, int id, AStar.MTSearchNode parent, Tri dstTri, WingedEdge edge, boolean landedOnEdge, IDistFactor getDistFactor) {
            Supplier<Point3d> getEdgePoint = () -> {
                Point3d ep = edge.p1();
                Vector3d edir = Util3D.vector(ep, edge.p2());
                double[] isect = Inter2D.isectLineLine(this.p.x, this.p.y, this.v.x, this.v.y, ep.x, ep.y, edir.x, edir.y, 1.0E-6);
                if (isect != null) {
                    isect[1] = thunderheadeng.geometry.Util.clampTIfValid(isect[1], 0.0, 1.0, 1.0E-6);
                    if (Double.isNaN(isect[1])) {
                        return null;
                    }
                    SplitEdge sedge = sedges[edge.id];
                    if (sedge != null && !sedge.isCrossable(isect[1], 1.0E-9)) {
                        return null;
                    }
                    return edge.get(isect[1]);
                }
                return edge.base.midpoint();
            };
            Point3d dstPt = getEdgePoint.get();
            if (dstPt == null) {
                return null;
            }
            return AStar.MTSearchNode.newDestNode(id, sedges, parent, dstTri, edge, landedOnEdge, dstPt, parent.corner, goal, null, getDistFactor);
        }
    }

    public static class MultiEdgeGoal
    implements IEdgeGoal {
        static final long serialVersionUID = 1L;
        public final Set<WingedEdge> edges;
        private transient WingedEdge[] d_edgeList;
        private transient Integer d_hashCode;

        public MultiEdgeGoal(WingedEdge ... edges) {
            this(Arrays.asList(edges));
        }

        public MultiEdgeGoal(Collection<? extends WingedEdge> edges) {
            if (edges.size() == 1) {
                this.edges = Collections.singleton(edges.iterator().next());
            } else {
                assert (!(edges instanceof Set) || Util.isOrdered(edges));
                this.edges = edges instanceof Set ? (Set<Object>)edges : new LinkedIdentityHashSet<WingedEdge>(edges);
            }
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiEdgeGoal && ((MultiEdgeGoal)obj).edges.equals(this.edges);
        }

        @Override
        public int hashCode() {
            if (this.d_hashCode == null) {
                this.d_hashCode = 0x6238FEE ^ this.edges.hashCode();
            }
            return this.d_hashCode;
        }

        @Override
        public Set<WingedEdge> getEdges() {
            return this.edges;
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        private WingedEdge[] getEdgeList() {
            if (this.d_edgeList == null) {
                this.d_edgeList = theUtil.toArray(this.edges, WingedEdge.class);
            }
            return this.d_edgeList;
        }

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            for (WingedEdge edge : this.getEdgeList()) {
                if (!PathGen.isTravellable(sedges, edge)) continue;
                return true;
            }
            return false;
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            double minDistSq = Double.POSITIVE_INFINITY;
            for (WingedEdge edge : this.getEdgeList()) {
                double distSq;
                if (!PathGen.isTravellable(sedges, edge) || !((distSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p)) < minDistSq)) continue;
                minDistSq = distSq;
            }
            return minDistSq == Double.POSITIVE_INFINITY ? minDistSq : Math.sqrt(minDistSq);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            assert (goalReached.edge != null);
            WingedEdge edge = goalReached.edge;
            assert (PathGen.isTravellable(sedges, edge));
            double distsq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            return Math.sqrt(distsq);
        }

        public WingedEdge getClosest(SplitEdge[] sedges, Point3d p) {
            double minDistSq = Double.MAX_VALUE;
            WingedEdge closestEdge = null;
            for (WingedEdge edge : this.getEdgeList()) {
                double distSq;
                if (!PathGen.isTravellable(sedges, edge) || !((distSq = Inter3D.distSqToNearestPtOnLineSeg(edge.base.n1.p, edge.base.n2.p, p)) < minDistSq)) continue;
                minDistSq = distSq;
                closestEdge = edge;
            }
            return closestEdge;
        }

        @Override
        public Pair<GoalDest, Double> testReached(PathChange pc, Point3d prevPt) {
            if (pc.edge != null && this.edges.contains(pc.edge)) {
                return new Pair<GoalDest, Double>(new GoalDest(pc.edge), 0.0);
            }
            return null;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            WingedEdge closestEdge = this.getClosest(shortenedEdges, p);
            if (closestEdge == null) {
                return null;
            }
            return new Pair<GoalDest, TriPoint>(new GoalDest(closestEdge), this.project(closestEdge, shortenedEdges, p));
        }

        @Override
        public TriPoint project(GoalDest reachResult, SplitEdge[] shortenedEdges, Point3d p) {
            return this.project(reachResult != null ? reachResult.edge : null, shortenedEdges, p);
        }

        public TriPoint project(WingedEdge edge, SplitEdge[] shortenedEdges, Point3d p) {
            if (edge == null && (edge = this.getClosest(shortenedEdges, p)) == null) {
                return null;
            }
            p = Inter3D.nearestPointOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            if ((p = PathGen.getWalkablePointOnEdge(shortenedEdges, edge, p)) == null) {
                return null;
            }
            Tri tri = edge.t1 != null ? edge.t1 : edge.t2;
            return new TriPoint(tri, p, edge);
        }
    }

    public static class EdgeGoal
    implements IEdgeGoal {
        static final long serialVersionUID = 1L;
        public final WingedEdge edge;

        public EdgeGoal(WingedEdge edge) {
            this.edge = edge;
        }

        @Override
        public Set<WingedEdge> getEdges() {
            return Collections.singleton(this.edge);
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof EdgeGoal && ((EdgeGoal)obj).edge.id == this.edge.id;
        }

        @Override
        public int hashCode() {
            return 0x1982F32B ^ this.edge.id;
        }

        @Override
        public boolean isStatic(KB kb) {
            return true;
        }

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            return PathGen.isTravellable(sedges, this.edge);
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            if (!PathGen.isTravellable(sedges, this.edge)) {
                return Double.POSITIVE_INFINITY;
            }
            double distsq = Inter3D.distSqToNearestPtOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, p);
            return Math.sqrt(distsq);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        @Override
        public Pair<GoalDest, Double> testReached(PathChange pc, Point3d prevPt) {
            if (pc.edge != null && pc.edge.id == this.edge.id) {
                return new Pair<GoalDest, Double>(new GoalDest(this.edge), 0.0);
            }
            return null;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            TriPoint tp = this.project(this.edge, shortenedEdges, p);
            if (tp == null) {
                return null;
            }
            return new Pair<GoalDest, TriPoint>(new GoalDest(this.edge), tp);
        }

        @Override
        public TriPoint project(GoalDest o, SplitEdge[] shortenedEdges, Point3d p) {
            return this.project(o != null ? o.edge : null, shortenedEdges, p);
        }

        public TriPoint project(WingedEdge o, SplitEdge[] shortenedEdges, Point3d p) {
            p = Inter3D.nearestPointOnLineSeg(this.edge.base.n1.p, this.edge.base.n2.p, p);
            if ((p = PathGen.getWalkablePointOnEdge(shortenedEdges, this.edge, p)) == null) {
                return null;
            }
            Tri tri = this.edge.t1 != null ? this.edge.t1 : this.edge.t2;
            return new TriPoint(tri, p, this.edge);
        }
    }

    public static interface IEdgeGoal
    extends IPathGoal,
    Serializable {
        public Set<WingedEdge> getEdges();

        @Override
        default public Path generatePath(KB kb, OccAgent agent, List<TriPoint> pathPoints, Predicate<WingedEdge> edgeFilter, boolean isVirtual, DoorDir doorDir, AStar.DebugInfo dbgInfo) {
            Set<WingedEdge> edges = this.getEdges();
            WingedEdge reachedTarget = null;
            for (int m = pathPoints.size() - 1; m >= 0; --m) {
                TriPoint tpoint = pathPoints.get(m);
                WingedEdge edge = tpoint.getEdge();
                if (!edges.contains(edge)) continue;
                if (!1.$assertionsDisabled && m != pathPoints.size() - 1) {
                    throw new AssertionError((Object)"Target edge should be the last in the list");
                }
                reachedTarget = edge;
                break;
            }
            if (!1.$assertionsDisabled && reachedTarget == null) {
                throw new AssertionError();
            }
            TriPoint lastPt = pathPoints.get(pathPoints.size() - 1);
            if (reachedTarget != null && reachedTarget.isDoor()) {
                ANode door = reachedTarget.getDoorNode();
                WingedEdge doorEdge = reachedTarget;
                ArrayList<IPathSeek> path = new ArrayList<IPathSeek>(pathPoints.size());
                ANode virtualDoor = isVirtual ? door : null;
                for (int m = 0; m < pathPoints.size() - 1; ++m) {
                    path.add(new WaypointSeek(pathPoints.get(m), edgeFilter, virtualDoor));
                }
                double occRadius = agent.getGeometryRadius();
                if (door.isExitDoor()) {
                    ExitSeek seek = new ExitSeek(kb.getMesh(), door, lastPt, occRadius, edgeFilter);
                    path.add(seek);
                } else {
                    Point3d segmentPt = Inter3D.nearestPointOnLineSeg(doorEdge.base.n1.p, doorEdge.base.n2.p, lastPt.p);
                    Mesh.DoorSegmentEndpoint[] lastSegment = kb.getMesh().getNearestTraversableDoorSegment(occRadius, door, doorEdge, segmentPt);
                    if (lastSegment != null) {
                        Tri destTri;
                        if (doorDir == null) {
                            doorDir = PathGen.getInferredEdgeDir(pathPoints, doorEdge);
                        }
                        if ((destTri = doorEdge.getDestTri(doorDir)) == null) {
                            destTri = doorEdge.getAdjTri(destTri);
                        }
                        if (!1.$assertionsDisabled && destTri == null) {
                            throw new AssertionError();
                        }
                        DoorSeek lastSeek = new DoorSeek(door, lastSegment, new TriPoint(destTri, lastPt.p, doorEdge), edgeFilter, isVirtual);
                        path.add(lastSeek);
                    } else {
                        path.add(new WaypointSeek(lastPt, edgeFilter));
                    }
                }
                return new Path(path, dbgInfo);
            }
            if (!1.$assertionsDisabled) {
                throw new AssertionError((Object)"We don't currently support ending with a non-door edge");
            }
            return null;
        }

        static {
            if (1.$assertionsDisabled) {
                // empty if block
            }
        }
    }

    public static class SearchConnection
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final WingedEdgeUse eu;
        public final Tri tri;
        public final boolean isVirtual;
        public final IDistFactor distFactor;

        private SearchConnection(WingedEdgeUse eu, Tri tri, boolean isVirtual, IDistFactor distFactor) {
            this.eu = eu;
            this.tri = tri;
            this.isVirtual = isVirtual;
            this.distFactor = distFactor;
        }
    }

    public static class MultiPointGoal
    implements IPathGoal,
    Serializable {
        static final long serialVersionUID = 1L;
        private Collection<? extends ITpSource> d_ptSrc;
        private Map<Tri, List<TriPoint>> d_triPoints = null;

        public MultiPointGoal(Collection<? extends ITpSource> ptSrc) {
            this.d_ptSrc = ptSrc;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof MultiPointGoal && GoalUtil.setsEqual(this.getPoints(), ((MultiPointGoal)obj).getPoints());
        }

        @Override
        public int hashCode() {
            return 0x23FA3BE ^ GoalUtil.setHashCode(this.getPoints());
        }

        private Collection<TriPoint> getPoints() {
            return theUtil.map(this.d_ptSrc, pt -> pt.getTriPoint());
        }

        @Override
        public boolean isStatic(KB kb) {
            return this.d_ptSrc.stream().allMatch(ITpSource::isStatic);
        }

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            return true;
        }

        @Override
        public Path generatePath(KB kb, OccAgent agent, List<TriPoint> pathPoints, Predicate<WingedEdge> edgeFilter, boolean isVirtual, DoorDir doorDir, AStar.DebugInfo dbgInfo) {
            ArrayList<IPathSeek> seekPts = new ArrayList<IPathSeek>(pathPoints.size() + 1);
            for (int m = 0; m < pathPoints.size(); ++m) {
                seekPts.add(new WaypointSeek(pathPoints.get(m), edgeFilter));
            }
            return new Path(seekPts, dbgInfo);
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            double distSq = this.getPoints().stream().mapToDouble(tp -> p.distanceSquared(tp.p)).min().getAsDouble();
            return Math.sqrt(distSq);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        private Map<Tri, List<TriPoint>> getTriPoints() {
            if (this.d_triPoints == null) {
                this.d_triPoints = new IdentityHashMap<Tri, List<TriPoint>>();
                for (ITpSource iTpSource : this.d_ptSrc) {
                    this.d_triPoints.computeIfAbsent(iTpSource.getTriPoint().tri, t -> new ArrayList(2)).add(iTpSource.getTriPoint());
                }
            }
            return this.d_triPoints;
        }

        @Override
        public Pair<GoalDest, Double> testReached(PathChange pc, Point3d prevPt) {
            Map<Tri, List<TriPoint>> triPtMap = this.getTriPoints();
            List points = triPtMap.getOrDefault(pc.tri, Collections.emptyList());
            if (!points.isEmpty()) {
                TriPoint closest = null;
                double closestDistSq = Double.MAX_VALUE;
                for (TriPoint p : points) {
                    double distSq = prevPt.distanceSquared(p.p);
                    if (!(distSq < closestDistSq)) continue;
                    closestDistSq = distSq;
                    closest = p;
                }
                double dist = triPtMap.size() == 1 ? 0.0 : Math.sqrt(closestDistSq);
                return new Pair<GoalDest, Double>(new GoalDest(closest), dist);
            }
            return null;
        }

        @Override
        public TriPoint project(GoalDest o, SplitEdge[] shortenedEdges, Point3d p) {
            return o.point;
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d prevPt) {
            TriPoint closest = null;
            double closestDistSq = Double.MAX_VALUE;
            for (ITpSource iTpSource : this.d_ptSrc) {
                double distSq = prevPt.distanceSquared(iTpSource.getTriPoint().p);
                if (!(distSq < closestDistSq)) continue;
                closestDistSq = distSq;
                closest = iTpSource.getTriPoint();
            }
            return new Pair<GoalDest, Object>(new GoalDest(closest), closest);
        }
    }

    public static class PointGoal
    implements IPathGoal,
    Serializable {
        static final long serialVersionUID = 1L;
        private ITpSource d_ptSrc;

        @Override
        public boolean isValid(SplitEdge[] sedges, double radius) {
            return true;
        }

        public PointGoal(OccAgent agent) {
            this(new ITpSource.AgentTpSource(agent));
        }

        public PointGoal(ITpSource ptSrc) {
            this.d_ptSrc = ptSrc;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof PointGoal && ((PointGoal)obj).d_ptSrc.getTriPoint().equals(this.d_ptSrc.getTriPoint());
        }

        @Override
        public int hashCode() {
            return 0x23FA3BE ^ this.d_ptSrc.getTriPoint().hashCode();
        }

        @Override
        public boolean isStatic(KB kb) {
            return this.d_ptSrc.isStatic();
        }

        @Override
        public Path generatePath(KB kb, OccAgent agent, List<TriPoint> pathPoints, Predicate<WingedEdge> edgeFilter, boolean isVirtual, DoorDir doorDir, AStar.DebugInfo dbgInfo) {
            ArrayList<IPathSeek> seekPts = new ArrayList<IPathSeek>(pathPoints.size() + 1);
            for (int m = 0; m < pathPoints.size(); ++m) {
                seekPts.add(new WaypointSeek(pathPoints.get(m), edgeFilter));
            }
            assert (pathPoints.isEmpty() || pathPoints.get(pathPoints.size() - 1).tolEquals(this.getTriPoint(), 1.0E-6));
            if (pathPoints.size() < 2) {
                seekPts.add(new WaypointSeek(this.getTriPoint(), edgeFilter));
            }
            return new Path(seekPts, dbgInfo);
        }

        @Override
        public double getMinDistance(SplitEdge[] sedges, Point3d p) {
            return p.distance(this.d_ptSrc.getTriPoint().p);
        }

        @Override
        public double getDistance(SplitEdge[] sedges, GoalDest goalReached, Point3d p) {
            return this.getMinDistance(sedges, p);
        }

        public double getMinDistance(WingedEdge edge, SplitEdge[] sedges) {
            Point3d p = this.d_ptSrc.getTriPoint().p;
            double neart = Inter3D.nearestTOnLineSeg(edge.base.n1.p, edge.base.n2.p, p);
            SplitEdge sedge = sedges[edge.id];
            if (sedge != null) {
                neart = sedge.findClosest(neart);
            }
            Point3d edgep = Util3D.linesegPoint(edge.base.n1.p, edge.base.n2.p, neart);
            return p.distance(edgep);
        }

        @Override
        public Pair<GoalDest, Double> testReached(PathChange pc, Point3d prevPt) {
            if (pc.tri == this.d_ptSrc.getTriPoint().tri) {
                return new Pair<GoalDest, Double>(new GoalDest(this.d_ptSrc.getTriPoint()), 0.0);
            }
            return null;
        }

        @Override
        public TriPoint project(GoalDest o, SplitEdge[] shortenedEdges, Point3d p) {
            return this.getTriPoint();
        }

        @Override
        public Pair<GoalDest, TriPoint> project(SplitEdge[] shortenedEdges, Point3d p) {
            TriPoint result = this.getTriPoint();
            return new Pair<GoalDest, TriPoint>(new GoalDest(result), result);
        }

        public TriPoint getTriPoint() {
            return this.d_ptSrc.getTriPoint();
        }
    }

    public static class GoalDest {
        public final TriPoint point;
        public final WingedEdge edge;

        public GoalDest(TriPoint point) {
            this.point = point;
            this.edge = null;
        }

        public GoalDest(WingedEdge edge) {
            this.edge = edge;
            this.point = null;
        }
    }

    public static interface IPathGoal {
        public boolean isStatic(KB var1);

        public boolean isValid(SplitEdge[] var1, double var2);

        public double getMinDistance(SplitEdge[] var1, Point3d var2);

        public double getDistance(SplitEdge[] var1, GoalDest var2, Point3d var3);

        public Pair<GoalDest, Double> testReached(PathChange var1, Point3d var2);

        public TriPoint project(GoalDest var1, SplitEdge[] var2, Point3d var3);

        public Pair<GoalDest, TriPoint> project(SplitEdge[] var1, Point3d var2);

        public Path generatePath(KB var1, OccAgent var2, List<TriPoint> var3, Predicate<WingedEdge> var4, boolean var5, DoorDir var6, AStar.DebugInfo var7);

        public int hashCode();

        public boolean equals(Object var1);
    }

    public static enum GeneratorType {
        ASTAR((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9) -> PathGen.getPathAStar(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9)),
        GEODESIC((x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9) -> PathGen.getPathGeodesic(x$0, x$1, x$2, x$3, x$4, x$5, x$6, x$7, x$8, x$9));

        public final IPathGen algorithm;

        private GeneratorType(IPathGen algorithm) {
            this.algorithm = algorithm;
        }
    }

    public static enum PathCleanup {
        DISABLED,
        ALWAYS,
        IF_NECESSARY;

    }
}

