/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.output;

import inferno.data2.ANode;
import inferno.data2.AnimatedGeom;
import inferno.data2.AppearanceMod;
import inferno.data2.AttractorSim;
import inferno.data2.Blockage;
import inferno.data2.Camera;
import inferno.data2.IAnimSrc;
import inferno.data2.Obscuration;
import inferno.data2.SpeedModifier;
import inferno.sim.CompositeCollections;
import inferno.sim.KB;
import inferno.sim.ObjectTracker;
import inferno.sim.output.AVisWriter;
import java.awt.Color;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Predicate;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.objs.Sphere;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.theUtil;

public class GeomVisWriter
extends AVisWriter
implements Serializable {
    static final long serialVersionUID = 1L;
    private static final int FLAGS = 0;
    private static final int DEFAULT_DATA_BLOCK_SIZE = 2000;
    private final ObjectTracker<IAnimSrc, Void> d_geomTracker = new ObjectTracker();
    private final AVisWriter.InterleavedBlockWriter d_dataBlockWriter = new AVisWriter.InterleavedBlockWriter(this, 2000);
    public static final int FILTER_ACCEPT_ANIMATED = 1;
    public static final int FILTER_ACCEPT_DYNAMIC = 2;
    public static final int FILTER_ACCEPT_ALL = 3;

    public GeomVisWriter(String filename) throws FileNotFoundException {
        super(filename, Version.curr().ordinal(), 0);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.d_dataBlockWriter.deserialize();
    }

    @Override
    protected void writeCustomHeaderData(KB kb, DataOutputStream stream) throws IOException {
        IdentityHashSet<? extends IAnimSrc> dynamicObjs = new IdentityHashSet<IAnimSrc>(GeomVisWriter.getDynamicGeom(kb));
        IFilteredCollection<IAnimSrc> animatedNodes = theUtil.filter(GeomVisWriter.getAnimatedObjs(kb), Filters.reject(dynamicObjs, IAnimSrc.class));
        stream.writeInt(animatedNodes.size());
        for (IAnimSrc node : animatedNodes) {
            GeomVisWriter.writeGeomId(stream, node);
        }
        this.d_dataBlockWriter.init();
    }

    private static boolean test(int options, int option) {
        return (options & option) == option;
    }

    public static Collection<? extends IAnimSrc> getGeom(KB kb, int filters) {
        boolean animated = GeomVisWriter.test(filters, 1);
        boolean dynamic = GeomVisWriter.test(filters, 2);
        ArrayList<Collection<IAnimSrc>> group = new ArrayList<Collection<IAnimSrc>>();
        if (animated) {
            group.add(theUtil.filter(kb.getNodes(), new Predicate<ANode>(){

                @Override
                public boolean test(ANode o) {
                    return o.getAnimationId() >= 0;
                }
            }));
            group.add(kb.getBlockages());
            group.add(theUtil.filter(kb.getCameras(), new Predicate<Camera>(){

                @Override
                public boolean test(Camera o) {
                    return o.get(Camera.PROP_SECURITY);
                }
            }));
            group.add(kb.getAnimatedGeoms().values());
        }
        if (animated || dynamic) {
            group.add(kb.getObscurations());
            group.add(theUtil.filter(kb.getAllAttractors(), attr -> attr.type.isPlaced && attr.getLocation() != null));
        }
        if (dynamic) {
            group.add(kb.getAppearanceMods());
        }
        return CompositeCollections.group(theUtil.toArray(group, Collection.class));
    }

    public static Collection<? extends IAnimSrc> getAllObjs(KB kb) {
        return GeomVisWriter.getGeom(kb, 3);
    }

    public static Collection<? extends IAnimSrc> getAnimatedObjs(KB kb) {
        return GeomVisWriter.getGeom(kb, 1);
    }

    public static Collection<? extends IAnimSrc> getDynamicGeom(KB kb) {
        return GeomVisWriter.getGeom(kb, 2);
    }

    public void writeFrame(KB kb, double t) {
        DataOutputStream oos = this.getStream();
        try {
            ArrayList added = new ArrayList();
            ArrayList removed = new ArrayList();
            this.d_geomTracker.beginUpdate(GeomVisWriter.getDynamicGeom(kb), added, removed);
            this.writeCreationData(t, added, removed);
            long frameix = this.getPos();
            Collection<? extends IAnimSrc> animNodes = GeomVisWriter.getAnimatedObjs(kb);
            GeomVisWriter.writeGeomUpdate(oos, animNodes);
            this.writeFrameIx(t, frameix);
            this.d_geomTracker.endUpdate(removed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void writeCreationData(double time, Collection<? extends IAnimSrc> added, Collection<? extends IAnimSrc> removed) throws IOException {
        if (added.isEmpty() && removed.isEmpty()) {
            return;
        }
        this.d_dataBlockWriter.beginWrite();
        DataOutputStream oos = new DataOutputStream(this.d_dataBlockWriter);
        long statusPos = this.d_dataBlockWriter.getPos();
        oos.writeByte(0);
        oos.writeFloat((float)time);
        GeomVisWriter.writeGeomsAdded(oos, added);
        GeomVisWriter.writeGeomsRemoved(oos, removed);
        long curPos = this.d_dataBlockWriter.getPos();
        this.d_dataBlockWriter.setPos(statusPos);
        oos.writeByte(1);
        this.d_dataBlockWriter.setPos(curPos);
        this.d_dataBlockWriter.endWrite();
    }

    public static void writeGeomId(DataOutputStream stream, IAnimSrc animObj) throws IOException {
        if (animObj instanceof ANode) {
            ANode node = (ANode)animObj;
            AnimType type = node.isDoor() ? AnimType.DOOR : AnimType.XFORM;
            stream.writeInt(type.ordinal());
            stream.writeInt(node.getAnimationId());
        } else if (animObj instanceof Blockage) {
            Blockage blkg = (Blockage)animObj;
            stream.writeInt(AnimType.BLOCKAGE.ordinal());
            stream.writeInt(blkg.id);
        } else if (animObj instanceof Obscuration) {
            Obscuration obsc = (Obscuration)animObj;
            stream.writeInt(AnimType.OBSCURATION.ordinal());
            stream.writeInt(obsc.id);
        } else if (animObj instanceof Camera) {
            Camera cam = (Camera)animObj;
            stream.writeInt(AnimType.CAMERA.ordinal());
            stream.writeInt(cam.getId());
        } else if (animObj instanceof AppearanceMod) {
            AppearanceMod appMod = (AppearanceMod)animObj;
            stream.writeInt(AnimType.APPEARANCE_OP.ordinal());
            stream.writeInt(appMod.getId());
        } else if (animObj instanceof AnimatedGeom) {
            AnimatedGeom ag = (AnimatedGeom)animObj;
            stream.writeInt(AnimType.ANIMATED_GEOM.ordinal());
            stream.writeLong(ag.resultsId);
        } else if (animObj instanceof AttractorSim) {
            AttractorSim attr = (AttractorSim)animObj;
            stream.writeInt(AnimType.ATTRACTOR.ordinal());
            stream.writeInt(attr.getId());
        } else assert (false) : "Unknown animation source: " + animObj.getClass().getSimpleName();
    }

    public static void writeGeomUpdate(DataOutputStream oos, Collection<? extends IAnimSrc> animNodes) throws IOException {
        oos.writeInt(animNodes.size());
        for (IAnimSrc iAnimSrc : animNodes) {
            GeomVisWriter.writeGeomFrame(oos, iAnimSrc);
        }
    }

    protected static void writeGeomFrame(DataOutputStream oos, IAnimSrc obj) throws IOException {
        GeomVisWriter.writeGeomId(oos, obj);
        if (obj instanceof ANode) {
            ANode anode = (ANode)obj;
            if (anode.isDoor()) {
                int open = anode.isPhysicallyClosed() ? 0 : 1;
                oos.writeByte(open);
            } else {
                Vector3d offset = anode.getAnimOffset();
                Quat4d rot = anode.getAnimRot();
                GeomVisWriter.write(oos, offset);
                GeomVisWriter.write(oos, rot);
            }
        } else if (obj instanceof Blockage) {
            Blockage blkg = (Blockage)obj;
            SpeedModifier smod = blkg.getSpeedModifier();
            if (!blkg.isActive()) {
                smod = SpeedModifier.IDENTITY;
            }
            oos.writeByte((byte)smod.type.ordinal());
            oos.writeFloat((float)smod.value);
        } else if (obj instanceof Obscuration) {
            Obscuration obsc = (Obscuration)obj;
            int active = obsc.active ? 1 : 0;
            oos.writeByte(active);
            Color c = obsc.color;
            oos.writeByte(c.getRed());
            oos.writeByte(c.getGreen());
            oos.writeByte(c.getBlue());
            oos.writeFloat((float)obsc.density);
        } else if (obj instanceof Camera) {
            Camera cam = (Camera)obj;
            GeomVisWriter.write(oos, cam.get(Camera.PROP_LOC));
            GeomVisWriter.write(oos, cam.get(Camera.PROP_REF));
            GeomVisWriter.write(oos, cam.get(Camera.PROP_UP));
            oos.writeFloat(cam.get(Camera.PROP_ZOOM).floatValue());
            GeomVisWriter.write(oos, cam.get(Camera.PROP_ZOOM_LOC));
        } else if (obj instanceof AnimatedGeom) {
            AnimatedGeom ag = (AnimatedGeom)obj;
            oos.writeBoolean(ag.isVisible());
        } else if (obj instanceof AttractorSim) {
            AttractorSim attr = (AttractorSim)obj;
            GeomVisWriter.write(oos, attr.getLocation().p);
            oos.writeFloat((float)attr.getInfluence());
        }
    }

    private static void write(DataOutputStream oos, Tuple3d p) throws IOException {
        oos.writeFloat((float)p.x);
        oos.writeFloat((float)p.y);
        oos.writeFloat((float)p.z);
    }

    private static void write(DataOutputStream oos, Tuple2d p) throws IOException {
        oos.writeFloat((float)p.x);
        oos.writeFloat((float)p.y);
    }

    private static void write(DataOutputStream oos, Quat4d rot) throws IOException {
        oos.writeFloat((float)rot.x);
        oos.writeFloat((float)rot.y);
        oos.writeFloat((float)rot.z);
        oos.writeFloat((float)rot.w);
    }

    public static void writeGeomsAdded(DataOutputStream oos, Collection<? extends IAnimSrc> objs) throws IOException {
        oos.writeInt(objs.size());
        for (IAnimSrc iAnimSrc : objs) {
            GeomVisWriter.writeGeomDesc(oos, iAnimSrc);
        }
    }

    public static void writeGeomDesc(DataOutputStream oos, IAnimSrc obj) throws IOException {
        GeomVisWriter.writeGeomId(oos, obj);
        if (obj instanceof Obscuration) {
            GeomVisWriter.writeGeomDesc(oos, (Obscuration)obj);
        } else if (obj instanceof AppearanceMod) {
            GeomVisWriter.writeGeomDesc(oos, (AppearanceMod)obj);
        } else if (obj instanceof AttractorSim) {
            GeomVisWriter.writeGeomDesc(oos, (AttractorSim)obj);
        }
    }

    private static void writeGeomDesc(DataOutputStream oos, Obscuration obsc) throws IOException {
        oos.writeChars(obsc.floorName);
        oos.writeChar(0);
        float[] comps = new float[3];
        obsc.color.getColorComponents(comps);
        oos.writeFloat(comps[0]);
        oos.writeFloat(comps[1]);
        oos.writeFloat(comps[2]);
        oos.writeFloat((float)obsc.density);
    }

    private static void writeGeomDesc(DataOutputStream oos, AppearanceMod appMod) throws IOException {
        oos.writeInt(appMod.type.ordinal());
        if (appMod.region instanceof Sphere) {
            Sphere sphere = (Sphere)appMod.region;
            oos.writeInt(0);
            GeomVisWriter.write(oos, sphere.center);
            oos.writeFloat((float)sphere.radius);
        } else {
            oos.writeInt(-1);
        }
    }

    private static void writeGeomDesc(DataOutputStream oos, AttractorSim attr) throws IOException {
        oos.writeInt(attr.getRootId());
    }

    public static void writeGeomsRemoved(DataOutputStream oos, Collection<? extends IAnimSrc> objs) throws IOException {
        oos.writeInt(objs.size());
        for (IAnimSrc iAnimSrc : objs) {
            GeomVisWriter.writeGeomId(oos, iAnimSrc);
        }
    }

    private static enum AnimType {
        XFORM,
        DOOR,
        BLOCKAGE,
        OBSCURATION,
        CAMERA,
        APPEARANCE_OP,
        ANIMATED_GEOM,
        ATTRACTOR;

    }

    private static enum Version {
        V0,
        V1,
        V2,
        V3,
        V4,
        V5,
        V6;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

