/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim.ai;

import inferno.data2.AttractorSim;
import inferno.data2.OccTarget;
import inferno.data2.Occupant;
import inferno.data2.ai.IGoal;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.BehaviorSim;
import inferno.sim.DoorQueue;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.ai.AGoalAiCore;
import inferno.sim.ai.AiUtil;
import inferno.sim.ai.IGoalAiCore;
import inferno.sim.steering.ISteeringBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class DefaultAiCore
extends AGoalAiCore {
    private static final long serialVersionUID = 1L;
    private IGoalInstance d_goalInst;
    private ISteeringBehavior d_steer = null;
    private ISeekArea d_currSeekArea;
    private AttractorState d_attrState = new AttractorState();
    private OccTarget d_currOccTarget = null;
    private boolean d_moreToDo = true;

    private boolean isInitialized() {
        return this.d_steer != null;
    }

    @Override
    public ISeekArea getCurrentSeekArea(KB kb, OccAgent agent) {
        return this.d_currSeekArea;
    }

    @Override
    public Optional<AttractorSim> getAttractorInUse(KB kb, OccAgent agent) {
        return this.d_attrState.getAttractorInUse(kb, agent);
    }

    @Override
    public Optional<OccTarget> getOccTargetInUse(KB kb, OccAgent agent) {
        return Optional.ofNullable(this.d_currOccTarget);
    }

    @Override
    public IGoalInstance getCurrentGoalInstance(OccAgent agent) {
        return this.d_goalInst != null ? this.d_goalInst : AiUtil.getDefaultCurrGoal(agent);
    }

    @Override
    public ISteeringBehavior getSteering(OccAgent agent) {
        assert (this.isInitialized());
        return this.d_steer;
    }

    @Override
    public IProgressNote getProgress(KB kb, OccAgent agent) {
        return this.getCurrentGoalInstance(agent).getProgress(kb, agent);
    }

    @Override
    public void doorCrossed(double t, OccAgent agent, DoorQueue door) {
        assert (this.isInitialized());
        this.getCurrentGoalInstance(agent).doorCrossed(agent, door);
        this.d_steer.doorCrossed(t, agent, door);
    }

    @Override
    public void init(KB kb, OccAgent agent) {
        assert (!this.isInitialized());
        this.initGoal(kb, agent, agent.getGoalIx(), false);
    }

    private void initGoal(KB kb, OccAgent agent, int goalIx, boolean interrupted) {
        List<IGoal> goalSequence = agent.getOcc().behaviorStack.peek().behavior.goals;
        IGoal currentGoal = goalSequence.get(goalIx);
        IGoalInstance ginst = currentGoal.begin(kb, agent);
        this.initGoalInst(kb, agent, ginst, interrupted);
    }

    private void initGoalInst(KB kb, OccAgent agent, IGoalInstance ginst, boolean interrupted) {
        this.d_goalInst = ginst;
        this.d_currSeekArea = IGoalAiCore.calcCurrentSeekArea(this, kb, agent, null);
        if (this.d_steer != null) {
            this.d_steer.done(kb, agent, interrupted);
        }
        this.d_steer = ginst.generateSteeringBehavior(kb, agent);
        this.updateState(kb, agent);
    }

    @Override
    public boolean getHasMoreToDo(KB kb, OccAgent agent) {
        return this.d_moreToDo;
    }

    @Override
    protected void updateState(KB kb, OccAgent agent) {
        super.updateState(kb, agent);
        this.d_currSeekArea = IGoalAiCore.calcCurrentSeekArea(this, kb, agent, this.getCurrentGoalInstance(agent));
        this.d_moreToDo = this.testMoreToDo(kb, agent);
    }

    private boolean testMoreToDo(KB kb, OccAgent agent) {
        Occupant occ = agent.getOcc();
        if (occ.behaviorStack.isEmpty()) {
            return false;
        }
        BehaviorSim.BehaviorInProgress curr = occ.behaviorStack.peek();
        if (curr.goalIndex < curr.behavior.goals.size() - 1) {
            return true;
        }
        IGoalInstance ginst = this.getCurrentGoalInstance(agent);
        if (!ginst.isSkippable(kb, agent)) {
            return true;
        }
        return this.d_attrState.testMoreToDo(kb, agent);
    }

    private void startNextGoal(KB kb, OccAgent agent, boolean interrupted) {
        int currentGoalIx = agent.getGoalIx();
        this.startGoal(kb, agent, currentGoalIx + 1, interrupted);
    }

    private void startGoal(KB kb, OccAgent agent, int goalIx, boolean interrupted) {
        boolean resetElevState = this.d_goalInst != null ? !this.d_goalInst.wasImmediate() : false;
        this.initGoal(kb, agent, goalIx, interrupted);
        agent.setGoalIx(goalIx, resetElevState);
    }

    @Override
    public void update(Engine e, KB kb, OccAgent agent) {
        assert (this.isInitialized());
        boolean wasSeeking = this.isSeeking(kb, agent);
        Deque<BehaviorSim.BehaviorInProgress> behaviorStack = agent.getOcc().behaviorStack;
        IGoalInstance currGoal = this.getCurrentGoalInstance(agent);
        ISeekArea oldArea = currGoal.update(kb, agent);
        if (oldArea != null) {
            this.recordSeekArea(kb, agent, oldArea);
            this.updateState(kb, agent);
        }
        if (currGoal.needsNewSteeringBehavior(kb, agent)) {
            if (this.d_steer != null) {
                this.d_steer.done(kb, agent, false);
            }
            this.d_steer = currGoal.generateSteeringBehavior(kb, agent);
        }
        if (currGoal.isReached(kb, agent)) {
            ISeekArea areaReached = currGoal.end(kb, agent);
            if (areaReached != null) {
                this.recordSeekArea(kb, agent, areaReached);
            }
            this.d_attrState.goalReached(kb, agent);
            boolean initNewGoal = true;
            List<IGoal> goalSequence = behaviorStack.peek().behavior.goals;
            if (agent.getGoalIx() + 1 >= goalSequence.size()) {
                behaviorStack.pop();
                if (currGoal.isAlwaysTerminal()) {
                    behaviorStack.clear();
                }
                while (!behaviorStack.isEmpty() && behaviorStack.size() > this.d_attrState.getMinBehaviorStackSize() && agent.getGoalIx() + 1 >= behaviorStack.peek().behavior.size()) {
                    behaviorStack.pop();
                }
                if (behaviorStack.isEmpty()) {
                    agent.finish(kb);
                    initNewGoal = false;
                }
                initNewGoal &= this.d_attrState.behaviorStackReduced(kb, agent);
            }
            if (initNewGoal) {
                this.startNextGoal(kb, agent, false);
            }
        }
        this.updateState(kb, agent);
        currGoal = this.getCurrentGoalInstance(agent);
        this.d_attrState.updateAttractor(kb, agent, currGoal, wasSeeking);
        this.d_currOccTarget = IGoalAiCore.calcOccTargetInUse(kb, agent, currGoal);
        agent.updateStats(kb, e.getCurrentDt());
    }

    @Override
    public void preMove(KB kb, OccAgent agent, double dt) {
        this.getCurrentGoalInstance(agent).preMove(kb, agent, dt);
    }

    @Override
    public void processLost(KB kb, OccAgent agent) {
        this.getCurrentGoalInstance(agent).processLost(kb, agent);
    }

    private static class AttrScheduleInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final double tScheduled;
        public final double tConsider;
        public final boolean important;

        public AttrScheduleInfo(double tScheduled, double tConsider, boolean important) {
            this.tScheduled = tScheduled;
            this.tConsider = tConsider;
            this.important = important;
        }
    }

    private class AttractorState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<AttractorSim> d_closedAttractors = new IdentityHashSet<AttractorSim>();
        private final NavigableMap<Double, List<AttractorSim>> d_futureAttractor = new TreeMap<Double, List<AttractorSim>>();
        private final Map<AttractorSim, AttrScheduleInfo> d_futureAttractorInfo = new IdentityHashMap<AttractorSim, AttrScheduleInfo>();
        private final Map<AttractorSim, Double> d_attractorMemSeek = new LinkedIdentityHashMap<AttractorSim, Double>();
        private final Map<AttractorSim, Double> d_attractorMemIdle = new LinkedIdentityHashMap<AttractorSim, Double>();
        private CurrAttractor d_currAttractor = null;

        private AttractorState() {
        }

        public Optional<AttractorSim> getAttractorInUse(KB kb, OccAgent agent) {
            return this.d_currAttractor != null ? Optional.ofNullable(this.d_currAttractor.attractor) : Optional.empty();
        }

        public void goalReached(KB kb, OccAgent agent) {
            if (this.d_currAttractor == null) {
                this.clearOldAttractors(kb, agent, true);
            }
        }

        public void clearOldAttractors(KB kb, OccAgent agent, boolean clearGlobal) {
            Occupant occ = agent.getOcc();
            BiConsumer<Map, Boolean> clearChanged = (memory, idle) -> memory.entrySet().removeIf(entry -> {
                double newInfluence;
                AttractorSim attr = (AttractorSim)entry.getKey();
                double prevInfluence = (Double)entry.getValue();
                return prevInfluence != (newInfluence = attr.getProbabilityOfInfluence(occ, (boolean)idle));
            });
            clearChanged.accept(this.d_attractorMemIdle, true);
            clearChanged.accept(this.d_attractorMemSeek, false);
            Predicate<AttractorSim> canReconsider = attr -> attr.forceConsiderationIfOccBecomesUnaware && !attr.isVisible(kb, occ);
            Iterator<AttractorSim> it = this.d_attractorMemIdle.keySet().iterator();
            while (it.hasNext()) {
                AttractorSim attr2 = it.next();
                if (!canReconsider.test(attr2)) continue;
                it.remove();
                this.d_attractorMemSeek.remove(attr2);
            }
            this.d_attractorMemSeek.keySet().removeIf(canReconsider);
            if (clearGlobal) {
                this.d_attractorMemSeek.keySet().removeAll(kb.getGlobalAttractors());
                this.d_attractorMemIdle.keySet().removeAll(kb.getGlobalAttractors());
            }
        }

        public void updateAttractor(KB kb, OccAgent agent, IGoalInstance currGoal, boolean wasSeeking) {
            this.clearOldAttractors(kb, agent, false);
            if ((this.d_currAttractor == null || this.d_currAttractor.attractor.rank < Integer.MAX_VALUE) && currGoal.canInterrupt(kb, agent)) {
                AttractorSim attr2;
                Predicate<Object> allowHigherRankAttrs;
                Occupant occ = agent.getOcc();
                boolean seeking = DefaultAiCore.this.isSeeking(kb, agent);
                if (seeking != wasSeeking) {
                    this.updateAttractorStateChange(kb, agent, seeking);
                }
                Set<AttractorSim> closedAttrs = seeking ? this.d_attractorMemSeek.keySet() : this.d_attractorMemIdle.keySet();
                List<AttractorSim> attractors = kb.findPotentialAttractors(occ, !seeking, Predicates.and(allowHigherRankAttrs = this.d_currAttractor != null ? attr -> attr.rank > this.d_currAttractor.attractor.rank : Predicates.alwaysTrue(), Filters.reject(this.d_closedAttractors), Filters.reject(this.d_futureAttractorInfo.keySet()), Filters.reject(closedAttrs)));
                if (!attractors.isEmpty()) {
                    this.scheduleAttractorReactionTimes(kb, agent, attractors, seeking);
                }
                if ((attr2 = this.pickAttractor(kb, agent, seeking)) != null) {
                    this.d_closedAttractors.add(attr2);
                    Pair<ISeekArea, Serializable> interrupted = currGoal.interrupt(kb, agent);
                    if (interrupted.v1 != null) {
                        DefaultAiCore.this.recordSeekArea(kb, agent, (ISeekArea)interrupted.v1);
                    }
                    Deque<BehaviorSim.BehaviorInProgress> behaviorStack = agent.getOcc().behaviorStack;
                    this.d_currAttractor = new CurrAttractor(this.d_currAttractor, attr2, behaviorStack.size(), currGoal, interrupted.v2, interrupted.v1 != null ? (ISeekArea)interrupted.v1 : DefaultAiCore.this.d_currSeekArea);
                    behaviorStack.push(new BehaviorSim.BehaviorInProgress(attr2.behavior, -1));
                    DefaultAiCore.this.startNextGoal(kb, agent, true);
                }
            }
        }

        private void updateAttractorStateChange(KB kb, OccAgent agent, boolean seeking) {
            Occupant occ = agent.getOcc();
            BiConsumer<Map, Map> applyMemToOther = (before, after) -> {
                for (Map.Entry entry : before.entrySet()) {
                    AttractorSim attractorSim = (AttractorSim)entry.getKey();
                    boolean bl = !seeking;
                    double currSusc = attractorSim.getProbabilityOfInfluence(occ, bl);
                    if (!(currSusc <= (Double)entry.getValue())) continue;
                    after.put((AttractorSim)entry.getKey(), currSusc);
                }
            };
            if (seeking) {
                applyMemToOther.accept(this.d_attractorMemIdle, this.d_attractorMemSeek);
            } else {
                applyMemToOther.accept(this.d_attractorMemSeek, this.d_attractorMemIdle);
            }
        }

        private void scheduleAttractorReactionTimes(KB kb, OccAgent agent, Collection<AttractorSim> attractors, boolean seeking) {
            Occupant occ = agent.getOcc();
            Random r = kb.getTimeBasedRandom(occ, 217151353641L);
            TriConsumer<AttractorSim, Double, Boolean> scheduleAttr = (attr, reactTime, important) -> {
                AttrScheduleInfo futureInfo = this.d_futureAttractorInfo.get(attr);
                if (futureInfo != null) {
                    if (futureInfo.tConsider <= reactTime) {
                        return;
                    }
                    List attrs = (List)this.d_futureAttractor.get(futureInfo.tConsider);
                    attrs.remove(attr);
                    if (attrs.isEmpty()) {
                        this.d_futureAttractor.remove(futureInfo.tConsider);
                    }
                }
                this.d_futureAttractor.computeIfAbsent((Double)reactTime, t -> new ArrayList(2)).add(attr);
                this.d_futureAttractorInfo.put((AttractorSim)attr, new AttrScheduleInfo(kb.getCurrentSimTime(), (double)reactTime, (boolean)important));
            };
            CachedValue<Double> maxIdleDelay = new CachedValue<Double>();
            Supplier<Double> calcMaxIdleDelay = () -> {
                double endTime;
                IGoalInstance ginst = DefaultAiCore.this.getCurrentGoalInstance(agent);
                IGoalInstance.IdleInfo ii = ginst.getIdleInfo(kb, agent);
                double d = endTime = ii != null ? ii.idleEndTime : Double.POSITIVE_INFINITY;
                if (Double.isInfinite(endTime)) {
                    endTime = kb.getCurrentSimTime() + kb.getParams().attr_default_idle_time;
                }
                return endTime - kb.getCurrentSimTime();
            };
            for (AttractorSim attr2 : attractors) {
                double reactTime2 = attr2.reactTime.getEventTime(kb, r);
                boolean important2 = true;
                if (Double.isNaN(reactTime2)) {
                    if (seeking) {
                        reactTime2 = 0.0;
                    } else {
                        important2 = false;
                        double idleDelay = maxIdleDelay.unsafeGet(calcMaxIdleDelay);
                        if (idleDelay == 0.0) continue;
                        reactTime2 = kb.getCurrentSimTime() + r.nextDouble() * idleDelay;
                    }
                } else if (reactTime2 < kb.getCurrentSimTime()) {
                    reactTime2 = Double.POSITIVE_INFINITY;
                    continue;
                }
                scheduleAttr.accept(attr2, reactTime2, important2);
            }
        }

        private AttractorSim pickAttractor(KB kb, OccAgent agent, boolean seeking) {
            int end;
            Map<AttractorSim, Double> attrMem;
            if (this.d_futureAttractor.isEmpty()) {
                return null;
            }
            Occupant occ = agent.getOcc();
            Random rand = kb.getTimeBasedRandom(occ, 7913634181690L);
            ArrayList<AttractorSim> chosenAttrs = new ArrayList<AttractorSim>();
            Map<AttractorSim, Double> map = attrMem = seeking ? this.d_attractorMemSeek : this.d_attractorMemIdle;
            while (!this.d_futureAttractor.isEmpty() && theUtil.ge(kb.getCurrentSimTime(), (Double)this.d_futureAttractor.firstKey(), 1.0E-6)) {
                List<AttractorSim> result = this.d_futureAttractor.pollFirstEntry().getValue();
                for (AttractorSim attr : result) {
                    AttrScheduleInfo futureInfo = this.d_futureAttractorInfo.remove(attr);
                    assert (futureInfo != null);
                    double timeScheduled = futureInfo.tScheduled;
                    if (timeScheduled != kb.getCurrentSimTime() && !attr.forceConsiderationIfOccBecomesUnaware && !attr.isVisible(kb, occ)) continue;
                    double influence = attr.getProbabilityOfInfluence(occ, !seeking);
                    attrMem.put(attr, influence);
                    boolean useAttractor = (this.d_currAttractor == null || this.d_currAttractor.attractor.rank < attr.rank) && rand.nextDouble() < influence;
                    if (!useAttractor) continue;
                    chosenAttrs.add(attr);
                }
            }
            if (chosenAttrs.isEmpty()) {
                return null;
            }
            if (chosenAttrs.size() == 1) {
                return (AttractorSim)chosenAttrs.get(0);
            }
            Collections.sort(chosenAttrs, (a1, a2) -> -Integer.compare(a1.rank, a2.rank));
            int highestRank = ((AttractorSim)chosenAttrs.get((int)0)).rank;
            for (end = 1; end < chosenAttrs.size() && ((AttractorSim)chosenAttrs.get((int)end)).rank == highestRank; ++end) {
            }
            return (AttractorSim)chosenAttrs.get(rand.nextInt(end));
        }

        public int getMinBehaviorStackSize() {
            return this.d_currAttractor == null ? Integer.MIN_VALUE : this.d_currAttractor.stackSize;
        }

        public boolean behaviorStackReduced(KB kb, OccAgent agent) {
            CurrAttractor currAttractor = this.d_currAttractor;
            Deque<BehaviorSim.BehaviorInProgress> behaviorStack = agent.getOcc().behaviorStack;
            if (currAttractor != null && behaviorStack.size() == currAttractor.stackSize) {
                while (currAttractor.parent != null && !currAttractor.parent.attractor.requiresCompletion) {
                    currAttractor = currAttractor.parent;
                    while (behaviorStack.size() > currAttractor.stackSize) {
                        behaviorStack.pop();
                    }
                }
                Consumer<CurrAttractor> recordPrevSeekArea = attr -> {
                    if (attr.prevSeekArea != null) {
                        DefaultAiCore.this.recordSeekArea(kb, agent, attr.prevSeekArea);
                    }
                };
                if (currAttractor.goalResumePacket != null && currAttractor.interruptedGoal.resume(kb, agent, currAttractor.goalResumePacket)) {
                    recordPrevSeekArea.accept(currAttractor);
                    DefaultAiCore.this.initGoalInst(kb, agent, currAttractor.interruptedGoal, false);
                } else {
                    recordPrevSeekArea.accept(currAttractor);
                    DefaultAiCore.this.startGoal(kb, agent, agent.getGoalIx(), false);
                }
                this.d_currAttractor = currAttractor.parent;
                return false;
            }
            return true;
        }

        public boolean testMoreToDo(KB kb, OccAgent occ) {
            return this.d_futureAttractorInfo.values().stream().anyMatch(info -> info.important);
        }
    }

    private static class CurrAttractor
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final CurrAttractor parent;
        public final AttractorSim attractor;
        public final int stackSize;
        public final IGoalInstance interruptedGoal;
        public final Object goalResumePacket;
        public final ISeekArea prevSeekArea;

        public CurrAttractor(CurrAttractor parent, AttractorSim attractor, int stackSize, IGoalInstance interruptedGoal, Object goalResumePacket, ISeekArea prevSeekArea) {
            this.parent = parent;
            this.attractor = attractor;
            this.stackSize = stackSize;
            this.interruptedGoal = interruptedGoal;
            this.goalResumePacket = goalResumePacket;
            this.prevSeekArea = prevSeekArea;
        }
    }
}

