/*
 * Decompiled with CFR 0.152.
 */
package inferno.sim;

import inferno.data2.ANode;
import inferno.data2.SlopeSpeed;
import inferno.data2.Tri;
import inferno.data2.value.ConstFunction1d;
import inferno.data2.value.IFunction1d;
import inferno.data2.value.PiecewiseFunction1d;
import java.util.function.ToDoubleFunction;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector2d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.util.theUtil;

public class KnownFuncs {
    public static final boolean SWENSON_DENSITY = System.getProperty("SDENSITY") != null;
    public static final double SFPE_SPEED = 1.19;
    public static final IFunction1d SFPE_FUNDAMENTAL_DIAGRAM = KnownFuncs.getSFPEFundamentalDiagram(0.15);
    public static final IFunction1d SFPE_STAIR_FUNCTION = PiecewiseFunction1d.newFunction(false, 0.0, 1.0, 0.5, 0.8785714285714287, 0.541, 0.8285714285714285, 0.638, 0.7714285714285716, 0.748, 0.7142857142857143, 1.8, 0.02428571428571429);
    public static final IFunction1d SFPE_RAMP_FUNCTION = new ConstFunction1d(1.0);
    public static final SlopeSpeed SFPE_STAIR_SPEED = new SlopeSpeed(SFPE_STAIR_FUNCTION, SFPE_FUNDAMENTAL_DIAGRAM, SFPE_STAIR_FUNCTION, SFPE_FUNDAMENTAL_DIAGRAM);
    public static final SlopeSpeed SFPE_RAMP_SPEED = new SlopeSpeed(SFPE_RAMP_FUNCTION, SFPE_FUNDAMENTAL_DIAGRAM, SFPE_RAMP_FUNCTION, SFPE_FUNDAMENTAL_DIAGRAM);
    private static final FruinSpaceContour[] s_fruinContours = new FruinSpaceContour[]{KnownFuncs.getContourModule(0.0, 0.0, 0.0), KnownFuncs.getContourModule(1.63, 1.63, 3.0), KnownFuncs.getContourModule(2.11, 2.03, 5.0), KnownFuncs.getContourModule(3.55, 3.05, 10.0), KnownFuncs.getContourModule(5.0, 3.54, 20.0)};
    private static final FruinSpaceContour[] s_densityContours = new FruinSpaceContour[]{new FruinSpaceContour(0.0, 0.0, 0.0), KnownFuncs.getContourDensity(0.36, 0.4, 6.0), KnownFuncs.getContourDensity(0.458224, 0.409266, 5.0), KnownFuncs.getContourDensity(0.594301, 0.422104, 4.0), KnownFuncs.getContourDensity(0.794075, 0.44095, 3.0), KnownFuncs.getContourDensity(1.109647, 0.470721, 2.0), KnownFuncs.getContourDensity(1.627106, 0.7, 1.0), KnownFuncs.getContourDensity(1.95, 0.8, 1.0E-6)};

    public static double kForOpen() {
        return 1.4;
    }

    public static double kForStairs(double slope) {
        return 1.4 * SFPE_STAIR_FUNCTION.get(Math.abs(slope));
    }

    public static double getSpecificFlow(double D, double k, IFunction1d curve) {
        return KnownFuncs.velFactor(D, k, curve) * 1.19 * D;
    }

    public static int maxPersons(double area, double dmax) {
        double num = dmax * area;
        double floor = Math.floor(num);
        double ceil = floor + 1.0;
        if (theUtil.eq(num, ceil, 1.0E-6)) {
            return (int)ceil;
        }
        return (int)floor;
    }

    public static double velFactor(double dens, double k, IFunction1d curve) {
        return k / 1.4 * curve.get(dens);
    }

    public static double velInterPerson(double dist) {
        if (dist < 0.2) {
            return 0.0;
        }
        if (0.2 < dist && dist < 1.2) {
            return KnownFuncs.linInterp(0.2, 0.0, 1.2, 1.4, dist);
        }
        if (1.2 < dist) {
            return 1.4;
        }
        assert (false);
        return -1.0;
    }

    public static double linInterp(double x1, double y1, double x2, double y2, double x) {
        double dx = x2 - x1;
        double dy = y2 - y1;
        double t = (x - x1) / dx;
        return y1 + t * dy;
    }

    public static double yAt(double m, double x, double b) {
        return m * x + b;
    }

    public static double getSlopedSpeedFactor(IFunction1d slopeSpeedFrac, double slope) {
        return slopeSpeedFrac.get(Math.abs(slope));
    }

    public static double getTerrainSlope(Tri tri) {
        switch (tri.terrain) {
            case RAMP: {
                return tri.actualSlope;
            }
            case STAIR: {
                return tri.node.stairData.getSlope();
            }
        }
        return 0.0;
    }

    public static double kForNode(ANode node) {
        if (node.stairData != null) {
            return KnownFuncs.kForStairs(node.stairData.getSlope());
        }
        return KnownFuncs.kForOpen();
    }

    private static FruinSpaceContour getContourDensity(double xm, double ym, double densitySqM) {
        return new FruinSpaceContour(xm, ym, 1.0 / densitySqM);
    }

    private static FruinSpaceContour getContourModule(double xft, double yft, double moduleSqFt) {
        return new FruinSpaceContour(NonSI.FOOT.getConverterTo(SI.METER).convert(xft), NonSI.FOOT.getConverterTo(SI.METER).convert(yft), NonSI.FOOT.pow(2).getConverterTo(SI.METER.pow(2)).convert(moduleSqFt));
    }

    public static double getFruinModule(double xl, double yl) {
        return KnownFuncs.getValFromContours(xl, yl, s_fruinContours, c -> c.module);
    }

    public static double getFruinDensity(double xl, double yl) {
        return 1.0 / KnownFuncs.getFruinModule(xl, yl);
    }

    public static double getModule(double xl, double yl) {
        if (SWENSON_DENSITY) {
            return KnownFuncs.getValFromContours(xl, yl, s_densityContours, c -> c.module);
        }
        return KnownFuncs.getFruinModule(xl, yl);
    }

    public static double getDensity(double xl, double yl) {
        return 1.0 / KnownFuncs.getModule(xl, yl);
    }

    public static void toFruinSpace(Point3d origin, Vector2d seekDirN, Point3d p, Point2d result) {
        double xx = seekDirN.x;
        double xy = seekDirN.y;
        double yx = -seekDirN.y;
        double yy = seekDirN.x;
        double lx = p.x - origin.x;
        double ly = p.y - origin.y;
        result.x = xx * lx + xy * ly;
        result.y = yx * lx + yy * ly;
    }

    public static double getValFromContours(double xl, double yl, FruinSpaceContour[] contours, ToDoubleFunction<FruinSpaceContour> valFunc) {
        if (xl == 0.0 && yl == 0.0) {
            return valFunc.applyAsDouble(contours[0]);
        }
        double lm = xl == 0.0 ? Double.POSITIVE_INFINITY : Math.abs(yl / xl);
        double lm2 = xl == 0.0 ? Double.POSITIVE_INFINITY : lm * lm;
        double iDistSqP = 1.0 / (xl * xl + yl * yl);
        double lowert2 = 0.0;
        for (int m = 1; m < contours.length; ++m) {
            double yi2;
            double xi2;
            FruinSpaceContour contour = contours[m];
            if (xl == 0.0) {
                xi2 = 0.0;
                yi2 = contour.b2;
            } else {
                xi2 = contour.b2 / (lm2 + contour.b2da2);
                if (theUtil.gt(xi2, contour.a2, 1.0E-9)) continue;
                yi2 = contour.b2da2 * (contour.a2 - xi2);
            }
            double t2 = (xi2 + yi2) * iDistSqP;
            if (t2 >= 1.0 || m == contours.length - 1) {
                double lowert = Math.sqrt(lowert2);
                double uppert = Math.sqrt(t2);
                return KnownFuncs.linInterp(lowert, valFunc.applyAsDouble(contours[m - 1]), uppert, valFunc.applyAsDouble(contour), 1.0);
            }
            lowert2 = t2;
        }
        assert (false);
        return Double.NaN;
    }

    public static void getSpacingFromDensity(double density, double xl, double yl, Point2d result) {
        KnownFuncs.getSpacingFromModule(1.0 / density, xl, yl, result);
    }

    public static void getSpacingFromModule(double module, double xl, double yl, Point2d result) {
        if (module == 0.0) {
            result.set(0.0, 0.0);
            return;
        }
        double lm = xl == 0.0 ? Double.POSITIVE_INFINITY : Math.abs(yl / xl);
        double lm2 = xl == 0.0 ? Double.POSITIVE_INFINITY : lm * lm;
        double a = KnownFuncs.s_fruinContours[KnownFuncs.s_fruinContours.length - 1].a;
        double b = KnownFuncs.s_fruinContours[KnownFuncs.s_fruinContours.length - 1].b;
        for (int m = 1; m < s_fruinContours.length; ++m) {
            FruinSpaceContour contour = s_fruinContours[m];
            if (!(module <= contour.module)) continue;
            FruinSpaceContour prevContour = s_fruinContours[m - 1];
            double t = (module - prevContour.module) / (contour.module - prevContour.module);
            a = theUtil.lerp(prevContour.a, contour.a, t);
            b = theUtil.lerp(prevContour.b, contour.b, t);
            break;
        }
        if (xl == 0.0) {
            result.set(0.0, b);
        } else {
            double b2 = b * b;
            double a2 = a * a;
            double xi2 = b2 / (lm2 + b2 / a2);
            if (xi2 > a2) {
                result.set(0.0, 0.0);
                return;
            }
            double yi2 = b2 / a2 * (a2 - xi2);
            result.set(Math.sqrt(xi2), Math.sqrt(yi2));
        }
    }

    public static double getFruinStrideLength(double v) {
        if (v <= 0.0) {
            return 0.528;
        }
        if (v <= 0.598) {
            return KnownFuncs.linInterp(0.0, 0.528, 0.598, 0.643, v);
        }
        if (v <= 0.999) {
            return KnownFuncs.linInterp(0.598, 0.643, 0.999, 1.08, v);
        }
        if (v <= 1.2) {
            return KnownFuncs.linInterp(0.999, 1.08, 1.2, 1.524, v);
        }
        return 1.524;
    }

    public static double getFruinSpeedFactorFromStrideSpacing(double distOnCenter) {
        double[] xs = new double[]{0.643, 1.08, 1.524};
        double[] ys = new double[]{0.49833333333333335, 0.8333333333333334, 1.0};
        if (distOnCenter <= xs[0]) {
            return ys[0];
        }
        for (int i = 1; i < xs.length; ++i) {
            if (!(distOnCenter <= xs[i])) continue;
            return KnownFuncs.linInterp(xs[i - 1], ys[i - 1], xs[i], ys[i], distOnCenter);
        }
        return ys[ys.length - 1];
    }

    public static double getFruinLateralSpacing(double v) {
        if (v <= 0.0) {
            return 0.61;
        }
        if (v <= 0.6) {
            return KnownFuncs.linInterp(0.0, 0.61, 0.6, 0.62, v);
        }
        if (v <= 1.0) {
            return KnownFuncs.linInterp(0.6, 0.62, 1.0, 0.93, v);
        }
        if (v <= 1.2) {
            return KnownFuncs.linInterp(1.0, 0.93, 1.2, 1.08, v);
        }
        return 1.2;
    }

    public static double getFruinSpeedFactorFromLateralSpacing(double distOnCenter) {
        double[] xs = new double[]{0.62, 0.93, 1.08};
        double[] ys = new double[]{0.5, 0.8333333333333334, 1.0};
        if (distOnCenter <= xs[0]) {
            return ys[0];
        }
        for (int i = 1; i < xs.length; ++i) {
            if (!(distOnCenter <= xs[i])) continue;
            return KnownFuncs.linInterp(xs[i - 1], ys[i - 1], xs[i], ys[i], distOnCenter);
        }
        return ys[ys.length - 1];
    }

    public static double getSpeedFactorFromLateralWallSpacing(double distOnCenter) {
        double[] xs = new double[]{0.62, 0.85};
        double[] ys = new double[]{0.5, 1.0};
        if (distOnCenter <= xs[0]) {
            return ys[0];
        }
        for (int i = 1; i < xs.length; ++i) {
            if (!(distOnCenter <= xs[i])) continue;
            return KnownFuncs.linInterp(xs[i - 1], ys[i - 1], xs[i], ys[i], distOnCenter);
        }
        return ys[ys.length - 1];
    }

    public static IFunction1d getSFPEFundamentalDiagram(double ymin) {
        double a = 0.266;
        double m = -0.31158486587794304;
        double b = 1.0 - m * 0.55;
        double xmin = (ymin - b) / m;
        double[] x = new double[]{0.55, xmin};
        double[] y = new double[]{1.0, ymin};
        return new PiecewiseFunction1d(x, y, false);
    }

    public static class FruinSpaceContour {
        public final double a;
        public final double b;
        public final double a2;
        public final double b2;
        public final double b2da2;
        public final double module;

        public FruinSpaceContour(double x, double y, double module) {
            this.a = x;
            this.a2 = this.a * this.a;
            this.b = y;
            this.b2 = this.b * this.b;
            this.b2da2 = this.b2 / this.a2;
            this.module = module;
        }
    }
}

