/*
 * Decompiled with CFR 0.152.
 */
package inferno.io;

import inferno.io.InfernoOIS;
import inferno.sim.Engine;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.List;
import merlin.Intl;

public class SnapshotReader {
    public static List<SnapshotInfo> getSnapshots(File file) {
        ArrayList<SnapshotInfo> infos = new ArrayList<SnapshotInfo>();
        try (FileInputStream fis = new FileInputStream(file);){
            while (true) {
                DataInputStream ois = new DataInputStream(fis);
                long size = ois.readLong();
                double t = ois.readDouble();
                if (size == -1L) break;
                if (Double.isNaN(t)) {
                    break;
                }
                long pos = fis.getChannel().position();
                infos.add(new SnapshotInfo(pos, size, t));
                long nextPos = pos + size;
                fis.getChannel().position(nextPos);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return infos;
    }

    public static Engine openSnapshot(File file, SnapshotInfo snapshot, boolean truncate) throws IOException {
        Engine engine;
        RandomAccessFile fis = new RandomAccessFile(file, "rw");
        try {
            fis.getChannel().position(snapshot.pos);
            BufferedInputStream bis = new BufferedInputStream(Channels.newInputStream(fis.getChannel()));
            InfernoOIS ois = new InfernoOIS(bis, file);
            if (!ois.canOpenVersion()) {
                throw new IOException(Intl.intl("The snapshot was made with an incompatible version."));
            }
            Engine engine2 = ois.readSnapshot();
            if (truncate) {
                fis.getChannel().truncate(snapshot.pos + snapshot.size);
            }
            engine = engine2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                throw new IOException(t);
            }
        }
        fis.close();
        return engine;
    }

    public static class SnapshotInfo {
        public final long pos;
        public final long size;
        public final double t;

        public SnapshotInfo(long pos, long size, double t) {
            this.pos = pos;
            this.size = size;
            this.t = t;
        }
    }
}

