/*
 * Decompiled with CFR 0.152.
 */
package inferno.geom;

import inferno.data2.WingedEdge;
import inferno.geom.Util;
import inferno.sim.path.PathChange;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class WallSlider
implements Serializable {
    static final long serialVersionUID = 1L;
    private final Point3d d_point;
    private final Predicate<PathChange> d_filter;
    private final Collection<WingedEdge> d_slideWalls;
    private final Pair<Vector2d, Vector2d>[] d_vecs;

    public WallSlider(Point3d p, Predicate<PathChange> filter, WingedEdge ... walls) {
        this(p, filter, Arrays.asList(walls));
    }

    public WallSlider(Point3d p, Predicate<PathChange> filter, Collection<WingedEdge> walls) {
        this.d_point = p;
        this.d_filter = filter;
        this.d_slideWalls = walls;
        TreeMap<Point3d, Pair<Vector2d, Vector2d>> vecs = new TreeMap<Point3d, Pair<Vector2d, Vector2d>>(Point3dComp.INSTANCE);
        Vector2d v1t = new Vector2d();
        Vector2d v2t = new Vector2d();
        Vector2d wallNorm = new Vector2d();
        for (WingedEdge wall : walls) {
            double dot2;
            Pair<Vector3d, Point3d> norm = Util.getWallNorm(wall, filter, p);
            Vector3d wallNorm3d = (Vector3d)norm.v1;
            wallNorm.set(wallNorm3d.x, wallNorm3d.y);
            v1t.set(wallNorm.y, -wallNorm.x);
            v1t.normalize();
            v2t.set(-v1t.x, -v1t.y);
            Pair<Vector2d, Vector2d> v = (Pair<Vector2d, Vector2d>)vecs.get(norm.v2);
            if (v == null) {
                v = new Pair<Vector2d, Vector2d>(new Vector2d(v1t), new Vector2d(v2t));
                vecs.put((Point3d)norm.v2, v);
                continue;
            }
            int numChanges = 0;
            double dot1 = ((Vector2d)v.v1).dot(wallNorm);
            if (theUtil.lt0(dot1, 1.0E-6)) {
                ((Vector2d)v.v1).set(v1t);
                ++numChanges;
            }
            if (theUtil.lt0(dot2 = ((Vector2d)v.v2).dot(wallNorm), 1.0E-6)) {
                ((Vector2d)v.v2).set(v2t);
                ++numChanges;
            }
            if (numChanges != 2) continue;
        }
        this.d_vecs = theUtil.toArray(vecs.values(), Pair.class);
    }

    public Predicate<PathChange> getEdgeFilter() {
        return this.d_filter;
    }

    public WallSlider tweak(Predicate<WingedEdge> wallFilter) {
        Collection edges = this.d_slideWalls.stream().filter(wallFilter).collect(Collectors.toList());
        return new WallSlider(this.d_point, this.d_filter, edges);
    }

    public Vector3d slide(Vector3d dir, boolean normalize) {
        return this.slide(dir, normalize, new Vector3d());
    }

    private static double dot2d(Tuple3d t1, Tuple3d t2) {
        return t1.x * t2.x + t1.y * t2.y;
    }

    public Vector3d slide(Vector3d inDir, boolean normalize, Vector3d outDir) {
        if (this.d_vecs.length == 0) {
            outDir.set(inDir);
            return outDir;
        }
        Vector3d inDir0 = inDir;
        Vector2d inDir2d = new Vector2d(inDir.x, inDir.y);
        for (Pair<Vector2d, Vector2d> v : this.d_vecs) {
            Vector2d d_v1 = (Vector2d)v.v1;
            Vector2d d_v2 = (Vector2d)v.v2;
            double cross1 = Util2D.cross(d_v1, inDir2d);
            double cross2 = Util2D.cross(inDir2d, d_v2);
            if (theUtil.ge0(cross1, 1.0E-6) && theUtil.ge0(cross2, 1.0E-6)) {
                outDir.set(inDir);
            } else {
                double dot2;
                double dot1 = inDir2d.dot(d_v1);
                if (theUtil.eq(dot1, dot2 = inDir2d.dot(d_v2), 1.0E-6)) {
                    outDir.set(GeomConstants.VEC3D_ZERO);
                } else if (dot1 >= dot2) {
                    outDir.set(d_v1.x, d_v1.y, 0.0);
                    if (!normalize) {
                        outDir.scale(dot1);
                    }
                } else {
                    outDir.set(d_v2.x, d_v2.y, 0.0);
                    if (!normalize) {
                        outDir.scale(dot2);
                    }
                }
            }
            inDir = outDir;
            inDir2d.set(inDir.x, inDir.y);
        }
        if (WallSlider.dot2d(inDir0, outDir) < 0.0) {
            return new Vector3d(0.0, 0.0, 0.0);
        }
        return outDir;
    }

    private static class Point3dComp
    implements Comparator<Point3d> {
        public static final Point3dComp INSTANCE = new Point3dComp();

        private Point3dComp() {
        }

        @Override
        public int compare(Point3d o1, Point3d o2) {
            int comp = theUtil.compare(o1.x, o2.x, 1.0E-6);
            if (comp == 0 && (comp = theUtil.compare(o1.y, o2.y, 1.0E-6)) == 0) {
                comp = theUtil.compare(o1.z, o2.z, 1.0E-6);
            }
            return comp;
        }
    }
}

