/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import common.data.ElevatorType;
import common.data.IElevatorTimingModel;
import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.elevator.ClosestSorter;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorLevel;
import inferno.elevator.ElevatorUtil;
import inferno.elevator.IElevatorScheduler;
import inferno.elevator.PrioritySorter;
import inferno.sim.KB;
import inferno.sim.path.PathGen;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class ElevatorModel
implements Serializable {
    private static final long serialVersionUID = 492666562082182514L;
    private List<Elevator> d_elevators = new ArrayList<Elevator>();
    private Map<KeyObj, Set<Elevator>> d_elevatorLinkedSets = new LinkedHashMap<KeyObj, Set<Elevator>>();
    private Map<Elevator, KeyObj> d_linkedElevatorKeys = new IdentityHashMap<Elevator, KeyObj>();
    private Map<Elevator, IElevatorScheduler> d_elevatorSchedulers;
    private Collection<ANode> memo_getAllElevatorRooms = null;

    public ElevatorModel() {
        this.d_elevatorLinkedSets.put(null, new LinkedHashSet());
        this.d_elevatorSchedulers = new HashMap<Elevator, IElevatorScheduler>();
    }

    public void init() {
        for (Elevator elevator : this.d_elevators) {
            elevator.init();
            if (elevator.getType().equals((Object)ElevatorType.EVAC)) {
                this.d_elevatorSchedulers.put(elevator, new EvacElevatorScheduler());
                continue;
            }
            this.d_elevatorSchedulers.put(elevator, new GeneralElevatorScheduler());
        }
    }

    public void linkElevators(Collection<Elevator> elevs) {
        this.d_elevatorLinkedSets.get(null).removeAll(elevs);
        LinkedHashSet<Elevator> linkSet = new LinkedHashSet<Elevator>(elevs);
        KeyObj key = new KeyObj();
        this.d_elevatorLinkedSets.put(key, linkSet);
        linkSet.forEach(elev -> this.d_linkedElevatorKeys.put((Elevator)elev, key));
    }

    public Collection<Set<Elevator>> getLinkedElevators() {
        ArrayList<Set<Elevator>> elevatorSets = new ArrayList<Set<Elevator>>(this.d_elevatorLinkedSets.size());
        for (Map.Entry<KeyObj, Set<Elevator>> entry : this.d_elevatorLinkedSets.entrySet()) {
            if (entry.getKey() == null || entry.getValue().size() <= 1) continue;
            elevatorSets.add(entry.getValue());
        }
        return elevatorSets;
    }

    public void addElevator(Elevator elev) {
        this.d_elevatorLinkedSets.get(null).add(elev);
        this.d_elevators.add(elev);
    }

    public Elevator addElevator(String name, ElevatorType type, Optional<ANode> dischargeNode, List<ElevatorLevel> levels, List<Integer> iFloorPriority, double openTime, double closeDelay, double rFactor, double maxDensity, ANode initNode, double callDistance, boolean isDoubleDeck, IElevatorTimingModel timingModel) {
        if (dischargeNode.isPresent()) {
            Elevator elevator = new Elevator(name, type, dischargeNode.get(), openTime, closeDelay, rFactor, maxDensity, initNode, callDistance, isDoubleDeck, timingModel);
            this.addElevator(elevator);
            elevator.addLevels(levels);
            this.setFloorPriority(elevator, iFloorPriority);
            elevator.endInit();
            return elevator;
        }
        return null;
    }

    private void setFloorPriority(Elevator elevator, List<Integer> iFloorPriority) {
        if (elevator.getType().equals((Object)ElevatorType.EVAC)) {
            if (!iFloorPriority.isEmpty()) {
                elevator.setFloorPriority(new PrioritySorter(iFloorPriority));
            }
        } else {
            elevator.setFloorPriority(new ClosestSorter(elevator));
        }
    }

    public int getNumElevators() {
        return this.d_elevators.size();
    }

    public Elevator getElevator(int id) {
        return this.d_elevators.get(id);
    }

    public List<Elevator> getElevators() {
        return Collections.unmodifiableList(this.d_elevators);
    }

    public void call(double t, ElevatorLevel source, Elevator.Direction dir) {
        assert (dir.moving);
        KeyObj linkKey = this.d_linkedElevatorKeys.get(source.getElevator());
        if (linkKey == null) {
            source.call(t, dir);
        } else {
            this.d_elevatorLinkedSets.get(linkKey).stream().map(elev -> elev.getLevel(source.levelId)).filter(level -> level != null).forEach(level -> level.call(t, dir));
        }
    }

    public void requestDischarge(ElevatorLevel level) {
        level.requestDischarge();
    }

    public void update(KB kb) {
        for (Elevator elev : this.d_elevators) {
            elev.update(kb);
        }
        for (Elevator elev : this.d_elevators) {
            this.d_elevatorSchedulers.get(elev).processHallCalls(kb, elev);
        }
    }

    @Deprecated
    public Elevator findElevator(ElevatorLevel level) {
        return level.getElevator();
    }

    public synchronized Collection<ANode> getAllElevatorRooms() {
        if (this.memo_getAllElevatorRooms == null) {
            this.memo_getAllElevatorRooms = new ArrayDeque<ANode>();
            for (Elevator elev : this.d_elevators) {
                for (ElevatorLevel elevLev : elev.getLevels()) {
                    this.memo_getAllElevatorRooms.add(elevLev.pickupNode);
                }
            }
        }
        return this.memo_getAllElevatorRooms;
    }

    private List<PathGen.SearchConnection> getTransportEdges(WingedEdge edge, ANode node, Map<ANode, List<PathGen.SearchConnection>> dischargeConnectionCache) {
        if (!edge.isDoor()) {
            return Collections.emptyList();
        }
        Function<ANode, List> computeLevels = dnode -> {
            ArrayList<PathGen.SearchConnection> connections = new ArrayList<PathGen.SearchConnection>();
            ElevatorLevel destLevel = dnode.getElevatorLevel();
            List<ElevatorLevel> transportLevels = this.getTransportLevels(dnode.getElevatorLevel());
            IdentityHashMap<ANode, Double> factors = new IdentityHashMap<ANode, Double>(transportLevels.size());
            for (ElevatorLevel srcLevel : transportLevels) {
                if (srcLevel == destLevel) continue;
                double elevTime = srcLevel.getTravelTimeTot(destLevel);
                double dist = ElevatorUtil.getAbsTeleportDist(srcLevel.pickupNode, destLevel.pickupNode);
                double avgSpeed = dist / elevTime;
                double factor = 1.19 / avgSpeed;
                factors.put(srcLevel.pickupNode, factor);
            }
            PathGen.NodeDistFactor distFactor = new PathGen.NodeDistFactor(factors);
            block1: for (WingedEdge dischargeDoor : dnode.getDoorEdges()) {
                Tri dischargeTri = dischargeDoor.getTri((ANode)dnode);
                for (int n = 0; n < 3; ++n) {
                    if (!dischargeTri.eu[n].wedge.equals(dischargeDoor)) continue;
                    connections.add(PathGen.virtualConnection(dischargeTri.eu[n], dischargeDoor.getAdjTri(dischargeTri), distFactor));
                    continue block1;
                }
            }
            return connections;
        };
        ArrayList<PathGen.SearchConnection> totalConnections = new ArrayList<PathGen.SearchConnection>();
        for (ElevatorLevel elevatorLevel : this.getTransportLevels(node.getElevatorLevel())) {
            totalConnections.addAll(dischargeConnectionCache.computeIfAbsent(elevatorLevel.pickupNode, computeLevels));
        }
        return totalConnections;
    }

    public List<ElevatorLevel> getTransportLevels(ElevatorLevel level) {
        if (level == null) {
            return Collections.emptyList();
        }
        ArrayList<ElevatorLevel> elevatorLevels = new ArrayList<ElevatorLevel>();
        Elevator elevator = level.getElevator();
        List<ElevatorLevel> levels = elevator.getLevels();
        int index = 0;
        int iter = 1;
        if (elevator.isDoubleDeck()) {
            index = elevator.getUpperLevelFor(level).equals(level) ? 1 : 0;
            iter = 2;
        }
        for (int i = index; i < levels.size(); i += iter) {
            ElevatorLevel el = levels.get(i);
            if (el == level) continue;
            elevatorLevels.add(levels.get(i));
        }
        return elevatorLevels;
    }

    public void initTriSearchConnections(Tri[] tris) {
        IdentityHashMap<ANode, List<PathGen.SearchConnection>> dischargeConnectionCache = new IdentityHashMap<ANode, List<PathGen.SearchConnection>>();
        for (Tri tri : tris) {
            int m;
            ArrayList<PathGen.SearchConnection> connections = new ArrayList<PathGen.SearchConnection>();
            for (m = 0; m < 3; ++m) {
                connections.add(PathGen.physicalConnection(tri.eu[m], tri.t[m]));
            }
            for (m = 0; m < 3; ++m) {
                connections.addAll(this.getTransportEdges(tri.eu[m].wedge, tri.node, dischargeConnectionCache));
            }
            tri.searchConnections = theUtil.toArray(connections, PathGen.SearchConnection.class);
        }
    }

    public ElevatorStatus getElevatorStatus(int id) {
        String pickupNode;
        int passengers;
        String state;
        Elevator elev = this.getElevator(id);
        switch (elev.getState()) {
            case AT_FLOOR: {
                state = "at floor";
                passengers = elev.getCurrentLevel().pickupNode.getNumOccupants();
                pickupNode = elev.getCurrentLevel().pickupNode.name;
                break;
            }
            case MOVING_TO_FLOOR: {
                state = "moving to floor";
                passengers = elev.getCurrentLevel().pickupNode.getNumOccupants();
                pickupNode = elev.getActiveLevel().pickupNode.name;
                break;
            }
            case READY: {
                state = "ready";
                passengers = 0;
                pickupNode = "none";
                break;
            }
            default: {
                assert (false);
                state = "unknown";
                passengers = 0;
                pickupNode = "none";
            }
        }
        Point3d pt = new Point3d(elev.getActiveLevel().pickupNode.getGeometryBounds().getCenter());
        Vector3d offset = elev.getActiveLevel().pickupNode.getAnimOffset();
        pt.add(offset);
        return new ElevatorStatus(id, state, pickupNode, passengers, pt);
    }

    public static class ElevatorStatus {
        public final int id;
        public final String state;
        public final String pickupNode;
        public final int pax;
        public final Point3d pt;

        public ElevatorStatus(int id, String state, String pickupNode, int pax, Point3d pt) {
            this.id = id;
            this.state = state;
            this.pickupNode = pickupNode;
            this.pax = pax;
            this.pt = pt;
        }
    }

    private static class GeneralElevatorScheduler
    implements IElevatorScheduler<Elevator>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private GeneralElevatorScheduler() {
        }

        public ElevatorLevel getFirstCallHall(Elevator elevator, Collection<ElevatorLevel> allLinkedInServiceLevels) {
            Elevator.Direction lastTravelDir = elevator.getLastMovingTravelDir();
            ElevatorLevel nextLevel = elevator.getNextInserviceLevel();
            IFilteredCollection<ElevatorLevel> calledLevels = theUtil.filter(allLinkedInServiceLevels, l -> l.isHallCallActive());
            if (calledLevels.size() == 0) {
                return null;
            }
            if (lastTravelDir.moving) {
                calledLevels = theUtil.filter(calledLevels, l -> (l.equals(nextLevel) || elevator.getDirection(nextLevel.levelId, l.levelId).equals((Object)lastTravelDir)) && l.getCallDirs().containsKey((Object)lastTravelDir));
            }
            if (calledLevels.size() > 0 && elevator.getActiveLevel() != null) {
                calledLevels = theUtil.filter(calledLevels, l -> elevator.getDirection(l.levelId, elevator.getActiveLevel().levelId).equals((Object)lastTravelDir));
            }
            if (calledLevels.size() == 0 && elevator.getState() == Elevator.ElevatorState.READY) {
                calledLevels = theUtil.filter(allLinkedInServiceLevels, l -> l.isHallCallActive());
            }
            if (calledLevels.size() == 0) {
                return null;
            }
            ArrayList<ElevatorLevel> sortedLevels = new ArrayList<ElevatorLevel>(calledLevels);
            Collections.sort(sortedLevels, elevator.getFloorSorter());
            return sortedLevels.get(0);
        }

        @Override
        public void processHallCalls(KB kb, Elevator elevator) {
            Collection<ElevatorLevel> elevatorLevels = elevator.getInServiceLevels();
            ElevatorLevel callLvl = this.getFirstCallHall(elevator, elevatorLevels);
            if (elevator.isDoubleDeck()) {
                callLvl = elevator.getLowerLevelFor(callLvl);
            }
            if (callLvl != null) {
                if (elevator.getState().equals((Object)Elevator.ElevatorState.READY)) {
                    elevator.beginPickup(kb, callLvl.levelId);
                }
                if (elevator.getState().equals((Object)Elevator.ElevatorState.MOVING_TO_FLOOR) && !callLvl.equals(elevator.getActiveLevel()) && !callLvl.equals(elevator.getCurrentLevel())) {
                    elevator.changePickupTo(kb.getCurrentSimTime(), callLvl.levelId);
                }
            }
        }
    }

    private static class EvacElevatorScheduler
    implements IElevatorScheduler<Elevator>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private EvacElevatorScheduler() {
        }

        private ElevatorLevel shouldReRouteTo(Elevator elevator, Collection<ElevatorLevel> allLinkedLevels) {
            assert (elevator.getState() == Elevator.ElevatorState.MOVING_TO_FLOOR);
            if (elevator.getDischargeActive()) {
                return null;
            }
            Point3d dischargePos = elevator.getTravelingNode().getGeometryBounds().getMin();
            Point3d elevPos = new Point3d(elevator.getActiveLevel().pickupNode.getGeometryBounds().getMin());
            elevPos.sub(dischargePos);
            elevPos.scale(elevator.getPickupProgress());
            elevPos.add(dischargePos);
            ArrayList<ElevatorLevel> prioritySortedLevels = new ArrayList<ElevatorLevel>(allLinkedLevels);
            Collections.sort(prioritySortedLevels, elevator.getFloorSorter());
            for (ElevatorLevel elevLevel : prioritySortedLevels) {
                if (elevLevel == elevator.getActiveLevel() || elevator.isDoubleDeck() && elevLevel == elevator.getDoubleDeckLevelPairs().getUpperLevel(elevator.getActiveLevel())) {
                    return null;
                }
                if (!elevLevel.isHallCallActive() || !elevator.isLevelInService(elevLevel.levelId) || elevator.isDoubleDeck() && elevator.getLowerLevelFor(elevLevel) == elevator.getActiveLevel()) continue;
                Point3d newPickupPos = elevLevel.pickupNode.getGeometryBounds().getMin();
                double distSqToDischarge = dischargePos.distanceSquared(elevPos);
                double distSqToNewPickup = elevPos.distanceSquared(newPickupPos);
                double distSqFull = dischargePos.distanceSquared(newPickupPos);
                if (!(distSqToDischarge < distSqFull) || !(distSqToNewPickup < distSqFull)) continue;
                return elevLevel;
            }
            return null;
        }

        @Override
        public void processHallCalls(KB kb, Elevator elevator) {
            ElevatorLevel newPickup;
            Collection<ElevatorLevel> elevatorLevels = elevator.getInServiceLevels();
            Elevator.ElevatorState state = elevator.getState();
            if (state == Elevator.ElevatorState.READY) {
                ElevatorLevel callLvl = this.getTopPriorityHallCall(elevator, elevatorLevels);
                if (callLvl != null) {
                    elevator.beginPickup(kb, callLvl.levelId);
                }
            } else if (state == Elevator.ElevatorState.MOVING_TO_FLOOR && (newPickup = this.shouldReRouteTo(elevator, elevatorLevels)) != null) {
                elevator.changePickupTo(kb.getCurrentSimTime(), newPickup.levelId);
            }
        }

        public ElevatorLevel getTopPriorityHallCall(Elevator elevator, Collection<ElevatorLevel> allLinkedInServiceLevels) {
            ArrayList<ElevatorLevel> prioritySortedLevels = new ArrayList<ElevatorLevel>(allLinkedInServiceLevels);
            Collections.sort(prioritySortedLevels, elevator.getFloorSorter());
            for (ElevatorLevel elevLevel : prioritySortedLevels) {
                if (!elevLevel.isHallCallActive() || !elevator.isLevelInService(elevLevel.levelId)) continue;
                return elevLevel;
            }
            return null;
        }
    }

    private static class KeyObj
    implements Serializable {
        private static final long serialVersionUID = 3316529401959403292L;

        private KeyObj() {
        }
    }
}

