/*
 * Decompiled with CFR 0.152.
 */
package inferno.elevator;

import inferno.data2.ANode;
import inferno.elevator.Elevator;
import inferno.elevator.ElevatorUtil;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class ElevatorLevel
implements Serializable {
    private static final long serialVersionUID = -2153617070083430794L;
    private transient Elevator d_elevator;
    public final int levelId;
    public final ANode pickupNode;
    public final double openTime;
    public final double closeTime;
    public boolean isDischargeLevel;
    public final double tFirstAvailable;
    private final EnumMap<Elevator.Direction, Double> d_callDirection = new EnumMap(Elevator.Direction.class);
    private AtomicBoolean d_dischargeRequested = new AtomicBoolean(false);
    private final boolean d_isEnabled;

    public ElevatorLevel(int levelId, ANode pickupNode, double openTime, double closeTime, double tFirstAvailable, boolean isEnabled) {
        this.levelId = levelId;
        this.openTime = openTime;
        this.closeTime = closeTime;
        this.pickupNode = pickupNode;
        this.tFirstAvailable = isEnabled ? tFirstAvailable : Double.POSITIVE_INFINITY;
        pickupNode.setElevatorLevel(this);
        this.d_isEnabled = isEnabled;
        this.isDischargeLevel = false;
    }

    public void setElevator(Elevator elevator) {
        this.d_elevator = elevator;
    }

    public Elevator getElevator() {
        return this.d_elevator;
    }

    public boolean isHallCallActive() {
        return !this.d_callDirection.isEmpty();
    }

    public Map<Elevator.Direction, Double> getCallDirs() {
        return this.d_callDirection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void call(double t, Elevator.Direction dir) {
        EnumMap<Elevator.Direction, Double> enumMap = this.d_callDirection;
        synchronized (enumMap) {
            this.d_callDirection.merge(dir, t, Double::min);
        }
    }

    protected void clearCall() {
        this.d_callDirection.clear();
    }

    public boolean isDischargeRequested() {
        return this.d_dischargeRequested.get();
    }

    protected void requestDischarge() {
        this.d_dischargeRequested.set(true);
    }

    protected void clearRequestedDischarge() {
        this.d_dischargeRequested.set(false);
    }

    public double getTravelTime(ElevatorLevel targetLevel) {
        double dist = ElevatorUtil.getSignedTeleportDist(this.pickupNode, targetLevel.pickupNode);
        return this.d_elevator.getTimingModel().getTime(dist);
    }

    public double getTravelTimeTot(ElevatorLevel targetLevel) {
        return this.closeTime + this.getTravelTime(targetLevel) + targetLevel.openTime;
    }

    public boolean isEnabled() {
        return this.d_isEnabled;
    }

    public String toString() {
        return String.format("ElevatorLevel[elev=%s,levelid=%d]", this.d_elevator.getName(), this.levelId);
    }
}

