/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.Occupant;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.WaitGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.Objects;
import java.util.Random;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;

public class WaitGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    private static final long s_delaySeed = 275670542901161L;
    public final IDistributedVal<UnitDouble> time;
    public final WaitMode mode;

    public WaitGoal(WaitMode mode, double seconds) {
        this(mode, new ConstantCurve(new UnitDouble(seconds, SI.SECOND)));
    }

    public WaitGoal(WaitMode mode, IDistributedVal<UnitDouble> timeDistribution) {
        this.time = timeDistribution;
        this.mode = mode;
    }

    public int hashCode() {
        return 54521850 + Objects.hash(new Object[]{this.time, this.mode});
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof WaitGoal)) {
            return false;
        }
        WaitGoal wg = (WaitGoal)obj;
        return this.time.equals(wg.time) && this.mode == wg.mode;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public double getWaitTime(KB kb, Occupant occ) {
        Random rnd = new Random();
        long seed = occ.rseed ^ 0xFAB88CC8DFA9L ^ (long)kb.getCurrentSimTime();
        rnd.setSeed(seed);
        return this.time.getValue(rnd).get(SI.SECOND);
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        double time = this.getWaitTime(kb, agent.getOcc());
        return new WaitGoalInstance(this, this.mode, kb.getCurrentSimTime() + time);
    }
}

