/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import common.data.WaitMode;
import inferno.data2.Counter;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.SteerUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.function.Predicate;
import thunderheadeng.util.Pair;

public class WaitForCounterGoal
implements IIdleGoal,
Serializable {
    static final long serialVersionUID = 1L;
    public final WaitMode mode;
    public final Counter counter;
    public final Predicate<BigDecimal> condition;

    public WaitForCounterGoal(WaitMode mode, Counter counter, Predicate<BigDecimal> condition) {
        this.mode = mode;
        this.counter = counter;
        this.condition = condition;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof WaitForCounterGoal && ((WaitForCounterGoal)obj).mode == this.mode && ((WaitForCounterGoal)obj).counter.equals(this.counter) && ((WaitForCounterGoal)obj).condition.equals(this.condition);
    }

    public int hashCode() {
        return 0xAF3F6 ^ Objects.hash(new Object[]{this.counter, this.condition, this.mode});
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public static class Instance
    implements IIdleGoalInstance {
        static final long serialVersionUID = 1L;
        private WaitForCounterGoal waitForCounterGoal;

        public Instance(WaitForCounterGoal waitForCounterGoal) {
            this.waitForCounterGoal = waitForCounterGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            return SteerUtil.newIdleSteer(kb, agent, GoalUtil.toIdleParams(this.waitForCounterGoal.mode));
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            return new Pair<Object, Instance>(null, this);
        }

        @Override
        public boolean resume(KB kb, OccAgent agent, Object resumePacket) {
            return true;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.waitForCounterGoal;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.waitForCounterGoal.counter.test(this.waitForCounterGoal.condition);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return IIdleGoalInstance.super.getProgress(kb, occ);
        }

        @Override
        public double getEndTime(KB kb) {
            return Double.POSITIVE_INFINITY;
        }
    }
}

