/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.OccProfileSim;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.Steer;
import inferno.sim.steering.simple.MaintainVel;
import inferno.sim.steering.simple.PostOpSteeringBehavior;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Random;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.theUtil;

public class SetOccPropToProfileGoal<T>
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final transient OccProfileSim.IOccProp<T> prop;

    public SetOccPropToProfileGoal(OccProfileSim.IOccProp<T> prop) {
        assert (prop instanceof IPropertySet.Prop);
        this.prop = prop;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SetOccPropToProfileGoal && ((SetOccPropToProfileGoal)obj).prop.equals(this.prop);
    }

    public int hashCode() {
        return 0xF7A983 ^ this.prop.hashCode();
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(((IPropertySet.Prop)((Object)this.prop)).key);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Object key = in.readObject();
        IPropertySet.Prop<?> prop = OccProfileSim.PROP_TYPES_MAP.get(key);
        assert (prop != null);
        assert (prop instanceof OccProfileSim.IOccProp);
        try {
            theUtil.assignFinalField(this, SetOccPropToProfileGoal.class, "prop", (OccProfileSim.IOccProp)((Object)prop));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this);
    }

    public static class Instance<T>
    implements IImmediateGoalInstance {
        private static final long serialVersionUID = 1L;
        private SetOccPropToProfileGoal<T> setOccPropGoal;

        public Instance(SetOccPropToProfileGoal<T> setOccPropGoal) {
            this.setOccPropGoal = setOccPropGoal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.setOccPropGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            return new PostOpSteeringBehavior(new MaintainVel(), new ChangePropOp<T>(this.setOccPropGoal));
        }
    }

    private static class ChangePropOp<T>
    implements Steer.IPostOp {
        private static final long serialVersionUID = 1L;
        public final SetOccPropToProfileGoal<T> goal;

        public ChangePropOp(SetOccPropToProfileGoal<T> goal) {
            this.goal = goal;
        }

        @Override
        public void accept(KB t, OccAgent u) {
            this.goal.prop.apply(u.getOcc(), new Random(), u.getOcc().getSeed((IPropertySet.Prop)((Object)this.goal.prop)), u.getOcc().parentProfile.getProp(this.goal.prop), t);
            if (this.goal.prop == OccProfileSim.PROP_SHAPE) {
                u.initVehicle(t);
            }
            if (this.goal.prop.testOption(OccProfileSim.PropOption.AFFECTS_PATH)) {
                u.markModified(t.getCurrentSimTime());
            }
        }
    }
}

