/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.Tag;
import inferno.data2.TriPoint;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IGoalInstance;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.ITargetPtSupplier;
import inferno.data2.seekarea.ISeekArea;
import inferno.data2.seekarea.IdleParams;
import inferno.data2.seekarea.PointSeekArea;
import inferno.data2.seekarea.RoomSeekArea;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.SteerUtil;
import inferno.sim.steering.locallyquickest.LocalTimeEstimate;
import inferno.sim.steering.locallyquickest.LocallyQuickest;
import inferno.sim.steering.locallyquickest.PointTarget;
import java.io.IOException;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Function;
import org.json.simple.JSONObject;
import thunderheadeng.io.JsonUtil;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class DynamicTargetGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final ITargetPtSupplier targetSupplier;
    public final Tracking tracking;
    public final double arrivalDist;
    public final TargetNotFound targetNotFound;
    public final TargetUnreachable targetUnreachable;

    public DynamicTargetGoal(ITargetPtSupplier targetSupplier, Tracking tracking, double arrivalDist, TargetNotFound targetNotFound, TargetUnreachable targetUnreachable) {
        this.targetSupplier = targetSupplier;
        this.tracking = tracking;
        this.arrivalDist = arrivalDist;
        this.targetNotFound = targetNotFound;
        this.targetUnreachable = targetUnreachable;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        DynamicTargetGoal goal = (DynamicTargetGoal)obj;
        return goal.targetSupplier.equals(this.targetSupplier) && goal.tracking == this.tracking && goal.arrivalDist == this.arrivalDist && goal.targetUnreachable == this.targetUnreachable && goal.targetNotFound == this.targetNotFound;
    }

    public int hashCode() {
        return 0x47823AB3 ^ Objects.hash(new Object[]{this.targetSupplier, this.tracking, this.arrivalDist, this.targetUnreachable, this.targetNotFound});
    }

    public JSONObject toJson(KB kb) {
        JSONObject jobj = new JSONObject();
        jobj.put("tracking", this.tracking.name());
        jobj.put("arrivalDist", this.arrivalDist);
        jobj.put("targetNotFound", this.targetNotFound.name());
        jobj.put("targetUnreachable", this.targetUnreachable.name());
        jobj.put("target", this.targetSupplier.toJson());
        return jobj;
    }

    public static DynamicTargetGoal fromJson(KB kb, JSONObject jobj, Function<String, Tag> getTag) throws IOException {
        JSONObject jtarget = (JSONObject)jobj.get("target");
        ITargetPtSupplier.InputFileInfo ifInfo = ITargetPtSupplier.InputFileInfo.findType(jtarget);
        Object target = ifInfo.fromJson.get(jtarget, getTag);
        return new DynamicTargetGoal((ITargetPtSupplier)target, JsonUtil.getEnum(jobj, "tracking", Tracking.class), JsonUtil.getDouble(jobj, "arrivalDist"), JsonUtil.getEnum(jobj, "targetNotFound", TargetNotFound.class), JsonUtil.getEnum(jobj, "targetUnreachable", TargetUnreachable.class));
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public ISeekGoalInstance begin(KB kb, OccAgent agent) {
        return new Instance(this, kb, agent);
    }

    public static class Instance
    implements ISeekGoalInstance {
        private static final long serialVersionUID = 1L;
        public final DynamicTargetGoal goal;
        private State d_state = State.SEARCHING;
        private double d_tNextChooseTarget;
        private ITpSource d_currTarget = null;
        private ISteeringBehavior d_nextSteering = null;
        private ISeekArea d_nextUpdateSeekArea = null;
        private transient IProgressNote d_progressNote = null;

        public Instance(DynamicTargetGoal goal, KB kb, OccAgent occ) {
            this.goal = goal;
            this.d_nextSteering = Instance.createIdleSteer(kb, occ);
            this.d_tNextChooseTarget = kb.getCurrentSimTime();
        }

        @Override
        public ISeekGoal getGoal() {
            return this.goal;
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return true;
        }

        @Override
        public Pair<ISeekArea, Serializable> interrupt(KB kb, OccAgent agent) {
            RoomSeekArea area = null;
            if (this.isSeeking(kb, agent)) {
                area = IGoalInstance.getCurrentAreaAsRoom(kb, agent);
            }
            return new Pair<ISeekArea, Serializable>(area, this);
        }

        @Override
        public boolean resume(KB kb, OccAgent agent, Object resumePacket) {
            assert (resumePacket == this);
            switch (this.d_state) {
                case SEARCHING: 
                case FINISHED_NOT_REACHED: 
                case FINISHED_REACHED: {
                    this.d_nextSteering = Instance.createIdleSteer(kb, agent);
                    break;
                }
                case SEEKING: {
                    this.pursueTarget(kb, agent);
                }
            }
            return true;
        }

        @Override
        public void processLost(KB kb, OccAgent agent) {
            assert (this.d_state == State.SEEKING);
            assert (this.d_currTarget != null);
            switch (this.goal.targetUnreachable) {
                case SKIP: {
                    this.d_state = State.FINISHED_NOT_REACHED;
                    break;
                }
                case WAIT: {
                    break;
                }
                case RESTART: {
                    this.startSearch(kb, agent, null);
                }
            }
        }

        private void startSearch(KB kb, OccAgent agent, ITpSource target) {
            this.d_state = State.SEARCHING;
            this.d_tNextChooseTarget = kb.getCurrentSimTime();
            this.d_currTarget = target;
            this.d_nextSteering = Instance.createIdleSteer(kb, agent);
            this.d_nextUpdateSeekArea = IGoalInstance.getCurrentAreaAsRoom(kb, agent);
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent agent) {
            assert (this.d_nextSteering != null);
            if (this.d_nextSteering == null) {
                this.update(kb, agent);
                assert (this.d_nextSteering != null);
            }
            ISteeringBehavior next = this.d_nextSteering;
            this.d_nextSteering = null;
            return next;
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            return this.d_nextSteering != null;
        }

        private static ISteeringBehavior createIdleSteer(KB kb, OccAgent agent) {
            return IGoalInstance.getCurrentAreaAsRoom(kb, agent).getIdleSteer(kb, agent, new IdleParams(true, true));
        }

        private void pursueTarget(KB kb, OccAgent agent) {
            this.d_state = State.SEEKING;
            PointTarget target = new PointTarget(this.d_currTarget);
            LocallyQuickest lq = new LocallyQuickest(agent, new LocalTimeEstimate.QueueSizes(), target);
            this.d_nextSteering = SteerUtil.newSeekSteer(kb, agent, lq);
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            switch (this.d_state) {
                case SEARCHING: {
                    if (this.d_currTarget == null) {
                        if (!theUtil.ge(kb.getCurrentSimTime(), this.d_tNextChooseTarget, 1.0E-6)) break;
                        this.d_currTarget = this.goal.targetSupplier.get(kb, agent);
                        if (this.d_currTarget != null) {
                            if (!this.goal.tracking.isTracking) {
                                this.d_currTarget = this.d_currTarget.getTriPoint();
                            }
                            this.pursueTarget(kb, agent);
                            break;
                        }
                        switch (this.goal.targetNotFound) {
                            case SKIP: {
                                this.d_state = State.FINISHED_NOT_REACHED;
                                break;
                            }
                            case WAIT: {
                                if (this.goal.targetSupplier.getHasMoreTargets(kb, agent)) {
                                    this.d_tNextChooseTarget = kb.getCurrentSimTime() + kb.getParams().dynamictarget_search_dt;
                                    break;
                                }
                                this.d_state = State.FINISHED_NOT_REACHED;
                            }
                        }
                        break;
                    }
                    if (!this.goal.targetSupplier.isTarget(kb, agent, this.d_currTarget)) break;
                    this.pursueTarget(kb, agent);
                    break;
                }
                case SEEKING: {
                    assert (this.d_currTarget != null);
                    TriPoint srcPos = agent.getLoc();
                    TriPoint destPos = this.d_currTarget.getTriPoint();
                    if (!this.goal.tracking.continuous && theUtil.le(srcPos.p.distanceSquared(destPos.p), this.goal.arrivalDist * this.goal.arrivalDist, 1.0E-6) && !kb.getMesh().isPathObstructed(srcPos, destPos, 0.0, Predicates.alwaysTrue())) {
                        this.d_state = State.FINISHED_REACHED;
                        break;
                    }
                    if (!this.goal.tracking.isTracking || this.goal.targetSupplier.isTarget(kb, agent, this.d_currTarget)) break;
                    Runnable startNotReached = () -> {
                        this.d_state = State.FINISHED_NOT_REACHED;
                        this.d_nextSteering = Instance.createIdleSteer(kb, agent);
                        this.d_nextUpdateSeekArea = IGoalInstance.getCurrentAreaAsRoom(kb, agent);
                    };
                    switch (this.goal.targetUnreachable) {
                        case SKIP: {
                            startNotReached.run();
                            break;
                        }
                        case WAIT: {
                            if (this.goal.targetSupplier.getIsFutureTarget(kb, agent, this.d_currTarget)) {
                                this.startSearch(kb, agent, this.d_currTarget);
                                break;
                            }
                            startNotReached.run();
                            break;
                        }
                        case RESTART: {
                            this.startSearch(kb, agent, null);
                        }
                    }
                    break;
                }
            }
        }

        @Override
        public ISeekArea update(KB kb, OccAgent occ) {
            ISeekArea area = this.d_nextUpdateSeekArea;
            this.d_nextUpdateSeekArea = null;
            return area;
        }

        @Override
        public boolean isReached(KB kb, OccAgent occ) {
            return this.d_state.done;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            if (this.d_state == State.FINISHED_REACHED) {
                assert (this.d_currTarget != null);
                TriPoint loc = this.d_currTarget.getTriPoint();
                return new PointSeekArea(loc, this.goal.arrivalDist, 0);
            }
            return null;
        }

        @Override
        public IGoalInstance.IdleInfo getIdleInfo(KB kb, OccAgent agent) {
            switch (this.d_state) {
                case FINISHED_NOT_REACHED: {
                    return new IGoalInstance.IdleInfo(kb.getCurrentSimTime());
                }
                case SEARCHING: {
                    return new IGoalInstance.IdleInfo(Double.POSITIVE_INFINITY);
                }
                case FINISHED_REACHED: 
                case SEEKING: {
                    return null;
                }
            }
            assert (false);
            return ISeekGoalInstance.super.getIdleInfo(kb, agent);
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case SEARCHING: 
                case FINISHED_NOT_REACHED: {
                    return null;
                }
                case FINISHED_REACHED: 
                case SEEKING: {
                    assert (this.d_currTarget != null);
                    TriPoint loc = this.d_currTarget.getTriPoint();
                    return new PointSeekArea(loc, this.goal.arrivalDist, 0);
                }
            }
            assert (false);
            return null;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            switch (this.d_state) {
                case FINISHED_NOT_REACHED: 
                case FINISHED_REACHED: {
                    return IProgressNote.PROGRESSING;
                }
                case SEARCHING: {
                    return IProgressNote.NOT_PROGRESSING;
                }
                case SEEKING: {
                    this.d_progressNote = GoalUtil.getSeekProgress(kb, occ, this.d_progressNote);
                    return this.d_progressNote;
                }
            }
            assert (false);
            return IProgressNote.NOT_PROGRESSING;
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        private static enum State {
            SEARCHING(false),
            SEEKING(false),
            FINISHED_REACHED(true),
            FINISHED_NOT_REACHED(true);

            public final boolean done;

            private State(boolean done) {
                this.done = done;
            }
        }
    }

    public static enum TargetUnreachable {
        SKIP,
        WAIT,
        RESTART;

    }

    public static enum TargetNotFound {
        SKIP,
        WAIT;

    }

    public static enum Tracking {
        DYNAMIC_ONCE(true, false),
        DYNAMIC_CONTINUOUS(true, true),
        INITIAL_LOC(false, false);

        public final boolean isTracking;
        public final boolean continuous;

        private Tracking(boolean isTracking, boolean continuous) {
            this.isTracking = isTracking;
            this.continuous = continuous;
        }
    }
}

