/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.AttractorSim;
import inferno.data2.TriPoint;
import inferno.data2.ai.GoalUtil;
import inferno.data2.ai.IIdleGoal;
import inferno.data2.ai.IIdleGoalInstance;
import inferno.data2.ai.IImmediateGoalInstance;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;

public class CreateAttractorGoal
implements IIdleGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final List<AttractorSim> attractors;
    public final LocationMode locationMode;
    public final TriPoint fixedLocation;

    public CreateAttractorGoal(List<AttractorSim> attractors, LocationMode locationMode, TriPoint fixedLocation) {
        this.attractors = attractors;
        this.locationMode = locationMode;
        this.fixedLocation = fixedLocation;
    }

    public int hashCode() {
        return 1489255260 + GoalUtil.setHashCode(this.attractors) + this.locationMode.hashCode() + Objects.hashCode(this.fixedLocation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof CreateAttractorGoal)) {
            return false;
        }
        CreateAttractorGoal ca = (CreateAttractorGoal)obj;
        return this.locationMode == ca.locationMode && Objects.equals(this.fixedLocation, ca.fixedLocation) && GoalUtil.setsEqual(this.attractors, ca.attractors);
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public IIdleGoalInstance begin(KB kb, OccAgent agent) {
        return new CreateAttractorGoalInstance(this);
    }

    private class CreateAttractorGoalInstance
    implements IImmediateGoalInstance {
        private static final long serialVersionUID = 1L;
        public final CreateAttractorGoal goal;

        public CreateAttractorGoalInstance(CreateAttractorGoal goal) {
            this.goal = goal;
        }

        @Override
        public IIdleGoal getGoal() {
            return this.goal;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent occ) {
            double time = kb.getCurrentSimTime();
            switch (CreateAttractorGoal.this.locationMode) {
                case FIXED_LOCATION: {
                    for (AttractorSim template : CreateAttractorGoal.this.attractors) {
                        kb.queueCreateAttractor(template.createInstance(occ, CreateAttractorGoal.this.fixedLocation, false, time));
                    }
                    break;
                }
                case CURRENT_LOCATION: {
                    TriPoint currentLoc = occ.getLoc();
                    for (AttractorSim template : CreateAttractorGoal.this.attractors) {
                        kb.queueCreateAttractor(template.createInstance(occ, currentLoc, false, time));
                    }
                    break;
                }
                case FOLLOW_OCC: {
                    TriPoint currentLoc = occ.getLoc();
                    for (AttractorSim template : CreateAttractorGoal.this.attractors) {
                        kb.queueCreateAttractor(template.createInstance(occ, currentLoc, true, time));
                    }
                    break;
                }
            }
            return null;
        }
    }

    public static enum LocationMode {
        FOLLOW_OCC,
        CURRENT_LOCATION,
        FIXED_LOCATION;

    }
}

