/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2.ai;

import inferno.data2.OccPriority;
import inferno.data2.ai.IProgressNote;
import inferno.data2.ai.ISeekGoal;
import inferno.data2.ai.ISeekGoalInstance;
import inferno.data2.ai.PointGoal;
import inferno.data2.seekarea.ISeekArea;
import inferno.sim.AssistedEvacClientAgent;
import inferno.sim.DoorQueue;
import inferno.sim.KB;
import inferno.sim.OccAgent;
import inferno.sim.steering.ISteeringBehavior;
import inferno.sim.steering.ITpSource;
import inferno.sim.steering.PathFollow;
import java.io.Serializable;
import javax.vecmath.Point3d;

public class AttachToAgentGoal
implements ISeekGoal,
Serializable {
    private static final long serialVersionUID = 1L;
    public final OccAgent goToAgent;

    public AttachToAgentGoal(OccAgent toGoAgent, KB kb) {
        this.goToAgent = toGoAgent;
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    @Override
    public AttachToAgentGoalInstance begin(KB kb, OccAgent agent) {
        return new AttachToAgentGoalInstance(this, this.goToAgent, kb, agent);
    }

    public static class AttachToAgentGoalInstance
    implements ISeekGoalInstance,
    Serializable {
        static final long serialVersionUID = 1L;
        private AttachToAgentGoal d_attachToAgentGoal;
        private boolean d_approachingAgent = true;
        private double d_tAttachBegin = Double.NaN;
        private double d_maxAttachTime = Double.NaN;
        private boolean d_isCanceled = false;
        private final OccAgent d_goToAgent;
        private final AssistedEvacClientAgent d_clientAgent;
        private PointGoal.Instance d_goToAgentPointGoalInstance = null;

        public AttachToAgentGoalInstance(AttachToAgentGoal attachToAgentGoal, OccAgent goToAgent, KB kb, OccAgent agent) {
            this.d_attachToAgentGoal = attachToAgentGoal;
            this.d_goToAgent = goToAgent;
            this.d_clientAgent = goToAgent.getAssistedEvacClientModule().get();
            this.initGoToAgentPointGoal(kb, agent);
        }

        @Override
        public boolean canInterrupt(KB kb, OccAgent agent) {
            return false;
        }

        @Override
        public ISeekGoal getGoal() {
            return this.d_attachToAgentGoal;
        }

        @Override
        public ISteeringBehavior generateSteeringBehavior(KB kb, OccAgent occ) {
            return this.d_goToAgentPointGoalInstance.generateSteeringBehavior(kb, occ);
        }

        private void initGoToAgentPointGoal(KB kb, OccAgent occ) {
            ITpSource goToSpot = this.d_clientAgent.getReservedSpotWithBackup(occ);
            assert (goToSpot != null);
            if (goToSpot != null) {
                PointGoal goToAgentGoal = new PointGoal(goToSpot, occ.getOccupantRadius());
                this.d_goToAgentPointGoalInstance = goToAgentGoal.begin(kb, occ);
            }
        }

        private double getAttachDist(KB kb, OccAgent agent, Point3d attachPt) {
            return 2.0 * Math.max(this.d_goToAgent.getCollisionShape().getEnclosingRadius(), attachPt.distance(this.d_goToAgent.getPos())) + (double)agent.getOcc().comfortDist + agent.getCollisionShape().getEnclosingRadius();
        }

        private boolean getAttachBegin(KB kb, OccAgent agent) {
            if (this.d_goToAgentPointGoalInstance.isReached(kb, agent)) {
                return true;
            }
            Point3d attachPt = this.d_goToAgentPointGoalInstance.getGoal().ptSrc.getTriPoint().p;
            double attachDist = this.getAttachDist(kb, agent, attachPt);
            PathFollow pf = agent.getPathFollow();
            assert (pf != null);
            if (pf == null) {
                return this.d_goToAgentPointGoalInstance.getGoal().ptSrc.getTriPoint().p.distance(agent.getLoc().p) <= attachDist;
            }
            return pf.isCloseToDestination(agent, attachDist);
        }

        @Override
        public ISeekArea getSeekArea(KB kb, OccAgent occ) {
            return this.d_goToAgentPointGoalInstance.getSeekArea(kb, occ);
        }

        @Override
        public void preMove(KB kb, OccAgent agent, double dt) {
            if (this.d_approachingAgent && this.getAttachBegin(kb, agent)) {
                this.d_approachingAgent = false;
            }
            if (!this.d_approachingAgent) {
                ITpSource goToSpot = this.d_clientAgent.getReservedSpotWithBackup(agent);
                if (goToSpot == null) {
                    this.d_isCanceled = true;
                    return;
                }
                if (Double.isNaN(this.d_tAttachBegin)) {
                    this.d_tAttachBegin = kb.getCurrentSimTime();
                }
            }
        }

        public OccAgent getGoToAgent() {
            return this.d_goToAgent;
        }

        @Override
        public ISeekArea end(KB kb, OccAgent agent) {
            if (!this.d_isCanceled) {
                agent.getOcc().isPassive = true;
                agent.getOcc().priority = OccPriority.lower(agent.getOcc().priority);
            }
            return this.getSeekArea(kb, agent);
        }

        @Override
        public boolean isReached(KB kb, OccAgent agent) {
            double tAttach;
            if (this.d_isCanceled) {
                return true;
            }
            if (this.d_clientAgent.isFullyOccupied()) {
                this.d_isCanceled = true;
                return true;
            }
            if (this.d_approachingAgent || this.d_goToAgentPointGoalInstance == null) {
                return false;
            }
            if (this.d_goToAgentPointGoalInstance.isReached(kb, agent)) {
                return true;
            }
            if (Double.isNaN(this.d_tAttachBegin)) {
                return false;
            }
            if (Double.isNaN(this.d_maxAttachTime)) {
                PathFollow pf = agent.getPathFollow();
                if (pf == null) {
                    return false;
                }
                double distRemain = pf.getRemainingDistance(agent, true);
                if (!Double.isFinite(distRemain)) {
                    return false;
                }
                double maxVel = OccAgent.getMaxVel(kb, agent.getOcc(), 0.0, null);
                this.d_maxAttachTime = 2.0 * OccAgent.calcTravelTime(0.0, maxVel, agent.getMaxStartAccel(kb), distRemain);
            }
            return (tAttach = kb.getCurrentSimTime() - this.d_tAttachBegin) > this.d_maxAttachTime;
        }

        @Override
        public IProgressNote getProgress(KB kb, OccAgent occ) {
            return this.d_goToAgentPointGoalInstance.getProgress(kb, occ);
        }

        @Override
        public void doorCrossed(OccAgent agent, DoorQueue door) {
        }

        @Override
        public boolean needsNewSteeringBehavior(KB kb, OccAgent occ) {
            return !this.d_approachingAgent;
        }

        public PointGoal.Instance getGoToAgentGoalInstance() {
            return this.d_goToAgentPointGoalInstance;
        }
    }
}

