/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.data2.WingedEdgeUse;
import inferno.sim.steering.ITpSource;
import java.io.Serializable;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Inter3D;

public class TriPoint
implements Serializable,
ITpSource {
    static final long serialVersionUID = 1L;
    public final Tri tri;
    public final Point3d p;
    private final boolean edgeKnown;
    private final WingedEdge edge;

    public TriPoint(Tri tri, Point3d p) {
        this(tri, p, null, false);
    }

    public TriPoint(Tri tri, Point3d p, WingedEdge edge) {
        this(tri, p, edge, true);
    }

    private TriPoint(Tri tri, Point3d p, WingedEdge edge, boolean edgeKnown) {
        this.tri = tri;
        this.p = p;
        this.edge = edge;
        this.edgeKnown = edgeKnown;
        assert (!edgeKnown || edge == null || tri == null || edge.isAdjacent(tri));
    }

    public int hashCode() {
        return this.p.hashCode();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof TriPoint && ((TriPoint)obj).p.equals(this.p);
    }

    @Override
    public boolean isEqual(ITpSource src) {
        return this.equals(src);
    }

    public TriPoint setToAdjacentTri(Tri tri) {
        return tri == this.tri ? this : new TriPoint(tri, this.p, this.edge, this.edgeKnown);
    }

    public WingedEdge getEdge() {
        return this.getEdge(1.0E-6);
    }

    public WingedEdge getEdge(double tol) {
        if (this.edgeKnown) {
            return this.edge;
        }
        double nearDistSq = tol * tol;
        WingedEdge nearEdge = null;
        for (WingedEdgeUse eu : this.tri.eu) {
            double distSq = Inter3D.distSqToNearestPtOnLineSeg(eu.wedge.p1(), eu.wedge.p2(), this.p);
            if (!(distSq <= nearDistSq)) continue;
            nearEdge = eu.wedge;
            nearDistSq = distSq;
        }
        return nearEdge;
    }

    @Override
    public TriPoint getTriPoint() {
        return this;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    public boolean tolEquals(TriPoint tp, double distTolSq) {
        if (tp == null) {
            return false;
        }
        return this.tri == tp.tri && this.p.distanceSquared(tp.p) <= distTolSq;
    }

    public String toString() {
        return this.p.toString();
    }
}

