/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Occupant;
import inferno.sim.OccAgent;
import java.io.Serializable;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class Tag
implements Serializable {
    static final long serialVersionUID = 1L;
    public static final EnumSet<Options> NO_OPTIONS = EnumSet.noneOf(Options.class);
    public final String name;
    public final String desc;
    public final EnumSet<Options> options;
    private final Set<Integer> d_occCounts;
    private final Map<Integer, Info> d_stats;
    private static final Function<Integer, Info> s_newStats = a -> new Info();
    private static final Info s_emptyStats = new Info();

    public Tag(String name, String desc, boolean predefined, boolean clearable) {
        this(name, desc, EnumSet.noneOf(Options.class));
    }

    public Tag(String name, String desc, EnumSet<Options> options) {
        this.name = name;
        this.desc = desc;
        this.options = options;
        this.d_occCounts = new LinkedHashSet<Integer>();
        this.d_stats = new HashMap<Integer, Info>();
    }

    public String toString() {
        return this.name;
    }

    public boolean isPredefined() {
        return this.options.contains((Object)Options.PREDEFINED);
    }

    public void tag(double t, OccAgent agent) {
        this.tag(t, agent.getOcc());
    }

    public synchronized void tag(double t, Occupant agent) {
        if (this.d_occCounts.add(agent.id)) {
            Info stats = this.d_stats.computeIfAbsent(agent.id, s_newStats);
            stats.tLastTagged = Double.isInfinite(stats.tLastTagged) ? t : Math.max(t, stats.tLastTagged);
        }
    }

    public void untag(double t, OccAgent agent) {
        this.untag(t, agent.getOcc());
    }

    public synchronized void untag(double t, Occupant agent) {
        if (this.d_occCounts.remove(agent.id)) {
            Info stats = this.d_stats.computeIfAbsent(agent.id, s_newStats);
            stats.tLastUntagged = Math.max(t, stats.tLastUntagged);
            assert (stats.tLastTagged <= stats.tLastUntagged);
            stats.tAccum += stats.tLastUntagged - stats.tLastTagged;
        }
    }

    public boolean isTagged(OccAgent agent) {
        return this.isTagged(agent.getOcc());
    }

    public boolean isTagged(Occupant agent) {
        return this.d_occCounts.contains(agent.id);
    }

    public int getTaggedCount() {
        return this.d_occCounts.size();
    }

    public Set<Integer> getTaggedAgents() {
        return this.d_occCounts;
    }

    public Info getInfo(OccAgent agent) {
        return this.getInfo(agent.getOcc());
    }

    public Info getInfo(Occupant agent) {
        return this.d_stats.getOrDefault(agent.getId(), s_emptyStats);
    }

    public boolean getAnyWereEverTagged() {
        return this.d_stats.values().stream().anyMatch(s -> Double.isFinite(s.tLastTagged));
    }

    public boolean getAnyWereEverUntagged() {
        return this.d_stats.values().stream().anyMatch(s -> s.tLastUntagged != 0.0);
    }

    public static class Info
    implements Serializable {
        static final long serialVersionUID = 1L;
        public double tLastTagged = Double.POSITIVE_INFINITY;
        public double tLastUntagged = 0.0;
        private double tAccum = 0.0;

        public double getTAccum(double currTime) {
            double t = this.tAccum;
            if (Double.isFinite(this.tLastTagged) && (this.tLastTagged == 0.0 && this.tLastUntagged == 0.0 || this.tLastTagged > this.tLastUntagged)) {
                t += currTime - this.tLastTagged;
            }
            return t;
        }
    }

    public static enum Options {
        PREDEFINED,
        CLEARABLE;

    }
}

