/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import java.io.Serializable;
import java.util.function.DoubleSupplier;
import thunderheadeng.util.theUtil;

public class SpeedModifier
implements Serializable,
Comparable<SpeedModifier> {
    static final long serialVersionUID = 1L;
    public static final double CUTOFF_FACTOR = 0.01;
    public static final double CUTOFF_LIMIT = 0.011899999999999999;
    public static final SpeedModifier IDENTITY = new SpeedModifier(Type.FACTOR, 1.0);
    public final Type type;
    public final double value;
    private final double d_distFactor;

    public SpeedModifier(Type type, double value) {
        this.type = type;
        this.value = value;
        DoubleSupplier calcDistFactorHack = () -> {
            switch (type) {
                case FACTOR: {
                    return 1.0 / Math.max(value, 0.01);
                }
                case CONSTANT: {
                    return 1.0;
                }
                case LIMIT: {
                    return 1.19 / Math.min(1.19, Math.max(value, 0.011899999999999999));
                }
            }
            assert (false);
            return 1.0;
        };
        this.d_distFactor = calcDistFactorHack.getAsDouble();
    }

    public int hashCode() {
        return 0x523F33FA ^ this.type.hashCode() + theUtil.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof SpeedModifier && ((SpeedModifier)obj).type == this.type && ((SpeedModifier)obj).value == this.value;
    }

    public double getAbsoluteSpeed(double occSpeed, boolean walkOnMovingTerrain) {
        return this.getRelativeSpeed(occSpeed, walkOnMovingTerrain) + this.getTerrainSpeed();
    }

    public double getRelativeSpeed(double occSpeed, boolean walkOnMovingTerrain) {
        switch (this.type) {
            case CONSTANT: {
                return walkOnMovingTerrain || this.value == 0.0 ? occSpeed : 0.0;
            }
            case FACTOR: {
                return this.value * occSpeed;
            }
            case LIMIT: {
                return Math.min(occSpeed, this.value);
            }
        }
        assert (false);
        return occSpeed;
    }

    public double getSpeedFactor(boolean walkOnMovingTerrain) {
        switch (this.type) {
            case CONSTANT: {
                return walkOnMovingTerrain || this.value == 0.0 ? 1.0 : 0.0;
            }
            case FACTOR: {
                return this.value;
            }
            case LIMIT: {
                return 1.0;
            }
        }
        assert (false);
        return 1.0;
    }

    public double getMaxSpeed() {
        switch (this.type) {
            case CONSTANT: 
            case FACTOR: {
                return Double.POSITIVE_INFINITY;
            }
            case LIMIT: {
                return this.value;
            }
        }
        assert (false);
        return Double.POSITIVE_INFINITY;
    }

    public double getTerrainSpeed() {
        switch (this.type) {
            case CONSTANT: {
                return this.value;
            }
            case FACTOR: 
            case LIMIT: {
                return 0.0;
            }
        }
        assert (false);
        return 0.0;
    }

    public boolean allowsMovement(boolean walkOnMovingTerrain) {
        return !this.isBlocking();
    }

    public boolean isBlocking() {
        switch (this.type) {
            case CONSTANT: {
                return false;
            }
            case FACTOR: {
                return this.value <= 0.01;
            }
            case LIMIT: {
                return this.value <= 0.011899999999999999;
            }
        }
        assert (false);
        return false;
    }

    public boolean isImpeding() {
        return this.isImpeding(Double.POSITIVE_INFINITY);
    }

    public boolean isImpeding(double maxVel) {
        switch (this.type) {
            case CONSTANT: {
                return false;
            }
            case FACTOR: {
                return this.value < 1.0;
            }
            case LIMIT: {
                return this.value < maxVel;
            }
        }
        assert (false);
        return false;
    }

    private double getMinVal() {
        switch (this.type) {
            case CONSTANT: {
                return 0.0;
            }
            case FACTOR: {
                return 0.01;
            }
            case LIMIT: {
                return 0.011899999999999999;
            }
        }
        assert (false);
        return 0.0;
    }

    public SpeedModifier clampToCutoff() {
        double minVal = this.getMinVal();
        return this.value < minVal ? new SpeedModifier(this.type, minVal) : this;
    }

    @Override
    public int compareTo(SpeedModifier o) {
        int result = this.type.compareTo(o.type);
        if (result != 0) {
            return result;
        }
        switch (this.type) {
            case CONSTANT: 
            case FACTOR: 
            case LIMIT: {
                return Double.compare(this.value, o.value);
            }
        }
        assert (false);
        return -1;
    }

    public double getDistanceFactorHACK() {
        return this.d_distFactor;
    }

    public static enum Type {
        CONSTANT(false),
        FACTOR(true),
        LIMIT(true);

        public final boolean isLimiting;

        private Type(boolean isLimiting) {
            this.isLimiting = isLimiting;
        }
    }
}

