/*
 * Decompiled with CFR 0.152.
 */
package inferno.data2;

import inferno.data2.Mesh;
import inferno.data2.Vertex;
import inferno.data2.WingedEdge;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import thunderheadeng.geometry.Inter2D;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class DoorGeom
implements Serializable {
    private static final long serialVersionUID = 1L;
    public final List<WingedEdge> edges;
    public final Vertex[] verts;
    public final double[] vt;
    public final double length;
    public final double length2d;

    public DoorGeom(List<WingedEdge> edges) {
        assert (!edges.isEmpty());
        this.edges = edges;
        this.verts = new Vertex[edges.size() + 1];
        this.verts[0] = edges.get(0).v1();
        for (int m = 0; m < edges.size(); ++m) {
            this.verts[m + 1] = edges.get(m).v2();
            assert (this.verts[m] == edges.get(m).v1());
        }
        double totLen = 0.0;
        double totLen2d = 0.0;
        for (WingedEdge e : edges) {
            totLen += e.p1().distance(e.p2());
            totLen2d += Mesh.length2d(e);
        }
        this.length = totLen;
        this.length2d = totLen2d;
        double ilen = 1.0 / this.length;
        this.vt = new double[this.verts.length];
        this.vt[0] = 0.0;
        totLen = 0.0;
        for (int m = 1; m < this.verts.length - 1; ++m) {
            this.vt[m] = (totLen += this.verts[m - 1].p.distance(this.verts[m].p)) * ilen;
        }
        this.vt[this.vt.length - 1] = 1.0;
    }

    public Pair<Integer, Point3d> getMidpoint() {
        return this.get(0.5);
    }

    public Pair<WingedEdge, Point3d> getNearestInfoOnDoor(Point3d p) {
        WingedEdge edge = null;
        double et = Double.NaN;
        double nearestDistSq = Double.POSITIVE_INFINITY;
        Point2d p2d = DoorGeom.to2d(p);
        for (WingedEdge e : this.edges) {
            double neart;
            Point2d l2;
            Point2d l1 = DoorGeom.to2d(e.base.n1.p);
            Point2d nearPt = Util2D.linePoint(l1, l2 = DoorGeom.to2d(e.base.n2.p), neart = Inter2D.nearestTOnLineSeg(p2d, l1, l2));
            double distSq = nearPt.distanceSquared(p2d);
            if (!(distSq < nearestDistSq)) continue;
            nearestDistSq = distSq;
            et = neart;
            edge = e;
        }
        return new Pair<Object, Point3d>(edge, edge.base.get(et));
    }

    public double distSqToProjectedPoint(Point3d p) {
        return this.edges.stream().mapToDouble(e -> Inter3D.distSqToNearestPtOnLineSeg(e.p1(), e.p2(), p)).min().getAsDouble();
    }

    private static Point2d to2d(Point3d p) {
        return new Point2d(p.x, p.y);
    }

    public Pair<Integer, Point3d> get(double t) {
        Pair<Integer, Double> et = this.getEdgeT(t);
        WingedEdge edge = this.edges.get((Integer)et.v1);
        return new Pair<Integer, Point3d>((Integer)et.v1, edge.base.get((Double)et.v2));
    }

    public Pair<Integer, Double> getEdgeT(double t) {
        if (this.edges.size() == 1) {
            return new Pair<Integer, Double>(0, t);
        }
        int ix = Arrays.binarySearch(this.vt, t);
        ix = ix < 0 ? Math.max(0, Math.min(this.vt.length - 2, -ix - 2)) : Math.min(ix, this.vt.length - 2);
        assert (ix >= 0 && ix < this.vt.length - 1);
        double vt1 = this.vt[ix];
        double vt2 = this.vt[ix + 1];
        double et = (t - vt1) / (vt2 - vt1);
        return new Pair<Integer, Double>(ix, et);
    }

    public Pair<Integer, Double> get(Point3d p, int edgeHint) {
        if (this.edges.size() == 1) {
            WingedEdge e = this.edges.get(0);
            return new Pair<Integer, Double>(0, Util3D.tOnLineSeg(e.base.n1.p, e.base.n2.p, p));
        }
        if (edgeHint < 0) {
            double nearestDistSq = Double.MAX_VALUE;
            for (int m = 0; m < this.edges.size(); ++m) {
                WingedEdge e = this.edges.get(m);
                double distSq = Inter3D.distSqToNearestPtOnLineSeg(e.p1(), e.p2(), p);
                if (!(distSq < nearestDistSq)) continue;
                nearestDistSq = distSq;
                edgeHint = m;
            }
        }
        WingedEdge e = this.edges.get(edgeHint);
        double et = Util3D.tOnLineSeg(e.base.n1.p, e.base.n2.p, p);
        double vt1 = this.vt[edgeHint];
        double vt2 = this.vt[edgeHint + 1];
        return new Pair<Integer, Double>(edgeHint, theUtil.lerp(vt1, vt2, et));
    }

    public double toEdgeT(int edgeIx, double t) {
        double vt1 = this.vt[edgeIx];
        double vt2 = this.vt[edgeIx + 1];
        return (t - vt1) / (vt2 - vt1);
    }

    public double toDoorT(int edgeIx, double t) {
        double vt1 = this.vt[edgeIx];
        double vt2 = this.vt[edgeIx + 1];
        return theUtil.lerp(vt1, vt2, t);
    }
}

