/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import inferno.data2.ANode;
import inferno.data2.Tri;
import inferno.data2.WingedEdge;
import inferno.geom.Util;
import inferno.sim.KB;
import inferno.sim.path.EstimateRealtime;
import inferno.test.Tweaks;
import merlin.data.MerlinData;

public class RealTimeTweak
implements Tweaks.ITweak {
    private static final double MAX_ANIMATABLE_DOOR_ANGLE = Math.toRadians(5.0);
    private static final double MAX_ANIMATABLE_DOOR_SLOPE = Util.getSlope(MAX_ANIMATABLE_DOOR_ANGLE);

    @Override
    public void tweak(KB kb) {
        kb.setForceIdle(true);
        kb.getParams().shutdown_empty = false;
        kb.getParams().realtime = true;
        kb.getParams().dt_snapshot = 0.0;
        kb.getParams().max_time = 0.0;
        kb.getParams().dt_init = 0.1;
        int maxAnimId = -1;
        for (ANode node : kb.getNodes()) {
            int animId = node.getAnimationId();
            if (animId <= maxAnimId) continue;
            maxAnimId = animId;
        }
        int animId = maxAnimId + 1;
        for (ANode node : kb.getNodes()) {
            if (!RealTimeTweak.isAnimatableNode(node)) continue;
            node.setAnimationId(animId++);
        }
        kb.setPathEstimates(new EstimateRealtime(kb));
    }

    @Override
    public void tweak(MerlinData kb) {
    }

    private static boolean isAnimatableNode(ANode node) {
        if (!node.isDoor() || node.getAnimationId() >= 0) {
            return false;
        }
        for (ANode adjNode : node.getAdjacentNodes()) {
            if (adjNode.stairData == null) continue;
            return false;
        }
        for (WingedEdge edge : node.getDoorEdges()) {
            for (Tri adjTri : edge.getAdjTris()) {
                if (!(adjTri.actualSlope > MAX_ANIMATABLE_DOOR_SLOPE)) continue;
                return false;
            }
        }
        return true;
    }
}

