/*
 * Decompiled with CFR 0.152.
 */
package fpserver;

import fpserver.IServer;
import fpserver.ServerState;
import inferno.data2.ANode;
import inferno.data2.IAnimSrc;
import inferno.data2.Occupant;
import inferno.data2.ai.ControlledOccGoal;
import inferno.sim.Engine;
import inferno.sim.KB;
import inferno.sim.ObjectTracker;
import inferno.sim.OccAgent;
import inferno.sim.OccTracker;
import inferno.sim.output.GeomVisWriter;
import inferno.sim.output.OccVisWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

public class AsyncUpdates
implements Runnable {
    public static final Object UPDATE_ID = new Object();
    private Engine d_engine;
    private IServer d_asyncServer;
    private final OccTracker d_occs;
    private final OccVisWriter.RelationTracker d_occRelations;
    private final ObjectTracker<IAnimSrc, Void> d_geomTracker;

    public AsyncUpdates(Engine engine, IServer asyncServer, OccTracker occTracker) {
        this.d_engine = engine;
        this.d_asyncServer = asyncServer;
        this.d_occs = occTracker;
        this.d_occRelations = new OccVisWriter.RelationTracker();
        this.d_geomTracker = new ObjectTracker();
    }

    private void sendAgentUpdate(MessageStream data, KB kb, Collection<OccAgent> activeAgents) {
        try {
            data.begin(Message.UPDATE_AGENTS, kb.getCurrentSimTime());
            OccVisWriter.writeAgentUpdate(data, this.d_occs, activeAgents);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendGeomUpdate(MessageStream oos, KB kb) {
        Collection<? extends IAnimSrc> animNodes = GeomVisWriter.getAnimatedObjs(kb);
        if (animNodes.isEmpty()) {
            return;
        }
        try {
            oos.begin(Message.UPDATE_GEOM, kb.getCurrentSimTime());
            GeomVisWriter.writeGeomUpdate(oos, animNodes);
            oos.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendStatsUpdate(MessageStream data, Engine engine) {
        try {
            KB kb = engine.getKB();
            int totalExited = 0;
            for (ANode aNode : kb.getNodes()) {
                if (!aNode.isDoor() || !aNode.doorQueue.isExitDoor()) continue;
                for (Occupant occ : aNode.getTotalUsageSet()) {
                    if (AsyncUpdates.isControlled(occ)) continue;
                    ++totalExited;
                }
            }
            int totalActive = 0;
            for (OccAgent agent : kb.getActiveAgents()) {
                if (AsyncUpdates.isControlled(agent.getOcc())) continue;
                ++totalActive;
            }
            int n = totalActive + totalExited;
            data.begin(Message.UPDATE_STATS, engine.getKB().getCurrentSimTime());
            data.writeInt(n);
            data.writeInt(totalExited);
            data.writeDouble(engine.getCurrentDt());
            data.writeDouble(engine.getPreviousWallDt());
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendStateUpdate(MessageStream data, Engine engine) {
        try {
            ServerState state = ServerState.get(engine);
            data.begin(Message.UPDATE_STATE, engine.getKB().getCurrentSimTime());
            data.writeInt(state.ordinal());
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendAgentAdded(MessageStream data, KB kb, Collection<OccAgent> agents, OccTracker.Changes changes) {
        if (agents.isEmpty() && changes.addedTrackedObjs.isEmpty() && changes.addedVehicleProxies.isEmpty()) {
            return;
        }
        try {
            data.begin(Message.ADD_AGENTS, kb.getCurrentSimTime());
            OccVisWriter.writeTrackedObjs(data, this.d_occs, changes.addedTrackedObjs);
            OccVisWriter.writeAgentsAdded(data, this.d_occs, agents, changes.addedVehicleProxies);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendAgentRemoved(MessageStream data, KB kb, Collection<OccAgent> agents, OccTracker.Changes changes) {
        if (agents.isEmpty() && changes.removedVehicleProxies.isEmpty()) {
            return;
        }
        try {
            data.begin(Message.REMOVE_AGENTS, kb.getCurrentSimTime());
            OccVisWriter.writeAgentsRemoved(data, this.d_occs, agents, changes.removedVehicleProxies);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendAgentChanged(MessageStream data, KB kb, OccTracker.Changes changes) {
    }

    private static boolean isControlled(Occupant occ) {
        return occ.behavior.goals.isEmpty() || occ.behavior.get(0) instanceof ControlledOccGoal;
    }

    private void sendAgentRelationsAdded(MessageStream data, KB kb, Collection<OccVisWriter.Relation> relations) {
        if (relations.isEmpty()) {
            return;
        }
        try {
            data.begin(Message.ADD_AGENT_RELATIONS, kb.getCurrentSimTime());
            OccVisWriter.writeRelationsAdded(data, relations);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendAgentRelationsRemoved(MessageStream data, KB kb, Collection<OccVisWriter.Relation> relations) {
        if (relations.isEmpty()) {
            return;
        }
        try {
            data.begin(Message.REMOVE_AGENT_RELATIONS, kb.getCurrentSimTime());
            OccVisWriter.writeRelationsRemoved(data, relations);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendGeomAdded(MessageStream data, KB kb, Collection<? extends IAnimSrc> objs) {
        if (objs.isEmpty()) {
            return;
        }
        try {
            data.begin(Message.ADD_GEOMS, kb.getCurrentSimTime());
            GeomVisWriter.writeGeomsAdded(data, objs);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void sendGeomRemoved(MessageStream data, KB kb, Collection<? extends IAnimSrc> objs) {
        if (objs.isEmpty()) {
            return;
        }
        try {
            data.begin(Message.REMOVE_GEOMS, kb.getCurrentSimTime());
            GeomVisWriter.writeGeomsRemoved(data, objs);
            data.end();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        KB kb = this.d_engine.getKB();
        MessageStream stream = new MessageStream();
        ArrayList<OccAgent> added = new ArrayList<OccAgent>();
        ArrayList<OccAgent> removed = new ArrayList<OccAgent>();
        Object changes = this.d_occs.beginUpdate(kb.getActiveAgents(), added, removed);
        this.sendAgentAdded(stream, kb, added, (OccTracker.Changes)changes);
        this.sendAgentRemoved(stream, kb, removed, (OccTracker.Changes)changes);
        this.sendAgentChanged(stream, kb, (OccTracker.Changes)changes);
        this.d_occs.endUpdate((Collection<? extends OccAgent>)removed);
        Set<OccVisWriter.Relation> occRelations = OccVisWriter.getRelations(kb.getActiveAgents());
        ArrayList<OccVisWriter.Relation> addedRelations = new ArrayList<OccVisWriter.Relation>();
        ArrayList<OccVisWriter.Relation> removedRelations = new ArrayList<OccVisWriter.Relation>();
        this.d_occRelations.beginUpdate(occRelations, addedRelations, removedRelations);
        this.sendAgentRelationsAdded(stream, kb, addedRelations);
        this.sendAgentRelationsRemoved(stream, kb, removedRelations);
        this.d_occRelations.endUpdate(removedRelations);
        ArrayList addedGeom = new ArrayList();
        ArrayList removedGeom = new ArrayList();
        this.d_geomTracker.beginUpdate(GeomVisWriter.getDynamicGeom(kb), addedGeom, removedGeom);
        this.sendGeomAdded(stream, kb, addedGeom);
        this.sendGeomRemoved(stream, kb, removedGeom);
        this.d_geomTracker.endUpdate(removedGeom);
        stream.broadcast(this.d_asyncServer, null);
        stream = new MessageStream();
        this.sendStateUpdate(stream, this.d_engine);
        this.sendStatsUpdate(stream, this.d_engine);
        this.sendAgentUpdate(stream, kb, kb.getActiveAgents());
        this.sendGeomUpdate(stream, kb);
        stream.broadcast(this.d_asyncServer, UPDATE_ID);
    }

    private static class SeekableByteOutputStream
    extends ByteArrayOutputStream {
        private int size = 0;

        private SeekableByteOutputStream() {
        }

        public synchronized byte[] getBuffer() {
            return this.buf;
        }

        public synchronized void seek(int pos) {
            this.count = pos;
        }

        @Override
        public synchronized void write(int b) {
            super.write(b);
            if (this.count > this.size) {
                this.size = this.count;
            }
        }

        @Override
        public synchronized void write(byte[] b, int off, int len) {
            super.write(b, off, len);
            if (this.count > this.size) {
                this.size = this.count;
            }
        }

        @Override
        public synchronized int size() {
            return this.size;
        }

        @Override
        public synchronized void reset() {
            super.reset();
            this.size = 0;
        }
    }

    private static class MessageStream
    extends DataOutputStream {
        private int d_messageBegin = 0;

        public MessageStream() {
            super(new SeekableByteOutputStream());
        }

        private static int getHeaderSize() {
            return 16;
        }

        public void begin(Message message, double time) throws IOException {
            this.d_messageBegin = ((SeekableByteOutputStream)this.out).size();
            this.writeInt(0);
            this.writeInt(message.id);
            this.writeDouble(time);
        }

        public void end() throws IOException {
            SeekableByteOutputStream stream = (SeekableByteOutputStream)this.out;
            int end = stream.size();
            int headerSize = MessageStream.getHeaderSize();
            stream.seek(this.d_messageBegin);
            this.writeInt(end - this.d_messageBegin - headerSize);
            stream.seek(end);
        }

        public void broadcast(IServer server, Object mergeId) {
            SeekableByteOutputStream stream = (SeekableByteOutputStream)this.out;
            int size = stream.size();
            if (size == 0) {
                return;
            }
            server.broadcast(stream.getBuffer(), 0, size, mergeId);
        }
    }

    public static enum Message {
        UPDATE_AGENTS(1),
        ADD_AGENTS(2),
        REMOVE_AGENTS(3),
        UPDATE_GEOM(4),
        UPDATE_STATS(5),
        ADD_GEOMS(6),
        REMOVE_GEOMS(7),
        ADD_AGENT_RELATIONS(8),
        REMOVE_AGENT_RELATIONS(9),
        UPDATE_STATE(10),
        AGENTS_CHANGED(11);

        int id;

        private Message(int id) {
            this.id = id;
        }

        public static Message find(int id) {
            for (Message msg : Message.values()) {
                if (msg.id != id) continue;
                return msg;
            }
            return null;
        }
    }
}

