/*
 * Decompiled with CFR 0.152.
 */
package common.data;

import merlin.Intl;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.PlotData;

public class SpeedInSmoke {
    public static final String PROP_KEY = "speedInSmoke";
    public static final PlotData CURVE_FRIDOLF = SpeedInSmoke.getFridolfM1CurveAsIs();
    public static final PlotData CURVE_FRIDOLF_ASFACTOR = SpeedInSmoke.getFridolfM1CurveAsFactor();

    public static double vMaxFridolf3(double occMaxVel, double visibility) {
        double adjMaxVel = occMaxVel - 0.34 * (3.0 - visibility);
        double result = Math.min(occMaxVel, Math.max(0.2, adjMaxVel));
        return result;
    }

    private static PlotData getFridolfM1CurveAsIs() {
        return new PlotData(SI.METER, SI.METER.divide(SI.SECOND), false, new double[]{0.0, 0.2, 0.647, 0.2, 3.0, 1.0, 6.0, 1.0});
    }

    private static PlotData getFridolfM1CurveAsFactor() {
        return new PlotData(SI.METER, Unit.ONE, false, new double[]{0.0, 0.2, 0.647, 0.2, 3.0, 1.0, 6.0, 1.0});
    }

    public static final class Data {
        public static final Data DISABLED = Data.newDisabled();
        public static final Data LEGACY_DEFAULT = Data.newLegacyDefault();
        public static final Data DEFAULT = Data.newDefault();
        public final Mode mode;
        public final UnitDouble customFuncVisThreshold;
        public final FuncType customFuncVisType;
        public final PlotData customFuncVis;

        public Data(Mode mode, UnitDouble customFuncVisThreshold, FuncType customFuncVisType, PlotData customFuncVis) {
            this.mode = mode;
            this.customFuncVisThreshold = customFuncVisThreshold;
            this.customFuncVisType = customFuncVisType;
            this.customFuncVis = customFuncVis;
        }

        private static Data newDisabled() {
            return new Data(Mode.DISABLED, new UnitDouble(3.0, SI.METER), FuncType.AS_GIVEN, SpeedInSmoke.getFridolfM1CurveAsIs());
        }

        private static Data newLegacyDefault() {
            return new Data(Mode.CUSTOM_VISIBILITY, new UnitDouble(3.0, SI.METER), FuncType.AS_FACTOR, SpeedInSmoke.getFridolfM1CurveAsFactor());
        }

        private static Data newDefault() {
            return new Data(Mode.FRIDOLF, new UnitDouble(3.0, SI.METER), FuncType.AS_GIVEN, SpeedInSmoke.getFridolfM1CurveAsIs());
        }
    }

    public static enum FuncType {
        AS_GIVEN,
        AS_FACTOR;

    }

    public static enum Mode {
        DISABLED(Intl.intl("Disabled"), Intl.intl("Disabled")),
        FRIDOLF(Intl.intl("Fridolf et al"), Intl.intl("Fridolf et al - Method 3")),
        CUSTOM_VISIBILITY(Intl.intl("Custom Function"), Intl.intl("Custom Function of Visibility"));

        public final String name;
        public final String alternateName;

        private Mode(String name, String alternateName) {
            this.name = name;
            this.alternateName = alternateName;
        }
    }
}

