/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import thunderheadeng.util.LinkedIdentityHashSet;

public class Hierarchy {
    public static Object[] getPath(Object child, Function<Object, Object> parentMap) {
        return Hierarchy.getPath(child, null, false, parentMap);
    }

    public static Object[] getPath(Object child, Object stopParent, boolean includeStopParent, Function<Object, Object> parentMap) {
        ArrayList<Object> path = new ArrayList<Object>();
        Hierarchy.getPath(path, child, stopParent, includeStopParent, parentMap);
        return path.toArray();
    }

    public static void getPath(List<Object> path, Object child, Object stopParent, boolean includeStopParent, Function<Object, Object> parentMap) {
        if (child != stopParent) {
            Object parent = parentMap.apply(child);
            if (parent != null) {
                Hierarchy.getPath(path, parent, stopParent, includeStopParent, parentMap);
            }
            path.add(child);
        }
        if (child == stopParent && includeStopParent) {
            path.add(child);
        }
    }

    public static <T> Iterator<T> iterateParents(Class<T> parentType, Object child, Function<Object, Object> parentMap) {
        return new ParentIterator<T>(parentType, child, parentMap);
    }

    public static Set<Object> getParents(Collection<?> objs, Function<Object, Object> parentMap) {
        LinkedIdentityHashSet<Object> parents = new LinkedIdentityHashSet<Object>();
        for (Object o : objs) {
            Object[] path = Hierarchy.getPath(o, parentMap);
            for (int m = 0; m < path.length - 1; ++m) {
                parents.add(path[m]);
            }
        }
        return parents;
    }

    public static boolean isDescendent(Object parent, Object child, Function<Object, Object> parentMap) {
        Object[] path;
        for (Object o : path = Hierarchy.getPath(child, parentMap)) {
            if (o != parent) continue;
            return true;
        }
        return false;
    }

    public static Object getCommonParent(Collection<?> objs, Function<Object, Object> parentMap) {
        if (objs.isEmpty()) {
            return null;
        }
        Iterator<?> it = objs.iterator();
        Object[] path = Hierarchy.getPath(it.next(), parentMap);
        int best = path.length - 2;
        while (it.hasNext() && best >= 0) {
            Object node = it.next();
            while (best >= 0 && !Hierarchy.isDescendent(path[best], node, parentMap)) {
                --best;
            }
        }
        return best >= 0 ? path[best] : null;
    }

    public static class ParentIterator<T>
    implements Iterator<T> {
        private final Function<Object, Object> d_parentMap;
        private final Class<T> d_parentType;
        private T d_nextParent = null;

        public ParentIterator(Class<T> parentType, Object o, Function<Object, Object> parentMap) {
            this.d_parentType = parentType;
            this.d_parentMap = parentMap;
            this.prefetchNext(o);
        }

        private void prefetchNext(Object o) {
            Object next = this.d_parentMap.apply(o);
            while (next != null && !this.d_parentType.isInstance(next)) {
                next = this.d_parentMap.apply(next);
            }
            this.d_nextParent = next == null ? null : next;
        }

        @Override
        public boolean hasNext() {
            return this.d_nextParent != null;
        }

        @Override
        public T next() {
            T next = this.d_nextParent;
            this.prefetchNext(next);
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

