/*
 * Decompiled with CFR 0.152.
 */
package merlin.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import merlin.data.AssistedEvacTeam;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.OccGroupTypeObj;
import merlin.data.OccSourceObj;
import merlin.data.Proxy;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.agents.VehicleShape;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.elevators.Elevator;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.EgressDoor;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.AssistOccupants;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.ChangeBehavior;
import merlin.data.egress.scripting.ChangeProfile;
import merlin.data.egress.scripting.GotoElevators;
import merlin.data.egress.scripting.GotoExits;
import merlin.data.egress.scripting.GotoOccTarget;
import merlin.data.egress.scripting.GotoQueue;
import merlin.data.egress.scripting.GotoRooms;
import merlin.data.egress.scripting.JoinOccGroup;
import merlin.data.egress.scripting.WaitForAssistance;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueueObjectComp;
import merlin.data.material.Material;
import merlin.util.MerlinUtil;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;

public class Dependencies {
    public static void getObjReferences(MerlinData md, Predicate<? super IMerlinObj> referencedTest, BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Dependencies.getObjReferences(md, Predicates.alwaysTrue(), referencedTest, references);
    }

    private static boolean test(int types, int type) {
        return (types & type) == type;
    }

    public static void getObjReferences(MerlinData md, int types, Predicate<? super IMerlinObj> referencedTest, BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        Pair<Predicate<Class<? extends IMerlinObj>>, Predicate<? super IMerlinObj>> predicates = Dependencies.finalizePredicates(types, referencedTest);
        Dependencies.getObjReferences(md, (Predicate<Class<? extends IMerlinObj>>)((Predicate)predicates.v1), (Predicate<? super IMerlinObj>)((Predicate)predicates.v2), references);
    }

    private static Pair<Predicate<Class<? extends IMerlinObj>>, Predicate<? super IMerlinObj>> finalizePredicates(int types, Predicate<? super IMerlinObj> referencedTest) {
        ArrayList<Class<? extends IMerlinObj>> clazzes = new ArrayList<Class<? extends IMerlinObj>>();
        for (Type type : Type.values()) {
            if (!Dependencies.test(types, type.flag)) continue;
            clazzes.add(type.mtype);
        }
        return new Pair<Predicate<Class<? extends IMerlinObj>>, Predicate<? super IMerlinObj>>(new ClassTest(theUtil.toArray(clazzes, Class.class)), referencedTest);
    }

    public static <T extends IMerlinObj> LinkedIdentityHashSet<T> getObjReferences(MerlinData md, Class<T> type, Predicate<? super T> referencedTest) {
        LinkedIdentityHashSet result = new LinkedIdentityHashSet();
        Dependencies.getObjReferences(md, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, ? super IMerlinObj target) -> result.add(target));
        return result;
    }

    public static <T> void getObjReferences(MerlinData md, Class<T> type, Predicate<? super T> referencedTest, BiConsumer<? super IMerlinObj, ? super T> references) {
        Dependencies.getObjReferences(md, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, ? super IMerlinObj target) -> references.accept((IMerlinObj)src, (Object)target));
    }

    public static void getObjReferences(MerlinData md, Predicate<Class<? extends IMerlinObj>> types, Predicate<? super IMerlinObj> referencedTest, BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        for (ReferencingType depType : ReferencingType.values()) {
            if (!Dependencies.testAny(types, depType.targetTypes)) continue;
            Dependencies.getObjReferences(depType.getSources.apply(md), types, referencedTest, references);
        }
    }

    private static boolean testAny(Predicate<Class<? extends IMerlinObj>> test, Class<? extends IMerlinObj> ... types) {
        for (Class<? extends IMerlinObj> type : types) {
            if (!test.test(type)) continue;
            return true;
        }
        return false;
    }

    public static <T extends IMerlinObj> void getObjReferences(Collection<? extends IMerlinObj> sourceObjs, Class<T> type, Predicate<? super T> referencedTest, BiConsumer<? super IMerlinObj, ? super T> references) {
        Dependencies.getObjReferences(sourceObjs, (Class<? extends IMerlinObj> t) -> type.isAssignableFrom((Class<?>)t), (? super IMerlinObj o) -> referencedTest.test(o), (? super IMerlinObj src, ? super IMerlinObj target) -> references.accept((IMerlinObj)src, (Object)target));
    }

    public static void getObjReferences(Collection<? extends IMerlinObj> sourceObjs, final Predicate<Class<? extends IMerlinObj>> types, final Predicate<? super IMerlinObj> referencedTest, final BiConsumer<? super IMerlinObj, ? super IMerlinObj> references) {
        IGetDepsCallback callback = new IGetDepsCallback(){

            @Override
            public boolean addRef(IMerlinObj src, IMerlinObj target) {
                if (src == null || target == null) {
                    return true;
                }
                if (types.test(target.getClass()) && referencedTest.test(target)) {
                    if (references != null) {
                        references.accept(src, target);
                    } else {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public <TargetT extends IMerlinObj> boolean addRefs(IMerlinObj src, Class<TargetT> targetType, Collection<? extends TargetT> targets) {
                if (types.test(targetType)) {
                    return this.addRefs(src, targets);
                }
                return true;
            }
        };
        for (ReferencingType dep : ReferencingType.values()) {
            if (!dep.testTypes(types)) continue;
            for (IMerlinObj iMerlinObj : MerlinUtil.flatten(sourceObjs, dep.srcType)) {
                dep.getDeps.get(iMerlinObj, callback);
            }
        }
    }

    private static <T extends IMerlinObj> void addCompRestrRefs(T obj, OccProfile profile, IGetDepsCallback callback) {
        if (profile.isDefinedLocally(OccProfile.PROP_RESTRICTED_COMPONENTS)) {
            OccProfile.CompRestrictions cr = profile.getProperty(OccProfile.PROP_RESTRICTED_COMPONENTS);
            callback.addRefs(obj, cr.comps);
        }
    }

    private static Class<? extends IMerlinObj>[] getCompRestrTypes(Class<? extends IMerlinObj> ... additionalTypes) {
        ArrayList<Class<? extends IMerlinObj>> types = new ArrayList<Class<? extends IMerlinObj>>(Arrays.asList(additionalTypes));
        types.addAll(Arrays.asList(IEgressOccupiable.class, IEgressConnector.class, Elevator.class));
        return theUtil.toArray(types);
    }

    private static enum ReferencingType {
        AGENTS(EgressAgent.class, md -> md.agents.getMembers(), (agent, callback) -> {
            callback.addRef(agent, agent.getBehavior());
            callback.addRef(agent, agent.getProfile().getProfParent());
            if (agent.getProfile().isDefinedLocally(OccProfile.PROP_SHAPE)) {
                callback.addRef(agent, agent.getProfile().getProperty(OccProfile.PROP_SHAPE).vehicleShape);
            }
            if (agent.getProfile().isDefinedLocally(OccProfile.PROP_ATTRACTOR_RESTRICTIONS)) {
                agent.getProfile().getProperty(OccProfile.PROP_ATTRACTOR_RESTRICTIONS).attractors.forEach(attr -> callback.addRef(agent, (IMerlinObj)attr));
            }
            Dependencies.addCompRestrRefs(agent, agent.getProfile(), callback);
        }, Dependencies.getCompRestrTypes(Behavior.class, OccProfile.class, VehicleShape.class, Attractor.class)),
        ATTRACTORS(Attractor.class, md -> md.attractors.getMembers(), (attractor, callback) -> {
            Behavior behavior = attractor.get(Attractor.BEHAVIOR);
            if (behavior != Attractor.WAIT_AT_ATTRACTOR_BEHAVIOR) {
                callback.addRef(attractor, behavior);
            }
            attractor.get(Attractor.ROOMS).stream().forEach(r -> callback.addRef(attractor, (IMerlinObj)r));
        }, Behavior.class, IEgressOccupiable.class),
        OCC_SOURCES(OccSourceObj.class, md -> md.occSources.getMembers(), (occSource, callback) -> {
            Set profs = occSource.get(OccSourceObj.PROP_PROFILE_DIST).getUnique(LinkedIdentityHashSet.class);
            List groupTemplates = occSource.get(OccSourceObj.PROP_GROUP_TEMPLATE_DIST).getUnique(ArrayList.class);
            for (OccGroupTypeObj groupType : groupTemplates) {
                if (!groupType.getProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES).booleanValue()) continue;
                Map<OccProfile, OccGroupTypeObj.GroupCreationDataObj> profData = groupType.getProperty(OccGroupTypeObj.PROP_PROFILE_DATA);
                profs.addAll(profData.keySet());
            }
            List behaviors = occSource.get(OccSourceObj.PROP_BEHAVIOR_DIST).getUnique(ArrayList.class);
            callback.addRefs(occSource, profs);
            callback.addRefs(occSource, behaviors);
            callback.addRef(occSource, occSource.getComponent());
        }, Behavior.class, OccProfile.class, IEgressConnector.class, IEgressOccupiable.class),
        OCC_PROFILES(OccProfile.class, md -> md.profiles.getMembers(), (prof, callback) -> {
            callback.addRef(prof, prof.getProperty(OccProfile.PROP_SHAPE).vehicleShape);
            Dependencies.addCompRestrRefs(prof, prof, callback);
            OccProfile.AttractorRestrictions ar = prof.getProperty(OccProfile.PROP_ATTRACTOR_RESTRICTIONS);
            ar.attractors.forEach(attr -> callback.addRef(prof, (IMerlinObj)attr));
        }, Dependencies.getCompRestrTypes(VehicleShape.class, Attractor.class)),
        CHANGE_PROFILE(ChangeProfile.class, md -> md.behaviors.flatten(ChangeProfile.class), (cb, callback) -> {
            IUrn<OccProfile> profiles = cb.get(ChangeProfile.PROP_PROFILE_DIST);
            if (profiles != null) {
                callback.addRefs(cb, profiles.getUnique());
            }
        }, OccProfile.class),
        CHANGE_BEHAVIOR(ChangeBehavior.class, md -> md.behaviors.flatten(ChangeBehavior.class), (cb, callback) -> {
            IUrn<Behavior> behaviors = cb.get(ChangeBehavior.PROP_BEHAVIOR_DIST);
            if (behaviors != null) {
                callback.addRefs(cb, behaviors.getUnique(LinkedIdentityHashSet.class));
            }
        }, Behavior.class),
        GOTO_EXITS(GotoExits.class, md -> md.behaviors.flatten(GotoExits.class), (ge, callback) -> callback.addRefs(ge, (Collection<? extends IMerlinObj>)ge.get(GotoExits.PROP_EXITS)), EgressDoor.class),
        GOTO_ELEVATORS(GotoElevators.class, md -> md.behaviors.flatten(GotoElevators.class), (ge, callback) -> callback.addRefs(ge, ge.getElevators()), Elevator.class),
        GOTO_ROOMS(GotoRooms.class, md -> md.behaviors.flatten(GotoRooms.class), (gr, callback) -> callback.addRefs(gr, gr.getRooms()), IEgressOccupiable.class),
        GOTO_OCC_TARGETS(GotoOccTarget.class, md -> md.behaviors.flatten(GotoOccTarget.class), (gol, callback) -> callback.addRefs(gol, (Collection<? extends IMerlinObj>)gol.get(GotoOccTarget.PROP_TARGETS)), OccTarget.class),
        GOTO_QUEUE(GotoQueue.class, md -> md.behaviors.flatten(GotoQueue.class), (gotoQ, callback) -> callback.addRefs(gotoQ, gotoQ.getDestinations()), QueueObject.class, QueueObjectComp.class),
        WAIT_FOR_ASSISTANCE(WaitForAssistance.class, md -> md.behaviors.flatten(WaitForAssistance.class), (wfa, callback) -> callback.addRefs(wfa, (Collection<? extends IMerlinObj>)wfa.get(WaitForAssistance.TEAMS)), AssistedEvacTeam.class),
        ASSIST_OCCUPANTS(AssistOccupants.class, md -> md.behaviors.flatten(AssistOccupants.class), (ao, callback) -> callback.addRef(ao, ao.get(AssistOccupants.TEAM)), AssistedEvacTeam.class),
        JOIN_OCCUPANT_GROUP(JoinOccGroup.class, md -> md.behaviors.flatten(JoinOccGroup.class), (jog, callback) -> callback.addRef(jog, jog.getGroup()), OccGroupObj.class),
        IMPORTED_GEOM(ImportedGeom.class, md -> md.sceneGeom.getMembers(), (ig, callback) -> {
            IPrimProps pprops;
            int numPrims = ig.getGeom().getNumPrims(7);
            IPropsSrc props = ig.getDisplayProps();
            for (int offset = 0; offset < numPrims && callback.addRef(ig, (Material)(pprops = props.get(offset)).getMaterial()); offset += props.getUniformCount(offset, numPrims - offset)) {
            }
        }, Material.class),
        AE_TEAMS(AssistedEvacTeam.class, md -> md.assistedEvacTeams.getMembers(), (team, callback) -> callback.addRefs(team, (Collection<? extends IMerlinObj>)team.getProperty(AssistedEvacTeam.PROP_OCC_ASSIST_ORDER)), EgressAgent.class),
        OCC_GROUP_TYPES(OccGroupTypeObj.class, md -> md.occGroupTypes.getMembers(), (group, callback) -> {
            if (group.getProperty(OccGroupTypeObj.PROP_SPECIFY_PROFILES).booleanValue()) {
                for (OccProfile prof : group.getProperty(OccGroupTypeObj.PROP_PROFILE_DATA).keySet()) {
                    callback.addRef(group, prof);
                }
            }
        }, Behavior.class),
        PROXIES(Proxy.class, md -> md.proxies.getAllProxies(), (proxy, callback) -> callback.addRef(proxy, (IMerlinObj)proxy.getObj()), ICompElement.class),
        ROOMS(EgressRoom.class, md -> md.floors.getMembers(), (room, callback) -> {
            IMaterial mat = room.getMaterial();
            callback.addRef(room, (Material)mat);
        }, Material.class),
        BLOCKAGE(EgressBlockage.class, md -> md.blockages.getMembers(), (blkg, callback) -> {
            IMaterial[] mats = blkg.getProp(MerlinData.MATERIAL).orElse(new IMaterial[0]);
            callback.addRefs(blkg, theUtil.map(Arrays.asList(mats), mat -> (Material)mat));
        }, Material.class),
        ELEVATOR_ROOMS(ElevatorRoom.class, md -> md.elevators.getMembers(), (room, callback) -> {
            IMaterial mat = room.getMaterial();
            callback.addRef(room, (Material)mat);
        }, Material.class),
        CORRIDORS(EgressCorridor.class, md -> md.floors.getMembers(), (corr, callback) -> {
            IMaterial mat = corr.getMaterial();
            callback.addRef(corr, (Material)mat);
        }, Material.class);

        public final Class<? extends IMerlinObj> srcType;
        public final GetDeps<IMerlinObj> getDeps;
        public final Function<MerlinData, Collection<? extends ICompElement>> getSources;
        public final Class<? extends IMerlinObj>[] targetTypes;

        private <SrcType extends IMerlinObj> ReferencingType(Class<SrcType> srcType, Function<MerlinData, Collection<? extends ICompElement>> getSources, GetDeps<SrcType> getDeps, Class<? extends IMerlinObj> ... targetTypes) {
            this.srcType = srcType;
            this.getDeps = (source, callback) -> getDeps.get(source, callback);
            this.getSources = getSources;
            this.targetTypes = targetTypes;
        }

        public boolean testTypes(Predicate<Class<? extends IMerlinObj>> test) {
            return Dependencies.testAny(test, this.targetTypes);
        }
    }

    public static enum Type {
        TYPE_ELEVATOR(Elevator.class),
        TYPE_ROOM(IEgressOccupiable.class),
        TYPE_PROFILE(OccProfile.class),
        TYPE_BEHAVIOR(Behavior.class),
        TYPE_MATERIAL(Material.class),
        TYPE_VEHICLE_SHAPE(VehicleShape.class),
        TYPE_AE_TEAM(AssistedEvacTeam.class),
        TYPE_DOOR(IEgressConnector.class),
        TYPE_AGENTS(EgressAgent.class),
        TYPE_QUEUE(QueueObject.class),
        TYPE_QUEUE_GROUP(QueueObjectComp.class),
        TYPE_ATTRACTOR(Attractor.class),
        TYPE_OCC_LOC(OccTarget.class);

        public final int flag = 1 << this.ordinal();
        public final Class<? extends IMerlinObj> mtype;

        private Type(Class<? extends IMerlinObj> mtype) {
            this.mtype = mtype;
        }
    }

    private static interface GetDeps<SrcType extends IMerlinObj> {
        public void get(SrcType var1, IGetDepsCallback var2);
    }

    private static interface IGetDepsCallback {
        public boolean addRef(IMerlinObj var1, IMerlinObj var2);

        default public boolean addRefs(IMerlinObj src, Collection<? extends IMerlinObj> targets) {
            for (IMerlinObj iMerlinObj : targets) {
                if (this.addRef(src, iMerlinObj)) continue;
                return false;
            }
            return true;
        }

        public <TargetT extends IMerlinObj> boolean addRefs(IMerlinObj var1, Class<TargetT> var2, Collection<? extends TargetT> var3);
    }

    private static class ClassTest<T>
    implements Predicate<Class<? extends T>> {
        private final Class<? extends T>[] types;

        public ClassTest(Class<? extends T> ... types) {
            this.types = types;
        }

        @Override
        public boolean test(Class<? extends T> t) {
            for (Class<T> clazz : this.types) {
                if (!clazz.isAssignableFrom(t) && !t.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }
    }
}

