/*
 * Decompiled with CFR 0.152.
 */
package merlin.treeview;

import java.awt.Component;
import java.util.Collections;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import merlin.treeview.Model;

public class CellRenderer
extends DefaultTreeCellRenderer {
    private static final long serialVersionUID = -4538221020893152290L;
    private final MerlinData d_data;

    public CellRenderer(MerlinData data) {
        this.d_data = data;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Component c = super.getTreeCellRendererComponent(tree, "", sel, expanded, leaf, row, hasFocus);
        Runnable redecorate = () -> {
            if (!tree.isDisplayable()) {
                return;
            }
            TreeModel model = tree.getModel();
            if (model instanceof Model) {
                Model m = (Model)model;
                m.fireDecorationChanged(Collections.singleton(value));
            }
            tree.repaint();
        };
        guiUtil.decorateCellRenderer(this.d_data, redecorate, value, this, sel, hasFocus);
        return c;
    }
}

