/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.tools;

import java.util.Collections;
import merlin.Intl;
import merlin.actions.AddObject;
import merlin.actions.SimpleOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.MerlinData;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.mv.ModelView;
import merlin.mv.tools.NewNavMeshRegionTool;
import merlin.util.MerlinProps;
import thunderheadeng.geometry.objs.node.IGeomNode;

public class NewBlockageTool
extends NewNavMeshRegionTool<MerlinProps> {
    public NewBlockageTool(ModelView mv, MerlinData data) {
        super(mv, data, Intl.intl("Obstacle"), Intl.intl("Click+drag to create an axis-aligned block obstacle or single-click multiple points to create a polygonal obstacle."), Intl.intl("Release to create an axis-aligned block obstacle."), Intl.intl("Continue left-clicking to add more points, or right-click to close the polygon and create the obstacle."), (props, shape) -> {
            SimpleOp op = new SimpleOp((app, md) -> {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    Undo.begin(Intl.intl("Add Obstacle"));
                    String blockageName = md.blockageNameGen.getCurrentName();
                    EgressBlockage blockage = new EgressBlockage(blockageName);
                    blockage.setSearchGeom((IGeomNode)shape);
                    AddObject.add(md, md.blockages, Collections.singleton(blockage));
                    md.blockageNameGen.nextName();
                    Undo.end(md);
                }
            });
            UIHook.run(null, "NewBlockageTool.finish", op, 4);
        });
    }
}

