/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.gui;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.MerlinData;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditCommand;
import merlin.manip.ATransformManip;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiIntField;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.util.IntVR;

public abstract class ATransformPanel<T extends ATransformManip>
extends APropEditPanel<T> {
    private static final long serialVersionUID = -7914506295464486913L;
    private final MerlinData d_data;
    private final ModePanel d_modePnl;
    private final CompletionPanel d_completionPanel;

    protected abstract String getXformName();

    public ATransformPanel(MerlinData data, int maxAllowableCopies) {
        super(new Object[0]);
        this.d_data = data;
        this.d_completionPanel = new CompletionPanel(this.getXformName());
        if (maxAllowableCopies > 0) {
            this.d_modePnl = new ModePanel(this.d_data, maxAllowableCopies);
            this.addSection(this.d_modePnl);
        } else {
            this.d_modePnl = null;
        }
    }

    protected void addCompletionPanel() {
        this.addSeparator();
        this.addSection(this.d_completionPanel);
    }

    private static class CompletionPanel
    extends APropEditPanel<ATransformManip> {
        private static final long serialVersionUID = 4870160017984996739L;
        private final JButton d_xformBtn;
        private final JButton d_cancelBtn;
        private final String d_baseXformName;

        public CompletionPanel(String xformName) {
            super(ATransformManip.CANCELLED, ATransformManip.OBJS_TRANSFORMED, ATransformManip.TRANSFORM_CHANGED, ATransformManip.COPY_MODE_CHANGED);
            this.d_baseXformName = xformName;
            this.d_xformBtn = this.initButton(new JButton(this.getCopyModeName()), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    ((ATransformManip)this.props()).transform(c, () -> {});
                }
            });
            this.d_cancelBtn = this.initButton(new JButton(Intl.intl("Cancel")), new IPropEditCommand(){

                @Override
                public void updateProp(Component c, boolean hardValidate) {
                    ((ATransformManip)this.props()).cancel();
                }
            });
            GridBagUtil.add(this, this.d_xformBtn, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_cancelBtn, 0, 1, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
            int btnHt = this.d_xformBtn.getPreferredSize().height;
            int maxWidth = Math.max(this.d_xformBtn.getPreferredSize().width, this.d_cancelBtn.getPreferredSize().width);
            Dimension size = new Dimension(maxWidth, btnHt);
            this.d_xformBtn.setPreferredSize(size);
            this.d_cancelBtn.setPreferredSize(size);
        }

        private String getCopyModeName() {
            return Intl.intl("Copy") + "/" + this.d_baseXformName;
        }

        @Override
        protected void updateFromProps(ATransformManip props) {
            this.d_xformBtn.setEnabled(props.isTransformValid());
            this.d_cancelBtn.setEnabled(true);
            String xformName = !props.getCopyMode() ? this.d_baseXformName : this.getCopyModeName();
            this.d_xformBtn.setText(xformName);
        }
    }

    private static class ModePanel
    extends APropEditPanel<ATransformManip> {
        private static final long serialVersionUID = 1942335034331146388L;
        private final guiRadioButton d_normalBtn = this.initButton(new guiRadioButton(Intl.intl("Normal Mode")), new IPropEditCommand[0]);
        private final guiRadioButton d_copyBtn = this.initButton(new guiRadioButton(Intl.intl("Copy Mode")), new IPropEditCommand[0]);
        private final guiIntField d_copiesFld;
        private final guiCheckBox d_randomizeCopiesCB;

        public ModePanel(MerlinData data, int maxCopies) {
            super(ATransformManip.COPY_MODE_CHANGED, ATransformManip.RANDOMIZE_COPIES, ATransformManip.CANCELLED, ATransformManip.OBJS_TRANSFORMED);
            this.d_copiesFld = this.initValueField(new guiIntField(IntVR.between(1, maxCopies, true, true)), new IPropEditCommand[0]);
            this.d_randomizeCopiesCB = this.initButton(new guiCheckBox(Intl.intl("Randomize parameters of object copies")), new IPropEditCommand[0]);
            this.d_randomizeCopiesCB.setToolTipText("<html>" + Intl.intl("Causes the copies of selected occupants to have randomized parameter values.<br>Copies of occupant sources will have randomized distributions of profiles, behaviors, and flowrates."));
            guiLabel copiesLbl = new guiLabel(Intl.intl("Copies") + ":");
            LinkStatus.link((AbstractButton)this.d_copyBtn, this.d_copiesFld, copiesLbl, this.d_randomizeCopiesCB);
            new guiButtonGroup(this.d_normalBtn, this.d_copyBtn);
            GridBagHelper gb = new GridBagHelper(this);
            gb.rowSpace = 1;
            gb.addRow(this.d_normalBtn, 0);
            if (maxCopies > 1) {
                gb.addRow(this.d_copyBtn, copiesLbl, this.d_copiesFld);
            } else {
                gb.addRow(this.d_copyBtn, 0);
            }
            gb.addIdentRow(this.d_randomizeCopiesCB, 0);
        }

        @Override
        protected void updateToProps(ATransformManip props) {
            props.pause();
            props.setNumCopies((Integer)this.d_copiesFld.getValue());
            props.setCopyMode(this.d_copyBtn.isSelected());
            props.setRandomizeCopies(this.d_randomizeCopiesCB.isSelected());
            props.resume();
        }

        @Override
        protected void updateFromProps(ATransformManip props) {
            if (props.getCopyMode()) {
                this.d_copyBtn.setSelected(true);
            } else {
                this.d_normalBtn.setSelected(true);
            }
            this.d_copiesFld.setValue(props.getNumCopies());
            this.d_randomizeCopiesCB.setEnabled(this.d_copyBtn.isSelected() && !MerlinUtil.flatten(props.getSelection(), ICompElement.class, MerlinUtil::canRandomize).isEmpty());
            this.d_randomizeCopiesCB.setSelected(props.getRandomizeCopies());
        }
    }
}

