/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.util.Collection;
import java.util.Set;
import java.util.function.Function;
import merlin.MerlinPrefs;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.material.Material;
import merlin.geom.IMerlinGeomSrc;
import merlin.mv.ModelView;
import merlin.mv.displays.AMerlinDispMgr;
import merlin.mv.displays.IMerlinDisplay;
import merlin.mv.displays.scenefinders.ISceneProvider;
import merlin.util.Dependencies;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.nativebuffered.GeomDisplay;
import thunderheadeng.scene3d.nativebuffered.INativeDisplayProps;
import thunderheadeng.scene3d.nativebuffered.PrimTransformAnim;
import thunderheadeng.scene3d.transformpreview.GeomDispTransformPreview;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class GeomDispMgr<T extends IMerlinGeomSrc>
extends AMerlinDispMgr<T, Display> {
    private final ModelView d_mv;

    public GeomDispMgr(MerlinData data, ModelView mv, Class<T> type, ISceneProvider<T> sceneFinder) {
        super(data, type, sceneFinder);
        this.d_mv = mv;
    }

    public ModelView getMV() {
        return this.d_mv;
    }

    @Override
    protected Display createDisplay(T obj, boolean visible, boolean selected) {
        Display disp = new Display(this.d_mv.getDisplayProps(), (IDisplayableGeomSrc)obj);
        disp.setVisible(visible);
        disp.setSelected(selected);
        return disp;
    }

    @Override
    public void update(Events events) {
        super.update(events);
        boolean updateAll = false;
        IEventRecord<MerlinData> mdevts = events.getEvents(MerlinData.class, new Class[0]);
        if (mdevts.containsChange(MerlinPrefs.DISPLAY_EDGE_ERROR) || mdevts.containsChange(MerlinPrefs.DISPLAY_FACE_ERROR)) {
            updateAll = true;
        }
        if (updateAll) {
            this.updateAll();
        } else {
            IEventRecord<Material> texEvts = events.getEvents(Material.class, new Class[0]);
            Set<Material> changedMats = texEvts.getChangedObjs(new Object[0]);
            if (!changedMats.isEmpty()) {
                LinkedIdentityHashSet referencingObjs = new LinkedIdentityHashSet();
                Dependencies.getObjReferences(changedMats, Material.class, Filters.accept(theUtil.filter(this.getObjs(), IMerlinObj.class)), (src, target) -> referencingObjs.add(src));
                this.updateDisplays(theUtil.filter(referencingObjs, this.getType(), this.getFilter()));
            }
        }
    }

    @Override
    public ITransformPreview getTransformPreview(IDisplayMgr<? super T> copyMgr, Collection<? extends T> objs, boolean copyMode) {
        if (!(copyMgr instanceof GeomDispMgr)) {
            return super.getTransformPreview(copyMgr, objs, copyMode);
        }
        return new GeomDispTransformPreview(this, (GeomDispMgr)copyMgr, objs, copyMode, new GeomDispTransformPreview.IAppHook<T, Display>(){

            @Override
            public void copyVis(IDisplayMgr<T> srcMgr, IDisplayMgr<T> destMgr, Collection<Pair<Display, Display>> displays) {
                for (Pair<Display, Display> entry : displays) {
                    ((Display)entry.v2).setVisible(((Display)entry.v1).isVisible());
                    ((Display)entry.v2).setSelected(((Display)entry.v1).isSelected());
                }
            }

            @Override
            public void hide(IDisplayMgr<T> mgr, Collection<? extends Display> cdisps) {
                for (Display display : cdisps) {
                    display.setVisible(false);
                    display.setSelected(false);
                }
            }

            @Override
            public Display getDisplay(IDisplayMgr<T> mgr, T obj) {
                return (Display)((GeomDispMgr)mgr).getDisplay(obj);
            }

            @Override
            public void setDispAnim(IDisplayMgr<T> mgr, Collection<? extends Display> displays, Function<Display, PrimTransformAnim> anims) {
                for (Display display : displays) {
                    display.setTransformAnim(anims.apply(display));
                }
            }

            @Override
            public void transformUpdated(IDisplayMgr<T> mgr) {
            }
        });
    }

    public static class Display
    extends GeomDisplay
    implements IMerlinDisplay {
        private static final long serialVersionUID = -6899524597127125577L;

        public Display(INativeDisplayProps dispProps, IDisplayableGeomSrc source) {
            super(dispProps, source, GeomDispTransformPreview.IDENTITY_ANIM);
        }
    }
}

