/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv.displays;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import merlin.builders.AgentDropper;
import merlin.data.egress.agents.OccProfile;
import merlin.geom.Geometry;
import merlin.mv.displays.AAgentDisplay;
import merlin.mv.displays.AgentDisplayType;
import merlin.mv.displays.AgentRenderer;
import merlin.mv.displays.IMerlinDisplay;
import merlin.mv.displays.IPropsDisplay;
import merlin.util.MerlinProps;
import thunderheadeng.io.nativexfer.ANativelyMirrored;

public class AgentDropperDisplay
implements Observer,
IPropsDisplay<AgentDropper> {
    private final MerlinProps.WeakRef<AgentDropper> d_dropper = new MerlinProps.WeakRef(this);
    private final Component d_surface;
    private final AgentRenderer d_renderer;
    private final List<Display> d_displays;
    private boolean d_added = false;

    public AgentDropperDisplay(Component surface, AgentRenderer ar) {
        this.d_surface = surface;
        this.d_displays = new ArrayList<Display>(AgentDisplayType.values().length);
        for (AgentDisplayType type : AgentDisplayType.values()) {
            this.d_displays.add(new Display(this.d_dropper, type));
        }
        this.d_renderer = ar;
    }

    public void addToScene() {
        if (!this.d_added) {
            this.d_added = true;
            this.d_renderer.addDisplays(this.d_displays);
        }
    }

    public void removeFromScene() {
        if (this.d_added) {
            this.d_renderer.removeDisplays(this.d_displays);
            this.d_added = false;
        }
    }

    @Override
    public IMerlinDisplay getDisplay() {
        return null;
    }

    @Override
    public void setProps(AgentDropper props) {
        this.d_dropper.set(props);
        this.update();
    }

    @Override
    public void update(Observable o, Object arg) {
        if (this.d_dropper.val().aPropChanged(AgentDropper.LOC_CHANGED, AgentDropper.PROFILE_CHANGED)) {
            this.pauseUpdates();
            this.setVisible(this.d_dropper.val().canCreate());
            this.update();
            this.resumeUpdates();
            this.d_surface.repaint();
        }
    }

    public Object getSelectionObj() {
        return null;
    }

    private void setVisible(boolean visible) {
        this.d_displays.forEach(d -> d.setVisible(visible));
    }

    private void pauseUpdates() {
        this.d_displays.forEach(ANativelyMirrored::pauseUpdates);
    }

    private void resumeUpdates() {
        this.d_displays.forEach(ANativelyMirrored::resumeUpdates);
    }

    public void update() {
        this.d_displays.forEach(AAgentDisplay::update);
        if (this.d_added) {
            this.d_renderer.agentsUpdated(this.d_displays, 1);
        }
    }

    private static class Display
    extends AAgentDisplay {
        private static final long serialVersionUID = -584873496083807112L;
        private final AgentDisplayType d_type;
        private final MerlinProps.WeakRef<AgentDropper> d_dropper;

        public Display(MerlinProps.WeakRef<AgentDropper> dropper, AgentDisplayType type) {
            this.d_type = type;
            this.d_dropper = dropper;
            this.setVisible(false);
            this.nativeConstructed(this.resolveNativeClass());
        }

        @Override
        protected AgentDisplayType getDisplayType() {
            return this.d_type;
        }

        @Override
        protected long getProfileSeed() {
            return !this.d_dropper.isNull() ? this.d_dropper.val().getProfileSeed() : 0L;
        }

        @Override
        public long getOrientSeed() {
            return this.getProfileSeed();
        }

        @Override
        protected Point3d getLocation() {
            return !this.d_dropper.isNull() ? this.d_dropper.val().getLocation().getPoint3dValue(Geometry.LENGTH_UNIT) : new Point3d();
        }

        @Override
        protected OccProfile getProfile() {
            return !this.d_dropper.isNull() ? this.d_dropper.val().getProfile() : null;
        }

        @Override
        protected boolean isTestAgent() {
            return true;
        }

        @Override
        public Point3f getColor() {
            if (!this.d_dropper.isNull()) {
                OccProfile prof = this.d_dropper.val().getProfile();
                return prof.getProperty(OccProfile.PROP_COLOR);
            }
            return new Point3f(0.0f, 0.0f, 0.0f);
        }

        @Override
        public Point3f getGroupColor() {
            return null;
        }

        @Override
        public Point3f getGroupTemplateColor() {
            return null;
        }

        @Override
        protected Point3f getBehaviorColor() {
            return !this.d_dropper.isNull() ? Display.toP3f(this.d_dropper.val().getBehavior().getColor()) : null;
        }

        private static Point3f toP3f(Color c) {
            float[] cc = new float[3];
            c.getColorComponents(cc);
            return new Point3f(cc);
        }
    }
}

