/*
 * Decompiled with CFR 0.152.
 */
package merlin.mv;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.EntryPointFactory;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinBoolAction;
import merlin.actions.AMerlinOp;
import merlin.actions.MerlinOp;
import merlin.actions.MerlinOpImpl;
import merlin.actions.SelectionObserver;
import merlin.actions.SimpleOp;
import merlin.actions.TransformAction;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.actions.UnitsAction;
import merlin.actions.importgeom.Import;
import merlin.builders.ABehaviorActionBuilder;
import merlin.builders.AQueueElementBuilder;
import merlin.builders.AbandonOccTargetActionBuilder;
import merlin.builders.AgentDropper;
import merlin.builders.AgentRegionDropper;
import merlin.builders.AssistedEvacActionBuilder;
import merlin.builders.AttractorBuilder;
import merlin.builders.ChangeBehaviorActionBuilder;
import merlin.builders.ChangeProfileActionBuilder;
import merlin.builders.CorridorBuilder;
import merlin.builders.DoorBuilder;
import merlin.builders.FloorExtractor3D;
import merlin.builders.GotoActionBuilder;
import merlin.builders.MeasurementRegionBuilder;
import merlin.builders.OccSourceBuilder;
import merlin.builders.OccTargetBuilder;
import merlin.builders.PlanarGeomBuilder;
import merlin.builders.PolyBuilder;
import merlin.builders.RampBuilder;
import merlin.builders.RectBuilder;
import merlin.builders.RoomGeomBuilder;
import merlin.builders.SimpleActionBuilder;
import merlin.builders.StairBuilder;
import merlin.builders.ToolNames;
import merlin.builders.WaitActionBuilder;
import merlin.builders.WaitUntilActionBuilder;
import merlin.builders.WallSubBuilder;
import merlin.builders.WorkingPlane;
import merlin.builders.queues.QueuePathBuilder;
import merlin.builders.queues.QueuePathNodeBuilder;
import merlin.builders.queues.QueueServiceBuilder;
import merlin.data.IMerlinObj;
import merlin.data.ImportedGeom;
import merlin.data.MeasurementRegionObj;
import merlin.data.MerlinData;
import merlin.data.OccSourceObj;
import merlin.data.ViewProps;
import merlin.data.camera.ICameraObj;
import merlin.data.egress.agents.EgressAgent;
import merlin.data.egress.agents.OccTarget;
import merlin.data.egress.blockages.EgressBlockage;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressConnector;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.RefugeFilter;
import merlin.data.egress.scripting.attractors.Attractor;
import merlin.data.egress.scripting.queues.IQueueElement;
import merlin.data.egress.scripting.queues.QueueObject;
import merlin.data.egress.scripting.queues.QueuePath;
import merlin.data.egress.scripting.queues.QueuePathNode;
import merlin.data.egress.scripting.queues.QueueService;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.geom.IMerlinGeomSrc;
import merlin.gui.APropEditPanel;
import merlin.gui.IPropEditor;
import merlin.gui.MerlinValueFields;
import merlin.gui.PropPanel;
import merlin.gui.guiUtil;
import merlin.manip.ATransformManip;
import merlin.manip.MirrorManip;
import merlin.manip.RotateManip;
import merlin.manip.TranslateManip;
import merlin.mv.MerlinColors;
import merlin.mv.Snappers.GridSnapper;
import merlin.mv.animate.session.MVAnimSession;
import merlin.mv.displays.AgentDispMgr;
import merlin.mv.displays.AgentDropperDisplay;
import merlin.mv.displays.AttractorBuilderDisplay;
import merlin.mv.displays.DoorBuilderDisplay;
import merlin.mv.displays.GlobalDisplayMgr;
import merlin.mv.displays.GotoBuilderDisplay;
import merlin.mv.displays.IMerlinDispMgr;
import merlin.mv.displays.IMerlinDisplay;
import merlin.mv.displays.IPropsDisplay;
import merlin.mv.displays.MerlinDispProps;
import merlin.mv.displays.NavMeshTriDispMgr;
import merlin.mv.displays.OccTargetBuilderDisplay;
import merlin.mv.displays.PlanarGeomBuilderDisplay;
import merlin.mv.displays.QueuePathBuilderDisplay;
import merlin.mv.displays.QueueServiceBuilderDisplay;
import merlin.mv.gui.FloorExtractor3DPanel;
import merlin.mv.gui.MirrorPanel;
import merlin.mv.gui.NewAgentPanel;
import merlin.mv.gui.NewAgentRegionPanel;
import merlin.mv.gui.NewAttractorPanel;
import merlin.mv.gui.NewDoorPanel;
import merlin.mv.gui.NewOccSourcePanel;
import merlin.mv.gui.NewOccTargetPanel;
import merlin.mv.gui.NewPolyPanel;
import merlin.mv.gui.NewRampPanel;
import merlin.mv.gui.NewRectPanel;
import merlin.mv.gui.NewStairPanel;
import merlin.mv.gui.NewWallPanel;
import merlin.mv.gui.RotatePanel;
import merlin.mv.gui.SelectionEditorPanel;
import merlin.mv.gui.TranslatePanel;
import merlin.mv.gui.behaviors.NewAbandonOccTargetsPnl;
import merlin.mv.gui.behaviors.NewAssistOccupantsPnl;
import merlin.mv.gui.behaviors.NewChangeBehaviorPnl;
import merlin.mv.gui.behaviors.NewChangeProfilePnl;
import merlin.mv.gui.behaviors.NewEmptyPnl;
import merlin.mv.gui.behaviors.NewGotoElevatorsPnl;
import merlin.mv.gui.behaviors.NewGotoExitsPnl;
import merlin.mv.gui.behaviors.NewGotoOccTargetPnl;
import merlin.mv.gui.behaviors.NewGotoQueuePnl;
import merlin.mv.gui.behaviors.NewGotoRoomsPnl;
import merlin.mv.gui.behaviors.NewGotoWaypointPnl;
import merlin.mv.gui.behaviors.NewWaitActionPnl;
import merlin.mv.gui.behaviors.NewWaitForAssistancePnl;
import merlin.mv.gui.behaviors.NewWaitUntilPnl;
import merlin.mv.gui.queues.NewQueuePathNodePnl;
import merlin.mv.gui.queues.NewQueuePathPnl;
import merlin.mv.gui.queues.NewQueueServicePnl;
import merlin.mv.manip.ManipHook;
import merlin.mv.tools.DeveloperTool;
import merlin.mv.tools.FloorExtractionTool;
import merlin.mv.tools.IPointPickListener;
import merlin.mv.tools.MeasureTool;
import merlin.mv.tools.Merlin3DSelector;
import merlin.mv.tools.MerlinPickRoot;
import merlin.mv.tools.MerlinTool;
import merlin.mv.tools.MirrorTool;
import merlin.mv.tools.NewAgentRegionTool;
import merlin.mv.tools.NewAgentTool;
import merlin.mv.tools.NewAttractorTool;
import merlin.mv.tools.NewBlockageTool;
import merlin.mv.tools.NewDoorTool;
import merlin.mv.tools.NewPolyTool;
import merlin.mv.tools.NewRampTool1Pt;
import merlin.mv.tools.NewRampTool2Pt;
import merlin.mv.tools.NewRectTool;
import merlin.mv.tools.NewSingleOccTargetTool;
import merlin.mv.tools.NewStairTool1Pt;
import merlin.mv.tools.NewStairTool2Pt;
import merlin.mv.tools.NewWallSubTool;
import merlin.mv.tools.OccSourceTool;
import merlin.mv.tools.PointPicker;
import merlin.mv.tools.RotateTool;
import merlin.mv.tools.ThinWallTool;
import merlin.mv.tools.TranslateTool;
import merlin.mv.tools.behaviors.BehaviorActionTool;
import merlin.mv.tools.behaviors.GotoElevatorsTool;
import merlin.mv.tools.behaviors.GotoExitsTool;
import merlin.mv.tools.behaviors.GotoOccTargetsTool;
import merlin.mv.tools.behaviors.GotoQueuesTool;
import merlin.mv.tools.behaviors.GotoRoomsTool;
import merlin.mv.tools.behaviors.GotoWaypointTool;
import merlin.mv.tools.queues.QueueElementTool;
import merlin.mv.tools.queues.QueuePathNodeTool;
import merlin.mv.tools.queues.QueuePathTool;
import merlin.mv.tools.queues.QueueServiceTool;
import merlin.unitsystem.UnitSystem;
import merlin.util.MerlinProps;
import merlin.util.MerlinUtil;
import merlin.util.OccSourceProps;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.animate.IAnimSession;
import thunderheadeng.animate.IAnimator;
import thunderheadeng.animate.TimeAnimator;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.gui.AbstractComponentListener;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.DecoratedIcon;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.SelectableAction;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.animate.IAnimView;
import thunderheadeng.gui.animate.StatusView;
import thunderheadeng.gui.animate.TimeView;
import thunderheadeng.gui.colorscheme.ColorChangedEvent;
import thunderheadeng.gui.colorscheme.ColorChangedListener;
import thunderheadeng.gui.colorscheme.ColorMgrMenu;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiInputDlg;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMenu;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiResponder;
import thunderheadeng.gui.guiStatusBar;
import thunderheadeng.gui.guiStatusMessage;
import thunderheadeng.gui.guiToolBar;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.IDeviceManager;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.io.nativexfer.Native;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.AxesScene;
import thunderheadeng.scene3d.nativebuffered.Camera;
import thunderheadeng.scene3d.nativebuffered.CameraRecord;
import thunderheadeng.scene3d.nativebuffered.GradientBG;
import thunderheadeng.scene3d.nativebuffered.GridSnapperDisp;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.scene3d.nativebuffered.ISceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.nativebuffered.OriginDisp;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.nativebuffered.OverlayLayout;
import thunderheadeng.scene3d.nativebuffered.PerspectiveCamera;
import thunderheadeng.scene3d.nativebuffered.RenderComponent;
import thunderheadeng.scene3d.nativebuffered.RenderFile;
import thunderheadeng.scene3d.nativebuffered.RenderPanel;
import thunderheadeng.scene3d.nativebuffered.SceneRenderOptions;
import thunderheadeng.scene3d.nativebuffered.SceneRenderer;
import thunderheadeng.scene3d.nativebuffered.SurfaceProps;
import thunderheadeng.scene3d.nativebuffered.View;
import thunderheadeng.scene3d.navtools.CompositeFunc;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.DragFunc;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.ManipFunc;
import thunderheadeng.scene3d.navtools.MultiFunc;
import thunderheadeng.scene3d.navtools.NavtoolUtil;
import thunderheadeng.scene3d.navtools.OrbitFunc;
import thunderheadeng.scene3d.navtools.RoamFunc;
import thunderheadeng.scene3d.navtools.SelectionFunc;
import thunderheadeng.scene3d.navtools.ZoomBoxFunc;
import thunderheadeng.scene3d.navtools.ZoomFunc;
import thunderheadeng.scene3d.picking.GeomPicker;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.BitOptions;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Global;
import thunderheadeng.util.IEventObserver;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;
import thunderheadeng.util.theUtil;

public class ModelView
implements ColorChangedListener,
IEventObserver,
IToolController {
    public static final Object EVT_RESET_CAMERAS = "ModelView.EVT_RESET_CAMERAS";
    public static final Object EVT_ANIMATION = "ModelView.EVT_ANIMATION";
    private final MerlinData d_data;
    private final JComponent d_panel;
    private final JMenu d_menu;
    private final AxesScene d_axes = new AxesScene();
    private final GradientBG d_background = new GradientBG(1, 0, 0.15f);
    private final SceneRenderer d_toolLayer = new SceneRenderer();
    private final RenderComponent d_renderComp;
    private final RenderFile d_renderFile;
    private final View d_mainView;
    private final OriginDisp d_origin = new OriginDisp();
    private final MerlinColors d_colors;
    private MerlinDispProps d_dispProps;
    private final BooleanAction d_realisticAction;
    private final BooleanAction d_realisticOutlinesAction;
    private final BooleanAction d_solidOutlinesAction;
    private final BooleanAction d_showGuidesAction;
    private final BooleanAction d_showPointerAction;
    private final BooleanAction d_wireframeAction;
    private final BooleanAction d_solidAction;
    private final FilterAction<IEgressComp> d_showNavGeomVisAction;
    private final BooleanAction d_showNavMeshTrisAction;
    private final List<FilterAction<?>> d_filterActions;
    private final List<ColorRoomsByAction> d_colorRoomsByActions;
    private final List<ColorOccTargetsByAction> d_colorOccTargetsByActions;
    private final List<BooleanAction> d_colorAgentsByActions;
    private final BooleanAction d_etMD5GenericAction;
    private final BooleanAction d_etMD5CasualAction;
    private final BooleanAction d_etMD5SimpleDisksAction;
    private final BooleanAction d_etMD5SimpleSpheresAction;
    private final BooleanAction d_etMD5SimpleCylAction;
    private final BooleanAction d_showSnapGridAction;
    private final BooleanAction d_showOriginAction;
    private final BooleanAction d_showStairDirArrowAction;
    private final BooleanAction d_showOnewayAction;
    private final BooleanAction d_showBlockageCadSearchAction;
    private final UIHook d_queueServiceUIHook;
    private final UIHook d_queuePathUIHook;
    private final UIHook d_queueNodeUIHook;
    private final JToolBar d_viewOptionsToolbar;
    private final JToolBar d_viewToolbar;
    private final JToolBar d_navToolbar;
    private final JToolBar d_creationToolbar;
    private final JToolBar d_editToolbar;
    private final JToolBar d_utilityToolbar;
    private final guiStatusMessage d_statusMessage;
    private final guiStatusBar d_statusBar;
    private final guiComboBox<Action> d_appearanceBox;
    private final SelectionFunc d_selFunc;
    private final ToolManager d_tools;
    private final CursorTool d_selectionTool3D;
    private final CursorTool d_selectionTool2D;
    private final CursorTool d_pointPickerTool;
    private final CursorTool d_compositeViewTool3d;
    private final CursorTool d_orbitTool;
    private final CursorTool d_modGameRoamTool;
    private final CursorTool d_dragTool;
    private final CursorTool d_zoomTool;
    private final CursorTool d_zoomBoxTool;
    private final FloorExtractionTool d_floorExtractTool;
    private final MeasureTool d_measureTool;
    private final DeveloperTool d_developerTool;
    private final NewRectTool<?> d_measurementRegionTool;
    private final OccSourceTool d_occSourceTool;
    private final ManipHook d_manipListener;
    private final GeomPicker d_manipSnapper;
    private final GeomPicker d_snapper;
    private final PropPanel d_toolPropsPanel;
    private final NewPolyTool d_openSpacePolyTool;
    private final NewRectTool<?> d_openSpaceRectTool;
    private final NewWallSubTool d_wallTool;
    private final ThinWallTool d_thinWallTool;
    private final NewStairTool2Pt d_stairTool2Pt;
    private final NewStairTool1Pt d_stairTool1Pt;
    private final NewRampTool2Pt d_rampTool2Pt;
    private final NewRampTool1Pt d_rampTool1Pt;
    private final NewAgentTool d_newAgentTool;
    private final NewAgentRegionTool d_newAgentRegionTool;
    private final NewDoorTool d_newDoorTool;
    private final NewBlockageTool d_newBlockageTool;
    private final NewAttractorTool d_newAttractorTool;
    private final NewSingleOccTargetTool d_newSingleOccTargetTool;
    private final TranslateTool d_translateTool;
    private final RotateTool d_rotateTool;
    private final MirrorTool d_mirrorTool;
    private final GridSnapper d_gridSnapper;
    private final GridSnapperDisp d_gridSnapperDisp;
    public static final int CAM_TOP = 0;
    public static final int CAM_FRONT = 1;
    public static final int CAM_LEFT = 2;
    public static final int CAM_PERSP = 3;
    private final Camera[] d_cameras = new Camera[4];
    private final Pair<Vector3d, Vector3d>[] d_camResetDirs = new Pair[4];
    private DrawMode d_drawMode;
    private final DrawMode d_drawMode3d;
    private final DrawMode d_drawMode2d;
    private final GlobalDisplayMgr d_dispMgr;
    private final GlobalDisplayMgr d_xformDispMgr;
    private final NavMeshTriDispMgr d_navMeshTris;
    private final SelectionEditorPanel d_selectionEditorPanel;
    private Optional<TimeAnimInfo> d_animInfo = Optional.empty();
    private final MVAnimSession d_animSession = new MVAnimSession();
    private JPanel d_middlePanel;
    private final UIHook d_snapGridHook = new UIHook((MerlinOp)new EditSketchGridSpacingOp(), Intl.intl("Edit Snap Grid..."), 4);
    public static final int ANIMOPT_REPEAT = 1;
    public static final int ANIMOPT_START_IMMEDIATELY = 2;
    public static final int ANIMOPT_CONTROL_TIME = 4;
    private final UIHook d_resetAllHook = new UIHook(new ResetToAllObjectsAction(), Intl.intl("Reset View to All Objects,R,Reset All,Reset view to all visible objects"), thunderheadeng.gui.guiUtil.loadTeciIcon("ZoomFit16.gif"), 1);
    private final UIHook d_resetToSelectedHook = new UIHook(new ResetToSelectedObjectsAction(), Intl.intl("Reset View to Selected Objects,E,Reset To Selection,Reset view to selected, visible objects"), guiUtil.loadMerlinIcon("ZoomSelectedObjs16.gif"), 1);
    private final UIHook d_fillViewHook = new UIHook(new FillViewAction(), Intl.intl("&Fill View,-,Fill view without resetting view angle"), guiUtil.loadMerlinIcon("fillview16.gif"), 1);
    private final Map<Runnable, SimpleOp> d_backgroundOps = Collections.synchronizedMap(new WeakHashMap());

    public ModelView(MerlinData data, MerlinColors colors) {
        final MerlinApp app = MerlinApp.getApp();
        this.d_data = data;
        this.d_colors = colors;
        this.upgradePrefs();
        this.d_dispMgr = new GlobalDisplayMgr(data, this);
        this.d_xformDispMgr = new GlobalDisplayMgr(data, this);
        SurfaceProps sprops = RenderPrefs.getDefaultSurfaceProps(MerlinPrefs.instance());
        this.d_renderComp = new RenderComponent(sprops);
        this.d_renderComp.getRootPanel().setOptions(this.d_renderComp.getRootPanel().getOptions() | RenderPanel.OPT_GAMMA_CORRECT);
        this.d_renderFile = new RenderFile(this.d_renderComp);
        this.d_mainView = new View((IRenderSurface)this.d_renderComp, this.d_dispMgr.mainScene.scene);
        this.d_dispProps = new MerlinDispProps(data, colors, this.d_dispMgr.getWireframeTester());
        this.d_navMeshTris = new NavMeshTriDispMgr(this.d_data, this.d_dispMgr.mainScene.scene);
        this.d_drawMode3d = new DrawMode();
        this.d_drawMode3d.props = new SceneRenderOptions();
        this.d_drawMode3d.props.setAutoClip(false);
        this.d_drawMode3d.props.setDrawWireframe(app.getPrefs().getBoolean(MerlinPrefs.DrawWireframeProp3d));
        this.d_drawMode3d.props.setShowMaterials(app.getPrefs().getBoolean(MerlinPrefs.ShowTexturesProp3d));
        this.d_drawMode3d.props.setDrawOutlines(app.getPrefs().getBoolean(MerlinPrefs.ShowOutlinesProp3d));
        this.d_drawMode3d.props.setLightModel(ISceneRenderOptions.LightModel.LOCAL_CAMERA);
        this.d_drawMode2d = new DrawMode();
        this.d_drawMode2d.props = new SceneRenderOptions();
        this.d_drawMode2d.props.setAutoClip(false);
        this.d_drawMode2d.props.setDrawWireframe(app.getPrefs().getBoolean(MerlinPrefs.DrawWireframeProp2d));
        this.d_drawMode2d.props.setShowMaterials(app.getPrefs().getBoolean(MerlinPrefs.ShowTexturesProp2d));
        this.d_drawMode2d.props.setDrawOutlines(app.getPrefs().getBoolean(MerlinPrefs.ShowOutlinesProp2d));
        this.d_drawMode2d.props.setLightModel(ISceneRenderOptions.LightModel.LOCAL_CAMERA);
        this.d_drawMode = this.d_drawMode3d;
        this.d_realisticAction = new ShowRealisticAction(false);
        this.d_realisticOutlinesAction = new ShowRealisticOutlinesAction(false);
        this.d_solidOutlinesAction = new ShowOutlinesAction(false);
        this.d_showGuidesAction = new ToolUpdateBoolAction(Intl.intl("Show Cursor Guides"), app.getPrefs().getBoolean(MerlinPrefs.ShowGuidesProp));
        this.d_showPointerAction = new ToolUpdateBoolAction(Intl.intl("Show System Mouse"), app.getPrefs().getBoolean(MerlinPrefs.ShowSystemMouseProp));
        this.d_showNavGeomVisAction = new FilterAction<IEgressComp>(Intl.intl("Show Navigation Geometry"), guiUtil.loadMerlinIcon("mesh16.png"), true, IEgressComp.class, Filters.alwaysFalse());
        this.d_filterActions = new ArrayList();
        this.d_filterActions.add(new FilterAction<ImportedGeom>(Intl.intl("Show Imported Geometry"), guiUtil.loadMerlinIcon("composite16.png"), true, ImportedGeom.class, new DescendentFilter(data, data.sceneGeom)));
        this.d_filterActions.add(new FilterAction<EgressAgent>(Intl.intl("Show Occupants"), guiUtil.loadMerlinIcon("occ_group16.png"), true, EgressAgent.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<IBehaviorAction>(Intl.intl("Show Behaviors"), guiUtil.loadMerlinIcon("script16.png"), true, IBehaviorAction.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<IQueueElement>(Intl.intl("Show Queues"), guiUtil.loadMerlinIcon("queue16.png"), true, IQueueElement.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<OccSourceObj>(Intl.intl("Show Occupant Sources"), guiUtil.loadMerlinIcon("occ_source_group16.png"), true, OccSourceObj.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<MeasurementRegionObj>(Intl.intl("Show Measurement Regions"), guiUtil.loadMerlinIcon("measure-area16.png"), true, MeasurementRegionObj.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<ICameraObj>(Intl.intl("Show View Objects"), guiUtil.loadMerlinIcon("cameras16.png"), true, ICameraObj.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<Attractor>(Intl.intl("Show Attractors"), EntryPointFactory.attractorIcon, true, Attractor.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<OccTarget>(Intl.intl("Show Occ Targets"), EntryPointFactory.occTargetIcon, true, OccTarget.class, Filters.alwaysFalse()));
        this.d_filterActions.add(new FilterAction<EgressBlockage>(Intl.intl("Show Obstacles"), EntryPointFactory.blockageIcon, true, EgressBlockage.class, Filters.alwaysFalse()));
        this.d_showNavMeshTrisAction = new DisplayVisToggleAction();
        this.d_wireframeAction = new UseWireframeAction(Intl.intl("Wireframe"), Intl.intl("Show geometry as outlines only"), false, "merlin/icons/wireframe.png", true);
        this.d_solidAction = new UseWireframeAction(Intl.intl("Solid"), Intl.intl("Show geometry as solids"), false, "merlin/icons/solid.png", false);
        this.d_colorRoomsByActions = new ArrayList<ColorRoomsByAction>();
        for (MerlinDispProps.ColorRoomsBy colorRoomsBy : MerlinDispProps.ColorRoomsBy.values()) {
            this.d_colorRoomsByActions.add(new ColorRoomsByAction(colorRoomsBy));
        }
        this.d_colorOccTargetsByActions = new ArrayList<ColorOccTargetsByAction>();
        for (Enum enum_ : MerlinDispProps.ColorOccTargetsBy.values()) {
            this.d_colorOccTargetsByActions.add(new ColorOccTargetsByAction((MerlinDispProps.ColorOccTargetsBy)enum_));
        }
        this.d_etMD5GenericAction = new SetEntityTypeAction(Intl.intl("Show as Generic"), false, 0);
        this.d_etMD5CasualAction = new SetEntityTypeAction(Intl.intl("Show as People"), false, 1);
        this.d_etMD5SimpleDisksAction = new SetEntityTypeAction(Intl.intl("Show as Disks"), false, 2);
        this.d_etMD5SimpleSpheresAction = new SetEntityTypeAction(Intl.intl("Show as Spheres"), false, 3);
        this.d_etMD5SimpleCylAction = new SetEntityTypeAction(Intl.intl("Show as Cylinders"), true, 4);
        this.d_colorAgentsByActions = new ArrayList<BooleanAction>();
        for (Enum enum_ : MerlinDispProps.ColorAgentsBy.values()) {
            this.d_colorAgentsByActions.add(new SetColorOccsByAction(((MerlinDispProps.ColorAgentsBy)enum_).desc, true, ((MerlinDispProps.ColorAgentsBy)enum_).prefId));
        }
        this.d_showSnapGridAction = new UpdateSnapGridAction(Intl.intl("Show Snap Grid"), true);
        this.d_showOriginAction = new UpdateSnapGridAction(Intl.intl("Show Origin"), true);
        this.d_showStairDirArrowAction = new CorrDrawOptionsAction(Intl.intl("Show Stair/Ramp Direction"), 2, true);
        this.d_showOnewayAction = new DoorDrawOptionsAction(Intl.intl("Show One-way Door Direction"), 1, true);
        this.d_showBlockageCadSearchAction = new BlockageDrawOptionsAction(Intl.intl("Show Imported Obstacle Search Area"), "<html>" + Intl.intl("For obstacles that are linked to imported geometry, this shows the search<br>volume that is intersected with the navigation mesh."), EnumSet.of(IMerlinDispProps.BlockageOptions.SHOW_CAD_SEARCH), false);
        this.d_statusBar = new guiStatusBar();
        this.d_statusMessage = new guiStatusMessage();
        this.d_statusBar.setStatusMessage(this.d_statusMessage);
        this.d_appearanceBox = new guiComboBox<Action>((T[])new Action[]{this.d_wireframeAction, this.d_solidAction, this.d_solidOutlinesAction, this.d_realisticAction, this.d_realisticOutlinesAction});
        this.d_appearanceBox.setToolTipText(Intl.intl("Change how geometry is rendered"));
        this.d_appearanceBox.addActionListener(e -> this.d_appearanceBox.getSelectedItem().actionPerformed(e));
        this.d_appearanceBox.setRenderer(new guiUtil.ActionCellRenderer());
        this.d_toolPropsPanel = new PropPanel();
        guiResponder responder = new guiResponder(this.d_renderComp);
        MerlinPickRoot pickRoot = new MerlinPickRoot(this.d_data, this, this.d_dispMgr.agentRenderer);
        this.d_snapper = new GeomPicker(pickRoot, this.d_mainView);
        this.d_manipSnapper = new GeomPicker(pickRoot, this.d_mainView);
        this.d_manipSnapper.setOcclusionFilteringEnabled(false);
        this.d_tools = new ToolManager(this.d_renderComp);
        this.d_measureTool = new MeasureTool(this);
        this.d_measureTool.setListener(new MeasureTool.IMeasureListener(){

            @Override
            public void measurementMade(UnitDouble length) {
                length = length.convert(app.getUnitSystem().getLength());
                String msg = String.format(Intl.intl("Total measurement = %s"), Global.format(length));
                JOptionPane.showMessageDialog(app.getMainFrame(), msg, Intl.intl("Measurement Result"), 1);
            }
        });
        this.addModalTool(this.d_measureTool, ToolNames.MEASURE, Intl.intl("Take a measurement"), guiUtil.loadMerlinIcon("ruler16.png"), new ToolPropsInfo(this.d_measureTool, null, this.d_measureTool.getDisplay()));
        this.d_developerTool = new DeveloperTool(this, this.d_data);
        this.d_tools.addTool(this.d_developerTool, "Dev", "Dev", null);
        this.d_thinWallTool = new ThinWallTool(this, this.d_data);
        this.addModalTool(this.d_thinWallTool, ToolNames.ADD_THIN_WALL, Intl.intl("Add a Thin Wall"), guiUtil.loadMerlinIcon("asplit16.png"), new ToolPropsInfo(this.d_thinWallTool, null, null));
        this.d_manipListener = new ManipHook(this.d_data, this, this.d_dispMgr, this.d_dispMgr.handleScene.scene);
        OrbitFunc orbitFunc = new OrbitFunc();
        DragFunc<CursorTool> dragFunc = new DragFunc<CursorTool>();
        ManipFunc manipFunc = new ManipFunc(this, this.d_manipListener.getManager(), this.d_manipSnapper, 10.0, UnitSystem.getType(0, true));
        this.d_selFunc = new SelectionFunc(this.d_snapper, new Merlin3DSelector(this.d_snapper));
        MultiFunc generalSelFunc3d = new MultiFunc(manipFunc, this.d_selFunc, orbitFunc, dragFunc);
        this.d_selectionTool3D = new CursorTool(this, generalSelFunc3d);
        this.d_tools.addTool(this.d_selectionTool3D, ToolNames.SELECT, Intl.intl("Select/Edit Objects"), thunderheadeng.gui.guiUtil.loadTeciIcon("pointer16.gif"));
        MultiFunc generalSelFunc2d = new MultiFunc(manipFunc, this.d_selFunc, dragFunc, dragFunc);
        this.d_selectionTool2D = new CursorTool(this, generalSelFunc2d);
        this.d_tools.addTool(this.d_selectionTool2D, ToolNames.SELECT, Intl.intl("Select/Edit Objects"), thunderheadeng.gui.guiUtil.loadTeciIcon("pointer16.gif"));
        PointPicker pointPickFunc = new PointPicker(this.d_data, this.d_renderComp);
        this.d_pointPickerTool = new CursorTool(this, NavtoolUtil.newPannableDrawTool(pointPickFunc));
        this.addModalTool(this.d_pointPickerTool, Intl.intl("Select Point"), Intl.intl("Select Point"), guiUtil.loadTeciIcon("pointer16.gif"), new ToolPropsInfo(this.d_pointPickerTool, null, null));
        this.d_orbitTool = new CursorTool(this, orbitFunc);
        this.d_tools.addTool(this.d_orbitTool, Intl.intl("Rotate"), Intl.intl("Rotate View"), OrbitFunc.ICON);
        this.d_modGameRoamTool = new CursorTool(this, new RoamFunc<CursorTool>(this.d_selFunc));
        this.d_tools.addTool(this.d_modGameRoamTool, ToolNames.ROAM, Intl.intl("Roam"), RoamFunc.ICON);
        this.d_dragTool = new CursorTool(this, dragFunc);
        this.d_tools.addTool(this.d_dragTool, ToolNames.PAN, Intl.intl("Pan View"), DragFunc.ICON);
        ZoomFunc zoomFunc = new ZoomFunc();
        this.d_zoomTool = new CursorTool(this, zoomFunc);
        this.d_tools.addTool(this.d_zoomTool, ToolNames.ZOOM, Intl.intl("Zoom"), ZoomFunc.ICON);
        ZoomBoxFunc zoomBoxFunc = new ZoomBoxFunc();
        this.d_zoomBoxTool = new CursorTool(this, zoomBoxFunc);
        this.d_tools.addTool(this.d_zoomBoxTool, ToolNames.ZOOM_BOX, Intl.intl("Zoom Box"), ZoomBoxFunc.ICON);
        this.d_compositeViewTool3d = new CursorTool(this, this.create3DCompositeTool());
        this.d_tools.addTool(this.d_compositeViewTool3d, ToolNames.ORBIT, Intl.intl("3D Orbit Navigation"), OrbitFunc.ICON);
        PlanarGeomBuilderDisplay d_planarGeomBuilderDisp = new PlanarGeomBuilderDisplay(this);
        GotoWaypointTool gotoWaypointTool = this.addBehaviorTool(Intl.intl("Goto Waypoint..."), Intl.intl("Occupants will go to a location in a room."), EntryPointFactory.gotoIcon, new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.WAYPOINT), new NewGotoWaypointPnl(), new GotoWaypointTool(this), new GotoBuilderDisplay(this));
        GotoElevatorsTool gotoElevatorsTool = this.addBehaviorTool(Intl.intl("Goto Elevators..."), Intl.intl("Occupants will use an elevator."), EntryPointFactory.elevatorIcon, new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.ELEVATORS), new NewGotoElevatorsPnl(), new GotoElevatorsTool(this));
        GotoRoomsTool gotoRoomsTool = this.addBehaviorTool(Intl.intl("Goto Rooms..."), Intl.intl("Occupants will go to a room."), guiUtil.loadMerlinIcon("openrect16.png"), new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.ROOMS, Predicates.alwaysTrue()), new NewGotoRoomsPnl(Intl.intl("Rooms:")), new GotoRoomsTool(this, Predicates.alwaysTrue()));
        GotoOccTargetsTool gotoOccTargetsTool = this.addBehaviorTool(Intl.intl("Goto Occupant Targets..."), Intl.intl("Occupants will go to a pre-defined occupant target."), EntryPointFactory.gotoOccTargetIcon, new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.OCC_TARGETS, Predicates.alwaysTrue()), new NewGotoOccTargetPnl(), new GotoOccTargetsTool(this, Predicates.alwaysTrue()));
        GotoQueuesTool gotoQueueTool = this.addBehaviorTool(Intl.intl("Goto Queues..."), Intl.intl("Occupants will wait at the assigned queue."), EntryPointFactory.queueIcon, new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.QUEUES), new NewGotoQueuePnl(), new GotoQueuesTool(this));
        BehaviorActionTool waitActionTool = this.addBehaviorTool(Intl.intl("Wait..."), Intl.intl("Occupants will wait for an amount of time."), EntryPointFactory.waitIcon, new WaitActionBuilder(this.d_data), new NewWaitActionPnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool waitUntilTool = this.addBehaviorTool(Intl.intl("Wait Until..."), Intl.intl("Occupants will wait until a specified time."), EntryPointFactory.waitIcon, new WaitUntilActionBuilder(this.d_data), new NewWaitUntilPnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool waitAssistTool = this.addBehaviorTool(Intl.intl("Wait For Assistance..."), Intl.intl("Occupants will wait until others start assisting them."), EntryPointFactory.waitForAssistanceIcon, new AssistedEvacActionBuilder(data, AssistedEvacActionBuilder.Type.WAIT_FOR_ASSISTANCE), new NewWaitForAssistancePnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool abandonOccTargetsTool = this.addBehaviorTool(Intl.intl("Abandon Occ Targets"), Intl.intl("Abandons all previously-reserved occupant targets"), EntryPointFactory.abandonOccTargetsIcon, new AbandonOccTargetActionBuilder(this.d_data), new NewAbandonOccTargetsPnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool assistTool = this.addBehaviorTool(Intl.intl("Assist Occupants..."), Intl.intl("Occupants will assist others."), EntryPointFactory.assistIcon, new AssistedEvacActionBuilder(data, AssistedEvacActionBuilder.Type.ASSIST), new NewAssistOccupantsPnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool detachAssistantsTool = this.addBehaviorTool(Intl.intl("Detach from Assistants..."), Intl.intl("Occupants being assisted will detach from those assisting them."), EntryPointFactory.detachIcon, new AssistedEvacActionBuilder(data, AssistedEvacActionBuilder.Type.DETACH_ASSISTANTS), new NewEmptyPnl(), this.newHiddenBehaviorTool());
        NewChangeBehaviorPnl changeBehaviorPnl = new NewChangeBehaviorPnl(data);
        BehaviorActionTool changeBehaviorTool = this.addBehaviorTool(Intl.intl("Change Behavior..."), Intl.intl("Occupants will change their behavior."), EntryPointFactory.behaviorIcon, new ChangeBehaviorActionBuilder(data, changeBehaviorPnl), changeBehaviorPnl, this.newHiddenBehaviorTool());
        NewChangeProfilePnl changeProfilePnl = new NewChangeProfilePnl(data);
        BehaviorActionTool changeProfileTool = null;
        changeProfileTool = this.addBehaviorTool(Intl.intl("Change Profile..."), Intl.intl("Occupants will change their profile."), EntryPointFactory.occupantProfileIcon, new ChangeProfileActionBuilder(data, changeProfilePnl), changeProfilePnl, this.newHiddenBehaviorTool());
        BehaviorActionTool resumePriorTool = this.addBehaviorTool(Intl.intl("Resume Prior Behavior"), Intl.intl("Resumes the prior behavior if this behavior was started by a Change Behavior action."), EntryPointFactory.resumePriorIcon, new SimpleActionBuilder(this.d_data, SimpleActionBuilder.Type.RESUME_PRIOR), new NewEmptyPnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool removeOccTool = this.addBehaviorTool(Intl.intl("Remove Occupant"), Intl.intl("Removes the occupant performing the behavior from the simulation."), EntryPointFactory.removeOccIcon, new SimpleActionBuilder(this.d_data, SimpleActionBuilder.Type.REMOVE_OCC), new NewEmptyPnl(), this.newHiddenBehaviorTool());
        BehaviorActionTool waitUntilEndTool = this.addBehaviorTool(Intl.intl("Wait Until Simulation End"), Intl.intl("The occupant will wait until all other occupants have finished or are also waiting until the end."), EntryPointFactory.waitUntilEndIcon, new SimpleActionBuilder(this.d_data, SimpleActionBuilder.Type.WAIT_UNTIL_END), new NewEmptyPnl(), this.newHiddenBehaviorTool());
        GotoRoomsTool gotoRefugeRoomsTool = this.addBehaviorTool(Intl.intl("Goto Refuge Rooms..."), Intl.intl("Occupants will go to a refuge room and wait until all others leave."), EntryPointFactory.refugeRoomIcon, new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.ROOMS, RefugeFilter.INSTANCE), new NewGotoRoomsPnl(Intl.intl("Refuge Rooms:")), new GotoRoomsTool(this, RefugeFilter.INSTANCE));
        GotoExitsTool gotoExitsTool = this.addBehaviorTool(Intl.intl("Goto Exits..."), Intl.intl("Occupants will leave the simulation through an exit."), EntryPointFactory.exitIcon, new GotoActionBuilder(this.d_data, GotoActionBuilder.Type.EXITS), new NewGotoExitsPnl(), new GotoExitsTool(this));
        BiFunction<BehaviorActionTool, Boolean, guiAction> baction = (btool, terminal) -> {
            SelPanelToolAction a = new SelPanelToolAction(this.d_tools.getToolAction((Tool)btool));
            a.set(SelectionEditorPanel.PROP_BEHAVIOR_ACTION_TERMINAL, terminal);
            return a;
        };
        guiAction[] behaviorActions = new guiAction[]{baction.apply(gotoWaypointTool, false), baction.apply(gotoRoomsTool, false), baction.apply(gotoElevatorsTool, false), baction.apply(gotoQueueTool, false), baction.apply(gotoOccTargetsTool, false), baction.apply(abandonOccTargetsTool, false), baction.apply(waitActionTool, false), baction.apply(waitUntilTool, false), baction.apply(changeBehaviorTool, false), baction.apply(changeProfileTool, false), baction.apply(assistTool, false), baction.apply(waitAssistTool, false), baction.apply(detachAssistantsTool, false), null, baction.apply(resumePriorTool, true), baction.apply(removeOccTool, true), baction.apply(waitUntilEndTool, true), baction.apply(gotoRefugeRoomsTool, true), baction.apply(gotoExitsTool, true)};
        QueueServiceTool addQueueService = this.addQueueTool(Intl.intl("Queue Service..."), Intl.intl("Add a processing point for a queue."), "service16.png", new QueueServiceBuilder(data), new NewQueueServicePnl(), new QueueServiceTool(this), new QueueServiceBuilderDisplay(this));
        QueuePathTool addQueuePath = this.addQueueTool(Intl.intl("Queue Path..."), Intl.intl("Add a directed path for a queue."), "path16.png", new QueuePathBuilder(data), new NewQueuePathPnl(), new QueuePathTool(this), new QueuePathBuilderDisplay(this));
        QueuePathNodeTool addQueueNode = this.addQueueTool(Intl.intl("Queue Path Node..."), Intl.intl("Add a point along a directed path."), "Node16.png", new QueuePathNodeBuilder(data), new NewQueuePathNodePnl(), new QueuePathNodeTool(this));
        this.d_queueServiceUIHook = new UIHook(new AddQueueElementAction(addQueueService), Intl.intl("Add Queue Service..."));
        this.d_queuePathUIHook = new UIHook(new AddQueueElementAction(addQueuePath), Intl.intl("Add Queue Path..."));
        this.d_queueNodeUIHook = new UIHook(new AddQueueNodeAction(addQueueNode), Intl.intl("Add Queue Path Node..."));
        guiAction[] queueActions = new guiAction[]{new SelPanelToolAction(this.d_tools.getToolAction(addQueueService)), new SelPanelToolAction(this.d_tools.getToolAction(addQueuePath)), new SelPanelToolAction(this.d_tools.getToolAction(addQueueNode))};
        this.d_selectionEditorPanel = new SelectionEditorPanel(this.d_data, behaviorActions, queueActions);
        this.d_toolPropsPanel.addEditor(this.d_selectionEditorPanel);
        WorkingPlane workingPlane = new WorkingPlane(this.d_data);
        TranslateManip transManip = new TranslateManip(this, this.d_dispMgr, this.d_xformDispMgr);
        this.d_translateTool = new TranslateTool(this.d_data, this, transManip, this.d_dispMgr.toolScene.scene, this.d_dispProps);
        TranslatePanel transPnl = new TranslatePanel(this.d_data);
        this.addModalTool(this.d_translateTool, ToolNames.MOVE, Intl.intl("Copy/Move Objects"), guiUtil.loadMerlinIcon("moveObj16.gif"), new MerlinToolPropsInfo(this, this.d_dispMgr.toolScene.scene, null, (APropEditPanel)transPnl, null, (MerlinProps)transManip, false));
        RotateManip rotManip = new RotateManip(this.d_data, this, this.d_dispMgr, this.d_xformDispMgr);
        this.d_rotateTool = new RotateTool(this.d_data, this, rotManip, this.d_dispMgr.toolScene.scene, this.d_dispProps);
        RotatePanel rotPnl = new RotatePanel(this.d_data);
        this.addModalTool(this.d_rotateTool, ToolNames.ROTATE, Intl.intl("Rotate Objects"), guiUtil.loadMerlinIcon("rotateObj16.gif"), new MerlinToolPropsInfo(this, this.d_dispMgr.toolScene.scene, null, (APropEditPanel)rotPnl, null, (MerlinProps)rotManip, false));
        MirrorManip mirrorManip = new MirrorManip(this, this.d_dispMgr, this.d_xformDispMgr);
        this.d_mirrorTool = new MirrorTool(this.d_data, this, mirrorManip, this.d_dispMgr.toolScene.scene, this.d_dispProps);
        MirrorPanel mirrorPnl = new MirrorPanel(this.d_data);
        this.addModalTool(this.d_mirrorTool, ToolNames.MIRROR, Intl.intl("Mirror Objects"), guiUtil.loadMerlinIcon("mirror16.png"), new MerlinToolPropsInfo(this, this.d_dispMgr.toolScene.scene, null, (APropEditPanel)mirrorPnl, null, (MerlinProps)mirrorManip, false));
        PolyBuilder geomPolyAdder = new PolyBuilder(this.d_data, workingPlane, new RoomGeomBuilder(RoomGeomBuilder.BooleanOp.ADD, responder));
        NewPolyPanel geomPolyPanel = new NewPolyPanel(this.d_data, 9);
        this.d_openSpacePolyTool = new NewPolyTool(this);
        this.addModalTool(this.d_openSpacePolyTool, ToolNames.NEW_POLY_ROOM, Intl.intl("Add a Polygonal Room"), guiUtil.loadMerlinIcon("openpoly16.png"), new GeomToolPropsInfo(this, (MerlinTool)this.d_openSpacePolyTool, (APropEditPanel)geomPolyPanel, (IPropsDisplay)d_planarGeomBuilderDisp, (PlanarGeomBuilder)geomPolyAdder));
        RectBuilder geomRectAdder = new RectBuilder(this.d_data, workingPlane, new RoomGeomBuilder(RoomGeomBuilder.BooleanOp.ADD, responder));
        NewRectPanel geomRectPanel = new NewRectPanel(this.d_data, new guiPanel[0]);
        this.d_openSpaceRectTool = new NewRectTool(this);
        this.addModalTool(this.d_openSpaceRectTool, ToolNames.NEW_RECT_ROOM, Intl.intl("Add a Rectangular Room"), guiUtil.loadMerlinIcon("openrect16.png"), new GeomToolPropsInfo(this, this.d_openSpaceRectTool, (APropEditPanel)geomRectPanel, (IPropsDisplay)d_planarGeomBuilderDisp, (PlanarGeomBuilder)geomRectAdder));
        MeasurementRegionBuilder vdBuilder = new MeasurementRegionBuilder();
        RectBuilder rectBuilder = new RectBuilder(this.d_data, workingPlane, vdBuilder);
        NewRectPanel rectPanel = new NewRectPanel(this.d_data, new guiPanel[0]);
        this.d_measurementRegionTool = new NewRectTool(this);
        this.addModalTool(this.d_measurementRegionTool, ToolNames.DRAW_MEASURE_REGION, Intl.intl("Add a Measurement Region"), guiUtil.loadMerlinIcon("measure-area16.png"), new GeomToolPropsInfo(this, this.d_measurementRegionTool, (APropEditPanel)rectPanel, (IPropsDisplay)d_planarGeomBuilderDisp, (PlanarGeomBuilder)rectBuilder));
        OccSourceBuilder osBuilder = new OccSourceBuilder();
        OccSourceProps occSourceProps = new OccSourceProps(this.d_data, workingPlane, osBuilder);
        NewOccSourcePanel occSourcePanel = new NewOccSourcePanel(data);
        this.d_occSourceTool = new OccSourceTool(this);
        this.addModalTool(this.d_occSourceTool, ToolNames.DRAW_OCCUPANT_SOURCE, Intl.intl("Add an Occupant Source"), guiUtil.loadMerlinIcon("occ_source_group16.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_occSourceTool, (APropEditPanel)occSourcePanel, (IPropsDisplay)d_planarGeomBuilderDisp, (MerlinProps)occSourceProps));
        WallSubBuilder d_wallBuilder = new WallSubBuilder(this.d_data, responder, workingPlane);
        NewWallPanel d_wallPanel = new NewWallPanel(this.d_data);
        this.d_wallTool = new NewWallSubTool(this);
        this.addModalTool(this.d_wallTool, ToolNames.ADD_THICK_WALL, Intl.intl("Add a Thick Wall"), guiUtil.loadMerlinIcon("block16.gif"), new GeomToolPropsInfo(this, (MerlinTool)this.d_wallTool, (APropEditPanel)d_wallPanel, (IPropsDisplay)d_planarGeomBuilderDisp, (PlanarGeomBuilder)d_wallBuilder));
        this.d_stairTool2Pt = new NewStairTool2Pt(this);
        StairBuilder tpBuilder = new StairBuilder(this.d_data, CorridorBuilder.Mode.TWO_POINT);
        NewStairPanel stair2pPanel = new NewStairPanel(CorridorBuilder.Mode.TWO_POINT);
        this.addModalTool(this.d_stairTool2Pt, ToolNames.NEW_TWO_CLICK_STAIR, Intl.intl("Create stairs between two edges by choosing a point on each"), guiUtil.loadMerlinIcon("astairs216.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_stairTool2Pt, (APropEditPanel)stair2pPanel, null, (MerlinProps)tpBuilder));
        this.d_stairTool1Pt = new NewStairTool1Pt(this);
        StairBuilder opBuilder = new StairBuilder(this.d_data, CorridorBuilder.Mode.ONE_POINT);
        NewStairPanel stairPanel = new NewStairPanel(CorridorBuilder.Mode.ONE_POINT);
        this.addModalTool(this.d_stairTool1Pt, ToolNames.NEW_ONE_CLICK_STAIR, Intl.intl("Create stairs by choosing one point on an edge"), guiUtil.loadMerlinIcon("astairs116.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_stairTool1Pt, (APropEditPanel)stairPanel, null, (MerlinProps)opBuilder));
        this.d_rampTool2Pt = new NewRampTool2Pt(this);
        RampBuilder r2Builder = new RampBuilder(this.d_data, CorridorBuilder.Mode.TWO_POINT);
        NewRampPanel ramp2pPanel = new NewRampPanel(CorridorBuilder.Mode.TWO_POINT);
        this.addModalTool(this.d_rampTool2Pt, ToolNames.NEW_TWO_CLICK_RAMP, Intl.intl("Create ramp between two edges by choosing a point on each"), guiUtil.loadMerlinIcon("aramp216.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_rampTool2Pt, (APropEditPanel)ramp2pPanel, null, (MerlinProps)r2Builder));
        this.d_rampTool1Pt = new NewRampTool1Pt(this);
        RampBuilder r1Builder = new RampBuilder(this.d_data, CorridorBuilder.Mode.ONE_POINT);
        NewRampPanel rampPanel = new NewRampPanel(CorridorBuilder.Mode.ONE_POINT);
        this.addModalTool(this.d_rampTool1Pt, ToolNames.NEW_ONE_CLICK_RAMP, Intl.intl("Create a ramp by choosing one point on an edge"), guiUtil.loadMerlinIcon("aramp116.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_rampTool1Pt, (APropEditPanel)rampPanel, null, (MerlinProps)r1Builder));
        this.d_newAttractorTool = new NewAttractorTool(this);
        AttractorBuilder attrBuilder = new AttractorBuilder(this.d_data);
        NewAttractorPanel attrPanel = new NewAttractorPanel(this.d_data);
        this.addModalTool(this.d_newAttractorTool, ToolNames.ADD_ATTRACTOR, Intl.intl("Add an attractor"), EntryPointFactory.attractorIcon, new MerlinToolPropsInfo(this, this.d_dispMgr.attractorScene.scene, (MerlinTool)this.d_newAttractorTool, (APropEditPanel)attrPanel, (IPropsDisplay)new AttractorBuilderDisplay(this), (MerlinProps)attrBuilder, true));
        this.d_newSingleOccTargetTool = new NewSingleOccTargetTool(this);
        OccTargetBuilder occTargetBuilder = new OccTargetBuilder(this.d_data);
        NewOccTargetPanel occTargetPanel = new NewOccTargetPanel(this.d_data);
        this.addModalTool(this.d_newSingleOccTargetTool, ToolNames.ADD_SINGLE_OCC_LOC, Intl.intl("Add an Occupant Target"), EntryPointFactory.occTargetIcon, new MerlinToolPropsInfo(this, this.d_dispMgr.occTargetScene.scene, (MerlinTool)this.d_newSingleOccTargetTool, (APropEditPanel)occTargetPanel, (IPropsDisplay)new OccTargetBuilderDisplay(this), (MerlinProps)occTargetBuilder, true));
        final AgentDropperDisplay agentDropperDisp = new AgentDropperDisplay(this.d_renderComp, this.d_dispMgr.agentRenderer);
        this.d_newAgentTool = new NewAgentTool(this);
        AgentDropper d_agentDropper = new AgentDropper(this.d_data);
        NewAgentPanel d_newAgentPanel = new NewAgentPanel(this.d_data);
        MerlinToolPropsInfo<AgentDropper> agentDropperProps = new MerlinToolPropsInfo<AgentDropper>((MerlinTool)this.d_newAgentTool, (APropEditPanel)d_newAgentPanel, (IPropsDisplay)agentDropperDisp, d_agentDropper){

            @Override
            public void activate() {
                super.activate();
                agentDropperDisp.addToScene();
            }

            @Override
            public void deactivate() {
                agentDropperDisp.removeFromScene();
                super.deactivate();
            }
        };
        this.addModalTool(this.d_newAgentTool, ToolNames.DRAW_OCCUPANT, Intl.intl("Add an Occupant"), guiUtil.loadMerlinIcon("occupant16.png"), agentDropperProps);
        this.d_newAgentRegionTool = new NewAgentRegionTool(this, this.d_data);
        AgentRegionDropper d_agentRectDropper = new AgentRegionDropper(this.d_data, this.d_newAgentRegionTool);
        NewAgentRegionPanel d_newAgentRectPanel = new NewAgentRegionPanel(this.d_data);
        this.addModalTool(this.d_newAgentRegionTool, ToolNames.DRAW_OCCUPANT_GROUP, Intl.intl("Add Occupants to a Region"), guiUtil.loadMerlinIcon("occ_group16.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_newAgentRegionTool, (APropEditPanel)d_newAgentRectPanel, null, (MerlinProps)d_agentRectDropper));
        DoorBuilder doorBuilder = new DoorBuilder(this.d_data);
        DoorBuilderDisplay doorBuilderDisp = new DoorBuilderDisplay(this);
        this.d_newDoorTool = new NewDoorTool(this);
        this.addModalTool(this.d_newDoorTool, ToolNames.DRAW_DOOR, Intl.intl("Add a New Door"), guiUtil.loadMerlinIcon("adoor16.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_newDoorTool, (APropEditPanel)new NewDoorPanel(), (IPropsDisplay)doorBuilderDisp, (MerlinProps)doorBuilder));
        this.d_newBlockageTool = new NewBlockageTool(this, this.d_data);
        this.addModalTool(this.d_newBlockageTool, ToolNames.ADD_BLOCKAGE, Intl.intl("Add an Obstacle"), guiUtil.loadMerlinIcon("blockage.png"), new ToolPropsInfo(this.d_newBlockageTool, null, null));
        FloorExtractor3D floorExtractor = new FloorExtractor3D();
        this.d_floorExtractTool = new FloorExtractionTool(this);
        FloorExtractor3DPanel floorExtPnl = new FloorExtractor3DPanel();
        this.addModalTool(this.d_floorExtractTool, ToolNames.EXTRACT_ROOM, Intl.intl("Extract Room from Imported Geometry"), guiUtil.loadMerlinIcon("extract16.png"), new MerlinToolPropsInfo(this, (MerlinTool)this.d_floorExtractTool, (APropEditPanel)floorExtPnl, null, (MerlinProps)floorExtractor));
        this.d_tools.addToolChangeListener(new ToolManager.ToolChangeListener(){

            @Override
            public void toolWillChanged(Tool oldTool, Tool newTool) {
                Object meta;
                ModelView.this.updateCurrentTool(oldTool, newTool);
                if (oldTool != null && (meta = ModelView.this.d_tools.getProps((Tool)oldTool).meta) instanceof ToolPropsInfo) {
                    ((ToolPropsInfo)meta).deactivate();
                }
                if (newTool != null) {
                    meta = ModelView.this.d_tools.getProps((Tool)newTool).meta;
                    if (meta instanceof ToolPropsInfo) {
                        ToolPropsInfo propsInfo = (ToolPropsInfo)meta;
                        propsInfo.activate();
                        if (propsInfo.d_clearSelOnActivate) {
                            AMerlinOp op = new AMerlinOp(){

                                @Override
                                public void run(MerlinApp app, MerlinData md) {
                                    md.beginWrite();
                                    try {
                                        md.selection.clear();
                                    }
                                    finally {
                                        md.endWrite();
                                    }
                                }
                            };
                            UIHook.run(null, "ModelView.ToolChangeListener.toolWillChanged", op, 4);
                        }
                    } else {
                        ModelView.this.d_toolPropsPanel.setEditor(ModelView.this.d_selectionEditorPanel);
                    }
                }
            }
        });
        this.initPredefCameras();
        this.d_gridSnapper = new GridSnapper(new UnitDouble(0.5, SI.METER));
        this.d_gridSnapperDisp = new GridSnapperDisp(0.0);
        this.d_gridSnapper.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ModelView.this.d_gridSnapperDisp.setSpacing(ModelView.this.d_gridSnapper.getSpacing().getValue(Geometry.LENGTH_UNIT));
            }
        });
        this.updateGridSnapperDisplay();
        this.d_viewToolbar = this.createViewToolbar();
        this.d_viewOptionsToolbar = this.createViewOptionsToolbar();
        this.d_navToolbar = this.createNavToolbar();
        this.d_creationToolbar = this.createCreationToolbar();
        this.d_editToolbar = this.createEditToolbar();
        this.d_utilityToolbar = this.createUtilityToolBar();
        this.d_panel = this.createMainPanel();
        this.d_menu = this.createMainMenu();
        this.d_drawMode2d.currentTool = this.d_selectionTool2D;
        this.d_drawMode3d.currentTool = this.d_selectionTool3D;
        this.d_drawMode = this.d_drawMode3d;
        this.updateColors(null);
        this.setMainCamera(this.d_cameras[3]);
        this.d_tools.setCurrentTool(this.d_drawMode.currentTool);
        this.updateDrawProps();
        this.updatePrefs();
        this.d_renderComp.addComponentListener(new AbstractComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ModelView.this.d_renderComp.removeComponentListener(this);
                ModelView.this.resetCameras(ModelView.this.d_cameras);
                ModelView.this.d_renderComp.repaint();
            }
        });
        this.d_colors.addColorChangedListener(this);
        this.applyPrefs();
        int colorBy = app.getPrefs().getInt(MerlinPrefs.ColorRoomsByProp);
        Stream.of(MerlinDispProps.ColorRoomsBy.values()).filter(cb -> cb.prefId == colorBy).findFirst().ifPresent(cb -> this.d_dispProps.setColorRoomsBy((MerlinDispProps.ColorRoomsBy)((Object)((Object)cb))));
        MerlinDispProps.ColorOccTargetsBy occTargetColor = app.getPrefs().getEnum(MerlinPrefs.ColorOccTargtesByProp, MerlinDispProps.ColorOccTargetsBy.class);
        this.d_dispProps.setColorOccTargetsBy(occTargetColor);
        this.updateColorBy();
        this.updateTransformToolEnabled();
        this.updateResetToSelectedEnabled();
        this.d_data.getEvents().addObserver(this);
        this.reset();
        this.d_renderComp.addKeyListener(new GCListener());
        this.d_renderComp.addResourceInitListener(rend -> this.detectVideoAdapter());
    }

    private <T extends ABehaviorActionBuilder> BehaviorActionTool<T> newHiddenBehaviorTool() {
        BehaviorActionTool tool = new BehaviorActionTool(this, true);
        return tool;
    }

    @Override
    public boolean endTool(Tool tool, boolean cancelled) {
        return this.d_tools.endTool(tool, cancelled);
    }

    @Override
    public <T> T getPreference(TypedProp<T> pref) {
        return MerlinPrefs.instance().getSystemOverLocal(pref);
    }

    public Camera getPredefCamera(int cam) {
        return this.d_cameras[cam];
    }

    public PropPanel getToolPropsPanel() {
        return this.d_toolPropsPanel;
    }

    public ToolManager getTools() {
        return this.d_tools;
    }

    public boolean validateEditor(boolean showWarnings, boolean commitData) {
        return this.d_toolPropsPanel.validateData(showWarnings, commitData);
    }

    private void updateColorBy() {
        this.d_colorRoomsByActions.get(this.d_dispProps.getColorRoomsBy().ordinal()).setSelected(true);
        this.d_colorOccTargetsByActions.get(this.d_dispProps.getColorOccTargetsBy().ordinal()).setSelected(true);
    }

    public MerlinDispProps getDisplayProps() {
        return this.d_dispProps;
    }

    public ManipMgr getManipMgr() {
        return this.d_manipListener.getManager();
    }

    public ManipHook getManipListener() {
        return this.d_manipListener;
    }

    private CompositeFunc<?> create3DCompositeTool() {
        CompositeFunc tool = NavtoolUtil.newCompositeNav3DTool(this.d_orbitTool.getFunction(), this.d_zoomTool.getFunction(), this.d_dragTool.getFunction(), this.d_selFunc);
        return tool;
    }

    @Override
    public Unit[] getLengthUnits() {
        return new Unit[]{Geometry.LENGTH_UNIT, MerlinApp.getApp().getUnitSystem().getLength()};
    }

    @Override
    public ModelScene[] getToolScenes() {
        return new ModelScene[]{this.d_dispMgr.mainScene.scene, null};
    }

    public GlobalDisplayMgr getDisplayManager() {
        return this.d_dispMgr;
    }

    private static <T> void updatePref(TypedProp<T> oldPref, TypedProp<T> newPref) {
        TeciProps props = MerlinPrefs.instance();
        if (props.isDefined(oldPref)) {
            if (!props.isDefined(newPref)) {
                T oldVal = props.get(oldPref);
                MerlinApp.setPref(newPref, oldVal);
            }
            MerlinApp.removePref(oldPref);
        }
    }

    private void upgradePrefs() {
        this.setPrefs(() -> {
            ModelView.updatePref(MerlinPrefs.KEY_USEVERTEXBUFFERS, RenderPrefs.PREF_USEVERTEXBUFFERS);
            ModelView.updatePref(MerlinPrefs.SCENE_SHADERS, RenderPrefs.PREF_SCENESHADERS);
            ModelView.updatePref(MerlinPrefs.SCENE_MULTISAMPLES, RenderPrefs.PREF_MULTISAMPLES);
            ModelView.updatePref(MerlinPrefs.SCENE_ANISOTROPIC_FILTERING, RenderPrefs.PREF_ANISOTROPIC_FILTERING);
        });
    }

    private static <T> boolean test(TypedProp<T> prop) {
        return MerlinPrefs.instance().containsKey(prop.key);
    }

    private static boolean getRetestGraphics() {
        return !ModelView.test(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10) || !ModelView.test(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140) || !ModelView.test(RenderPrefs.PREF_USEVERTEXBUFFERS) || !ModelView.test(RenderPrefs.PREF_SCENESHADERS);
    }

    private void setPrefs(final Runnable prefs) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                try (MerlinData.WriteLock lock = md.lockWrite();){
                    prefs.run();
                }
            }
        };
        UIHook.run(this.d_renderComp, null, op, 20);
    }

    private static void getLocalDefaultPrefs(TeciProps props, IRenderSurface.SurfPrefs caps) {
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(caps.shaders));
    }

    public TeciProps getDefaultPrefs() {
        return RenderPrefs.getDefaultPrefs(this.d_renderComp, ModelView::getLocalDefaultPrefs);
    }

    public TeciProps getPreferredPrefs() {
        TeciProps props = RenderPrefs.getPreferredPrefs();
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(true));
        return props;
    }

    public TeciProps getCompatibilityPrefs() {
        TeciProps props = RenderPrefs.getCompatibilityPrefs();
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10, Boolean.valueOf(false));
        props.set(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140, Boolean.valueOf(false));
        return props;
    }

    private void detectVideoAdapter() {
        if (MerlinApp.getApp().isSafeMode()) {
            return;
        }
        IRenderSurface.Adapter adapter = this.d_renderComp.getAdapter();
        MerlinPrefs.Version ver = MerlinPrefs.getVersion();
        boolean forceRedetect = ver.ordinal() < MerlinPrefs.Version.VER_0001.ordinal() || ModelView.getRetestGraphics() || ver.ordinal() < MerlinPrefs.Version.VER_0002.ordinal() && adapter != IRenderSurface.Adapter.NVIDIA || ver.ordinal() < MerlinPrefs.Version.VER_0003.ordinal() && adapter == IRenderSurface.Adapter.INTEL;
        TeciProps tprops = (TeciProps)MerlinPrefs.instance().clone();
        if (RenderPrefs.detectVideoAdapter(tprops, MerlinApp.getApp().isSafeMode(), this.d_renderComp, forceRedetect, ModelView::getLocalDefaultPrefs)) {
            this.setPrefs(() -> MerlinApp.setPrefs(tprops));
        }
    }

    public void showIntelWarning() {
        this.d_renderComp.addResourceInitListener(rc -> {
            if (this.d_renderComp.getAdapter() != IRenderSurface.Adapter.INTEL) {
                return;
            }
            MerlinOpImpl op = new MerlinOpImpl((app, md) -> {
                md.beginRead();
                try {
                    if (MerlinPrefs.getBoolean(RenderPrefs.INTEL_WARNING_SHOWN)) {
                        return;
                    }
                }
                finally {
                    md.endRead();
                }
                md.uiLater(() -> {
                    Consumer<Boolean> setRemember = remember -> this.setPrefs(() -> MerlinApp.setPref(RenderPrefs.INTEL_WARNING_SHOWN, remember));
                    RenderPrefs.showIntelWarning(this.d_renderComp, "Pathfinder", () -> this.d_renderComp.getOpenGLInfo(), setRemember, MerlinPrefs.getBoolean(RenderPrefs.INTEL_SAFE_MODE));
                });
            });
            UIHook.run(this.d_renderComp, null, op, 20);
        });
    }

    public void applyPrefs() {
        this.forceImmediate(!MerlinPrefs.getBoolean(RenderPrefs.PREF_USEVERTEXBUFFERS));
        this.useHardwareSkinning(MerlinPrefs.getBoolean(MerlinPrefs.KEY_HARDWARE_SKINNING_VP10), MerlinPrefs.getBoolean(MerlinPrefs.KEY_HARDWARE_SKINNING_GLSL140));
        this.setMaxVBSize(MerlinPrefs.getLong(MerlinPrefs.KEY_RFIXED_MAX_VB_SIZE));
        Stream.Builder<SceneRenderOptions> ropts = Stream.builder();
        ropts.add(this.d_drawMode2d.props);
        ropts.add(this.d_drawMode3d.props);
        ropts.add(this.d_drawMode.props);
        RenderPrefs.applyPrefs(MerlinPrefs.instance(), Stream.of(this.d_renderComp), Stream.empty(), ropts.build());
    }

    public void forceImmediate(boolean immediateMode) {
        this.d_dispMgr.getScenes(scene -> scene.forceImmediate(immediateMode));
        this.d_xformDispMgr.getScenes(scene -> scene.forceImmediate(immediateMode));
        this.d_dispMgr.agentRenderer.forceImmediate(immediateMode);
        this.d_xformDispMgr.agentRenderer.forceImmediate(immediateMode);
        this.repaint();
    }

    public void useHardwareSkinning(boolean enabledVP10, boolean enabledGLSL140) {
        this.d_dispMgr.agentRenderer.enableHardwareSkinning(enabledVP10, enabledGLSL140);
        this.d_xformDispMgr.agentRenderer.enableHardwareSkinning(enabledVP10, enabledGLSL140);
        this.repaint();
    }

    public void setMaxVBSize(long maxSize) {
        this.d_dispMgr.agentRenderer.setMaxVBSize(maxSize);
        this.d_xformDispMgr.agentRenderer.setMaxVBSize(maxSize);
    }

    private void updateLayout() {
        OverlayLayout mainLayout = new OverlayLayout();
        OverlayLayout screenshotLayout = new OverlayLayout();
        if (this.d_mainView.getCamera() instanceof PerspectiveCamera) {
            this.initLayout3D(mainLayout);
            this.initLayout3D(screenshotLayout);
        } else {
            this.initLayout2D(mainLayout);
            this.initLayout2D(screenshotLayout);
        }
        mainLayout.add(this.d_axes, 13, 0.15f, 0.15f);
        mainLayout.add(this.d_toolLayer);
        this.d_renderComp.getRootPanel().setLayoutManager(mainLayout);
        this.d_renderFile.getRootPanel().setLayoutManager(screenshotLayout);
    }

    private void initLayout3D(OverlayLayout layout) {
        layout.add(this.d_background);
        GlobalDisplayMgr.initLayout3D(layout, Arrays.asList(this.d_dispMgr, this.d_xformDispMgr));
    }

    private void initLayout2D(OverlayLayout layout) {
        layout.add(this.d_background);
        GlobalDisplayMgr.initLayout2D(layout, Arrays.asList(this.d_dispMgr, this.d_xformDispMgr));
    }

    private <BuilderT extends ABehaviorActionBuilder, ToolT extends BehaviorActionTool<BuilderT>> ToolT addBehaviorTool(String actionLbl, String shortDesc, Icon icon, BuilderT builder, APropEditPanel<BuilderT> pnl, ToolT tool) {
        return this.addBehaviorTool(actionLbl, shortDesc, icon, builder, pnl, tool, null);
    }

    private <BuilderT extends ABehaviorActionBuilder, ToolT extends BehaviorActionTool<BuilderT>> ToolT addBehaviorTool(String actionLbl, String shortDesc, Icon icon, BuilderT builder, APropEditPanel<BuilderT> pnl, ToolT tool, IPropsDisplay<? super BuilderT> propsDisp) {
        return this.addBehaviorTool(actionLbl, shortDesc, icon, builder, pnl, tool, propsDisp, null);
    }

    private <BuilderT extends ABehaviorActionBuilder, ToolT extends BehaviorActionTool<BuilderT>> ToolT addBehaviorTool(String actionLbl, String shortDesc, Icon icon, BuilderT builder, APropEditPanel<BuilderT> pnl, ToolT tool, IPropsDisplay<? super BuilderT> propsDisp, KeyStroke accelerator) {
        MerlinToolPropsInfo props = new MerlinToolPropsInfo(this, this.d_dispMgr.behaviorScene.scene, tool, pnl, propsDisp, builder, false);
        this.addModalTool(tool, actionLbl, "", icon, props, accelerator);
        ToolManager.ToolAction action = this.d_tools.getToolAction(tool);
        action.putValue("ShortDescription", shortDesc);
        return tool;
    }

    private <BuilderT extends AQueueElementBuilder, ToolT extends QueueElementTool<BuilderT>> ToolT addQueueTool(String actionLbl, String shortDesc, String icon, BuilderT builder, APropEditPanel<BuilderT> pnl, ToolT tool) {
        return this.addQueueTool(actionLbl, shortDesc, icon, builder, pnl, tool, null);
    }

    private <BuilderT extends AQueueElementBuilder, ToolT extends QueueElementTool<BuilderT>> ToolT addQueueTool(String actionLbl, String shortDesc, String icon, BuilderT builder, APropEditPanel<BuilderT> pnl, ToolT tool, IPropsDisplay<? super BuilderT> propsDisp) {
        return this.addQueueTool(actionLbl, shortDesc, icon, builder, pnl, tool, propsDisp, null);
    }

    private <BuilderT extends AQueueElementBuilder, ToolT extends QueueElementTool<BuilderT>> ToolT addQueueTool(String actionLbl, String shortDesc, String icon, BuilderT builder, APropEditPanel<BuilderT> pnl, ToolT tool, IPropsDisplay<? super BuilderT> propsDisp, KeyStroke accelerator) {
        MerlinToolPropsInfo props = new MerlinToolPropsInfo(this, this.d_dispMgr.behaviorScene.scene, tool, pnl, propsDisp, builder, false);
        this.addModalTool(tool, actionLbl, "", guiUtil.loadMerlinIcon(icon), props, accelerator);
        ToolManager.ToolAction action = this.d_tools.getToolAction(tool);
        action.putValue("ShortDescription", shortDesc);
        return tool;
    }

    private void addModalTool(Tool tool, String name, String toolTip, Icon icon, ToolPropsInfo toolProps) {
        this.addModalTool(tool, name, toolTip, icon, toolProps, null);
    }

    private void addModalTool(Tool tool, String name, String toolTip, Icon icon, ToolPropsInfo toolProps, KeyStroke accelerator) {
        this.d_tools.addTool(tool, name, toolTip, icon, true, toolProps, accelerator);
        if (toolProps != null && toolProps.d_editor != null) {
            this.d_toolPropsPanel.addEditor(toolProps.d_editor);
        }
    }

    private void initPredefCameras() {
        this.d_cameras[0] = new OrthoCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.0, 10000.0, 1.0);
        this.d_camResetDirs[0] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZNEG);
        this.d_cameras[1] = new OrthoCamera(new Point3d(0.0, -1.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), 0.0, 10000.0, 1.0);
        this.d_camResetDirs[1] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_YPOS);
        this.d_cameras[2] = new OrthoCamera(new Point3d(-1.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 0.0, 1.0), 0.0, 10000.0, 1.0);
        this.d_camResetDirs[2] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_ZPOS, GeomConstants.VEC3D_XPOS);
        this.d_cameras[3] = new PerspectiveCamera(new Point3d(0.0, 0.0, 1.0), new Point3d(0.0, 0.0, 0.0), new Vector3d(0.0, 1.0, 0.0), 0.1, 10000.0, 65.0);
        this.d_camResetDirs[3] = new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZNEG);
    }

    private final JToolBar createViewToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        KeyStroke view1ks = KeyStroke.getKeyStroke(49, 128);
        KeyStroke view2ks = KeyStroke.getKeyStroke(50, 128);
        KeyStroke view3ks = KeyStroke.getKeyStroke(51, 128);
        KeyStroke view4ks = KeyStroke.getKeyStroke(52, 128);
        ChangeViewListener perspListener = this.createChangeViewListener(ToolNames.PERSPECTIVE_VIEW, Intl.intl("Switch to the Perspective View"), "merlin/icons/perspective16.png", 3, toolbar, view1ks);
        ChangeViewListener topListener = this.createChangeViewListener(ToolNames.TOP_VIEW, Intl.intl("Switch to the Top View"), "thunderheadeng/gui/graphics/ViewXY.gif", 0, toolbar, view2ks);
        ChangeViewListener frontListener = this.createChangeViewListener(ToolNames.FRONT_VIEW, Intl.intl("Switch to the Front View"), "thunderheadeng/gui/graphics/ViewXZ.gif", 1, toolbar, view3ks);
        ChangeViewListener leftListener = this.createChangeViewListener(ToolNames.LEFT_VIEW, Intl.intl("Switch to the Left View"), "thunderheadeng/gui/graphics/ViewYZ.gif", 2, toolbar, view4ks);
        guiUtil.addMEToolbarItems(toolbar, perspListener, topListener, frontListener, leftListener);
        perspListener.setSelected(true);
        Utils.noToolBarFocus(toolbar);
        return toolbar;
    }

    private final ChangeViewListener createChangeViewListener(String name, String desc, String iconLocation, int c, JToolBar toolbar, KeyStroke accelerator) {
        ChangeViewListener listener = new ChangeViewListener(name, desc, iconLocation, c);
        toolbar.getInputMap(2).put(accelerator, name);
        toolbar.getActionMap().put(name, listener);
        return listener;
    }

    private JToolBar createViewOptionsToolbar() {
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.add(this.d_appearanceBox);
        toolbar.add(Box.createHorizontalStrut(2));
        toolbar.add(guiUtil.createToolbarToggleButton(this.d_showNavGeomVisAction));
        for (FilterAction<?> filterAction : this.d_filterActions) {
            toolbar.add(guiUtil.createToolbarToggleButton(filterAction));
        }
        Utils.noToolBarFocus(toolbar);
        this.d_appearanceBox.setMaximumSize(this.d_appearanceBox.getPreferredSize());
        return toolbar;
    }

    private final JToolBar createNavToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        Utils.noToolBarFocus(tb);
        this.updateNavToolbar(tb);
        return tb;
    }

    private final void updateNavToolbar(JToolBar tb) {
        if (tb == null) {
            return;
        }
        tb.removeAll();
        if (this.getMainScene().getCamera() instanceof OrthoCamera) {
            tb.add(this.d_tools.getToolbarButton(this.d_selectionTool2D));
        } else {
            tb.add(this.d_tools.getToolbarButton(this.d_selectionTool3D));
            tb.add(this.d_tools.getToolbarButton(this.d_compositeViewTool3d));
            tb.add(this.d_tools.getToolbarButton(this.d_modGameRoamTool));
        }
        tb.add(this.d_tools.getToolbarButton(this.d_dragTool));
        tb.add(this.d_tools.getToolbarButton(this.d_zoomTool));
        tb.add(this.d_tools.getToolbarButton(this.d_zoomBoxTool));
        tb.addSeparator();
        tb.add(this.d_resetAllHook);
        tb.add(this.d_resetToSelectedHook);
        tb.add(this.d_fillViewHook);
        Utils.noToolBarFocus(tb);
    }

    private JToolBar createCreationToolbar() {
        JToolBar tb = new JToolBar();
        tb.setLayout(new GridBagLayout());
        tb.setFloatable(false);
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_tools.getToolbarButton(this.d_translateTool), this.d_tools.getToolbarButton(this.d_rotateTool));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_mirrorTool));
        gbh.addSeparator();
        gbh.addRow(this.d_tools.getToolbarButton(this.d_openSpacePolyTool), this.d_tools.getToolbarButton(this.d_openSpaceRectTool));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_thinWallTool), this.d_tools.getToolbarButton(this.d_wallTool));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_stairTool1Pt), this.d_tools.getToolbarButton(this.d_stairTool2Pt));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_rampTool1Pt), this.d_tools.getToolbarButton(this.d_rampTool2Pt));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_newDoorTool), this.d_tools.getToolbarButton(this.d_newBlockageTool));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_newAgentTool), this.d_tools.getToolbarButton(this.d_newAgentRegionTool));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_newAttractorTool), this.d_tools.getToolbarButton(this.d_newSingleOccTargetTool));
        gbh.addRow(this.d_tools.getToolbarButton(this.d_measurementRegionTool), this.d_tools.getToolbarButton(this.d_occSourceTool));
        if (MerlinApp.isDev()) {
            gbh.addRow(this.d_tools.getToolbarButton(this.d_developerTool));
        }
        gbh.finalizeRows();
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private JToolBar createEditToolbar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_tools.getToolbarButton(this.d_floorExtractTool));
        gbh.finalizeRows();
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private JToolBar createUtilityToolBar() {
        JToolBar tb = new JToolBar();
        tb.setFloatable(false);
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_tools.getToolbarButton(this.d_measureTool));
        gbh.finalizeRows();
        Utils.noToolBarFocus(tb);
        return tb;
    }

    private JToolBar get3DToolToolBar() {
        JToolBar tb = new JToolBar();
        tb.setLayout(new GridBagLayout());
        GridBagHelper gbh = new GridBagHelper(tb, false, 1, 1);
        gbh.addRow(this.d_creationToolbar);
        gbh.addSeparator();
        gbh.addRow(this.d_editToolbar);
        gbh.addSeparator();
        gbh.addRow(this.d_utilityToolbar);
        gbh.finalizeRows();
        return tb;
    }

    private JToolBar getViewOptionsToolBar() {
        guiToolBar viewOptions = new guiToolBar();
        ((Container)viewOptions).add(this.d_viewToolbar);
        ((Container)viewOptions).add(this.d_viewOptionsToolbar);
        viewOptions.addSeparator();
        ((Container)viewOptions).add(this.d_navToolbar);
        Utils.noToolBarFocus(viewOptions);
        return viewOptions;
    }

    private JPanel createMainPanel() {
        JToolBar viewToolBar = this.getViewOptionsToolBar();
        JToolBar toolsToolBar = this.get3DToolToolBar();
        toolsToolBar.setOrientation(1);
        toolsToolBar.setFloatable(false);
        viewToolBar.setFloatable(false);
        JPanel panel = new JPanel(new BorderLayout());
        JPanel viewPanel = new JPanel(new BorderLayout());
        viewPanel.add((Component)viewToolBar, "North");
        viewPanel.add((Component)new JSeparator(0), "South");
        JPanel toolsPanel = new JPanel(new BorderLayout());
        JPanel renderPanel = new JPanel(new BorderLayout());
        this.d_middlePanel = new JPanel(new BorderLayout());
        this.d_middlePanel.add((Component)this.d_renderComp, "Center");
        renderPanel.add((Component)this.d_middlePanel, "Center");
        JPanel compPanel = new JPanel(new BorderLayout());
        compPanel.add((Component)toolsToolBar, "West");
        compPanel.add((Component)renderPanel, "Center");
        toolsPanel.add((Component)this.d_toolPropsPanel, "North");
        toolsPanel.add((Component)compPanel, "Center");
        panel.add((Component)viewPanel, "North");
        panel.add((Component)toolsPanel, "Center");
        panel.add((Component)this.d_statusBar, "South");
        return panel;
    }

    private JMenu createMainMenu() {
        guiMenu menu = new guiMenu(Intl.intl("&View"));
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showOriginAction);
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showSnapGridAction);
        menu.add(this.d_snapGridHook.getMenuItem());
        menu.addSeparator();
        JMenu agentsSubMenu = new JMenu(Intl.intl("Occupant Display"));
        guiUtil.addMEMenuItems(agentsSubMenu, this.d_etMD5SimpleDisksAction, this.d_etMD5SimpleCylAction, this.d_etMD5SimpleSpheresAction, this.d_etMD5GenericAction, this.d_etMD5CasualAction);
        menu.add(agentsSubMenu);
        JMenu agentsColorSubMenu = new JMenu(Intl.intl("Occupant Color"));
        guiUtil.addMEMenuItems(agentsColorSubMenu, this.d_colorAgentsByActions);
        menu.add(agentsColorSubMenu);
        menu.addSeparator();
        JMenu filterActionsSubMenu = new JMenu(Intl.intl("Show Object Types"));
        for (FilterAction<?> fAction : this.d_filterActions) {
            guiUtil.addSelectableMenuItem(filterActionsSubMenu, fAction);
        }
        menu.add(filterActionsSubMenu);
        menu.addSeparator();
        guiUtil.addSelectableMenuItem(menu, this.d_showNavGeomVisAction);
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showNavMeshTrisAction);
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showStairDirArrowAction);
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showOnewayAction);
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showBlockageCadSearchAction);
        menu.addSeparator();
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showGuidesAction);
        guiUtil.addSelectableMenuItem(menu, (SelectableAction)this.d_showPointerAction);
        menu.addSeparator();
        ColorMgrMenu colorMenu = new ColorMgrMenu(Intl.intl("Color Scheme"), this.d_colors);
        menu.add(colorMenu);
        BiConsumer<String, List> addMESubMenu = (name, items) -> {
            JMenu subMenu = new JMenu((String)name);
            guiUtil.addMEMenuItems(subMenu, (Collection<? extends SelectableAction>)items);
            menu.add(subMenu);
        };
        addMESubMenu.accept(Intl.intl("Color Rooms"), this.d_colorRoomsByActions);
        addMESubMenu.accept(Intl.intl("Color Occupant Targets"), this.d_colorOccTargetsByActions);
        addMESubMenu.accept(Intl.intl("Units"), Arrays.asList(UnitsAction.SI_ACTION, UnitsAction.ENGLISH_ACTION));
        menu.addSeparator();
        menu.add(this.d_resetAllHook.getMenuItem());
        menu.add(this.d_resetToSelectedHook.getMenuItem());
        menu.add(this.d_fillViewHook.getMenuItem());
        return menu;
    }

    public void repaint() {
        this.d_renderComp.repaint();
    }

    public void startAnimation(double[] tRange, double tInit, int options) {
        if (this.d_animInfo.isPresent()) {
            return;
        }
        this.stopAnimation();
        BitOptions opts = new BitOptions(options);
        MVAnimSession session = this.d_animSession;
        session.set(IAnimSession.TIME_RANGE, tRange);
        session.set(IAnimSession.TIME, tInit);
        session.set(IAnimSession.STATE, opts.get(2L) ? IAnimSession.State.PLAYING : IAnimSession.State.PAUSED);
        ArrayList<IAnimator> animators = new ArrayList<IAnimator>();
        animators.add(new TimeAnimator(this.d_animSession, opts.get(1L)));
        this.d_animSession.viewport.getAnimators(animators, this, this.d_animSession);
        Camera cam = this.d_animSession.viewport.getCamera(this);
        SwingUtilities.invokeLater(() -> {
            ChangeViewListener action = this.findChangeViewAction(cam);
            action.setSelected(true);
            this.setMainCamera(cam);
        });
        ArrayList<IAnimView> views = new ArrayList<IAnimView>();
        ArrayList<IEventObserver> observers = new ArrayList<IEventObserver>();
        IEventObserver repainter = events -> this.d_renderComp.render();
        observers.add(repainter);
        Optional<Component> tv = Optional.empty();
        ArrayList<Integer> status = new ArrayList<Integer>();
        if (opts.get(4L)) {
            TimeView timeView = new TimeView(this.d_animSession, this.d_animSession, 0);
            JPanel panel = new JPanel(new BorderLayout());
            panel.add((Component)timeView.getViewUI(), "Center");
            panel.add((Component)new JSeparator(), "South");
            SwingUtilities.invokeLater(() -> this.d_middlePanel.add((Component)panel, "South"));
            tv = Optional.of(panel);
            views.add(timeView);
            int statusIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            int timeIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            int speedIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            int fpsIx = this.d_statusBar.addPane(new guiLabel(), 0.0);
            status.add(statusIx);
            status.add(timeIx);
            status.add(speedIx);
            status.add(fpsIx);
            StatusView statusBarTimeView = new StatusView(this.d_animSession, this.d_animSession, new StatusView.BarInfo(this.d_statusBar, statusIx, timeIx, speedIx, fpsIx));
            views.add(statusBarTimeView);
        }
        this.d_animInfo = Optional.of(new TimeAnimInfo(this.d_animSession, tv, observers, views, status, animators));
        this.d_animInfo.get().start();
    }

    public Optional<MVAnimSession> getAnimation() {
        return this.d_animInfo.flatMap(ai -> Optional.of(ai.session));
    }

    public void stopAnimation() {
        this.d_animInfo.ifPresent(ai -> {
            ai.stop();
            ai.timeView.ifPresent(tv -> this.d_middlePanel.remove((Component)tv));
            ((Stream)ai.status.stream().sorted((i1, i2) -> i2 - i1).sequential()).forEach(i -> this.d_statusBar.removePane((int)i));
            this.d_animInfo = Optional.empty();
        });
    }

    public ModelScene getMainScene() {
        return this.d_dispMgr.mainScene.scene;
    }

    public RenderFile getScreenshotGenerator() {
        return this.d_renderFile;
    }

    public boolean isImportWireframe() {
        return this.d_drawMode.props.drawWireframe();
    }

    public void startChoosingPoints(final IPointPickListener listener) {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                Optional<PointPicker> opicker = ModelView.this.d_pointPickerTool.findFunc(PointPicker.class);
                assert (opicker.isPresent());
                opicker.ifPresent(picker -> {
                    picker.setListener(listener);
                    ModelView.this.beginTempTool(ModelView.this.d_pointPickerTool);
                });
            }
        };
        if (EventQueue.isDispatchThread()) {
            runner.run();
        } else {
            EventQueue.invokeLater(runner);
        }
    }

    public void stopChoosingPoints() {
        if (EventQueue.isDispatchThread()) {
            this.endTempTool();
        } else {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ModelView.this.endTempTool();
                }
            });
        }
    }

    private void beginTempTool(Tool tool) {
        this.d_tools.setCurrentTool(tool, true);
    }

    private void endTempTool() {
        this.d_tools.cancelCurrentTool();
    }

    private void updateTransformToolEnabled() {
        Tool[] xformTools;
        Set<IMerlinObj> objs = TransformAction.getValidObjs(this.d_data);
        boolean xformEnabled = !objs.isEmpty();
        for (Tool tool : xformTools = new Tool[]{this.d_translateTool, this.d_rotateTool, this.d_mirrorTool}) {
            this.d_tools.getToolAction(tool).setEnabled(xformEnabled);
        }
        Tool currentTool = this.d_tools.getCurrentTool();
        if (currentTool != null) {
            Optional<ATransformManip> xform = this.findToolProps(currentTool, ATransformManip.class);
            xform.ifPresent(props -> props.setSelection(objs));
        }
    }

    private void updateResetToSelectedEnabled() {
        MerlinData md = Objects.requireNonNull(MerlinApp.getApp()).getData();
        IFilteredCollection<IMerlinGeomSrc> selObjs = md.selection.flatten(IMerlinGeomSrc.class);
        this.d_resetToSelectedHook.setEnabled(!selObjs.isEmpty());
    }

    public <T extends MerlinProps> Optional<T> findToolProps(Tool tool, Class<T> expectedType) {
        ToolManager.ToolProps props = this.d_tools.getProps(tool);
        if (props.meta instanceof MerlinToolPropsInfo) {
            MerlinToolPropsInfo tpi = (MerlinToolPropsInfo)props.meta;
            return expectedType.isInstance(tpi.d_props) ? Optional.of((MerlinProps)expectedType.cast(tpi.d_props)) : Optional.empty();
        }
        return Optional.empty();
    }

    public void reset() {
        Consumer<FilterAction> updateAction = action -> action.update(this.d_data);
        updateAction.accept(this.d_showNavGeomVisAction);
        this.d_filterActions.stream().forEach(updateAction);
        this.updateViewProps();
        this.updateCurrentTool();
        this.resetCameras(this.d_cameras);
    }

    @Override
    public void update(Events events) {
        IEventRecord<MerlinData> mdRec;
        IEventRecord<IMerlinGeomSrc> geomRec;
        if (events.getEvents(MerlinData.class, new Class[0]).containsChange(MerlinData.PREFS_CHANGED)) {
            this.applyPrefs();
        }
        if ((geomRec = events.getEvents(IMerlinGeomSrc.class, new Class[0])).hasAddedObjs() || geomRec.hasRemovedObjs() || geomRec.containsChange(MerlinData.SELECTION_CHANGED)) {
            this.updateTransformToolEnabled();
            this.updateResetToSelectedEnabled();
        }
        boolean cancelModalTool = false;
        IEventRecord<Object> objEvts = events.getEvents(Object.class, new Class[0]);
        if (objEvts.areChangesOnly() && objEvts.areChangesExclusiveTo(MerlinData.SELECTION_CHANGED)) {
            cancelModalTool = !this.d_data.selection.isEmpty();
        }
        boolean reset = (mdRec = events.getEvents(MerlinData.class, new Class[0])).containsChange(Import.MODEL_IMPORTED) || mdRec.containsChange(MerlinData.MODEL_LOADED);
        this.d_dispProps.update(events);
        this.d_dispMgr.update(events);
        this.d_navMeshTris.update(events);
        if (cancelModalTool) {
            this.stopCurrentTool();
        }
        if (reset) {
            this.reset();
        } else {
            if (mdRec.containsChange(EVT_RESET_CAMERAS)) {
                this.resetCameras(this.d_cameras);
            }
            if (events.getEvents(ViewProps.class, new Class[0]).hasChangedObjs()) {
                this.updateViewProps();
            }
        }
        this.d_renderComp.repaint();
    }

    private void updateViewProps() {
        this.d_gridSnapper.setSpacing(this.d_data.viewProps.get(ViewProps.SKETCH_GRID_SPACING));
    }

    public void applyCamera(CameraRecord state) {
        this.d_cameras[3].apply(state);
        ChangeViewListener action = this.findChangeViewAction(this.d_cameras[3]);
        action.setSelected(true);
        this.setMainCamera(this.d_cameras[3]);
        this.repaint();
    }

    private ChangeViewListener findChangeViewAction(Camera cam) {
        if (this.d_viewToolbar != null) {
            for (int m = 0; m < this.d_viewToolbar.getComponentCount(); ++m) {
                Component c = this.d_viewToolbar.getComponentAtIndex(m);
                if (!(c instanceof AbstractButton) || !(((AbstractButton)c).getAction() instanceof ChangeViewListener) || this.d_cameras[((ChangeViewListener)((AbstractButton)c).getAction()).d_camera] != cam) continue;
                return (ChangeViewListener)((AbstractButton)c).getAction();
            }
        }
        return null;
    }

    public JComponent getMainPanel() {
        return this.d_panel;
    }

    public JMenu getMainMenu() {
        return this.d_menu;
    }

    @Override
    public RenderComponent getRenderComp() {
        return this.d_renderComp;
    }

    @Override
    public MerlinColors getColors() {
        return this.d_colors;
    }

    @Override
    public guiStatusMessage getStatusMessage() {
        return this.d_statusMessage;
    }

    @Override
    public GeomPicker getSnapper() {
        return this.d_snapper;
    }

    @Override
    public MVAnimSession getAnimSession() {
        return this.d_animSession;
    }

    @Override
    public IDeviceManager getDevices() {
        return this.d_tools.getDevices();
    }

    public View getMainView() {
        return this.d_mainView;
    }

    private void updateDrawProps() {
        this.d_drawMode.props.deleteObservers();
        this.d_dispMgr.updateDrawProps(this.d_mainView.getCamera(), this.d_drawMode.props);
        this.d_xformDispMgr.updateDrawProps(this.d_mainView.getCamera(), this.d_drawMode.props);
        boolean wireframe = this.d_drawMode.props.drawWireframe();
        boolean outline = this.d_drawMode.props.drawOutlines();
        boolean materials = this.d_drawMode.props.showMaterials();
        BooleanAction item = !wireframe && !outline && !materials ? this.d_solidAction : (!wireframe && outline && !materials ? this.d_solidOutlinesAction : (!wireframe && !outline && materials ? this.d_realisticAction : (!wireframe && outline && materials ? this.d_realisticOutlinesAction : (wireframe && !outline && !materials ? this.d_wireframeAction : this.d_realisticOutlinesAction))));
        this.d_appearanceBox.setSelectedItem(item);
    }

    private void updatePrefs() {
    }

    public void savePreferences() {
        TeciProps prefs = MerlinApp.getApp().getPrefs();
        prefs.set(MerlinPrefs.ShowSystemMouseProp, Boolean.valueOf(this.d_showPointerAction.isSelected()));
        prefs.set(MerlinPrefs.ShowGuidesProp, Boolean.valueOf(this.d_showGuidesAction.isSelected()));
        prefs.set(MerlinPrefs.DrawWireframeProp3d, Boolean.valueOf(this.d_drawMode3d.props.drawWireframe()));
        prefs.set(MerlinPrefs.ShowTexturesProp3d, Boolean.valueOf(this.d_drawMode3d.props.showMaterials()));
        prefs.set(MerlinPrefs.ShowOutlinesProp3d, Boolean.valueOf(this.d_drawMode3d.props.drawOutlines()));
        prefs.set(MerlinPrefs.UseSmoothLightingProp3d, Boolean.valueOf(this.d_drawMode3d.props.getLightModel() == ISceneRenderOptions.LightModel.LOCAL_CAMERA));
        prefs.set(MerlinPrefs.DrawWireframeProp2d, Boolean.valueOf(this.d_drawMode2d.props.drawWireframe()));
        prefs.set(MerlinPrefs.ShowTexturesProp2d, Boolean.valueOf(this.d_drawMode2d.props.showMaterials()));
        prefs.set(MerlinPrefs.ShowOutlinesProp2d, Boolean.valueOf(this.d_drawMode2d.props.drawOutlines()));
        prefs.set(MerlinPrefs.UseSmoothLightingProp2d, Boolean.valueOf(this.d_drawMode2d.props.getLightModel() == ISceneRenderOptions.LightModel.LOCAL_CAMERA));
        int colorBy = this.d_dispProps.getColorRoomsBy().prefId;
        prefs.set(MerlinPrefs.ColorRoomsByProp, Integer.valueOf(colorBy));
        prefs.set(MerlinPrefs.ColorOccTargtesByProp, this.d_dispProps.getColorOccTargetsBy().name());
    }

    public void updateColors(ColorChangedEvent evt) {
        Color bgColor1 = this.d_colors.getColor(MerlinColors.BACKGROUND_COLOR);
        Color bgColor2 = this.d_colors.getColor(MerlinColors.BACKGROUND_COLOR2);
        this.d_background.setColors(bgColor1, bgColor2);
        float[] bgColorComps = bgColor1.getComponents(new float[4]);
        this.d_axes.setBackgroundColor(new Color(bgColorComps[0], bgColorComps[1], bgColorComps[2], 0.9f));
        this.d_axes.setAxisColor(this.d_colors.getColor(MerlinColors.AXIS_COLOR));
        this.d_axes.setBoxColor(this.d_colors.getColor(MerlinColors.AXIS_BOX_COLOR));
        this.d_axes.setTextColor(this.d_colors.getColor(MerlinColors.AXIS_TEXT_COLOR));
        this.d_origin.setColor(this.d_colors.getColor(MerlinColors.ORIGIN2D_COLOR));
        this.d_gridSnapperDisp.setColors(this.d_colors.getColor(MerlinColors.SNAP_TO_GRID_COLOR), this.d_colors.getColor(MerlinColors.SNAP_TO_POINTS_COLOR));
        this.updateAll();
    }

    private void updateAll() {
        this.d_dispMgr.updateAll();
        this.d_xformDispMgr.updateAll();
    }

    private void updateAll(Class<?> type) {
        Consumer<GlobalDisplayMgr> update = dispMgr -> {
            for (IMerlinDispMgr<?> mgr : dispMgr.getManagers()) {
                if (!mgr.getType().isAssignableFrom(type)) continue;
                mgr.updateAll();
            }
        };
        update.accept(this.d_dispMgr);
        update.accept(this.d_xformDispMgr);
    }

    private void setToolEnabled(Tool tool, boolean enable) {
        this.d_tools.getToolAction(tool).setEnabled(enable);
    }

    public Camera getCamera(int camId) {
        return this.d_cameras[camId];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainCamera(Camera camera) {
        this.stopCurrentTool();
        this.d_dispMgr.setMainCamera(camera);
        this.d_xformDispMgr.setMainCamera(camera);
        this.d_axes.setBaseCamera(camera);
        boolean ortho = camera instanceof OrthoCamera;
        this.d_data.beginRead();
        try {
            this.d_drawMode = ortho ? this.d_drawMode2d : this.d_drawMode3d;
            this.d_tools.setCurrentTool(this.d_drawMode.currentTool);
            Plane3d zplane = new Plane3d(0.0, 0.0, 1.0, 0.0);
            boolean drawToolsEnabled = !ortho || !Util3D.areParallel(zplane, camera.getViewVector(), 1.0E-6);
            this.setToolEnabled(this.d_newAgentTool, drawToolsEnabled);
            this.setToolEnabled(this.d_newAgentRegionTool, drawToolsEnabled);
            this.setToolEnabled(this.d_newAttractorTool, drawToolsEnabled);
            this.setToolEnabled(this.d_newSingleOccTargetTool, drawToolsEnabled);
            this.setToolEnabled(this.d_newDoorTool, drawToolsEnabled);
            this.setToolEnabled(this.d_newBlockageTool, drawToolsEnabled);
            this.setToolEnabled(this.d_openSpacePolyTool, drawToolsEnabled);
            this.setToolEnabled(this.d_openSpaceRectTool, drawToolsEnabled);
            this.setToolEnabled(this.d_thinWallTool, drawToolsEnabled);
            this.setToolEnabled(this.d_wallTool, drawToolsEnabled);
            this.setToolEnabled(this.d_stairTool2Pt, drawToolsEnabled);
            this.setToolEnabled(this.d_stairTool1Pt, drawToolsEnabled);
            this.setToolEnabled(this.d_rampTool2Pt, drawToolsEnabled);
            this.setToolEnabled(this.d_rampTool1Pt, drawToolsEnabled);
            this.updateLayout();
            this.updateDrawProps();
            this.updateCurrentTool();
            this.updateGridSnapperDisplay();
        }
        finally {
            this.d_data.endRead();
        }
        this.updateNavToolbar(this.d_navToolbar);
    }

    private void stopCurrentTool() {
        this.d_tools.cancelCurrentTool();
    }

    private void updateCurrentTool() {
        this.updateCurrentTool(this.d_tools.getCurrentTool(), this.d_tools.getCurrentTool());
    }

    private void updateCurrentTool(Tool oldTool, Tool newTool) {
        if (newTool == this.d_modGameRoamTool) {
            AABox modelBounds = this.getModelSceneBounds();
            this.d_modGameRoamTool.findFunc(RoamFunc.class).ifPresent(rf -> rf.setModelBounds(modelBounds));
        }
        if (newTool instanceof CursorTool) {
            CursorTool ctool = (CursorTool)newTool;
            ctool.setGuidesVisible(this.d_showGuidesAction.isSelected());
            ctool.setPointerVisible(this.d_showPointerAction.isSelected());
            ctool.setView(this.d_mainView);
            this.d_toolLayer.clear();
            this.d_toolLayer.add(ctool);
        }
        this.d_drawMode.currentTool = newTool;
    }

    @Override
    public void colorChanged(final ColorChangedEvent e) {
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                ModelView.this.updateColors(e);
                ModelView.this.d_renderComp.repaint();
            }
        };
        UIHook.run(null, "ModelView.colorChanged", op, 5);
    }

    private AABox getModelSceneBounds() {
        return this.getModelSceneBounds(true);
    }

    private AABox getModelSceneBounds(boolean useExcluded) {
        AABox bounds = new AABox(this.d_dispMgr.getModelSceneBounds(useExcluded));
        bounds.add(this.d_xformDispMgr.getModelSceneBounds(useExcluded));
        return bounds;
    }

    public void resetCurrentCamera() {
        this.resetCameras(this.d_mainView.getCamera());
    }

    public void resetCameras(Camera ... cams) {
        AABox bounds = this.getModelSceneBounds(false);
        this.resetCameras(bounds, cams);
    }

    public void resetCurrentCamera(Collection<?> objs) {
        this.resetCameras(objs, this.d_mainView.getCamera());
    }

    public void resetCameras(Collection<?> objs, Camera ... cams) {
        if (objs.isEmpty()) {
            this.resetCameras(cams);
            return;
        }
        AABox bb = new AABox();
        for (IMerlinGeomSrc geom : theUtil.filter(objs, IMerlinGeomSrc.class)) {
            bb.add(geom.getBounds());
        }
        IFilteredCollection<EgressAgent> agents = theUtil.filter(objs, EgressAgent.class);
        Consumer<GlobalDisplayMgr> addAgentBounds = dispMgr -> {
            for (AgentDispMgr mgr : MerlinUtil.filter(dispMgr.getManagers(), AgentDispMgr.class)) {
                bb.add(mgr.getBoundingBox(agents));
            }
        };
        addAgentBounds.accept(this.d_dispMgr);
        addAgentBounds.accept(this.d_xformDispMgr);
        this.resetCameras(bb, cams);
    }

    private void resetCameras(AABox bb, Camera ... cams) {
        bb = new AABox(bb.getMinX(), bb.getMinY(), bb.getMinZ(), bb.getMaxX(), bb.getMaxY(), bb.getMaxZ());
        for (Camera c : cams) {
            AABox box = new AABox(bb);
            c.ensureValidForReset(box, 5.0);
            Pair<Vector3d, Vector3d> resetDirs = this.getResetDirs(c);
            c.reset((Vector3d)resetDirs.v2, (Vector3d)resetDirs.v1, box, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }
    }

    private Pair<Vector3d, Vector3d> getResetDirs(Camera c) {
        int index = -1;
        for (int m = 0; m < this.d_cameras.length; ++m) {
            if (c != this.d_cameras[m]) continue;
            index = m;
            break;
        }
        if (index != -1) {
            if (index == 3) {
                Vector3d upDir;
                Vector3d viewDir;
                if (this.d_tools.getCurrentTool() == this.d_modGameRoamTool) {
                    viewDir = new Vector3d(0.0, 1.0, 0.0);
                    upDir = new Vector3d(0.0, 0.0, 1.0);
                } else {
                    viewDir = new Vector3d(0.0, 0.0, -1.0);
                    upDir = new Vector3d(0.0, 1.0, 0.0);
                }
                return new Pair<Vector3d, Vector3d>(upDir, viewDir);
            }
            return this.d_camResetDirs[index];
        }
        return new Pair<Vector3d, Vector3d>(GeomConstants.VEC3D_YPOS, GeomConstants.VEC3D_ZNEG);
    }

    public void fillCamera() {
        AABox bounds = this.getModelSceneBounds(false);
        this.fillCameras(bounds, this.d_mainView.getCamera());
    }

    public void fillCameras(AABox bb, Camera ... cameras) {
        for (Camera c : cameras) {
            AABox box = new AABox(bb);
            c.ensureValidForReset(box, 5.0);
            c.fillView(box, this.d_renderComp.getWidth(), this.d_renderComp.getHeight());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void setVisible(MerlinApp app, MerlinData data, Class<T> type, Predicate<T> filter, boolean visible) {
        app.beginWaitCursor();
        data.beginWrite();
        try {
            if (!visible) {
                data.displayFilter.registerFilter(type, filter);
            } else {
                data.displayFilter.removeFilter(type, filter);
            }
        }
        finally {
            data.endWrite();
        }
        app.endWaitCursor();
    }

    public <T> void setVisible(Class<T> type, boolean visible, boolean waitToComplete) {
        SimpleOp op = new SimpleOp((app, data) -> ModelView.setVisible(app, data, type, Predicates.alwaysFalse(), visible));
        int options = 20;
        if (waitToComplete) {
            options |= 2;
        }
        UIHook.run(MerlinApp.getApp().getActiveFrame(), "ModelView.setVisible", op, options);
    }

    public <T> boolean isVisible(Class<T> type) {
        this.d_data.beginRead();
        try {
            boolean bl = !this.d_data.displayFilter.isFilteringAllOf(type);
            return bl;
        }
        finally {
            this.d_data.endRead();
        }
    }

    private static DecoratedIcon createVisibilityIcon(Icon base, Icon decoration) {
        return base == null ? null : new DecoratedIcon(base, decoration, 3);
    }

    public UIHook getResetViewOp() {
        return this.d_resetAllHook;
    }

    public UIHook getResetViewToSelOp() {
        return this.d_resetToSelectedHook;
    }

    public UIHook getFillViewOp() {
        return this.d_fillViewHook;
    }

    public UIHook getSnapGridOp() {
        return this.d_snapGridHook;
    }

    public UIHook getQueuePathHook() {
        return this.d_queuePathUIHook;
    }

    public UIHook getQueueServiceHook() {
        return this.d_queueServiceUIHook;
    }

    public UIHook getQueueNodeHook() {
        return this.d_queueNodeUIHook;
    }

    public JToolBar getViewsToolbar() {
        return this.d_viewToolbar;
    }

    public void updateEgressColors() {
        this.updateAll(IEgressComp.class);
    }

    @Override
    public void backgroundTaskStarted(Runnable cancel) {
        SimpleOp op = new SimpleOp((app, md) -> cancel.run());
        this.d_backgroundOps.put(cancel, op);
        UIHook.addPreOp(op);
    }

    @Override
    public void backgroundTaskEnded(Runnable cancelOp) {
        SimpleOp op = this.d_backgroundOps.remove(cancelOp);
        if (op != null) {
            UIHook.removePreOp(op);
        }
    }

    private void updateGridSnapperDisplay() {
        boolean snap;
        boolean ortho = this.d_mainView.getCamera() instanceof OrthoCamera;
        boolean showGrid = ortho && this.d_showSnapGridAction.isSelected();
        boolean showOrigin = ortho && this.d_showOriginAction.isSelected();
        boolean bl = snap = showGrid || showOrigin;
        if (showGrid) {
            this.d_dispMgr.gridScene.scene.addRenderableObjects(this.d_gridSnapperDisp);
        } else {
            this.d_dispMgr.gridScene.scene.removeRenderableObjects(this.d_gridSnapperDisp);
        }
        if (showOrigin) {
            this.d_dispMgr.originScene.scene.addRenderableObjects(this.d_origin);
        } else {
            this.d_dispMgr.originScene.scene.removeRenderableObjects(this.d_origin);
        }
        if (snap) {
            this.d_data.geomLocation.getLocator().add(this.d_gridSnapper);
        } else {
            this.d_data.geomLocation.getLocator().remove(this.d_gridSnapper);
        }
        this.d_gridSnapper.setOriginOnly(showOrigin && !showGrid);
        this.d_gridSnapperDisp.setSpacing(this.d_gridSnapper.getSpacing().getValue(Geometry.LENGTH_UNIT));
    }

    private static class GCListener
    extends KeyAdapter {
        private GCListener() {
        }

        @Override
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 123) {
                long total = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long freemem = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long inuse = total - freemem;
                System.out.printf("in use before: %d MB%n", inuse);
                System.gc();
                System.runFinalization();
                long totalnow = Runtime.getRuntime().totalMemory() / 1024L / 1024L;
                long freenow = Runtime.getRuntime().freeMemory() / 1024L / 1024L;
                long inusenow = totalnow - freenow;
                long delta = inuse - inusenow;
                System.out.printf("in use after: %d MB (freed %d MB)%n", inusenow, delta);
                System.out.printf("total: %d (%d) MB%n", totalnow, freenow);
            }
        }
    }

    private static class AddQueueNodeAction
    extends AddQueueElementAction {
        public AddQueueNodeAction(QueueElementTool t) {
            super(t);
        }

        @Override
        public void update(Events events) {
            MerlinData md = MerlinApp.getApp().getData();
            this.setEnabled(md.selection.isSingleExclusive(QueuePath.class) || md.selection.isSingleExclusive(QueuePathNode.class));
        }
    }

    private static class AddQueueElementAction
    extends AMerlinOp
    implements IEventObserver {
        private final QueueElementTool d_tool;

        public AddQueueElementAction(QueueElementTool t) {
            this.d_tool = t;
            SelectionObserver.add(this, IMerlinObj.class);
            this.update(null);
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            app.getModelView().getTools().getToolAction(this.d_tool).actionPerformed(null);
        }

        @Override
        public void update(Events events) {
            MerlinData md = MerlinApp.getApp().getData();
            this.setEnabled(md.selection.isSingleExclusive(QueueObject.class) || md.selection.isSingleExclusive(QueueService.class) || md.selection.isSingleExclusive(QueuePath.class));
        }
    }

    private static class GeomToolPropsInfo<T extends PlanarGeomBuilder>
    extends MerlinToolPropsInfo<T> {
        final /* synthetic */ ModelView this$0;

        public GeomToolPropsInfo(MerlinTool<T> tool, APropEditPanel<T> panel, IPropsDisplay<T> display, T props) {
            this.this$0 = var1_1;
            super((ModelView)var1_1, tool, panel, display, props);
        }

        @Override
        public void activate() {
            super.activate();
        }
    }

    private class MerlinToolPropsInfo<PropType extends MerlinProps>
    extends ToolPropsInfo {
        public final PropType d_props;
        public final IPropsDisplay<? super PropType> d_propDisp;
        final /* synthetic */ ModelView this$0;

        public MerlinToolPropsInfo(MerlinTool<PropType> tool, APropEditPanel<PropType> panel, IPropsDisplay<? super PropType> display, PropType props) {
            this(var1_1, var1_1.d_dispMgr.mainScene.scene, tool, panel, display, (MerlinProps)props, true);
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public MerlinToolPropsInfo(ModelScene scene, MerlinTool<PropType> tool, APropEditPanel<PropType> panel, IPropsDisplay<? super PropType> propsDisp, PropType props, boolean clearSelOnActivate) {
            this.this$0 = (ModelView)n;
            super(scene, tool, panel, propsDisp != null ? propsDisp.getDisplay() : null, clearSelOnActivate);
            this.d_props = props;
            this.d_propDisp = propsDisp;
        }

        public void setProps() {
            if (this.d_tool != null) {
                ((MerlinTool)this.d_tool).setProps(this.d_props);
            }
            if (this.d_editor != null) {
                ((APropEditPanel)this.d_editor).setProps(this.d_props);
            }
            if (this.d_propDisp != null) {
                this.d_propDisp.setProps(this.d_props);
            }
        }

        @Override
        public void activate() {
            this.setProps();
            super.activate();
        }

        @Override
        public void deactivate() {
            super.deactivate();
        }
    }

    private class ToolPropsInfo {
        public final ModelScene d_scene;
        public final Tool d_tool;
        public final IPropEditor d_editor;
        public final IMerlinDisplay d_display;
        public final boolean d_clearSelOnActivate;

        public ToolPropsInfo(Tool tool, IPropEditor editor, IMerlinDisplay display) {
            this(modelView.d_dispMgr.mainScene.scene, tool, editor, display, true);
        }

        public ToolPropsInfo(ModelScene scene, Tool tool, IPropEditor editor, IMerlinDisplay display, boolean clearSelOnActivate) {
            this.d_scene = scene;
            this.d_tool = tool;
            this.d_editor = editor;
            this.d_display = display;
            this.d_clearSelOnActivate = clearSelOnActivate;
        }

        public void activate() {
            ModelView.this.d_toolPropsPanel.setEditor(this.d_editor);
            if (this.d_display != null) {
                this.d_scene.addObjects(this.d_display.getDisplayObjs());
            }
            if (this.d_editor != null) {
                SwingUtilities.invokeLater(() -> this.d_editor.activate());
            }
        }

        public void deactivate() {
            if (this.d_display != null) {
                this.d_scene.removeObjects(this.d_display.getDisplayObjs());
            }
        }
    }

    private class UpdateSnapGridAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public UpdateSnapGridAction(String name, boolean initValue) {
            super(true, name, initValue);
        }

        @Override
        protected void work(MerlinData md, boolean selected) {
            md.beginWrite();
            try {
                ModelView.this.updateGridSnapperDisplay();
            }
            finally {
                md.endWrite();
            }
            md.ui(() -> ModelView.this.repaint());
        }
    }

    private class DisplayVisToggleAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public DisplayVisToggleAction() {
            super(false, Intl.intl("Show Mesh Triangles"), false);
            ModelView.this.d_navMeshTris.setVisible(false);
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            data.beginRead();
            try {
                ModelView.this.d_navMeshTris.setVisible(selected);
            }
            finally {
                data.endRead();
            }
            ModelView.this.repaint();
        }
    }

    private class ColorOccTargetsByAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final MerlinDispProps.ColorOccTargetsBy d_colorByType;

        public ColorOccTargetsByAction(MerlinDispProps.ColorOccTargetsBy colorByType) {
            super(false, colorByType.desc, false);
            this.putValue("ShortDescription", colorByType.longDesc);
            this.d_colorByType = colorByType;
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            if (!selected) {
                return;
            }
            data.beginRead();
            try {
                this.setMode();
            }
            finally {
                data.endRead();
            }
            ModelView.this.repaint();
        }

        private void setMode() {
            ModelView.this.d_dispProps.setColorOccTargetsBy(this.d_colorByType);
            ModelView.this.updateAll(OccTarget.class);
        }
    }

    private class ColorRoomsByAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final MerlinDispProps.ColorRoomsBy d_colorByType;

        public ColorRoomsByAction(MerlinDispProps.ColorRoomsBy colorByType) {
            super(false, colorByType.desc, false);
            this.putValue("ShortDescription", colorByType.longDesc);
            this.d_colorByType = colorByType;
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            if (!selected) {
                return;
            }
            data.beginRead();
            try {
                this.setMode();
            }
            finally {
                data.endRead();
            }
            ModelView.this.repaint();
        }

        private void setMode() {
            ModelView.this.d_dispProps.setColorRoomsBy(this.d_colorByType);
            ModelView.this.updateEgressColors();
        }
    }

    private class FillViewAction
    extends AMerlinOp {
        private FillViewAction() {
        }

        @Override
        public void run(MerlinApp app, MerlinData md) {
            md.beginRead();
            try {
                ModelView.this.fillCamera();
            }
            finally {
                md.endRead();
            }
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToSelectedObjectsAction
    extends AMerlinOp {
        @Override
        public void run(MerlinApp app, MerlinData md) {
            md.beginRead();
            try {
                ModelView.this.resetCurrentCamera(md.selection.getDeepSelected(IMerlinGeomSrc.class));
                ModelView.this.updateCurrentTool();
            }
            finally {
                md.endRead();
            }
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class ResetToAllObjectsAction
    extends AMerlinOp {
        @Override
        public void run(MerlinApp app, MerlinData md) {
            md.beginRead();
            try {
                ModelView.this.resetCurrentCamera();
                ModelView.this.updateCurrentTool();
            }
            finally {
                md.endRead();
            }
            ModelView.this.d_renderComp.repaint();
        }
    }

    private class UseWireframeAction
    extends BooleanAction {
        private static final long serialVersionUID = 1L;
        private final boolean d_wireframe;

        public UseWireframeAction(String name, String desc, boolean selected, String iconLocation, boolean wireframe) {
            super(name, selected, new ImageIcon(ClassLoader.getSystemResource(iconLocation)));
            this.putValue("ShortDescription", desc);
            this.d_wireframe = wireframe;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ModelView.this.d_drawMode.props.setDrawWireframe(this.d_wireframe);
            ModelView.this.d_drawMode.props.setDrawOutlines(false);
            ModelView.this.d_drawMode.props.setShowMaterials(false);
            ModelView.this.repaint();
        }
    }

    private class SetColorOccsByAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;
        private final int d_type;

        public SetColorOccsByAction(String desc, boolean initValue, int type) {
            super(initValue, desc, null);
            this.d_type = type;
        }

        @Override
        protected void setProp(boolean selected) {
            if (!selected) {
                return;
            }
            ModelView.this.d_dispMgr.agentRenderer.setAgentColorBy(this.d_type);
            ModelView.this.d_xformDispMgr.agentRenderer.setAgentColorBy(this.d_type);
        }
    }

    private class SetEntityTypeAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;
        private final int d_type;

        public SetEntityTypeAction(String desc, boolean initValue, int type) {
            super(initValue, desc, null);
            this.d_type = type;
        }

        @Override
        protected void setProp(boolean selected) {
            if (!selected) {
                return;
            }
            ModelView.this.d_dispMgr.agentRenderer.setAgentType(this.d_type);
            ModelView.this.d_xformDispMgr.agentRenderer.setAgentType(this.d_type);
        }
    }

    private class ShowOutlinesAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;

        public ShowOutlinesAction(boolean initValue) {
            super(initValue, Intl.intl("Solid with Outlines"), Intl.intl("Show geometry as solids with outlines"), "merlin/icons/outlines.png");
        }

        @Override
        protected void setProp(boolean selected) {
            ModelView.this.d_drawMode.props.setDrawWireframe(false);
            ModelView.this.d_drawMode.props.setDrawOutlines(true);
            ModelView.this.d_drawMode.props.setShowMaterials(false);
        }
    }

    private class ShowRealisticOutlinesAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticOutlinesAction(boolean initValue) {
            super(initValue, Intl.intl("Realistic with Outlines"), Intl.intl("Show geometry using surface appearances with outlines"), "merlin/icons/texturesOutline.png");
        }

        @Override
        protected void setProp(boolean selected) {
            ModelView.this.d_drawMode.props.setDrawWireframe(false);
            ModelView.this.d_drawMode.props.setDrawOutlines(true);
            ModelView.this.d_drawMode.props.setShowMaterials(true);
        }
    }

    private class ShowRealisticAction
    extends SetPropAction {
        private static final long serialVersionUID = 1L;

        public ShowRealisticAction(boolean initValue) {
            super(initValue, Intl.intl("Realistic"), Intl.intl("Show geometry using surface appearances"), "merlin/icons/textures.png");
        }

        @Override
        protected void setProp(boolean selected) {
            ModelView.this.d_drawMode.props.setDrawWireframe(false);
            ModelView.this.d_drawMode.props.setDrawOutlines(false);
            ModelView.this.d_drawMode.props.setShowMaterials(true);
        }
    }

    private abstract class SetPropAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public SetPropAction(boolean initValue, String name, String icon) {
            super(false, name, initValue, icon == null ? null : new ImageIcon(ClassLoader.getSystemResource(icon)));
        }

        public SetPropAction(boolean initValue, String name, String desc, String icon) {
            this(initValue, name, icon);
            this.putValue("ShortDescription", desc);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void work(MerlinData data, boolean selected) {
            Application.getApp().beginWaitCursor();
            try (MerlinData.ReadLock ignored = data.lockRead();){
                this.setProp(selected);
                ModelView.this.repaint();
            }
            finally {
                Native.manager.flush();
                Application.getApp().endWaitCursor();
            }
        }

        protected abstract void setProp(boolean var1);
    }

    private class BlockageDrawOptionsAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final EnumSet<IMerlinDispProps.BlockageOptions> d_options;

        public BlockageDrawOptionsAction(String name, String tooltip, EnumSet<IMerlinDispProps.BlockageOptions> options, boolean initValue) {
            super(false, name, initValue, null);
            if (tooltip != null) {
                this.putValue("ShortDescription", tooltip);
            }
            this.d_options = options;
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            ModelView.this.d_dispProps.setBlockageOptions(this.d_options, selected);
            ModelView.this.updateAll(EgressBlockage.class);
            ModelView.this.repaint();
        }
    }

    private class DoorDrawOptionsAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final int d_options;

        public DoorDrawOptionsAction(String name, int options, boolean initValue) {
            super(false, name, initValue, null);
            this.d_options = options;
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            ModelView.this.d_dispProps.setDoorDrawOptions(this.d_options, selected);
            ModelView.this.updateAll(EgressCorridor.class);
            ModelView.this.updateAll(IEgressConnector.class);
            ModelView.this.repaint();
        }
    }

    private class CorrDrawOptionsAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final int d_options;

        public CorrDrawOptionsAction(String name, int options, boolean initValue) {
            super(false, name, initValue, null);
            this.d_options = options;
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            ModelView.this.d_dispProps.setStairDrawOptions(this.d_options, selected);
            ModelView.this.updateAll(EgressCorridor.class);
            ModelView.this.repaint();
        }
    }

    private static class FilterAction<T extends IMerlinObj>
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private final Class<T> d_type;
        private final Icon d_onIcon;
        private final Icon d_offIcon;
        private final Predicate<T> d_filter;

        public FilterAction(String name, Icon icon, boolean initValue, Class<T> type, Predicate<T> filter) {
            super(true, name, initValue, icon);
            this.d_type = type;
            this.d_filter = filter;
            this.d_onIcon = ModelView.createVisibilityIcon(icon, guiUtil.loadMerlinIcon("lightbulb16.png", 8));
            this.d_offIcon = ModelView.createVisibilityIcon(icon, guiUtil.loadMerlinIcon("lightbulb_off16.png", 8));
            this.updateIcon();
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            ModelView.setVisible(MerlinApp.getApp(), data, this.d_type, this.d_filter, selected);
        }

        public void update(MerlinData data) {
            this.setSelected(!data.displayFilter.isRegisteredFilter(this.d_type, this.d_filter));
        }

        public void updateIcon() {
            this.putValue("SmallIcon", this.isSelected() ? this.d_onIcon : this.d_offIcon);
        }

        @Override
        protected void stateChanged() {
            super.stateChanged();
            this.updateIcon();
        }
    }

    private static class DescendentFilter<T extends IMerlinObj>
    implements Predicate<T> {
        private final MerlinData d_data;
        private final IMerlinObj d_root;

        public DescendentFilter(MerlinData data, IMerlinObj root) {
            this.d_data = data;
            this.d_root = root;
        }

        @Override
        public boolean test(IMerlinObj o) {
            return !this.d_data.hierarchy.isDescendent(this.d_root, o);
        }
    }

    private class ToolUpdateBoolAction
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;

        public ToolUpdateBoolAction(String desc, boolean initValue) {
            super(false, desc, initValue);
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            data.beginRead();
            try {
                ModelView.this.updateCurrentTool();
            }
            finally {
                ModelView.this.d_data.endRead();
            }
            ModelView.this.d_renderComp.repaint();
        }
    }

    private static class TimeAnimInfo {
        public final MVAnimSession session;
        public final Optional<Component> timeView;
        public final List<IEventObserver> observers;
        public final List<IAnimView> views;
        public final List<Integer> status;
        public final List<IAnimator> animators;

        public TimeAnimInfo(MVAnimSession session, Optional<Component> timeView, List<IEventObserver> observers, List<IAnimView> views, List<Integer> status, List<IAnimator> animators) {
            this.session = session;
            this.timeView = timeView;
            this.observers = observers;
            this.views = views;
            this.status = status;
            this.animators = animators;
        }

        private void start() {
            this.animators.forEach(this.session::addAnimator);
            this.observers.forEach(this.session.getEvents()::addObserver);
            this.views.forEach(IAnimView::connect);
            this.session.start();
        }

        private void stop() {
            this.session.stop();
            this.views.forEach(IAnimView::disconnect);
            this.observers.forEach(this.session.getEvents()::removeObserver);
            this.animators.forEach(this.session::removeAnimator);
        }
    }

    private class ChangeViewListener
    extends AMerlinBoolAction {
        private static final long serialVersionUID = 1L;
        private int d_camera;

        public ChangeViewListener(String name, String desc, String iconLocation, int c) {
            super(false, name, false, new ImageIcon(ClassLoader.getSystemResource(iconLocation)));
            this.putValue("ShortDescription", desc);
            this.d_camera = c;
        }

        @Override
        protected void work(MerlinData data, boolean selected) {
            if (!selected) {
                return;
            }
            ModelView.this.setMainCamera(ModelView.this.d_cameras[this.d_camera]);
            ModelView.this.d_renderComp.repaint();
        }
    }

    private static class EditSketchGridSpacingOp
    extends AMerlinOp {
        private EditSketchGridSpacingOp() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run(MerlinApp app, MerlinData md) {
            UnitDouble spacing;
            md.beginRead();
            try {
                spacing = md.viewProps.get(ViewProps.SKETCH_GRID_SPACING);
            }
            finally {
                md.endRead();
            }
            ValueField<UnitDouble> field = MerlinValueFields.udFld(UnitDoubleVR.above(0.0, SI.METER, false), 0);
            guiInputDlg<UnitDouble> dlg = new guiInputDlg<UnitDouble>((Window)MerlinApp.getApp().getMainFrame(), Intl.intl("Edit Snap Grid"), Intl.intl("Snap grid spacing:"), field, spacing, UnitDouble.class);
            if (dlg.doModal() != 1) {
                return;
            }
            UnitDouble newSpacing = dlg.getValue();
            if (newSpacing == null) {
                return;
            }
            md.beginWrite();
            Undo.begin(Intl.intl("Edit Snap Grid"));
            try {
                Undo.insertUndoEntry_restore(md, md.viewProps);
                md.viewProps.setIfNotDefault(ViewProps.SKETCH_GRID_SPACING, newSpacing);
            }
            finally {
                Undo.end(md);
                md.endWrite();
            }
        }
    }

    private static class SelPanelToolAction
    extends guiAction {
        private static final long serialVersionUID = 1L;
        public final ToolManager.ToolAction action;

        public SelPanelToolAction(ToolManager.ToolAction action) {
            super("", null, e -> action.setSelected(!action.isSelected()));
            this.action = action;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.action.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.action.removePropertyChangeListener(listener);
        }

        @Override
        public Object getValue(String key) {
            return this.action.getValue(key);
        }

        @Override
        public void putValue(String key, Object value) {
            if (this.action != null) {
                this.action.putValue(key, value);
            }
        }

        @Override
        public boolean isEnabled() {
            return this.action.isEnabled();
        }

        @Override
        public void setEnabled(boolean b) {
            this.action.setEnabled(b);
        }

        public Tool getTool() {
            return this.action.getTool();
        }
    }

    private static class DrawMode {
        public Tool currentTool;
        public SceneRenderOptions props = new SceneRenderOptions();

        private DrawMode() {
        }
    }
}

