/*
 * Decompiled with CFR 0.152.
 */
package merlin.legacy.v0013.data.geom;

import java.awt.Color;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import merlin.data.ICompElement;
import merlin.data.ImportedGeom;
import merlin.data.NamedMerlinObj;
import merlin.geom.IMerlinGeomSrc;
import merlin.legacy.v0013.data.geom.GeomMeta;
import merlin.legacy.v0013.data.geom.IGeom;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.UniformProps;
import thunderheadeng.util.HashPool;
import thunderheadeng.util.Meta;

public abstract class AGeom
extends NamedMerlinObj
implements IGeom,
Serializable {
    static final long serialVersionUID = 1L;
    public boolean d_visible = true;
    public Matrix4d d_localToWorldXform = null;
    public Meta d_meta;
    private static final IPrimProps s_defProps = new IPrimProps.GenericProps(Color.WHITE, null, 1.0, IPrimProps.DEF_STIPPLE, 1.0, 0);
    private static final IPropsSrc s_defPropsSrc = new UniformProps(s_defProps);

    protected abstract thunderheadeng.geometry.objs.IGeom convertGeom();

    protected IPropsSrc convertProps(HashPool<IPrimProps> propsPool, thunderheadeng.geometry.objs.IGeom geom) {
        int primTypes = AGeom.getPrimTypes(geom);
        if (primTypes == 0) {
            return DisplayGeom.EMPTY.props;
        }
        return this.convertMetaToSrc(propsPool, primTypes);
    }

    @Override
    public ICompElement fromLegacy(HashPool<IPrimProps> propsPool) {
        thunderheadeng.geometry.objs.IGeom geom = this.convertGeom();
        IPropsSrc props = this.convertProps(propsPool, geom);
        ImportedGeom newObj = new ImportedGeom(this.getName(), new DisplayGeom((IGeomNode)GeomNodeUtil.newNode(geom), props));
        return this.fromLegacy(newObj);
    }

    protected <T extends IMerlinGeomSrc> T fromLegacy(T obj) {
        if (this.d_localToWorldXform != null && !this.d_localToWorldXform.equals(GeomConstants.IDENTITY4d)) {
            obj.transform(new TransformInfo(this.d_localToWorldXform));
        }
        obj.setVisible(this.d_visible);
        return obj;
    }

    protected IPrimProps convertMeta(HashPool<IPrimProps> propsPool, int primTypes, boolean cullFace) {
        IPrimProps.AProps props;
        if (this.d_meta == null) {
            return s_defProps;
        }
        Color color = (Color)this.d_meta.get(GeomMeta.COLOR);
        Double lineWidth = (Double)this.d_meta.get(GeomMeta.LINE_WIDTH);
        Double pointSize = (Double)this.d_meta.get(GeomMeta.POINT_SIZE);
        switch (primTypes) {
            case 4: {
                props = new IPrimProps.Vertex(color, pointSize);
                break;
            }
            case 2: {
                props = new IPrimProps.Edge(color, lineWidth, IPrimProps.DEF_STIPPLE, 0);
                break;
            }
            case 1: {
                props = new IPrimProps.Face(color, null, cullFace ? 2 : 0);
                break;
            }
            default: {
                props = new IPrimProps.GenericProps(color, null, lineWidth, IPrimProps.DEF_STIPPLE, pointSize, 0);
            }
        }
        return propsPool.getExisting(props);
    }

    protected IPropsSrc convertMetaToSrc(HashPool<IPrimProps> propsPool, int primTypes) {
        if (this.d_meta == null) {
            return s_defPropsSrc;
        }
        return new UniformProps(this.convertMeta(propsPool, primTypes, false));
    }

    protected static int getPrimTypes(thunderheadeng.geometry.objs.IGeom geom) {
        int[] allTypes = new int[]{1, 2, 4};
        int types = 0;
        for (int type : allTypes) {
            int np = geom.getNumPrims(type);
            if (np <= 0) continue;
            types |= np;
        }
        return types;
    }
}

