/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui.value;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import merlin.Intl;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.ImpulseFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.data.value.RandomizedImpulseFunction1d;
import merlin.gui.value.ByTimeFlowrateEditor;
import merlin.gui.value.ConstFunction1dEditor;
import merlin.gui.value.FixedValEditor;
import merlin.gui.value.IValEditor;
import merlin.gui.value.MultiValEditor;
import merlin.gui.value.PiecewiseFunction1dEditor;
import merlin.gui.value.PopupValEditor;
import merlin.gui.value.ScheduledFlowrateEditor;
import thunderheadeng.util.theUtil;

public class Function1dEditorFactory {
    public static final EnumSet<Type> GENERAL_TYPES = theUtil.filterEnum(Type.class, t -> t.general);
    public static final EnumSet<Type> OCC_FLOWRATE_TYPES = theUtil.filterEnum(Type.class, t -> t.occFlowrate);

    public static IValEditor<IFunction1d> nonNullable(Function1dProp prop, boolean verbose, Supplier<IFunction1d> nullConverter, EnumSet<Type> types) {
        return new MultiValEditor(IFunction1d.class, Function1dEditorFactory.getEntries(prop, verbose, nullConverter, types), false);
    }

    public static IValEditor<IFunction1d> nullable(Function1dProp prop, boolean verbose, String nullName, String nullDesc, Supplier<IFunction1d> nullConverter, EnumSet<Type> types) {
        ArrayList entries = new ArrayList();
        FixedValEditor<Object> nullEditor = new FixedValEditor<Object>(IFunction1d.class, null);
        entries.add(new MultiValEditor.Entry<IFunction1d, IFunction1d>(nullName, nullDesc, nullEditor, o -> o == null, () -> true, o -> null));
        entries.addAll(Function1dEditorFactory.getEntries(prop, verbose, nullConverter, types));
        return new MultiValEditor(IFunction1d.class, entries, false);
    }

    public static List<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> getEntries(Function1dProp prop, boolean verbose, Supplier<IFunction1d> nullSupplier, EnumSet<Type> types) {
        ArrayList<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> entries = new ArrayList<MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>>();
        for (Type type : types) {
            type.getEntries.get(prop, verbose, nullSupplier, entries::add);
        }
        return entries;
    }

    private static void getPredefEntries(Function1dProp prop, Consumer<? super MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> entries) {
        for (Function1dProp.PredefFunction predef : prop.predef) {
            FixedValEditor<IFunction1d> editor = new FixedValEditor<IFunction1d>(IFunction1d.class, predef.func.apply(null));
            MultiValEditor.Entry<IFunction1d, IFunction1d> entry = new MultiValEditor.Entry<IFunction1d, IFunction1d>(predef.shortDesc, predef.longDesc, editor, f -> Function1dEditorFactory.safeEquals(predef.func, f), () -> true, f -> predef.func.apply(null));
            entries.accept(entry);
        }
    }

    private static boolean safeEquals(Function<Component, IFunction1d> func, IFunction1d f) {
        IFunction1d other = func.apply(null);
        if (other == null) {
            return f == null;
        }
        return other.equals(f);
    }

    private static MultiValEditor.Entry<IFunction1d, PiecewiseFunction1d> getPiecewiseEntry(Function1dProp prop, boolean popup, Supplier<IFunction1d> nullSupplier) {
        return Function1dEditorFactory.getOptionalPopupEntry(prop, popup, nullSupplier, () -> new PiecewiseFunction1dEditor(prop), PiecewiseFunction1d.class, Intl.intl("From Table"), "<html>" + String.format(Intl.intl("Enter <b>%1$s</b> as a function of <b>%2$s</b>."), prop.y.desc, prop.x.desc), f -> f.toPiecewise(prop));
    }

    private static MultiValEditor.Entry<IFunction1d, ImpulseFunction1d> getPerOccEntry(Function1dProp prop, boolean popup, Supplier<IFunction1d> nullSupplier) {
        return Function1dEditorFactory.getOptionalPopupEntry(prop, popup, nullSupplier, () -> new ByTimeFlowrateEditor(prop), ImpulseFunction1d.class, Intl.intl("By Time"), "<html>" + String.format(Intl.intl("Enter the time at which each occupant enters the simulation."), new Object[0]), f -> f.toImpulse(prop));
    }

    private static MultiValEditor.Entry<IFunction1d, RandomizedImpulseFunction1d> getRandomizedFlowrateEntry(Function1dProp prop, boolean popup, Supplier<IFunction1d> nullSupplier) {
        return Function1dEditorFactory.getOptionalPopupEntry(prop, popup, nullSupplier, () -> new ScheduledFlowrateEditor(prop), RandomizedImpulseFunction1d.class, Intl.intl("Scheduled"), "<html>" + String.format(Intl.intl("Enter timed insertion intervals with optional random distributions."), new Object[0]), f -> f.toRandomizedImpulse(prop));
    }

    private static <T extends IFunction1d> MultiValEditor.Entry<IFunction1d, T> getOptionalPopupEntry(Function1dProp prop, boolean popup, Supplier<IFunction1d> nullSupplier, Supplier<? extends IValEditor<T>> popupEditor, Class<T> type, String label, String desc, Function<IFunction1d, T> convert) {
        IValEditor<T> editor;
        BooleanSupplier edit;
        if (popup) {
            PopupValEditor<IFunction1d> popupValEditor = new PopupValEditor<IFunction1d>(PopupValEditor.Mode.HTML, type, prop.desc, popupEditor, f -> Function1dEditorFactory.format(prop, f));
            edit = () -> popupValEditor.editValue();
            editor = popupValEditor;
        } else {
            editor = popupEditor.get();
            edit = () -> true;
        }
        return new MultiValEditor.Entry<IFunction1d, IFunction1d>(label, desc, editor, v -> v != null, edit, f -> {
            if (f == null) {
                f = (IFunction1d)nullSupplier.get();
            }
            return (IFunction1d)convert.apply((IFunction1d)f);
        });
    }

    private static MultiValEditor.Entry<IFunction1d, ConstFunction1d> getConstEntry(Function1dProp prop, Supplier<IFunction1d> nullSupplier) {
        ConstFunction1dEditor editor = new ConstFunction1dEditor(prop);
        return new MultiValEditor.Entry<IFunction1d, ConstFunction1d>(Intl.intl("Constant"), "<html>" + String.format(Intl.intl("Enter <b>%s</b> as a constant value."), prop.y.desc), editor, v -> v != null, () -> true, f -> {
            if (f == null) {
                f = (IFunction1d)nullSupplier.get();
            }
            return f.toConstant(prop);
        });
    }

    public static String format(Function1dProp prop, IFunction1d val) {
        if (val == null) {
            return Intl.intl("&lt;mixed&gt;");
        }
        for (Function1dProp.PredefFunction predef : prop.predef) {
            if (!Function1dEditorFactory.safeEquals(predef.func, val)) continue;
            return "&lt;" + predef.shortDesc + "&gt;";
        }
        return Intl.intl("&lt;edit&gt;");
    }

    public static interface GetEntries {
        public void get(Function1dProp var1, boolean var2, Supplier<IFunction1d> var3, Consumer<? super MultiValEditor.Entry<IFunction1d, ? extends IFunction1d>> var4);
    }

    public static enum Type {
        CONSTANT(true, true, (prop, verbose, nullSupplier, result) -> result.accept(Function1dEditorFactory.getConstEntry(prop, nullSupplier))),
        VARYING(true, true, (prop, verbose, nullSupplier, result) -> result.accept(Function1dEditorFactory.getPiecewiseEntry(prop, !verbose, nullSupplier))),
        PREDEF(false, true, (prop, verbose, nullSupplier, result) -> Function1dEditorFactory.getPredefEntries(prop, result)),
        PER_OCC(true, false, (prop, verbose, nullSupplier, result) -> result.accept(Function1dEditorFactory.getPerOccEntry(prop, !verbose, nullSupplier))),
        SCHEDULED(true, false, (prop, verbose, nullSupplier, result) -> result.accept(Function1dEditorFactory.getRandomizedFlowrateEntry(prop, !verbose, nullSupplier)));

        public final boolean occFlowrate;
        public final boolean general;
        public final GetEntries getEntries;

        private Type(boolean occFlowrate, boolean general, GetEntries getEntries) {
            this.occFlowrate = occFlowrate;
            this.general = general;
            this.getEntries = getEntries;
        }
    }
}

