/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.egress.elevators.ElevatorRoom;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.gui.SetChooser;
import thunderheadeng.util.Predicates;

public class RoomChooser
extends SetChooser<IEgressOccupiable> {
    private static final long serialVersionUID = 1L;

    public RoomChooser(MerlinData md) {
        this(md, Predicates.alwaysTrue(), false);
    }

    public RoomChooser(MerlinData md, final Predicate<? super IEgressOccupiable> filter, boolean anyAllowed) {
        super(md, Intl.intl("Rooms"), Intl.intl("none"), 1 | (anyAllowed ? 4 : 0), md.floors, IEgressOccupiable.class, new Predicate<IEgressOccupiable>(){

            @Override
            public boolean test(IEgressOccupiable o) {
                return !(o instanceof ElevatorRoom) && filter.test(o);
            }
        });
    }

    @Override
    public void setFilter(Predicate<? super IEgressOccupiable> filter) {
        super.setFilter(filter);
    }

    public void setRooms(Set<IEgressOccupiable> elevators) {
        this.setObjs(elevators);
    }

    public Set<IEgressOccupiable> getRooms() {
        return this.getObjs();
    }
}

