/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.gui.guiUtil;
import merlin.util.MerlinUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Modifiable;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventObserver;

public class PriorityChooser<T extends IMerlinObj>
extends guiPanel
implements Modifiable,
IEventObserver {
    private static final long serialVersionUID = 5777707841251118554L;
    private final MerlinData d_data;
    private boolean d_modified = false;
    private final JEditorPane d_editor;
    private final String d_desc;
    private final String d_emptyDesc;
    private final String d_nonApplicableDesc;
    private final Composite<? extends ICompElement> d_root;
    private final Class<T> d_clazz;
    private Predicate<T> d_filter;
    private Comparator<T> d_sorter;
    private List<T> d_availObjs;
    private List<T> d_objs;
    private boolean applicable = true;

    public PriorityChooser(MerlinData md, String desc, String emptyDesc, String nonApplicableDesc, Composite<? extends ICompElement> root, Class<T> clazz, Predicate<T> availFilter) {
        this.d_data = md;
        this.d_desc = desc;
        this.d_emptyDesc = emptyDesc;
        this.d_nonApplicableDesc = nonApplicableDesc;
        this.d_root = root;
        this.d_clazz = clazz;
        this.d_sorter = ObjSorter.INSTANCE;
        this.d_objs = Collections.EMPTY_LIST;
        this.d_filter = availFilter == null ? Filters.acceptAll(clazz) : availFilter;
        this.d_editor = guiUtil.newHTMLLabel();
        this.d_editor.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED && PriorityChooser.this.d_editor.isEnabled()) {
                    PriorityChooser.this.edit();
                }
            }
        });
        GridBagHelper gb = new GridBagHelper(this);
        gb.addRow(this.d_editor, 1.0);
        gb.finalizeRows();
        this.d_data.getEvents().addObserver(this);
        this.updateAvailable();
    }

    public void setSorter(Comparator<T> sorter) {
        this.d_sorter = sorter;
        this.updateAvailable();
    }

    private void edit() {
        ArrayList<Object> fullPriority = new ArrayList<Object>(this.d_availObjs.size());
        if (this.d_objs != null) {
            fullPriority.addAll(this.d_objs);
        }
        for (IMerlinObj obj : this.d_availObjs) {
            if (this.d_objs != null && this.d_objs.contains(obj)) continue;
            fullPriority.add(obj);
        }
        Window parent = (Window)SwingUtilities.getAncestorOfClass(Window.class, this);
        EditDlg<T> dlg = new EditDlg<T>(parent, this.d_desc, this.d_root, this.d_clazz, this.d_sorter, fullPriority);
        if (dlg.doModal() != 1) {
            return;
        }
        List<T> result = dlg.get();
        if (result.equals(fullPriority)) {
            return;
        }
        this.setPriority(result);
        this.d_modified = true;
        this.getComm().touch(this);
    }

    @Override
    public void update(Events events) {
        if (events.isAffected(this.d_clazz)) {
            this.updateAvailable();
        }
    }

    public void updateAvailable() {
        this.d_availObjs = this.getAllAvailableObjs();
        if (this.d_objs != null && !this.d_objs.isEmpty()) {
            this.d_objs = new ArrayList<T>(this.d_objs);
            this.d_objs.retainAll(this.d_availObjs);
        }
        this.updateDesc();
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    @Override
    public boolean isModified() {
        return this.d_modified;
    }

    public void setFilter(Predicate<T> filter) {
        if (filter == null) {
            filter = Filters.acceptAll();
        }
        if (this.d_filter == filter) {
            return;
        }
        this.d_filter = filter;
        this.updateAvailable();
    }

    private List<T> getAllAvailableObjs() {
        ArrayList<IMerlinObj> all = new ArrayList<IMerlinObj>();
        for (IMerlinObj obj : this.d_root.getDeepMembers(this.d_clazz)) {
            if (!this.d_filter.test(obj)) continue;
            all.add(obj);
        }
        Collections.sort(all, this.d_sorter);
        return all;
    }

    public void setPriority(List<T> objs) {
        this.d_objs = objs;
        this.updateDesc();
        this.d_modified = false;
    }

    public List<T> getPriority() {
        return this.d_objs;
    }

    public void setApplicable(boolean applicable) {
        this.applicable = applicable;
        this.updateDesc();
    }

    protected void updateDesc() {
        boolean isShortened;
        Object desc = null;
        if (this.d_objs == null) {
            desc = Intl.intl("[mixed]");
        } else if (!this.applicable) {
            desc = "[" + this.d_nonApplicableDesc + "]";
        } else if (this.d_objs.isEmpty()) {
            desc = "[" + this.d_emptyDesc + "]";
        } else {
            List<T> objList = this.d_objs;
            desc = "";
            for (IMerlinObj obj : objList) {
                if (!((String)desc).isEmpty()) {
                    desc = (String)desc + "; ";
                }
                desc = (String)desc + MerlinUtil.getName(obj);
            }
        }
        FontMetrics fm = this.d_editor.getFontMetrics(this.d_editor.getFont());
        Object displayDesc = guiUtil.shorten((String)desc, 100, fm);
        boolean bl = isShortened = !((String)displayDesc).equals(desc);
        if (!this.d_availObjs.isEmpty() && this.applicable) {
            displayDesc = "<html><a href=\"blank\">" + (String)displayDesc + "</a></html>";
        }
        this.d_editor.setText((String)displayDesc);
        if (isShortened) {
            this.d_editor.setToolTipText((String)desc);
        } else {
            this.d_editor.setToolTipText(null);
        }
    }

    private static class EditDlg<T extends IMerlinObj>
    extends guiDialog {
        private static final long serialVersionUID = -6860102906872540439L;
        private Composite<? extends ICompElement> d_root;
        private final guiTable d_table;

        public EditDlg(Window parent, String desc, Composite<? extends ICompElement> root, Class<T> type, final Comparator<T> sorter, List<T> priority) {
            super(parent, desc, 9);
            this.setResizable(true);
            this.d_root = root;
            final JButton up = new JButton(Intl.intl("Move Up"));
            up.addActionListener(new PriorityButtonListener(-1));
            final JButton down = new JButton(Intl.intl("Move Down"));
            down.addActionListener(new PriorityButtonListener(1));
            JButton sortDown = new JButton(Intl.intl("Sort top-down"));
            sortDown.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    List objs = this.get();
                    Collections.sort(objs, sorter);
                    this.set(objs);
                }
            });
            guiDefaultTableModel model = new guiDefaultTableModel(priority.size(), 1, false, priority.size(), false, 1);
            model.setColumnClass(type);
            this.d_table = new guiTable((TableModel)model, 16);
            this.d_table.getColumnModel().getColumn(0).setHeaderValue(desc);
            this.d_table.setDefaultRenderer(type, new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 6588290907242155103L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.setText(MerlinUtil.getName((IMerlinObj)value));
                    return this;
                }
            });
            this.d_table.setColumnEditable(0, false);
            JScrollPane sp = new JScrollPane(this.d_table);
            GridBagHelper gb = new GridBagHelper(this.getDialogPane());
            gb.addFilledRow(sp);
            gb.addRow(new Object[]{up, GridBagHelper.Anchor.CENTER, down, GridBagHelper.Anchor.CENTER});
            gb.addRow(new Object[]{sortDown, 0, GridBagHelper.Anchor.CENTER});
            gb.finalizeRows();
            this.set(priority);
            this.d_table.autoSizeColumns();
            sp.setPreferredSize(new Dimension(sp.getPreferredSize().width, 200));
            this.d_table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.updateButtonStates(up, down);
                }
            });
            this.updateButtonStates(up, down);
        }

        private void updateButtonStates(JButton up, JButton down) {
            boolean enabled = this.d_table.getSelectedRowCount() > 0;
            up.setEnabled(enabled);
            down.setEnabled(enabled);
        }

        public void set(List<T> priority) {
            guiDefaultTableModel model = (guiDefaultTableModel)this.d_table.getModel();
            for (int m = 0; m < priority.size(); ++m) {
                model.setValueAt(priority.get(m), m, 0);
            }
        }

        public List<T> get() {
            ArrayList<IMerlinObj> newPriority = new ArrayList<IMerlinObj>(this.d_table.getModel().getRowCount());
            for (int m = 0; m < this.d_table.getModel().getRowCount(); ++m) {
                IMerlinObj obj = (IMerlinObj)this.d_table.getModel().getValueAt(m, 0);
                newPriority.add(obj);
            }
            return newPriority;
        }

        private class PriorityButtonListener
        implements ActionListener {
            private final int d_dir;

            public PriorityButtonListener(int dir) {
                this.d_dir = dir;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                int insertIx;
                List priority = EditDlg.this.get();
                int[] selRows = EditDlg.this.d_table.getSelectedRows();
                Arrays.sort(selRows);
                int n = insertIx = this.d_dir == -1 ? selRows[0] - 1 : selRows[selRows.length - 1] - selRows.length + 2;
                if (insertIx < 0) {
                    insertIx = 0;
                } else if (insertIx >= priority.size() - selRows.length) {
                    insertIx = priority.size() - selRows.length;
                }
                ArrayList<IMerlinObj> modObjs = new ArrayList<IMerlinObj>(selRows.length);
                for (int selRow : selRows) {
                    modObjs.add((IMerlinObj)priority.get(selRow));
                }
                priority.removeAll(modObjs);
                priority.addAll(insertIx, modObjs);
                EditDlg.this.set(priority);
                EditDlg.this.d_table.setRowSelectionInterval(insertIx, insertIx + modObjs.size() - 1);
            }
        }
    }

    private static class ObjSorter<T extends IMerlinObj>
    implements Comparator<T> {
        public static final ObjSorter<?> INSTANCE = new ObjSorter();

        private ObjSorter() {
        }

        @Override
        public int compare(T o1, T o2) {
            return MerlinUtil.getName(o1).compareToIgnoreCase(MerlinUtil.getName(o2));
        }
    }
}

