/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.MerlinPrefs;
import merlin.actions.AMerlinOp;
import merlin.actions.AddObject;
import merlin.actions.Delete;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.data.Composite;
import merlin.data.ICompElement;
import merlin.data.INamed;
import merlin.data.MerlinData;
import merlin.data.egress.agents.OccProfile;
import merlin.data.egress.agents.VehicleShape;
import merlin.gui.guiUtil;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import merlin.io.MerlinOOS;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.theUtil;

public class LibraryDlg
extends guiDialog {
    private static final long serialVersionUID = 4159924215120436555L;
    private static final String libExtension = "plib";
    private static final String pthExtension = "pth";
    private final String d_predefinedLibInstallPath;
    private final String d_predefinedLibAppDataPath;
    private static final String CUSTOM_LIB = Intl.intl("Custom");
    private JList<OccProfile> d_modelObjs;
    private JList<OccProfile> d_libObjs;
    private JButton d_loadFromLibBtn;
    private JButton d_saveToLibBtn;
    private JButton d_chooseLibBtn;
    private JButton d_saveLibBtn;
    private JButton d_newLibBtn;
    private JButton d_deleteModelObjBtn;
    private JButton d_deleteLibObjBtn;
    private guiComboBox d_predefinedCb;
    private guiLabel d_libLbl;
    private boolean d_libUnsaved;
    private String d_currentLib = "";
    private List<OccProfile> d_libModel;
    private List<OccProfile> d_curModel;
    private MerlinData d_md;
    private boolean d_readOnly;
    private Runnable d_updateMgr;
    private boolean d_cbListenerListening = true;

    public LibraryDlg(JFrame owner, MerlinData md) {
        this(owner, md, null);
    }

    public LibraryDlg(JFrame owner, MerlinData md, Runnable updateMgr) {
        super((Window)owner, Intl.intl("Profile Libraries"), 16);
        this.d_md = md;
        this.d_updateMgr = updateMgr;
        Collection<OccProfile> profiles = md.profiles.flatten(OccProfile.class);
        this.d_curModel = new ArrayList<OccProfile>();
        this.d_curModel.addAll(profiles);
        this.d_libModel = new ArrayList<OccProfile>();
        this.d_modelObjs = new JList(new DefaultListModel());
        this.d_libObjs = new JList(new DefaultListModel());
        JScrollPane currentObjsSP = new JScrollPane(this.d_modelObjs);
        JScrollPane libSP = new JScrollPane(this.d_libObjs);
        currentObjsSP.setVerticalScrollBarPolicy(22);
        libSP.setVerticalScrollBarPolicy(22);
        currentObjsSP.getViewport().setScrollMode(2);
        libSP.getViewport().setScrollMode(2);
        Dimension listSize = new Dimension(170, 200);
        libSP.setPreferredSize(listSize);
        currentObjsSP.setPreferredSize(listSize);
        this.d_loadFromLibBtn = new JButton("<--");
        this.d_saveToLibBtn = new JButton("-->");
        this.d_chooseLibBtn = new JButton(Intl.intl("Load Library..."));
        this.d_saveLibBtn = new JButton(Intl.intl("Save Current Library..."));
        this.d_newLibBtn = new JButton(Intl.intl("Create New Library"));
        this.d_deleteModelObjBtn = new JButton(Intl.intl("Delete Selected Objects..."));
        this.d_deleteLibObjBtn = new JButton(Intl.intl("Delete Selected Objects..."));
        this.d_chooseLibBtn.addActionListener(new LoadLibraryAction());
        this.d_saveToLibBtn.addActionListener(new SaveToLibraryAction());
        this.d_loadFromLibBtn.addActionListener(new LoadFromLibraryAction());
        this.d_saveLibBtn.addActionListener(new SaveLibraryAction());
        this.d_newLibBtn.addActionListener(new CreateLibraryAction());
        this.d_predefinedLibInstallPath = new File(MerlinApp.getApp().getInstallDir(), "lib/profiles").getPath();
        this.d_predefinedLibAppDataPath = new File(MerlinApp.getApp().getAppDataDir(), "profiles").getPath();
        this.d_predefinedCb = new guiComboBox();
        this.d_predefinedCb.addItemListener(e -> this.listenToCbChanges(e));
        guiLabel currentSurfsL = new guiLabel(Intl.intl("Current Model"));
        this.d_libLbl = new guiLabel(Intl.intl("Library - \"untitled\""));
        Dimension libDim = this.d_libLbl.getPreferredSize();
        libDim.width = listSize.width;
        this.d_libLbl.setPreferredSize(libDim);
        int row = 0;
        guiPanel libPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(libPanel, this.d_libLbl, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_predefinedCb, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, libSP, 0, row++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(libPanel, this.d_newLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_chooseLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_saveLibBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(libPanel, this.d_deleteLibObjBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        row = 0;
        guiPanel modelPanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(modelPanel, currentSurfsL, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        GridBagUtil.add(modelPanel, currentObjsSP, 0, row++, 1, 1, 0, 12, 6, 12, 1, 1.0, 1.0, 17);
        GridBagUtil.add(modelPanel, this.d_deleteModelObjBtn, 0, row++, 1, 1, 0, 12, 6, 12, 2, 1.0, 0.0, 17);
        JPanel arrowPanel = new JPanel(new GridLayout(2, 1, 0, 6));
        arrowPanel.add(this.d_loadFromLibBtn);
        arrowPanel.add(this.d_saveToLibBtn);
        row = 0;
        guiPanel managePanel = new guiPanel(new GridBagLayout());
        GridBagUtil.add(managePanel, modelPanel, 0, 1, 1, 4, 0, 0, 6, 0, 3, 0.0, 1.0, 17);
        GridBagUtil.add(managePanel, arrowPanel, 1, 1, 1, 4, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(managePanel, libPanel, 2, 1, 1, 4, 0, 0, 6, 0, 3, 0.0, 1.0, 17);
        guiPanel mainPanel = this.getDialogPane();
        mainPanel.setLayout(new GridBagLayout());
        GridBagUtil.add(mainPanel, managePanel, 0, 2, 10, 1, 0, 0, 6, 6, 1, 1.0, 1.0, 17);
        ListSelectionListener updateSelAction = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                LibraryDlg.this.updateActions();
            }
        };
        this.d_modelObjs.addListSelectionListener(updateSelAction);
        this.d_libObjs.addListSelectionListener(updateSelAction);
        DeleteModelObjectsAction deleteModelListener = new DeleteModelObjectsAction();
        DeleteLibraryObjectsAction deleteLibListener = new DeleteLibraryObjectsAction();
        this.d_modelObjs.addKeyListener(deleteModelListener);
        this.d_libObjs.addKeyListener(deleteLibListener);
        this.d_deleteLibObjBtn.addActionListener(deleteLibListener);
        this.d_deleteModelObjBtn.addActionListener(deleteModelListener);
        ManagerRenderer renderer = new ManagerRenderer();
        this.d_modelObjs.setCellRenderer(renderer);
        this.d_libObjs.setCellRenderer(renderer);
        this.d_saveToLibBtn.setEnabled(false);
        this.d_loadFromLibBtn.setEnabled(false);
        this.d_deleteModelObjBtn.setEnabled(false);
        this.d_deleteLibObjBtn.setEnabled(false);
        this.loadList(this.d_curModel, this.d_modelObjs);
    }

    private void listenToCbChanges(final ItemEvent e) {
        if (e.getStateChange() == 1) {
            Runnable handleSelection = new Runnable(){
                final boolean isListening;
                {
                    this.isListening = LibraryDlg.this.d_cbListenerListening;
                }

                @Override
                public void run() {
                    MerlinApp.getApp().beginWaitCursor();
                    String item = (String)e.getItem();
                    if (this.isListening) {
                        if (LibraryDlg.this.checkSaveNewLib()) {
                            if (item == CUSTOM_LIB) {
                                String curLib = MerlinPrefs.get(MerlinPrefs.LIB_DLG_LAST_LIB);
                                if (curLib != null && LibraryDlg.this.loadLibraryModel(curLib, false)) {
                                    LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                                } else {
                                    LibraryDlg.this.resetSelection();
                                }
                            } else {
                                String filePath = new File(LibraryDlg.this.d_predefinedLibInstallPath, item).getPath();
                                if (LibraryDlg.this.loadLibraryModel(filePath, true)) {
                                    LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                                } else {
                                    filePath = new File(LibraryDlg.this.d_predefinedLibAppDataPath, item).getPath();
                                    if (LibraryDlg.this.loadLibraryModel(filePath, true)) {
                                        LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                                    } else {
                                        LibraryDlg.this.resetSelection();
                                    }
                                }
                            }
                            LibraryDlg.this.d_libUnsaved = false;
                        } else {
                            LibraryDlg.this.setListening(false);
                            LibraryDlg.this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
                            LibraryDlg.this.d_libUnsaved = true;
                            LibraryDlg.this.setListening(true);
                        }
                    }
                    LibraryDlg.this.updateActions();
                    MerlinApp.getApp().endWaitCursor();
                }
            };
            EventQueue.invokeLater(handleSelection);
        }
    }

    private void resetSelection() {
        this.setListening(false);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
        this.d_libModel = new ArrayList<OccProfile>();
        this.loadList(this.d_libModel, this.d_libObjs);
        this.setCurrentLibrary("untitled.plib", false);
        this.setListening(true);
    }

    private void updateActions() {
        boolean modSel = !this.d_modelObjs.isSelectionEmpty();
        boolean libSel = !this.d_libObjs.isSelectionEmpty();
        this.d_deleteLibObjBtn.setEnabled(libSel && !this.d_readOnly);
        this.d_loadFromLibBtn.setEnabled(libSel);
        this.d_deleteModelObjBtn.setEnabled(modSel);
        this.d_saveToLibBtn.setEnabled(modSel && !this.d_readOnly);
    }

    private boolean checkSaveNewLib() {
        int selection;
        return !this.d_libUnsaved || !((selection = JOptionPane.showConfirmDialog(this, Intl.intl("The current library has not been saved.  Would you like to do so now?"), Intl.intl("Save New Library") + "?", 1)) == 0 ? !this.saveLibrary() : selection == 2 || selection == -1);
    }

    public boolean saveLibrary() {
        File newLibFile = this.serialize(this.d_libModel);
        if (newLibFile == null) {
            return false;
        }
        this.setCurrentLibrary(newLibFile.getAbsolutePath(), false);
        this.d_libUnsaved = false;
        return true;
    }

    private File serialize(List<OccProfile> profiles) {
        MerlinApp app = MerlinApp.getApp();
        File f = guiUtil.getSaveFile(app, this.d_md, MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, this.d_md.getNewFilename(".plib"), libExtension, Intl.intl("Pathfinder Library"));
        if (f == null) {
            return null;
        }
        MerlinData tempmd = new MerlinData(false);
        tempmd.profiles.clear();
        tempmd.profiles.addAll(profiles);
        try (MerlinOOS oos = new MerlinOOS(new FileOutputStream(f));){
            oos.writeObject(tempmd);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), Intl.intl("Error"), 2);
            e.printStackTrace();
        }
        return f;
    }

    private List<OccProfile> deserialize(String filename, boolean showWarnings) {
        try {
            MerlinIO io = new MerlinIO();
            MerlinIO.OpenResult result = io.openModel(this, filename, progress -> progress.cancel(), MerlinOIS.DM_DEFAULT);
            return new ArrayList<OccProfile>(result.data.profiles.flatten(OccProfile.class));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(MerlinApp.getApp().getActiveFrame(), String.format(Intl.intl("The file \"%s\" could not be read."), filename));
            }
            return null;
        }
    }

    public boolean loadLibraryModelFromFile(String filename, boolean showWarnings) {
        List<OccProfile> newLibModel = this.deserialize(filename, showWarnings);
        if (newLibModel != null) {
            this.d_libModel = newLibModel;
        }
        return newLibModel != null;
    }

    private boolean loadLibraryModel() {
        if (!this.checkSaveNewLib()) {
            return false;
        }
        File f = guiUtil.getOpenFile((Component)this, this.d_md, MerlinPrefs.LIB_DLG_OPEN_DIR_PREF, libExtension, Intl.intl("Pathfinder Profile Library"), pthExtension, Intl.intl("Pathfinder Model File (Read-only)"));
        if (f == null) {
            return false;
        }
        return this.loadLibraryModel(f.getAbsolutePath(), false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadLibraryModel(String filename, boolean predefined) {
        try {
            this.beginWaitCursor();
            if (!this.loadLibraryModelFromFile(filename, true)) {
                boolean bl = false;
                return bl;
            }
            this.setCurrentLibrary(filename, predefined);
            boolean bl = true;
            return bl;
        }
        finally {
            this.endWaitCursor();
        }
    }

    private void setCurrentLibrary(String lib, boolean predefined) {
        this.d_currentLib = lib;
        File f = new File(this.d_currentLib);
        boolean bl = this.d_readOnly = predefined || !FilenameManager.splitFilename(lib)[1].toLowerCase().equals(libExtension);
        if (this.d_readOnly && !predefined) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("Library %s is open for reading only."), f.getName()), Intl.intl("Read-only Access"), 1);
        }
        String libLabel = String.format(Intl.intl("Library: %s"), f.getName());
        String fullLabel = String.format(Intl.intl("Library: %s"), f.getAbsolutePath());
        this.d_libLbl.setText(libLabel);
        this.d_libLbl.setToolTipText(fullLabel);
        if (!predefined) {
            MerlinPrefs.set(MerlinPrefs.LIB_DLG_LAST_LIB, lib);
        }
    }

    private void setListening(boolean listening) {
        this.d_cbListenerListening = listening;
    }

    public void createLibrary() {
        if (!this.checkSaveNewLib()) {
            return;
        }
        this.d_libModel = new ArrayList<OccProfile>();
        this.d_libUnsaved = true;
        this.setCurrentLibrary("untitled.plib", false);
        this.setListening(false);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
        this.setListening(true);
    }

    public List<OccProfile> copyListSelection(JList<OccProfile> jlistBeingCopied, JList<OccProfile> jlistCopiedTo, List<OccProfile> containerCopiedTo) {
        List<OccProfile> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<OccProfile, OccProfile> replacements = new LinkedHashMap<OccProfile, OccProfile>();
        for (OccProfile prof : objsToCopy) {
            String newName = this.getNewName(prof, containerCopiedTo);
            OccProfile newProf = prof.clone();
            if (!newName.equals(prof.getName())) {
                newProf.setName(newName);
            }
            replacements.put(prof, newProf);
        }
        for (OccProfile prof : replacements.keySet()) {
            int replIndex = objsToCopy.indexOf(prof);
            objsToCopy.remove(replIndex);
            objsToCopy.add(replIndex, (OccProfile)replacements.get(prof));
        }
        containerCopiedTo.addAll(objsToCopy);
        this.loadList(containerCopiedTo, jlistCopiedTo);
        return objsToCopy;
    }

    private String getNewName(INamed namedObj, Collection<? extends INamed> containerCopiedTo) {
        String baseName = namedObj.getName();
        Object newName = baseName;
        int i = 1;
        boolean alreadyExists = false;
        do {
            alreadyExists = false;
            for (INamed iNamed : containerCopiedTo) {
                if (!iNamed.getName().equals(newName)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) continue;
            newName = baseName + " (" + i++ + ")";
        } while (alreadyExists);
        return newName;
    }

    private void loadList(List<OccProfile> from, JList<OccProfile> to) {
        to.setListData((OccProfile[])theUtil.toArray(from, OccProfile.class));
    }

    private boolean deleteObjs(JList<OccProfile> jlist, List<OccProfile> domain) {
        List<OccProfile> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return false;
        }
        domain.removeAll(objs);
        this.loadList(domain, jlist);
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            if (!this.checkSaveNewLib()) {
                return;
            }
        } else {
            this.init();
        }
        super.setVisible(visible);
    }

    private void init() {
        MerlinApp.getApp().beginWaitCursor();
        this.loadPredefinedLibraries();
        MerlinApp.getApp().endWaitCursor();
    }

    private void loadPredefinedLibraries() {
        File[] installFolderFiles = new File(this.d_predefinedLibInstallPath).listFiles();
        File[] appDataFiles = new File(this.d_predefinedLibAppDataPath).listFiles();
        Consumer<File[]> processFiles = files -> {
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (!f.isFile() || !f.getName().endsWith(libExtension)) continue;
                this.d_predefinedCb.add(f.getName());
            }
        };
        processFiles.accept(installFolderFiles);
        processFiles.accept(appDataFiles);
        this.d_predefinedCb.add(CUSTOM_LIB);
        this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
    }

    private class DeleteLibraryObjectsAction
    extends KeyAdapter
    implements ActionListener {
        private DeleteLibraryObjectsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.delete();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                this.delete();
            } else {
                super.keyReleased(e);
            }
        }

        private void delete() {
            if (LibraryDlg.this.deleteObjs(LibraryDlg.this.d_libObjs, LibraryDlg.this.d_libModel)) {
                LibraryDlg.this.d_libUnsaved = true;
            }
        }
    }

    private class DeleteModelObjectsAction
    extends KeyAdapter
    implements ActionListener {
        private DeleteModelObjectsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            this.delete(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_curModel);
        }

        private void delete(final JList<OccProfile> modelObjs, final List<OccProfile> curModel) {
            final List<OccProfile> objs = modelObjs.getSelectedValuesList();
            AMerlinOp op = new AMerlinOp(){

                @Override
                public void run(MerlinApp app, MerlinData md) {
                    Delete.uiDelete(MerlinApp.getApp(), md, new HashSet(objs), true);
                    curModel.clear();
                    LibraryDlg.this.d_md.beginRead();
                    curModel.addAll(LibraryDlg.this.d_md.profiles.flatten(OccProfile.class));
                    LibraryDlg.this.d_md.endRead();
                    LibraryDlg.this.loadList(curModel, modelObjs);
                    if (LibraryDlg.this.d_updateMgr != null) {
                        LibraryDlg.this.d_updateMgr.run();
                    }
                }
            };
            UIHook.run(LibraryDlg.this, "LibraryDlg.DeleteAction.actionPerformed", op, 0);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                this.delete(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_curModel);
            } else {
                super.keyReleased(e);
            }
        }
    }

    private class ManagerRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -7049889130747457100L;

        private ManagerRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            guiUtil.decorateCellRenderer(LibraryDlg.this.d_md, list::repaint, value, this, isSelected, cellHasFocus);
            OccProfile obj = (OccProfile)value;
            this.setText(obj.getName());
            return this;
        }
    }

    private class CreateLibraryAction
    implements ActionListener {
        private CreateLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryDlg.this.createLibrary();
            LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
        }
    }

    private class SaveLibraryAction
    implements ActionListener {
        private SaveLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            LibraryDlg.this.saveLibrary();
        }
    }

    private class LoadFromLibraryAction
    implements ActionListener {
        private LoadFromLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Application.getApp().beginWaitCursor();
            List<OccProfile> added = LibraryDlg.this.copyListSelection(LibraryDlg.this.d_libObjs, LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_curModel);
            if (!added.isEmpty()) {
                LibraryDlg.this.d_md.pauseUpdates();
                Undo.begin(Intl.intl("New Profile"));
                AddObject.add(LibraryDlg.this.d_md, LibraryDlg.this.d_md.profiles, LibraryDlg.this.d_md.profiles.flatten().size(), added);
                for (OccProfile prof : added) {
                    OccProfile.OccShape occShape = prof.getProperty(OccProfile.PROP_SHAPE);
                    if (!occShape.type.equals((Object)VehicleShape.ShapeType.POLYGON)) continue;
                    VehicleShape vs = occShape.vehicleShape;
                    String newName = LibraryDlg.this.getNewName(vs, LibraryDlg.this.d_md.vehicleShapes.flatten(VehicleShape.class));
                    VehicleShape newVs = vs.clone();
                    if (!newName.equals(vs.getName())) {
                        newVs.setName(newName);
                    }
                    occShape.vehicleShape = newVs;
                    prof.setProperty(OccProfile.PROP_SHAPE, occShape);
                    AddObject.add((MerlinData)LibraryDlg.this.d_md, (Composite)LibraryDlg.this.d_md.vehicleShapes, (int)LibraryDlg.this.d_md.vehicleShapes.flatten().size(), (ICompElement[])new VehicleShape[]{newVs});
                }
                Undo.end(LibraryDlg.this.d_md);
                LibraryDlg.this.d_md.resumeUpdates();
            }
            Application.getApp().endWaitCursor();
        }
    }

    private class SaveToLibraryAction
    implements ActionListener {
        private SaveToLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Application.getApp().beginWaitCursor();
            if (!LibraryDlg.this.copyListSelection(LibraryDlg.this.d_modelObjs, LibraryDlg.this.d_libObjs, LibraryDlg.this.d_libModel).isEmpty()) {
                LibraryDlg.this.d_libUnsaved = true;
            }
            Application.getApp().endWaitCursor();
        }
    }

    private class LoadLibraryAction
    implements ActionListener {
        private LoadLibraryAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (LibraryDlg.this.loadLibraryModel()) {
                LibraryDlg.this.loadList(LibraryDlg.this.d_libModel, LibraryDlg.this.d_libObjs);
                LibraryDlg.this.setListening(false);
                LibraryDlg.this.d_predefinedCb.setSelectedItem(CUSTOM_LIB);
                LibraryDlg.this.setListening(true);
                LibraryDlg.this.d_libUnsaved = false;
            }
        }
    }
}

