/*
 * Decompiled with CFR 0.152.
 */
package merlin.gui;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import merlin.Intl;
import merlin.data.egress.agents.IAvatar;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.data.egress.agents.ShapeAvatar;
import merlin.gui.AvatarChooser;
import merlin.gui.guiUtil;
import merlin.gui.value.AValEditor;
import merlin.util.BitOptions;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HTMLBtn;
import thunderheadeng.util.Property;
import thunderheadeng.util.stat.IUrn;
import thunderheadeng.util.theUtil;

public class AvatarEditor
extends AValEditor<Property<IUrn<IAvatar>>> {
    private static final long serialVersionUID = -2561265429589894624L;
    public static final int OPT_MULTI_SELECT = 1;
    public static final int OPT_NULL_AVATAR = 2;
    public static final int OPT_SHAPE_AVATAR = 4;
    private final HTMLBtn d_btn;
    private AvatarChooser d_chooser;
    private final BitOptions d_options;

    public AvatarEditor(int options, ResourceAvatar.Type type) {
        super(IUrn.class);
        this.d_options = new BitOptions(options);
        this.d_btn = new HTMLBtn("");
        this.d_chooser = null;
        this.d_btn.addActionListener(e -> {
            if (this.d_chooser == null) {
                Window parent = e.getSource() instanceof Component ? SwingUtilities.getWindowAncestor((Component)e.getSource()) : null;
                int min = 1;
                int max = this.d_options.get(1L) ? Integer.MAX_VALUE : 1;
                this.d_chooser = new AvatarChooser(parent, min, max, options, type);
            }
            this.d_chooser.setValue((Property)this.getValue());
            if (this.d_chooser.doModal() == 1) {
                this.setValue(this.d_chooser.getValue());
            }
        });
        this.d_btn.setPreferredWidth(100);
        this.d_btn.setWrapEnabled(false);
        GridBagHelper gb = new GridBagHelper(this);
        this.add(gb);
        gb.nextRow();
    }

    @Override
    public void add(GridBagHelper gb) {
        gb.add(this.d_btn, 1.0);
    }

    @Override
    protected void loadValue(Property<IUrn<IAvatar>> value) {
        if (value.isUniform()) {
            ArrayList values = new ArrayList();
            value.get().getUnique(values);
            Collections.sort(values, new AvatarComparator());
            List<String> names = theUtil.map(values, a -> {
                if (a == null) {
                    return "&lt;" + Intl.intl("hidden") + "&gt;";
                }
                return guiUtil.escapeHTML(a.getName());
            });
            Object txt = values.isEmpty() ? "&lt;" + Intl.intl("none") + "&gt;" : String.join((CharSequence)", ", names);
            this.d_btn.setText((String)txt);
        } else {
            this.d_btn.setText("&lt;" + Intl.intl("multiple") + "&gt;");
        }
    }

    @Override
    protected Property<IUrn<IAvatar>> saveValue() {
        return (Property)this.getValue();
    }

    public static class AvatarComparator
    implements Comparator<IAvatar> {
        @Override
        public int compare(IAvatar o1, IAvatar o2) {
            boolean o2null;
            boolean o1null = o1 == null;
            boolean bl = o2null = o2 == null;
            if (o1null && o2null) {
                return 0;
            }
            if (o1null) {
                return -1;
            }
            if (o2null) {
                return 1;
            }
            boolean o1shape = o1 instanceof ShapeAvatar;
            boolean o2shape = o2 instanceof ShapeAvatar;
            if (o1shape && o2shape) {
                return 0;
            }
            if (o1shape) {
                return -1;
            }
            if (o2shape) {
                return 1;
            }
            return o1.getName().compareToIgnoreCase(o2.getName());
        }
    }
}

