/*
 * Decompiled with CFR 0.152.
 */
package merlin.geom;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class MeshTransformMapper {
    private static Map<MeshHash, Pair<Mesh, Integer>> s_instanceCount = new HashMap<MeshHash, Pair<Mesh, Integer>>();

    private static void addMesh(Mesh mesh) {
        s_instanceCount.compute(new MeshHash(mesh), (mh, pair) -> pair == null ? new Pair<Mesh, Integer>(mesh, 1) : new Pair<Mesh, Integer>((Mesh)pair.v1, (Integer)pair.v2 + 1));
    }

    public static void printInstanceCounts() {
        s_instanceCount.entrySet().stream().sorted((e1, e2) -> {
            int count1 = (Integer)((Pair)e1.getValue()).v2 * ((Mesh)((Pair)e1.getValue()).v1).indices.length;
            int count2 = (Integer)((Pair)e2.getValue()).v2 * ((Mesh)((Pair)e2.getValue()).v1).indices.length;
            return count2 - count1;
        }).forEachOrdered(e -> System.out.println(e.getKey() + "=" + ((Pair)e.getValue()).v2));
    }

    private static class MeshHash {
        public final Mesh mesh;

        public MeshHash(Mesh mesh) {
            this.mesh = mesh;
        }

        public int hashCode() {
            return this.mesh.primtype + Arrays.hashCode(this.mesh.indices) + this.mesh.vertices.length;
        }

        public boolean equals(Object obj) {
            return obj instanceof MeshHash && ((MeshHash)obj).mesh.primtype == this.mesh.primtype && ((MeshHash)obj).mesh.vertices.length == this.mesh.vertices.length && Arrays.equals(((MeshHash)obj).mesh.indices, this.mesh.indices) && MeshHash.getMappingTransform(((MeshHash)obj).mesh, this.mesh) != null;
        }

        private static boolean lengthsMatch(Mesh mesh1, Mesh mesh2) {
            if (mesh1.primtype != 2 && mesh1.primtype != 3) {
                return false;
            }
            int vpp = mesh1.getNumVertsPerPrim();
            for (int m = 0; m < mesh1.indices.length; m += vpp) {
                for (int n = 0; n < vpp; ++n) {
                    Vector3d m2v2;
                    Vector3d m2v1;
                    double angle2;
                    Vector3d m1v2;
                    double dist2;
                    Point3d m1p1a = mesh1.vertices[mesh1.indices[n]];
                    Point3d m1p2a = mesh1.vertices[mesh1.indices[(n + 1) % vpp]];
                    Point3d m2p1a = mesh2.vertices[mesh2.indices[n]];
                    Point3d m2p2a = mesh2.vertices[mesh2.indices[(n + 1) % vpp]];
                    double dist1 = m1p1a.distance(m1p2a);
                    if (!theUtil.eq(dist1, dist2 = m2p1a.distance(m2p2a), 1.0E-6)) {
                        return false;
                    }
                    Point3d m1p3a = mesh1.vertices[mesh1.indices[(n + 2) % vpp]];
                    Point3d m2p3a = mesh2.vertices[mesh2.indices[(n + 2) % vpp]];
                    Vector3d m1v1 = Util3D.vector(m1p1a, m1p2a);
                    double angle1 = m1v1.angle(m1v2 = Util3D.vector(m1p2a, m1p3a));
                    if (theUtil.eq(angle1, angle2 = (m2v1 = Util3D.vector(m2p1a, m2p2a)).angle(m2v2 = Util3D.vector(m2p2a, m2p3a)), 1.0E-6)) continue;
                    return false;
                }
            }
            return true;
        }

        private static Matrix4d getMappingTransform(Mesh mesh1, Mesh mesh2) {
            if (mesh1.primtype != 2 && mesh2.primtype != 2) {
                return null;
            }
            Matrix4d xform = MeshHash.calcMappingTransform(mesh1, mesh2);
            for (int m = 0; m < mesh1.vertices.length; ++m) {
                Point3d m1p = mesh1.vertices[m];
                Point3d m2p = mesh2.vertices[m];
                Point3d xformedp = Util3D.xform(xform, m1p);
                double err = xformedp.distance(m2p);
                if (!theUtil.gt0(err, 1.0E-6)) continue;
                return null;
            }
            return xform;
        }

        private static Matrix4d calcMappingTransform(Mesh mesh1, Mesh mesh2) {
            int vpp = mesh1.getNumVertsPerPrim();
            BiFunction<Mesh, Integer, Matrix4d> triGen = (m, primIx) -> {
                Vector3d ly;
                int ioffset = vpp * primIx;
                Point3d offset = m.vertices[m.indices[ioffset]];
                Point3d[] tri = new Point3d[]{GeomConstants.PNT3D_ORIGIN, Util3D.sub(m.vertices[m.indices[ioffset + 1]], (Tuple3d)offset), Util3D.sub(m.vertices[m.indices[ioffset + 2]], (Tuple3d)offset)};
                Vector3d lx = Util3D.vector(tri[0], tri[1]);
                Vector3d lz = Util3D.cross(lx, ly = Util3D.vector(tri[0], tri[2]));
                if (lz.equals(GeomConstants.VEC3D_ZERO)) {
                    throw new IllegalArgumentException();
                }
                Matrix4d mat = new Matrix4d(lx.x, ly.x, lz.x, 0.0, lx.y, ly.y, lz.y, 0.0, lx.z, ly.z, lz.z, 0.0, 0.0, 0.0, 0.0, 1.0);
                return mat;
            };
            Matrix4d M = null;
            Matrix4d N = null;
            int numPrims = mesh1.indices.length / vpp;
            for (int pix = 0; pix < numPrims; ++pix) {
                try {
                    Matrix4d m2 = triGen.apply(mesh1, pix);
                    m2.invert();
                    Matrix4d n = triGen.apply(mesh2, pix);
                    M = m2;
                    N = n;
                    break;
                }
                catch (Throwable m2) {
                    continue;
                }
            }
            if (M == null || N == null) {
                System.err.println("Could not find a rotation mapping matrix between meshes.");
            }
            Point3d m1p1 = mesh1.vertices[mesh1.indices[0]];
            Point3d m2p1 = mesh2.vertices[mesh2.indices[0]];
            Matrix4d result = Util.translateMat(m2p1.x, m2p1.y, m2p1.z);
            if (N != null && M != null) {
                result.mul(N);
                result.mul(M);
            }
            result.mul(Util.translateMat(-m1p1.x, -m1p1.y, -m1p1.z));
            return result;
        }

        private static Matrix4d calcMappingTransform2(Mesh mesh1, Mesh mesh2) {
            int vpp = mesh1.getNumVertsPerPrim();
            Point3d m1p1 = mesh1.vertices[mesh1.indices[0]];
            Point3d m1p2 = mesh1.vertices[mesh1.indices[1]];
            Point3d m2p1 = mesh2.vertices[mesh2.indices[0]];
            Point3d m2p2 = mesh2.vertices[mesh2.indices[1]];
            block0: for (int m = 0; m < mesh1.indices.length; m += vpp) {
                for (int n = 0; n < vpp; ++n) {
                    Vector3d m2v;
                    Point3d m1p1a = mesh1.vertices[mesh1.indices[n]];
                    Point3d m1p2a = mesh1.vertices[mesh1.indices[(n + 1) % vpp]];
                    Point3d m2p1a = mesh2.vertices[mesh2.indices[n]];
                    Point3d m2p2a = mesh2.vertices[mesh2.indices[(n + 1) % vpp]];
                    Vector3d m1v = Util3D.vector(m1p1a, m1p2a);
                    Vector3d axis = Util3D.cross(m1v, m2v = Util3D.vector(m2p1a, m2p2a));
                    if (axis.epsilonEquals(GeomConstants.VEC3D_ZERO, 1.0E-6)) continue;
                    m1p1 = m1p1a;
                    m1p2 = m1p2a;
                    m2p1 = m2p1a;
                    m2p2 = m2p2a;
                    break block0;
                }
            }
            Vector3d m1v = Util3D.vector(m1p1, m1p2);
            Vector3d m2v = Util3D.vector(m2p1, m2p2);
            Vector3d axis = Util3D.cross(m1v, m2v);
            double angle = Util3D.angle(m1v, m2v, axis);
            Matrix4d xform = new Matrix4d();
            xform.setIdentity();
            xform.mul(Util.translateMat(m2p1.x, m2p1.y, m2p1.z));
            xform.mul(Util.rotMat(axis.x, axis.y, axis.z, angle));
            xform.mul(Util.translateMat(-m1p1.x, -m1p1.y, -m1p1.z));
            return xform;
        }

        public String toString() {
            return String.format("[MeshHash: %d, type=%d, icount=%d]", this.mesh.hashCode(), this.mesh.primtype, this.mesh.indices.length);
        }
    }
}

