/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.value;

import inferno.data2.value.ImpulseFunction1d;
import inferno.sim.occsource.AUCOccSourceFlowrate;
import inferno.sim.occsource.IOccSourceFlowrate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.IntStream;
import merlin.data.property.Function1dProp;
import merlin.data.value.ConstFunction1d;
import merlin.data.value.IFunction1d;
import merlin.data.value.PiecewiseFunction1d;
import merlin.unitsystem.SIUS;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ImpulseFunction1d
implements IFunction1d,
Serializable {
    private static final long serialVersionUID = 1L;
    public final UnitDouble defaultValue;
    public final List<Pulse> entries;

    public ImpulseFunction1d(UnitDouble defValue, List<Pulse> entries) {
        this.defaultValue = defValue;
        this.entries = entries;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ImpulseFunction1d f = (ImpulseFunction1d)obj;
        return this.defaultValue.equals(f.defaultValue) && this.entries.equals(f.entries);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.entries);
    }

    public static <T> PiecewiseFunction1d impulseToPiecewiseFunction(Function1dProp prop, List<T> entries, UnitDouble defaultValue, Function<T, UnitDouble> getX, Function<T, UnitDouble> getDuration, Function<T, UnitDouble> getY) {
        UnitDouble defVal;
        Unit xUnit = SIUS.unit(prop.x.unitType);
        UnitDouble minTimeBetween = new UnitDouble(Double.POSITIVE_INFINITY, xUnit);
        UnitDouble minDuration = new UnitDouble(Double.POSITIVE_INFINITY, xUnit);
        for (int m = 0; m < entries.size(); ++m) {
            UnitDouble begin2;
            T entry1 = entries.get(m);
            minDuration = UnitDouble.min(minDuration, getDuration.apply(entry1));
            if (m >= entries.size() - 1) continue;
            T entry2 = entries.get(m + 1);
            UnitDouble end1 = getX.apply(entry1).add(getDuration.apply(entry1));
            if (end1.eq(begin2 = getX.apply(entry2), 1.0E-9)) continue;
            UnitDouble dt = begin2.sub(end1);
            minTimeBetween = UnitDouble.min(minTimeBetween, dt);
        }
        UnitDouble riseTime = UnitDouble.min(minTimeBetween, minDuration).scale(0.1);
        riseTime = UnitDouble.min(riseTime, new UnitDouble(0.1, xUnit));
        UnitDouble halfRiseTime = riseTime.scale(0.5);
        UnitDouble x0 = new UnitDouble(0.0, SIUS.unit(prop.x.unitType));
        ArrayList pentries = new ArrayList(entries.size() * 4);
        BiConsumer<UnitDouble, UnitDouble> add = (x, y) -> pentries.add(new PiecewiseFunction1d.Entry((UnitDouble)x, (UnitDouble)y));
        UnitDouble prevVal = defVal = defaultValue;
        for (int m = 0; m < entries.size(); ++m) {
            UnitDouble entryEnd;
            T entry = entries.get(m);
            if (!prevVal.eq(getY.apply(entry), 1.0E-9)) {
                UnitDouble prevX = UnitDouble.max(x0, getX.apply(entry).sub(halfRiseTime));
                if (m > 0 || !prevX.equals(x0)) {
                    add.accept(prevX, prevVal);
                    add.accept(getX.apply(entry).add(halfRiseTime), getY.apply(entry));
                }
            }
            if ((entryEnd = getX.apply(entry).add(getDuration.apply(entry))).isInfinite()) {
                UnitDouble prevX = UnitDouble.max(x0, getX.apply(entry).sub(halfRiseTime));
                add.accept(prevX, getY.apply(entry));
                if (pentries.size() == 1) {
                    add.accept(prevX.add(new UnitDouble(1.0, prevX.getUnit())), getY.apply(entry));
                }
                assert (m == entries.size() - 1);
                break;
            }
            if (m >= entries.size() - 1 || !getX.apply(entries.get(m + 1)).eq(entryEnd, 1.0E-9)) {
                add.accept(entryEnd.sub(halfRiseTime), getY.apply(entry));
                add.accept(entryEnd.add(halfRiseTime), defVal);
                prevVal = defVal;
                continue;
            }
            prevVal = getY.apply(entry);
        }
        assert (IntStream.range(1, pentries.size()).allMatch(i -> ((PiecewiseFunction1d.Entry)pentries.get((int)i)).x.gt(((PiecewiseFunction1d.Entry)pentries.get((int)(i - 1))).x, 1.0E-9)));
        return new PiecewiseFunction1d((PiecewiseFunction1d.Entry[])theUtil.toArray(pentries));
    }

    @Override
    public PiecewiseFunction1d toPiecewise(Function1dProp prop) {
        return ImpulseFunction1d.impulseToPiecewiseFunction(prop, this.entries, this.defaultValue, e -> e.x, e -> e.duration, e -> e.y);
    }

    @Override
    public ConstFunction1d toConstant(Function1dProp prop) {
        if (this.entries.isEmpty()) {
            return new ConstFunction1d(this.defaultValue);
        }
        if (this.entries.get((int)0).x.getRawValue() == 0.0) {
            return new ConstFunction1d(this.entries.get((int)0).y);
        }
        return new ConstFunction1d(this.defaultValue);
    }

    @Override
    public ImpulseFunction1d toImpulse(Function1dProp prop) {
        return this;
    }

    @Override
    public inferno.data2.value.IFunction1d toInfernoFunction(Unit xUnit, Unit yUnit) {
        double def = this.defaultValue.get(yUnit);
        ArrayList<ImpulseFunction1d.Pulse> iEntries = new ArrayList<ImpulseFunction1d.Pulse>(this.entries.size());
        for (Pulse entry : this.entries) {
            iEntries.add(new ImpulseFunction1d.Pulse(entry.x.get(xUnit), entry.duration.get(xUnit), entry.y.get(yUnit)));
        }
        return new inferno.data2.value.ImpulseFunction1d(def, iEntries);
    }

    @Override
    public IOccSourceFlowrate toInfernoOccSourceFlowrate(long occSourceSeed) {
        return new AUCOccSourceFlowrate(this.toInfernoFunction(SI.SECOND, Unit.ONE.divide(SI.SECOND)));
    }

    public static ImpulseFunction1d toImpulseFunction(int yUnitType, List<UnitDouble> x) {
        BiPredicate<UnitDouble, UnitDouble> compareTimes = (t1, t2) -> t1.epsilonEquals((UnitDouble)t2, 1.0E-9);
        ArrayList<Pair<UnitDouble, Integer>> tEntries = new ArrayList<Pair<UnitDouble, Integer>>();
        UnitDouble minDt = new UnitDouble(Double.POSITIVE_INFINITY, SI.SECOND);
        int m = 0;
        while (m < x.size()) {
            UnitDouble t12 = x.get(m++);
            int numOccs = 1;
            while (m < x.size()) {
                UnitDouble unitDouble = x.get(m);
                if (!compareTimes.test(t12, unitDouble)) {
                    minDt = UnitDouble.min(minDt, unitDouble.sub(t12));
                    break;
                }
                ++m;
                ++numOccs;
            }
            tEntries.add(new Pair<UnitDouble, Integer>(t12, numOccs));
        }
        UnitDouble duration = UnitDouble.min(minDt.scale(0.1), new UnitDouble(0.01, SI.SECOND));
        ArrayList<Pulse> entries = new ArrayList<Pulse>(tEntries.size());
        for (Pair pair : tEntries) {
            UnitDouble flowrate = new UnitDouble(((Integer)pair.v2).intValue(), Unit.ONE).divide(duration);
            entries.add(new Pulse((UnitDouble)pair.v1, duration, flowrate));
        }
        return new ImpulseFunction1d(new UnitDouble(0.0, SIUS.unit(yUnitType)), entries);
    }

    public static class Pulse
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final UnitDouble x;
        public final UnitDouble duration;
        public final UnitDouble y;

        public Pulse(UnitDouble x, UnitDouble duration, UnitDouble y) {
            this.x = x;
            this.duration = duration;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            Pulse f = (Pulse)obj;
            return this.x == f.x && this.duration == f.duration && this.y == f.y;
        }

        public int hashCode() {
            return 0xAF793 ^ Objects.hash(this.x, this.duration, this.y);
        }

        public String toString() {
            return String.format("%s -> %s: %s", this.x, this.x.add(this.duration), this.y);
        }
    }
}

