/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting.attractors;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.Behavior;
import merlin.data.egress.scripting.RoomLocationGeometry;
import merlin.data.value.ConstVariant;
import merlin.data.value.IVariant;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.EventChannel;
import thunderheadeng.util.ICyclicSurrogate;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.UnorderedPair;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.IDistributedVal;
import thunderheadeng.util.theUtil;

public class Attractor
extends NamedMerlinObj
implements IEgressObj,
IDirectDependent<MerlinData>,
ICyclicSurrogate {
    private static final long serialVersionUID = 1L;
    public static final Behavior WAIT_AT_ATTRACTOR_BEHAVIOR = new Behavior(Intl.intl("<Wait at Attractor>")){
        private static final long serialVersionUID = 1L;

        private Object readResolve() throws ObjectStreamException {
            return WAIT_AT_ATTRACTOR_BEHAVIOR;
        }

        @Override
        public boolean isPlaceholder() {
            return true;
        }
    };
    public static final IPropertySet.Prop<Awareness> AWARENESS = new IPropertySet.Prop<Awareness>(-2110148814, Awareness.LINE_OF_SIGHT);
    public static final TopologyProp<Point3d> LOCATION = new TopologyProp<Point3d>(128448899, new Point3d(0.0, 0.0, 0.0));
    public static final IPropertySet.Prop<Vector3d> ROOM_NORMAL = new IPropertySet.Prop<Vector3d>(92873722, new Vector3d(0.0, 0.0, 1.0));
    public static final IPropertySet.Prop<UnitDouble> INFLUENCE_RADIUS = new IPropertySet.Prop<UnitDouble>(10070259, new UnitDouble(2.0, SI.METER));
    @Deprecated
    private static final IPropertySet.Prop<UnitDouble> INFLUENCE = new IPropertySet.Prop<UnitDouble>(37024035, new UnitDouble(100.0, NonSI.PERCENT));
    public static final IPropertySet.Prop<IVariant<UnitDouble>> ATTR_INFLUENCE = new IPropertySet.Prop<ConstVariant<UnitDouble>>(183743272, new ConstVariant<UnitDouble>(new UnitDouble(100.0, NonSI.PERCENT)));
    public static final IPropertySet.Prop<Behavior> BEHAVIOR = new IPropertySet.Prop<Behavior>(266417039, WAIT_AT_ATTRACTOR_BEHAVIOR);
    public static final IPropertySet.Prop<IDistributedVal<UnitDouble>> WAIT_TIME = new IPropertySet.Prop<ConstantCurve>(-1752198270, new ConstantCurve(new UnitDouble(5.0, SI.SECOND)));
    public static final IPropertySet.Prop<UnitDouble> WAIT_RADIUS = new IPropertySet.Prop<UnitDouble>(142645281, new UnitDouble(1.0, SI.METER));
    public static final IPropertySet.Prop<Set<IEgressOccupiable>> ROOMS = new IPropertySet.Prop(6464059, Collections.emptySet());
    public static final Set<Object> PROPS = Sets.appendLHS(new LinkedHashSet(IPropertySet.getAllDeclaredPublicStaticProps(Attractor.class)), NamedMerlinObj.NAME, MerlinData.VISIBILITY, MerlinData.ENABLED);
    @SkipDep
    private transient IEgressOccupiable d_room;
    private PropertySet d_props = new PropertySet();
    private boolean d_visible = true;
    private boolean d_enabled = true;
    private static final Color BASE_COLOR = Color.ORANGE;

    public Attractor(String name) {
        super(name);
    }

    private void readObject(ObjectInputStream is) throws ClassNotFoundException, IOException {
        is.defaultReadObject();
        if (this.d_props.isDefined(INFLUENCE)) {
            UnitDouble influence = this.d_props.get(INFLUENCE);
            this.d_props.setIfNotDefault(ATTR_INFLUENCE, new ConstVariant<UnitDouble>(influence));
            this.d_props.remove(INFLUENCE);
        }
    }

    @Override
    public Attractor clone() {
        Attractor clone = (Attractor)super.clone();
        clone.d_props = this.d_props.clone();
        clone.d_room = null;
        return clone;
    }

    @Override
    public boolean cyclicEquals(Object comparable, HashSet<UnorderedPair<Object, Object>> comparedSet) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !this.getClass().equals(comparable.getClass())) {
            return false;
        }
        Attractor attr = (Attractor)comparable;
        if (!this.getName().equals(attr.getName())) {
            return false;
        }
        for (IPropertySet.Prop<?> prop : IPropertySet.getAllDeclaredPublicStaticProps(Attractor.class)) {
            if (theUtil.equal(this.get(prop), attr.get(prop), comparedSet)) continue;
            return false;
        }
        return true;
    }

    public IEgressOccupiable getRoom() {
        return this.d_room;
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_room);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_room = (IEgressOccupiable)ois.readObject();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof Attractor)) {
            return;
        }
        Attractor a = (Attractor)obj;
        this.pauseUpdates();
        this.setName(a.getName());
        this.d_props = a.d_props;
        this.d_room = a.d_room;
        this.d_enabled = a.d_enabled;
        this.d_visible = a.d_visible;
        this.changedEvt(MerlinData.TOPOLOGY);
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROPS;
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        return this.d_props.get(prop);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T value) {
        if (!Objects.equals(this.d_props.get(prop), value)) {
            this.d_props.setIfNotDefault(prop, value);
            this.pauseUpdates();
            if (prop instanceof TopologyProp) {
                this.changedEvt(MerlinData.TOPOLOGY);
            }
            this.changedEvt(prop);
            this.resumeUpdates();
        }
    }

    public boolean isEnabled() {
        return this.d_enabled;
    }

    public void setEnabled(boolean enabled) {
        if (enabled == this.d_enabled) {
            return;
        }
        this.d_enabled = enabled;
        this.changedEvt(MerlinData.VISIBILITY, MerlinData.ENABLED, EventChannel.EVT_GENERAL, MerlinData.TOPOLOGY);
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.ENABLED) {
            this.setEnabled((Boolean)value);
        }
    }

    @Override
    public Object getProperty(Object property) {
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == MerlinData.ENABLED) {
            return this.isEnabled();
        }
        return NOT_SUPPORTED;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible && this.d_enabled;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(MerlinData.VISIBILITY);
        }
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{IEgressOccupiable.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_room != null ? Collections.singleton(this.d_room) : Collections.emptyList();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return this.d_room == null;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (conn == this.d_room) {
            this.d_room = null;
            this.pauseUpdates();
            this.set(ROOM_NORMAL, GeomConstants.VEC3D_ZPOS);
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        if (conn instanceof IEgressOccupiable) {
            // empty if block
        }
    }

    @Override
    public boolean updateTopo() {
        Point3d loc = this.get(LOCATION);
        GeomUtil.FindResult room = GeomUtil.findRoom((MerlinData)this.getDomain(), new Point3d(loc.x, loc.y, loc.z + 1.0E-6), new Point3d(loc.x, loc.y, loc.z - 1.0E-6), 1);
        if (room != null) {
            this.pauseUpdates();
            this.d_room = room.room;
            this.set(ROOM_NORMAL, room.faceNormal);
            loc = room.p;
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
        return true;
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        return this.get(LOCATION);
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        return this.get(LOCATION);
    }

    public void setLocation(IEgressOccupiable room, Vector3d roomNormal, Point3d loc) {
        if (loc.equals(this.d_props.get(LOCATION)) && roomNormal.equals(this.d_props.get(ROOM_NORMAL)) && this.d_room == room) {
            return;
        }
        this.d_props.set(LOCATION, loc);
        this.d_props.set(ROOM_NORMAL, roomNormal);
        if (room != this.d_room) {
            if (this.getDomain() != null) {
                if (this.d_room != null) {
                    this.d_room.disconnectFrom(this);
                    this.disconnectFrom(this.d_room);
                }
                if (room != null) {
                    room.connectTo(this);
                }
            }
            this.d_room = room;
        }
        this.changedEvt(new Object[0]);
    }

    public boolean requiresLocation() {
        return Attractor.requiresLocation(this.d_props);
    }

    public static boolean requiresLocation(IPropertySet props) {
        switch (props.get(AWARENESS)) {
            case LINE_OF_SIGHT: 
            case ROOM_ONLY: {
                return true;
            }
            case ROOMS: 
            case GLOBAL: {
                return props.get(BEHAVIOR) == WAIT_AT_ATTRACTOR_BEHAVIOR;
            }
        }
        assert (false);
        return false;
    }

    @Override
    public IGeomNode getGeom() {
        switch (this.get(AWARENESS)) {
            case LINE_OF_SIGHT: {
                return GeomNodeUtil.newNode(this.getLocGeom());
            }
            case ROOM_ONLY: {
                return GeomNodeUtil.newNode(this.getPointGeom());
            }
            case ROOMS: 
            case GLOBAL: {
                return this.get(BEHAVIOR) == WAIT_AT_ATTRACTOR_BEHAVIOR ? GeomNodeUtil.newNode(this.getPointGeom()) : GeomNodeUtil.EMPTY_NODE;
            }
        }
        assert (false);
        return GeomNodeUtil.EMPTY_NODE;
    }

    private RoomLocationGeometry getLocGeom() {
        return new RoomLocationGeometry(this.d_room, this.get(ROOM_NORMAL), this.get(LOCATION), this.get(INFLUENCE_RADIUS).getValue(Geometry.LENGTH_UNIT));
    }

    private Point getPointGeom() {
        return new Point(this.get(LOCATION));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof RoomLocationGeometry) {
            RoomLocationGeometry wgeom = (RoomLocationGeometry)geom;
            this.pauseUpdates();
            this.set(INFLUENCE_RADIUS, new UnitDouble(wgeom.radius, Geometry.LENGTH_UNIT));
            this.setLocation(wgeom.room, wgeom.normal, wgeom.location);
            this.resumeUpdates();
        } else if (geom instanceof Point) {
            Point p = (Point)geom;
            this.set(LOCATION, p.loc);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeomNode geom = this.getGeom();
        PropsBuilder gprops = new PropsBuilder();
        Runnable addPointProps = () -> gprops.add(new IPrimProps.Vertex(BASE_COLOR, 12.0));
        switch (this.get(AWARENESS)) {
            case LINE_OF_SIGHT: {
                gprops.add(new IPrimProps.Edge(Color.BLACK, 2.0, IPrimProps.DEF_STIPPLE, 0));
                gprops.add(new IPrimProps.Face(BASE_COLOR, null, 0));
                gprops.add(new IPrimProps.Vertex(Color.BLACK, 8.0));
                break;
            }
            case ROOM_ONLY: {
                addPointProps.run();
                break;
            }
            case ROOMS: 
            case GLOBAL: {
                if (this.get(BEHAVIOR) != WAIT_AT_ATTRACTOR_BEHAVIOR) break;
                addPointProps.run();
            }
        }
        return new DisplayGeom(geom, gprops);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        Behavior behavior = this.get(BEHAVIOR);
        if (behavior != WAIT_AT_ATTRACTOR_BEHAVIOR) {
            deps.add(DLink.REQUIRED, this.get(BEHAVIOR));
        }
        deps.add(DLink.WEAK, (Collection<? extends Object>)this.get(ROOMS));
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        if (old == this.get(BEHAVIOR)) {
            assert (replacement != null);
            this.set(BEHAVIOR, (Behavior)replacement);
        } else if (this.get(ROOMS).contains(old)) {
            Set<Object> rooms = new LinkedIdentityHashSet((Collection)this.get(ROOMS));
            rooms.remove(old);
            if (replacement instanceof IEgressOccupiable) {
                rooms.add((IEgressOccupiable)replacement);
            }
            if (rooms.isEmpty()) {
                rooms = Collections.emptySet();
            }
            this.set(ROOMS, rooms);
        }
    }

    public static class TopologyProp<T>
    extends IPropertySet.Prop<T> {
        public TopologyProp(Object key, T defVal) {
            super(key, defVal);
        }
    }

    public static enum Awareness {
        LINE_OF_SIGHT(Intl.intl("Line of Sight"), Intl.intl("The occupant must be within the influence radius and have\nline-of-sight to the attractor.")),
        ROOM_ONLY(Intl.intl("Same Room"), Intl.intl("The occupant must be in the same room as the attractor.")),
        ROOMS(Intl.intl("Specified Rooms"), Intl.intl("The occupant must be in one of the specified rooms.")),
        GLOBAL(Intl.intl("Global"), Intl.intl("The occupant always knows about the attractor."));

        public final String name;
        public final String desc;

        private Awareness(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

