/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.scripting;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import merlin.Intl;
import merlin.data.ICompElement;
import merlin.data.IMerlinObj;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.egress.SimError;
import merlin.data.egress.geom.IEgressComp;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.scripting.IBehaviorAction;
import merlin.data.egress.scripting.IDestination;
import merlin.data.egress.scripting.IDestinationAction;
import merlin.data.egress.scripting.IUnreachable;
import merlin.util.MerlinUtil;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class GotoRooms
extends NamedMerlinObj
implements IBehaviorAction,
IDestinationAction,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 2349523402345098738L;
    public static final IPropertySet.Prop<Set<IEgressOccupiable>> PROP_ROOMS = new IPropertySet.Prop("GotoRooms.ROOMS", Collections.emptySet());
    public static final IPropertySet.Prop<Predicate<IEgressOccupiable>> PROP_FILTER = new IPropertySet.Prop("GotoRooms.FILTER", Predicates.alwaysTrue());
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(NamedMerlinObj.NAME, PROP_ROOMS, PROP_FILTER);
    private Set<IEgressOccupiable> d_rooms;
    private Predicate<? super IEgressOccupiable> d_filter;

    public GotoRooms(Predicate<? super IEgressOccupiable> filter, Set<IEgressOccupiable> rooms) {
        super(null);
        this.d_rooms = rooms;
        this.d_filter = filter;
    }

    public static boolean getAnyAllowed(Predicate<? super IEgressOccupiable> filter) {
        return !Predicates.alwaysTrue(filter);
    }

    @Override
    public GotoRooms getRestoreObj() {
        return (GotoRooms)this.clone();
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof GotoRooms)) {
            return;
        }
        GotoRooms gr = (GotoRooms)obj;
        this.pauseUpdates();
        this.setRooms(gr.d_rooms);
        this.setName(gr.getSetName());
        this.d_filter = gr.d_filter;
        this.resumeUpdates();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_filter == null) {
            this.d_filter = Predicates.alwaysTrue();
        }
    }

    public boolean getAnyAllowed() {
        return GotoRooms.getAnyAllowed(this.d_filter);
    }

    @Override
    public boolean mustBeLast() {
        return this.d_filter instanceof IFilter && ((IFilter)this.d_filter).isTerminal();
    }

    @Override
    public boolean isTerminal() {
        return this.mustBeLast();
    }

    @Override
    public boolean isImmediate() {
        return false;
    }

    public Set<IEgressOccupiable> getRooms() {
        return Collections.unmodifiableSet(this.d_rooms);
    }

    public void setRooms(Set<IEgressOccupiable> rooms) {
        this.d_rooms = rooms;
        this.changedEvt(new Object[0]);
    }

    public Predicate<? super IEgressOccupiable> getFilter() {
        return this.d_filter;
    }

    @Override
    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        if (this.d_filter instanceof IFilter) {
            String filterName = ((IFilter)this.d_filter).getName();
            if (this.d_rooms.size() == 1) {
                return String.format(Intl.intl("Goto %1$s <%2$s>"), filterName, this.d_rooms.iterator().next().getName());
            }
            return String.format(Intl.intl("Goto %s Rooms"), filterName);
        }
        if (this.d_rooms.size() == 1) {
            return String.format(Intl.intl("Goto %s"), this.d_rooms.iterator().next().getName());
        }
        return String.format(Intl.intl("Goto Rooms"), new Object[0]);
    }

    @Override
    public String getSetName() {
        return super.getName();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_ROOMS) {
            return this.getRooms();
        }
        if (property == PROP_FILTER) {
            return this.getFilter();
        }
        return ICompElement.NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_ROOMS) {
            this.setRooms((Set)value);
        }
    }

    @Override
    public IDestination getDestination() {
        MerlinData md;
        Collection<IEgressOccupiable> destRooms = this.d_rooms;
        if (destRooms.isEmpty() && this.getAnyAllowed() && (md = (MerlinData)this.getDomain()) != null) {
            destRooms = md.floors.flatten(IEgressOccupiable.class, this.d_filter);
        }
        return new Destination(this, this.d_rooms, destRooms);
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        LinkedIdentityHashSet<IEgressOccupiable> newRooms = new LinkedIdentityHashSet<IEgressOccupiable>((Collection<IEgressOccupiable>)this.d_rooms);
        newRooms.remove(old);
        if (replacement != null && replacement instanceof IEgressOccupiable) {
            newRooms.add((IEgressOccupiable)replacement);
        }
        this.setProperty(PROP_ROOMS, newRooms);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.d_rooms);
    }

    private int surrogateHashCode() {
        int hash = 7;
        for (IEgressOccupiable room : this.getRooms()) {
            hash = 31 * hash + theUtil.hashCode(room);
        }
        return 31 * hash + theUtil.hashCode(this.getProperty(PROP_FILTER));
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || this.getClass() != comparable.getClass()) {
            return false;
        }
        GotoRooms comparableBehavior = (GotoRooms)comparable;
        return Objects.equals(this.getSetName(), comparableBehavior.getSetName()) && this.getProperty(PROP_FILTER).equals(comparableBehavior.getProperty(PROP_FILTER)) && theUtil.surrogateSetsEqual(this.d_rooms, comparableBehavior.getRooms());
    }

    public static interface IFilter
    extends Predicate<IEgressOccupiable> {
        public String getName();

        public boolean isTerminal();
    }

    public static class Destination
    implements IDestination {
        private final IMerlinObj d_sourceObj;
        private final Set<IEgressOccupiable> d_rooms;
        private final Collection<IEgressOccupiable> d_destRooms;

        public Destination(IMerlinObj sourceObj, Set<IEgressOccupiable> inputRooms, Collection<IEgressOccupiable> finalRooms) {
            this.d_sourceObj = sourceObj;
            this.d_rooms = inputRooms;
            this.d_destRooms = finalRooms;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof Destination && ((Destination)obj).getRooms().equals(this.d_rooms);
        }

        @Override
        public int hashCode() {
            return 0xFAAFE324 ^ this.d_rooms.hashCode();
        }

        protected Set<IEgressOccupiable> getRooms() {
            return this.d_rooms;
        }

        @Override
        public IUnreachable getUnreachable(IEgressComp source) {
            Collection<IEgressOccupiable> rooms = this.d_destRooms;
            if (this.d_rooms != this.d_destRooms) {
                if (MerlinUtil.isConnected(source, rooms)) {
                    return null;
                }
                return this.allRoomsUnreachable(source, this.d_destRooms);
            }
            ArrayList<IEgressOccupiable> unreachable = new ArrayList<IEgressOccupiable>(this.d_rooms.size());
            for (IEgressOccupiable room : this.d_rooms) {
                if (MerlinUtil.isConnected(source, room)) continue;
                unreachable.add(room);
            }
            if (unreachable.size() == this.d_rooms.size()) {
                return this.allRoomsUnreachable(source, this.d_rooms);
            }
            if (!unreachable.isEmpty()) {
                return this.someRoomsUnreachable(source, unreachable);
            }
            return null;
        }

        private IUnreachable allRoomsUnreachable(IEgressComp csource, Collection<? extends IEgressOccupiable> rooms) {
            return source -> {
                String name = MerlinUtil.getName(source);
                String cname = MerlinUtil.getName(csource);
                String thisname = MerlinUtil.getName(this.d_sourceObj);
                return new SimError(SimError.Level.CRITICAL, String.format(Intl.intl("Error in \"%1$s\": \"%2$s\" is not connected to any rooms in \"%3$s\"."), name, cname, thisname), String.format(Intl.intl("Connect \"%1$s\" to at least one room in \"%2$s\"."), cname, thisname), this.collect(source, csource, rooms));
            };
        }

        private IUnreachable someRoomsUnreachable(IEgressComp csource, Collection<? extends IEgressOccupiable> rooms) {
            return source -> {
                String name = MerlinUtil.getName(source);
                String cname = MerlinUtil.getName(csource);
                String thisname = MerlinUtil.getName(this.d_sourceObj);
                return new SimError(SimError.Level.MODERATE, String.format(Intl.intl("Error in \"%1$s\": \"%2$s\" is not connected to %3$d rooms of \"%4$s\"."), name, cname, rooms.size(), thisname), String.format(Intl.intl("Connect \"%1$s\" with the rooms specified in \"%2$s\"."), cname, thisname), this.collect(source, csource, rooms));
            };
        }

        private List<IMerlinObj> collect(IMerlinObj source, IEgressComp csrc, Collection<? extends IEgressOccupiable> rooms) {
            ArrayList<IMerlinObj> objs = new ArrayList<IMerlinObj>(1 + rooms.size());
            objs.add(source);
            if (csrc != source) {
                objs.add(csrc);
            }
            if (this.d_sourceObj != source) {
                objs.add(this.d_sourceObj);
            }
            objs.addAll(rooms);
            return objs;
        }

        @Override
        public Collection<? extends IEgressComp> getExitComponents() {
            return this.d_destRooms;
        }
    }
}

