/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.geom;

import merlin.data.SimParams;
import merlin.data.egress.geom.IEgressFlowrate;
import merlin.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;

public class DoorUtil {
    public static IEgressFlowrate getFlowrate(SimParams sp, UnitDouble doorWidth) {
        if (sp.useDoorQueues && sp.doorFlowDensityFlag) {
            return IEgressFlowrate.FROM_DENSITY;
        }
        if (sp.useDoorQueues) {
            UnitDouble specFlow = sp.reactiveSteering ? sp.specificFlowSteering : SIUS.newud(1.32, 12);
            return new IEgressFlowrate.Limited(DoorUtil.getFlowrate(specFlow, sp.doorBoundaryLayer, doorWidth));
        }
        return IEgressFlowrate.UNLIMITED;
    }

    public static UnitDouble getFlowrate(UnitDouble sflowrate, UnitDouble doorBoundaryLayer, UnitDouble doorWidth) {
        UnitDouble blayer = doorBoundaryLayer.scale(2.0);
        doorWidth = UnitDouble.max(doorWidth.sub(blayer), SIUS.newud(0.0, 0));
        return sflowrate.multiply(doorWidth);
    }
}

