/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.blockages;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import merlin.Intl;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.data.Opacity;
import merlin.data.egress.IEgressObj;
import merlin.data.egress.geom.EgressModelGeom;
import merlin.data.egress.geom.EgressRoom;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.data.egress.geom.SpeedModifier;
import merlin.data.material.Material;
import merlin.data.value.ConstVariant;
import merlin.data.value.DiscreteVariant;
import merlin.data.value.IVariant;
import merlin.data.value.VariantUtil;
import merlin.geom.GeomUtil;
import merlin.geom.Geometry;
import merlin.geom.IMerlinDispProps;
import merlin.io.inferno.InfernoGeom;
import merlin.io.inferno.InfernoType;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.Unit;
import thunderheadeng.delaunay.Mesh;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.dependencies.SkipDep;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.AABoxTest;
import thunderheadeng.geometry.Util2D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.nmt.Edge;
import thunderheadeng.geometry.nmt.Face;
import thunderheadeng.geometry.nmt.Model;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.node.AGeomNode;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MirrorXform;
import thunderheadeng.geometry.objs.transform.RotateXform;
import thunderheadeng.geometry.objs.transform.ScaleXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.geometry.objs.transform.TranslateXform;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IMaterial;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IPickable;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.CachedValue;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;
import thunderheadeng.util.SoftCachedValue;
import thunderheadeng.util.TriConsumer;
import thunderheadeng.util.theUtil;

public class EgressBlockage
extends NamedMerlinObj
implements Serializable,
IEgressObj,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(EgressBlockage.class.getSimpleName());
    public static final BlkgProp<DisplayType> DISPLAY_TYPE = new BlkgProp<DisplayType>("EgressBlockage.DISPLAY_TYPE", DisplayType.SIMPLE, (blkg, oldVal, newVal) -> {
        if (blkg.getLinkCadGeomToSearch() && (newVal == DisplayType.CAD_GEOM || oldVal == DisplayType.CAD_GEOM)) {
            blkg.changedEvt(true, true, true, false);
        }
    });
    public static final IPropertySet.Prop<SpeedModifier> SPEED_MODIFIER = IEgressOccupiable.SPEED_MODIFIER;
    public static final BlkgProp<DisplayGeom> CAD_GEOM = new BlkgProp<DisplayGeom>("EgressBlockage.CAD_GEOM", DisplayGeom.EMPTY, (blkg, oldVal, newVal) -> {
        boolean searchGeomDirty = blkg.isSearchGeomCalculated();
        blkg.changedEvt(true, searchGeomDirty, searchGeomDirty, true);
    });
    public static final BlkgProp<Boolean> LINK_CAD_GEOM_TO_SEARCH = new BlkgProp<Boolean>("EgressBlockage.LINK_CAD_GEOM_TO_SEARCH", true, (blkg, oldVal, newVal) -> {
        if (blkg.getDisplayType() == DisplayType.CAD_GEOM) {
            blkg.changedEvt(true, true, true, false);
        }
    });
    public static final BlkgProp<UnitDouble> CAD_HEAD_HEIGHT = new BlkgProp<UnitDouble>("EgressBlockage.CAD_HEAD_HEIGHT", new UnitDouble(6.0, NonSI.FOOT), (blkg, oldVal, newVal) -> {
        boolean searchGeomDirty = blkg.isSearchGeomCalculated();
        blkg.changedEvt(true, searchGeomDirty, searchGeomDirty, true);
    });
    private static final Set<Object> SHARED_PROPS = Sets.fromArrayLHS(NamedMerlinObj.NAME, MerlinData.VISIBILITY, DISPLAY_TYPE, SPEED_MODIFIER, SpeedModifier.PROP_TYPE_FILTER, CAD_GEOM, LINK_CAD_GEOM_TO_SEARCH, CAD_HEAD_HEIGHT);
    public static final Set<Object> SIMPLE_GEOM_PROPS = Sets.appendLHS(SHARED_PROPS, MerlinData.COLOR, MerlinData.MATERIAL, MerlinData.OPACITY);
    public static final Set<Object> NO_GEOM_PROPS = SHARED_PROPS;
    public static final Set<Object> CAD_GEOM_PROPS = new LinkedHashSet<Object>(SHARED_PROPS);
    public static final Predicate<SpeedModifier.Type> ALLOWED_SPEED_MOD_TYPES;
    public static final SpeedModifier DEFAULT_SPEED_MOD;
    public static final Opacity DEFAULT_OPACITY;
    private PropertySet d_props;
    private IGeomNode d_setSearchGeom = GeomNodeUtil.EMPTY_NODE;
    private CachedValue<IGeomNode> d_linkedSearchGeom = new CachedValue();
    @SkipDep
    private transient Map<EgressRoom, Pair<IGeom, IGeom>> d_roomGeom = new LinkedIdentityHashMap<EgressRoom, Pair<IGeom, IGeom>>();
    private CachedValue<BlockageGeom> d_cachedGeom = new CachedValue();
    private SoftCachedValue<Model> d_searchModel = new SoftCachedValue();
    private boolean d_visible = true;
    private static final IDOF LINKED_SEARCH_GEOM_IDOF;

    private boolean getLinkCadGeomToSearch() {
        return this.getProp(LINK_CAD_GEOM_TO_SEARCH).get();
    }

    public EgressBlockage(String name) {
        super(name);
        this.d_props = new PropertySet();
        this.setProp(IEgressOccupiable.SPEED_MODIFIER, DEFAULT_SPEED_MOD);
        this.setProp(MerlinData.MATERIAL, new IMaterial[]{null});
        this.setProp(MerlinData.OPACITY, DEFAULT_OPACITY);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.d_cachedGeom = new CachedValue();
        this.d_linkedSearchGeom = new CachedValue();
        this.d_roomGeom = new LinkedIdentityHashMap<EgressRoom, Pair<IGeom, IGeom>>();
        this.d_searchModel = new SoftCachedValue();
        this.d_setSearchGeom = GeomNodeUtil.EMPTY_NODE;
        in.defaultReadObject();
    }

    public static SpeedModifier convertLegacyFactor(double speedFactor, IVariant<Boolean> state) {
        ArrayList speedFactors = new ArrayList();
        for (DiscreteVariant.Entry<Boolean> bEntry : VariantUtil.getDiscreteValues(state, true)) {
            boolean blocking = (Boolean)bEntry.val;
            speedFactors.add(new DiscreteVariant.Entry<UnitDouble>(bEntry.t, new UnitDouble(blocking ? speedFactor : 1.0, Unit.ONE)));
        }
        return speedFactors.isEmpty() ? DEFAULT_SPEED_MOD : new SpeedModifier(SpeedModifier.Type.FACTOR, VariantUtil.newVariant(speedFactors));
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof EgressBlockage)) {
            return;
        }
        EgressBlockage blockage = (EgressBlockage)obj;
        this.pauseUpdates();
        this.d_roomGeom = blockage.d_roomGeom;
        this.d_cachedGeom = blockage.d_cachedGeom;
        this.d_searchModel = blockage.d_searchModel;
        this.d_setSearchGeom = blockage.d_setSearchGeom;
        this.d_linkedSearchGeom = blockage.d_linkedSearchGeom;
        this.d_props = blockage.d_props;
        this.changedEvt(false, true, false, false);
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public EgressBlockage clone() {
        EgressBlockage clone = (EgressBlockage)super.clone();
        clone.d_roomGeom = new LinkedIdentityHashMap<EgressRoom, Pair<IGeom, IGeom>>(this.d_roomGeom);
        clone.d_cachedGeom = this.d_cachedGeom.clone();
        clone.d_searchModel = this.d_searchModel.clone();
        clone.d_linkedSearchGeom = this.d_linkedSearchGeom.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    public DisplayType getDisplayType() {
        return this.d_props.get(DISPLAY_TYPE);
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible == visible) {
            return;
        }
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    public void setSpeedModifier(SpeedModifier smod) {
        this.setProp(SPEED_MODIFIER, smod);
    }

    public SpeedModifier getSpeedModifier() {
        return this.getProp(SPEED_MODIFIER).orElse(null);
    }

    public Material getSimpleDisplayMaterial() {
        if (this.getDisplayType() == DisplayType.SIMPLE) {
            return this.getProp(MerlinData.MATERIAL).map(mats -> mats[0]).orElse(null);
        }
        return null;
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        switch (this.d_props.get(DISPLAY_TYPE)) {
            case CAD_GEOM: {
                return CAD_GEOM_PROPS;
            }
            case NONE: {
                return NO_GEOM_PROPS;
            }
            case SIMPLE: {
                return SIMPLE_GEOM_PROPS;
            }
        }
        assert (false);
        return Collections.emptySet();
    }

    @Override
    public Object getProperty(Object property) {
        if (property == SpeedModifier.PROP_TYPE_FILTER) {
            return ALLOWED_SPEED_MOD_TYPES;
        }
        if (property == NAME) {
            return this.getName();
        }
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (GeomUtil.CAD_GEOM_PROPS.contains(property) && this.getDisplayType() == DisplayType.CAD_GEOM) {
            DisplayGeom dg = this.getProp(CAD_GEOM).get();
            return GeomUtil.getCadGeomProp(dg.node, dg.props, property);
        }
        if (property instanceof IPropertySet.Prop && this.getPropTypes(0).contains(property)) {
            return this.d_props.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == NAME) {
            this.setName((String)value);
        } else if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (GeomUtil.CAD_GEOM_PROPS.contains(property) && this.getDisplayType() == DisplayType.CAD_GEOM) {
            DisplayGeom dg = this.getProp(CAD_GEOM).get();
            dg = GeomUtil.setCadGeomProp(dg.node, dg.props, property, value);
            this.setProp(CAD_GEOM, dg);
        } else if (property instanceof IPropertySet.Prop && this.getPropTypes(0).contains(property)) {
            IPropertySet.Prop prop = (IPropertySet.Prop)property;
            this.pauseUpdates();
            Object prevVal = this.d_props.get(prop);
            if (!Objects.equals(prevVal, value)) {
                if (prop == DISPLAY_TYPE) {
                    DisplayType dtype = (DisplayType)((Object)value);
                    if (dtype != DisplayType.CAD_GEOM) {
                        this.ensureValidSetSearchGeom();
                        this.setProp(CAD_GEOM, (DisplayGeom)EgressBlockage.CAD_GEOM.defVal);
                        this.d_linkedSearchGeom.clear();
                    }
                    if (dtype != DisplayType.SIMPLE) {
                        this.setProp(MerlinData.MATERIAL, new IMaterial[]{null});
                        this.setProp(MerlinData.COLOR, (Color)MerlinData.COLOR.defVal);
                        this.setProp(MerlinData.OPACITY, DEFAULT_OPACITY);
                    }
                    this.changedEvt(MerlinData.SUPPORTED_PROPS_CHANGED);
                } else if (prop == LINK_CAD_GEOM_TO_SEARCH) {
                    if (this.getDisplayType() == DisplayType.CAD_GEOM) {
                        this.ensureValidSetSearchGeom();
                    }
                    if (!((Boolean)value).booleanValue()) {
                        this.d_linkedSearchGeom.clear();
                    }
                }
                this.d_props.setIfNotDefault(prop, value);
                this.changedEvt(prop);
                if (property instanceof BlkgProp) {
                    ((BlkgProp)property).markChanges.accept(this, prevVal, value);
                }
            }
            this.resumeUpdates();
        }
    }

    private void ensureValidSetSearchGeom() {
        if (this.d_setSearchGeom == GeomNodeUtil.EMPTY_NODE && this.getDisplayType() == DisplayType.CAD_GEOM) {
            this.d_setSearchGeom = this.getLinkedSearchGeom();
        }
    }

    private static int getNumFaces(IGeomNode node) {
        return node.getNumPrims(1);
    }

    private static int getNumEdges(IGeomNode node) {
        return node.getNumPrims(2);
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        boolean isWireframe = dispProps.isWireframe(this);
        if (dispProps instanceof IMerlinDispProps) {
            BlockageGeom bgeom = this.getDisplayBaseGeom((IMerlinDispProps)dispProps, true, validateProgress);
            return new DisplayGeom((IGeomNode)bgeom, IPickable.DEF_PROPS);
        }
        return new DisplayGeom(this.getGeom().getPickable(validateProgress, isWireframe), IPickable.DEF_PROPS);
    }

    private BlockageGeom getDisplayBaseGeom(IMerlinDispProps mprops, boolean pickable, Runnable validateProgress) {
        BlockageGeom bgeom = this.getGeom();
        if (this.isSearchGeomCalculated() && !mprops.getBlockageOptions().contains((Object)IMerlinDispProps.BlockageOptions.SHOW_CAD_SEARCH)) {
            bgeom = new BlockageGeom(bgeom.room, GeomNodeUtil.EMPTY_NODE, bgeom.cad, false);
        }
        if (pickable) {
            boolean wireframe = mprops.isWireframe(this);
            bgeom = new BlockageGeom(bgeom.room.getPickable(validateProgress, wireframe), bgeom.search.getPickable(validateProgress, wireframe), bgeom.cad.getPickable(validateProgress, wireframe), bgeom.searchGeomManipulatable);
        }
        return bgeom;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        if (!(props instanceof IMerlinDispProps)) {
            return DisplayGeom.EMPTY;
        }
        IMerlinDispProps mprops = (IMerlinDispProps)props;
        DisplayType dtype = this.getDisplayType();
        BlockageGeom bgeom = this.getDisplayBaseGeom(mprops, false, () -> {});
        PropsBuilder dprops = new PropsBuilder();
        int numFaces = EgressBlockage.getNumFaces(bgeom.room);
        int numEdges = EgressBlockage.getNumEdges(bgeom.room);
        dprops.add(this.getRoomFaceProps(mprops), numFaces);
        dprops.add(mprops.getEdgeProps(this, IMerlinDispProps.EgressType.BLOCKAGE, null, 1.0f), numEdges);
        int numSearchFaces = EgressBlockage.getNumFaces(bgeom.search);
        if (numSearchFaces != 0) {
            float searchOpacity = 0.3f;
            Color searchColor = null;
            if (dtype == DisplayType.SIMPLE) {
                searchColor = (Color)this.getNullableProp(MerlinData.COLOR).get().val;
            }
            dprops.add(mprops.getFaceProps(this, IMerlinDispProps.EgressType.BLOCKAGE_SEARCH, null, searchColor, 0.3f), numSearchFaces);
        }
        if (dtype == DisplayType.CAD_GEOM) {
            DisplayGeom dg = this.getProp(CAD_GEOM).get();
            dprops.add(dg.props, dg.node.getNumPrims(7));
        }
        IPropsSrc finalProps = dprops.finalizeProps();
        IGeomNode geom = GeomUtil.finalizeTexCoords((IGeomNode)bgeom, finalProps);
        return new DisplayGeom(geom, finalProps);
    }

    public IPrimProps getRoomFaceProps(IMerlinDispProps mprops) {
        Material mat = null;
        Color color = null;
        float opacity = 1.0f;
        if (this.getDisplayType() == DisplayType.SIMPLE) {
            mat = (Material)this.getProp(MerlinData.MATERIAL).get()[0];
            color = (Color)this.getNullableProp(MerlinData.COLOR).get().val;
            opacity = this.getProp(MerlinData.OPACITY).get().getValue();
        }
        return mprops.getFaceProps(this, IMerlinDispProps.EgressType.BLOCKAGE, mat, color, opacity);
    }

    public boolean isSearchGeomSettable() {
        return !this.isSearchGeomCalculated();
    }

    public boolean isSearchGeomCalculated() {
        return this.getDisplayType() == DisplayType.CAD_GEOM && this.getProp(LINK_CAD_GEOM_TO_SEARCH).get() != false;
    }

    private IGeomNode getLinkedSearchGeom() {
        return this.d_linkedSearchGeom.get(() -> {
            if (!this.isSearchGeomCalculated()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            Mesh dmesh = new Mesh();
            IGeomNode cad = this.getProp(EgressBlockage.CAD_GEOM).get().node.flatten();
            double[] zrange = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
            HashSet closedPoints = new HashSet();
            Consumer<Point3d> addPoint = p -> {
                zrange[0] = Math.min(zrange[0], p.z);
                zrange[1] = Math.max(zrange[1], p.z);
                Point2d p2d = Util2D.round(new Point2d(p.x, p.y), 3);
                if (closedPoints.add(p2d)) {
                    dmesh.addPoint(p2d.x, p2d.y);
                }
            };
            double faceTol = this.getDomain() != null ? ((MerlinData)this.getDomain()).simParams.faceError : 1.0E-6;
            double edgeTol = this.getDomain() != null ? ((MerlinData)this.getDomain()).simParams.edgeError : 1.0E-6;
            List<Triangle> tris = thunderheadeng.geometry.objs.GeomUtil.convertToTriangles(faceTol, cad.getLocalGeom());
            for (Triangle triangle : tris) {
                for (int m = 0; m < 3; ++m) {
                    addPoint.accept(triangle.getPoint(m));
                }
            }
            List<LineSeg> lineSegs = thunderheadeng.geometry.objs.GeomUtil.convertToLineSegs(edgeTol, cad.getLocalGeom());
            for (LineSeg ls : lineSegs) {
                addPoint.accept(ls.p1);
                addPoint.accept(ls.p2);
            }
            List list = thunderheadeng.geometry.objs.GeomUtil.explode(cad.getLocalGeom(), Point.class);
            list.stream().forEach(p -> addPoint.accept(p.loc));
            if (closedPoints.isEmpty()) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            if (!dmesh.triangulateConvexHull(0)) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            List<Point2d> chull = dmesh.getConvexHull();
            if (chull.size() < 3) {
                return GeomNodeUtil.EMPTY_NODE;
            }
            Point3d[] basePoints = new Point3d[chull.size()];
            for (int m = 0; m < chull.size(); ++m) {
                Point2d p2d = chull.get(m);
                basePoints[m] = new Point3d(p2d.x, p2d.y, zrange[1]);
            }
            IPolygon base = PolyUtil.newPoly(basePoints);
            Vector3d extrusion = new Vector3d(0.0, 0.0, zrange[0] - zrange[1] - this.d_props.get(CAD_HEAD_HEIGHT).get(Geometry.LENGTH_UNIT));
            ExtrudedPoly epoly = new ExtrudedPoly(base, extrusion);
            return GeomNodeUtil.newNode(epoly);
        });
    }

    public void setSearchGeom(IGeomNode geom) {
        if (!this.isSearchGeomSettable()) {
            return;
        }
        if (geom == this.d_setSearchGeom || geom.getNumPrims(6) != 0) {
            return;
        }
        this.d_setSearchGeom = geom;
        this.changedEvt(true, true, true, false);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (!(geom instanceof BlockageGeom)) {
            assert (false) : "You probably wanted to use setSearchGeom instead";
            return;
        }
        this.pauseUpdates();
        BlockageGeom bgeom = (BlockageGeom)geom;
        DisplayType dt = this.getDisplayType();
        TransformInfo xformInfo = bgeom.getLocalTransform().getInfo();
        if (this.isSearchGeomSettable()) {
            this.setSearchGeom(bgeom.search.transform(xformInfo));
        }
        if (dt == DisplayType.CAD_GEOM) {
            DisplayGeom existingCad = this.getProp(CAD_GEOM).get();
            assert (existingCad != null);
            if (existingCad != null) {
                boolean primCountMatch;
                boolean bl = primCountMatch = existingCad.node.getNumPrims(7) == bgeom.cad.getNumPrims(7);
                assert (primCountMatch);
                if (primCountMatch) {
                    this.setProp(CAD_GEOM, new DisplayGeom(bgeom.cad.quickTransform(xformInfo), existingCad.props));
                    if (this.isSearchGeomCalculated()) {
                        this.d_linkedSearchGeom.set(bgeom.search.transform(xformInfo));
                        boolean regenLinkedSearch = !LINKED_SEARCH_GEOM_IDOF.accept(xformInfo);
                        this.changedEvt(true, true, true, regenLinkedSearch);
                    }
                }
            }
        }
        this.resumeUpdates();
    }

    public boolean changedEvt(boolean geomChanged, boolean regenTopo, boolean regenSearchModel, boolean regenLinkedSearchGeom) {
        regenTopo |= (regenSearchModel |= regenLinkedSearchGeom);
        if (regenLinkedSearchGeom) {
            this.d_linkedSearchGeom.clear();
        }
        if (regenSearchModel) {
            this.d_searchModel.clear();
        }
        if (geomChanged) {
            this.d_cachedGeom.clear();
        }
        if (regenTopo) {
            this.markTopoDirty();
        }
        return super.changedEvt(new Object[0]);
    }

    protected void markTopoDirty() {
        this.changedEvt(MerlinData.TOPOLOGY);
    }

    @Override
    public BlockageGeom getGeom() {
        return this.d_cachedGeom.get(() -> {
            DisplayType dt = this.getDisplayType();
            ArrayList<IGeom> faces = new ArrayList<IGeom>();
            ArrayList<IGeom> edges = new ArrayList<IGeom>();
            for (Pair<IGeom, IGeom> entry : this.d_roomGeom.values()) {
                faces.add((IGeom)entry.v1);
                edges.add((IGeom)entry.v2);
            }
            ArrayList<IGeom> allRoomGeoms = new ArrayList<IGeom>(faces.size() + edges.size());
            allRoomGeoms.addAll(faces);
            allRoomGeoms.addAll(edges);
            IGeom roomGeom = thunderheadeng.geometry.objs.GeomUtil.group(allRoomGeoms);
            GeomNodeLeaf roomNode = GeomNodeUtil.newNode(roomGeom);
            IGeomNode searchGeom = this.getSearchGeom();
            IGeomNode cadNode = dt == DisplayType.CAD_GEOM ? this.getProp(EgressBlockage.CAD_GEOM).get().node : GeomNodeUtil.EMPTY_NODE;
            return new BlockageGeom(roomNode, searchGeom, cadNode, this.isSearchGeomSettable());
        });
    }

    public IGeomNode getSearchGeom() {
        return this.isSearchGeomSettable() ? this.d_setSearchGeom : this.getLinkedSearchGeom();
    }

    public IGeomNode getSetSearchGeom() {
        return this.d_setSearchGeom;
    }

    public Model getSearchModel() {
        return this.d_searchModel.get(() -> GeomUtil.toNmtModel((MerlinData)this.getDomain(), this.getSearchGeom(), 0));
    }

    @Override
    public Class<? extends IEgressObj>[] getTopoTypes() {
        return new Class[]{EgressRoom.class};
    }

    @Override
    public Collection<? extends IEgressObj> getConnections() {
        return this.d_roomGeom.keySet();
    }

    @Override
    public boolean hasOpenSpots(Class<? extends IEgressObj> type) {
        return true;
    }

    @Override
    public void disconnectFrom(IEgressObj conn) {
        if (this.d_roomGeom.remove(conn) != null) {
            this.changedEvt(true, false, false, false);
        }
    }

    @Override
    public void connectTo(IEgressObj conn) {
        assert (this.d_roomGeom.containsKey(conn));
    }

    @Override
    public void writeTopology(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.d_roomGeom);
    }

    @Override
    public void readTopology(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.d_roomGeom = (Map)ois.readObject();
    }

    @Override
    public boolean updateTopo() {
        MerlinData md = (MerlinData)this.getDomain();
        if (md == null) {
            return true;
        }
        this.d_roomGeom.clear();
        AABox bounds = this.getSearchGeom().getBoundingBox(new AABox());
        Collection<EgressRoom> nearRooms = md.geomLocation.getLocator().find((ITest<AABox>)new AABoxTest(bounds, 1.0E-6), EgressRoom.class, room -> room.getModificationsAllowed(), 1);
        boolean modelOptions = false;
        for (EgressRoom room2 : nearRooms) {
            EgressRoom.RoomBlockageInfo blkgInfo;
            EgressModelGeom geom = this.getModelGeom(room2, blkgInfo = room2.intersectBlockages(Collections.singletonList(this)), 0);
            if (geom == null) continue;
            ArrayList faces = new ArrayList();
            ArrayList edges = new ArrayList();
            geom.getFaceGeom(faces::add);
            geom.getEdgeGeom(edges::add);
            this.d_roomGeom.put(room2, new Pair<IGeom, IGeom>(thunderheadeng.geometry.objs.GeomUtil.group(faces), thunderheadeng.geometry.objs.GeomUtil.group(edges)));
        }
        this.changedEvt(true, false, false, false);
        return true;
    }

    public void getInfernoGeom(Consumer<InfernoGeom> geoms, IMerlinDispProps dprops, EgressRoom room, EgressRoom.RoomBlockageInfo blkgInfo) {
        EgressModelGeom geom = this.getModelGeom(room, blkgInfo, 1);
        if (geom == null) {
            return;
        }
        geoms.accept(new InfernoGeom(this, InfernoType.REMOVABLE, geom, this.getRoomFaceProps(dprops)));
    }

    protected EgressModelGeom getModelGeom(EgressRoom room, EgressRoom.RoomBlockageInfo blkgInfo, int modelOptions) {
        final int faceId = blkgInfo.getFaceId(this);
        if (faceId == -1) {
            return null;
        }
        Model model = blkgInfo.model;
        Predicate<Face> faceFilter = new Predicate<Face>(){

            @Override
            public boolean test(Face o) {
                return o.partOfGroup(faceId);
            }
        };
        Predicate<Edge> edgeFilter = new Predicate<Edge>(){

            @Override
            public boolean test(Edge o) {
                if (o.partOfGroup(1)) {
                    return false;
                }
                int fCount = 0;
                for (Face face : o.faces) {
                    if (!face.partOfGroup(faceId)) continue;
                    ++fCount;
                }
                return fCount == 1;
            }
        };
        return new EgressModelGeom(model, room.getInUseEdgeFilter(), faceFilter, edgeFilter, modelOptions);
    }

    @Override
    public Point3d astarProject(IEgressObj obj, Point3d p) {
        double closestDistSq = Double.MAX_VALUE;
        Point3d closestPoint = null;
        for (Pair<IGeom, IGeom> roomGeom : this.d_roomGeom.values()) {
            for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode((IGeom)roomGeom.v1, IFace.class)) {
                Point3d proj = face.project(p);
                double distSq = proj.distanceSquared(p);
                if (!(distSq < closestDistSq)) continue;
                closestDistSq = distSq;
                closestPoint = proj;
            }
        }
        return closestPoint;
    }

    @Override
    public Point3d astarGetSharedPt(IEgressObj adj) {
        Pair<IGeom, IGeom> roomGeom = this.d_roomGeom.get(adj);
        assert (roomGeom != null);
        if (roomGeom == null) {
            return new Point3d();
        }
        for (IFace face : thunderheadeng.geometry.objs.GeomUtil.explode((IGeom)roomGeom.v1, IFace.class)) {
            if (face instanceof IPolygon) {
                IPolygon poly = (IPolygon)face;
                return poly.getPoint(0, 0);
            }
            thunderheadeng.geometry.objs.Mesh m = face.triangulate(1.0E-6);
            if (m.vertices.length <= 0) continue;
            return m.vertices[0];
        }
        assert (false);
        return new Point3d();
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, (T[])this.d_props.get(MerlinData.MATERIAL));
        DisplayGeom dg = this.getProp(CAD_GEOM).orElse(null);
        if (dg != null) {
            GeomUtil.takeDepSnapshotCadGeom(deps, dg.node, dg.props);
        }
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        DisplayGeom dg;
        this.pauseUpdates();
        IMaterial[] mats = this.d_props.get(MerlinData.MATERIAL);
        if (mats.length > 0) {
            assert (mats.length == 1);
            if (old == mats[0]) {
                this.setProp(MerlinData.MATERIAL, new IMaterial[]{(IMaterial)replacement});
            }
        }
        if ((dg = (DisplayGeom)this.getProp(CAD_GEOM).orElse(null)) != null && (dg = GeomUtil.replaceDependency(md, old, replacement, dg.node, dg.props)) != null) {
            this.setProp(CAD_GEOM, dg);
        }
        this.resumeUpdates();
    }

    static {
        CAD_GEOM_PROPS.addAll(GeomUtil.CAD_GEOM_PROPS);
        ALLOWED_SPEED_MOD_TYPES = Filters.reject(SpeedModifier.Type.CONSTANT);
        DEFAULT_SPEED_MOD = new SpeedModifier(SpeedModifier.Type.FACTOR, new ConstVariant<UnitDouble>(new UnitDouble(0.0, Unit.ONE)));
        DEFAULT_OPACITY = new Opacity(0.5f);
        LINKED_SEARCH_GEOM_IDOF = new IDOF(){

            @Override
            public boolean accept(TransformInfo ti) {
                Predicate<ScaleXform> stest;
                Predicate<RotateXform> rtest;
                Predicate<MirrorXform> mtest;
                if (ti.isIdentity()) {
                    return true;
                }
                Predicate<TranslateXform> ttest = Predicates.alwaysTrue();
                return thunderheadeng.geometry.objs.GeomUtil.testTransforms(ti.xform, ttest, mtest = mir -> theUtil.eq0(mir.plane.z, 1.0E-9), rtest = r -> thunderheadeng.geometry.objs.GeomUtil.isZRotation(r, 1.0E-9), stest = s -> !theUtil.eq0(s.x, 1.0E-6) && !theUtil.eq0(s.y, 1.0E-6) && theUtil.eq(s.z, 1.0, 1.0E-9), o -> o.isIdentity()) || thunderheadeng.geometry.objs.GeomUtil.testTransforms(ti.getMatrix(), ttest, rtest, stest);
            }

            @Override
            public void describeRules(Set<String> rules) {
            }

            public String toString() {
                return "EgressBlock.LINKED_SEARCH_GEOM_IDOF";
            }
        };
    }

    private static class BlkgProp<T>
    extends IPropertySet.Prop<T> {
        public final TriConsumer<EgressBlockage, T, T> markChanges;

        public BlkgProp(Object key, T defVal, TriConsumer<EgressBlockage, T, T> markChanges) {
            super(key, defVal);
            this.markChanges = markChanges;
        }
    }

    public static class BlockageGeom
    extends AGeomNode {
        private static final long serialVersionUID = 1L;
        public final IGeomNode room;
        public final IGeomNode search;
        public final IGeomNode cad;
        public final boolean searchGeomManipulatable;

        public BlockageGeom() {
            this(GeomNodeUtil.EMPTY_NODE, GeomNodeUtil.EMPTY_NODE, GeomNodeUtil.EMPTY_NODE, false);
        }

        public BlockageGeom(IGeomNode roomGeom, IGeomNode searchGeom, IGeomNode cadGeom, boolean searchGeomManipulatable) {
            this(TransformUtil.IDENTITY, roomGeom, searchGeom, cadGeom, searchGeomManipulatable);
        }

        public BlockageGeom(ITransform xform, IGeomNode roomGeom, IGeomNode searchGeom, IGeomNode cadGeom, boolean searchGeomManipulatable) {
            super(xform, EmptyGeom.INSTANCE, Elements.newElements());
            this.room = roomGeom;
            this.search = searchGeom;
            this.cad = cadGeom;
            this.searchGeomManipulatable = searchGeomManipulatable;
        }

        @Override
        public IGeomNode newNode(ITransform xform, IGeom geom, IPropertySet elements, Collection<? extends IGeomNode> children) {
            assert (geom.getNumPrims(7) == 0);
            assert (children.size() == 3);
            Iterator<? extends IGeomNode> childIt = children.iterator();
            return new BlockageGeom(xform, childIt.next(), childIt.next(), childIt.next(), this.searchGeomManipulatable);
        }

        @Override
        public Collection<? extends IGeomNode> getChildren() {
            return Arrays.asList(this.room, this.search, this.cad);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            if (!this.searchGeomManipulatable) {
                return;
            }
            IGeomNode.generateLocalHandles(this.search, handle -> {
                if (handle instanceof IGeomNode.Handle) {
                    handles.accept(new SearchGeomHandle((IGeomNode.Handle)handle));
                }
            });
        }

        public class SearchGeomHandle
        implements IHandle {
            public final IGeomNode.Handle base;

            public SearchGeomHandle(IGeomNode.Handle base) {
                this.base = base;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (obj == null || !obj.getClass().equals(this.getClass())) {
                    return false;
                }
                return ((SearchGeomHandle)obj).base.equals(this.base);
            }

            @Override
            public IGeomNode getGeom() {
                return this.base.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.base.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return this.base.getConstraint(handleLoc);
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
                this.base.begin(handleLoc, constraint);
            }

            @Override
            public Object modify(Point3d newLoc) throws ManipException {
                return this.modifySearch(this.base.modify(newLoc));
            }

            @Override
            public Object end() {
                return this.modifySearch(this.base.end());
            }

            private BlockageGeom modifySearch(IGeomNode newSearch) {
                return new BlockageGeom(BlockageGeom.this.getLocalTransform(), BlockageGeom.this.room, newSearch, BlockageGeom.this.cad, BlockageGeom.this.searchGeomManipulatable);
            }
        }
    }

    public static enum DisplayType {
        NONE(Intl.intl("None"), Intl.intl("The obstacle will not be displayed in Results.")),
        SIMPLE(Intl.intl("Simple"), Intl.intl("The obstacle will be displayed in Results as a polygon extruded up from the nav mesh.")),
        CAD_GEOM(Intl.intl("Imported"), Intl.intl("The obstacle will display imported CAD geometry in Results."));

        public final String name;
        public final String desc;

        private DisplayType(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

