/*
 * Decompiled with CFR 0.152.
 */
package merlin.data.egress.agents;

import java.awt.Component;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import merlin.Intl;
import merlin.MerlinPrefs;
import merlin.data.egress.agents.ResourceAvatar;
import merlin.gui.guiUtil;
import thunderheadeng.io.CopyFile;
import thunderheadeng.io.FilenameManager;

public class AvatarImportUtil {
    public static String importAvatarModel(Component parent, ResourceAvatar.Type type) {
        String importedModelName;
        File srcFile = guiUtil.getOpenFile(parent, MerlinPrefs.AVATAR_IMPORT_DIR_PREF, type.fileFilters);
        if (srcFile == null) {
            return null;
        }
        try {
            String toCopyfileName;
            System.out.println("importing " + srcFile.getAbsolutePath());
            String fileNameWithExtension = srcFile.getName();
            importedModelName = toCopyfileName = FilenameManager.splitFilename(fileNameWithExtension)[0];
            File importDir = ResourceAvatar.getAvatarDirs(true, type).get(0);
            File newFileDir = new File(importDir, toCopyfileName);
            File targetFile = new File(newFileDir, fileNameWithExtension);
            AvatarImportUtil.copyAvatarFile(newFileDir, srcFile, targetFile);
            File newBeaFile = new File(newFileDir, toCopyfileName + ".bea");
            AvatarImportUtil.writeBEAFile(fileNameWithExtension, newBeaFile, type);
            AvatarImportUtil.addPreviewImage(type.defPreviewImg, newFileDir);
            String htmlFriendlyPath = "file:///" + newFileDir.getCanonicalPath();
            String htmlStr = String.format("<p>Files copied to local <a href=%s>directory.</a></p>", htmlFriendlyPath);
            guiUtil.showHTMLMessageDialog(parent, Intl.intl("Import Successful"), htmlStr);
        }
        catch (IOException e) {
            guiUtil.showError(parent, Intl.intl("An error occurred while importing the model."), thunderheadeng.Intl.intl("Import Error"), (Throwable)e);
            return null;
        }
        return importedModelName;
    }

    private static void copyAvatarFile(File newDir, File src, File target) throws IOException {
        if (!newDir.exists()) {
            newDir.mkdirs();
        }
        CopyFile.copy(src, target);
    }

    private static void writeBEAFile(String avatarName, File newBEATarget, ResourceAvatar.Type type) throws IOException {
        String beaFileContents = AvatarImportUtil.getBEAFileText(avatarName, type);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(newBEATarget), "utf-8"));){
            writer.write(beaFileContents);
        }
    }

    private static String getBEAFileText(String fileNameWithExt, ResourceAvatar.Type type) {
        StringBuilder sb = new StringBuilder();
        sb.append("MESH {\n    \"" + fileNameWithExt + "\" 1.0\n}\nANIMATIONS {\n");
        if (type == ResourceAvatar.Type.OCCUPANT) {
            sb.append("    IDLESTAND {\n        \"anims/idle.md5anim\" retarget_to \"anims/base_mesh.md5mesh\" \n    }\n    IDLEWHEELCHAIR{\n        \"anims/wheelchair_idle.md5anim\" retarget_to \"anims/base_mesh.md5mesh\" \n    }\n    IDLEINJURED{\n        \"anims/injured.md5anim\" retarget_to \"anims/base_mesh.md5mesh\" \n    }\n    IDLEBEDFLAT{\n        \"anims/bed2.md5anim\" retarget_to \"anims/base_mesh.md5mesh\"\n    }\n    IDLESEVERELYINJURED{\n        \"anims/injured_severe1a.md5anim\" retarget_to \"anims/base_mesh.md5mesh\" rotate 0 0 1 90\n        \"anims/injured_severe1b.md5anim\" retarget_to \"anims/base_mesh.md5mesh\"  rotate 0 0 1 -90\n        \"anims/injured_severe4a.md5anim\" retarget_to \"anims/base_mesh.md5mesh\"  rotate 0 0 1 90\n        \"anims/injured_severe4b.md5anim\" retarget_to \"anims/base_mesh.md5mesh\"  rotate 0 0 1 -90\n    }\n    MOVEFORWARD {\n        \"anims/walk1.md5anim\" 13 .725 1.1 retarget_to \"anims/base_mesh.md5mesh\" \n        \"anims/walk3.md5anim\" 5 1.800 1.7 retarget_to \"anims/base_mesh.md5mesh\" \n        \"anims/maleRun.md5anim\"   4 3.170 1000 retarget_to \"anims/base_mesh.md5mesh\" \n    }\n    MOVEFORWARDDOWNSTAIRS {\n        \"anims/stairsDown.md5anim\" 1 .530 1000 retarget_to \"anims/base_mesh.md5mesh\" \n    }\n    MOVEFORWARDUPSTAIRS {\n        \"anims/stairsUp.md5anim\" 8 .480 1000 retarget_to \"anims/base_mesh.md5mesh\" \n    }\n    MOVEFORWARDWHEELCHAIR{\n        \"anims/wheelchair.md5anim\" 0 2.5 1000 retarget_to \"anims/base_mesh.md5mesh\" \n    }\n");
        }
        sb.append("}\n");
        return sb.toString();
    }

    private static void addPreviewImage(File defaultPreview, File targetDir) throws IOException {
        File targetFile = new File(targetDir, "preview.png");
        CopyFile.copy(defaultPreview, targetFile);
    }
}

