/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.BiPredicate;
import merlin.Intl;
import merlin.data.Composite;
import merlin.data.MerlinData;
import merlin.data.OccGroupObj;
import merlin.data.egress.agents.OccProfile;
import merlin.util.MerlinUtil;
import org.jscience.physics.units.Unit;
import thunderheadeng.dependencies.DLink;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.ISurrogate;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.NameGenerator;
import thunderheadeng.util.stat.ConstantCurve;
import thunderheadeng.util.stat.ICurve;
import thunderheadeng.util.stat.LogNormCurve;
import thunderheadeng.util.stat.StdNormCurve;
import thunderheadeng.util.stat.UniformCurve;
import thunderheadeng.util.theUtil;

public class OccGroupTypeObj
extends OccGroupObj
implements Serializable,
IDirectDependent<MerlinData>,
ISurrogate {
    static final long serialVersionUID = 1L;
    public static final IPropertySet.Prop<ICurve> PROP_MIN_NUMBER_OF_MEMBERS = new IPropertySet.Prop<ConstantCurve>("OccGroupObj.MIN_NUMBER_OF_MEMBERS", new ConstantCurve(new UnitDouble(1.0, Unit.ONE)));
    public static final IPropertySet.Prop<ICurve> PROP_PREF_NUMBER_OF_MEMBERS = new IPropertySet.Prop<ConstantCurve>("OccGroupObj.PREF_NUMBER_OF_MEMBERS", new ConstantCurve(new UnitDouble(2.0, Unit.ONE)));
    public static final IPropertySet.Prop<Boolean> PROP_ALLOW_SMALLER_GROUPS = new IPropertySet.Prop<Boolean>("OccGroupObj.ALLOW_SMALLER_GROUPS", true);
    public static final IPropertySet.Prop<Boolean> PROP_USE_EXACT_DIST_CALCULATION = new IPropertySet.Prop<Boolean>("OccGroupObj.USE_EXACT_DIST_CALCULATION", true);
    public static final IPropertySet.Prop<UnitDouble> PROP_HEIGHT_MULTIPLIER = new IPropertySet.Prop<UnitDouble>("OccGroupObj.HEIGHT_MULTIPLIER", new UnitDouble(10.0, Unit.ONE));
    public static final IPropertySet.Prop<Map<OccProfile, GroupCreationDataObj>> PROP_PROFILE_DATA = new IPropertySet.Prop("OccGroupObj.PROFILE_DATA", new LinkedHashMap());
    public static final IPropertySet.Prop<Boolean> PROP_SPECIFY_PROFILES = new IPropertySet.Prop<Boolean>("OccGroupObj.SPECIFY_PROFILES", false);
    public static final IPropertySet.Prop<OccProfile> PROP_LEADER_PROFILE = new IPropertySet.Prop<Object>("OccGroupObj.LEADER_PROFILE", null);
    public static final Set<Object> PROP_TYPES = new HashSet(IPropertySet.getAllDeclaredPublicStaticProps(OccGroupTypeObj.class));
    private NameGenerator newGroupNameGenerator;

    public OccGroupTypeObj() {
        this.initNewGroupNameGenerator();
        this.setRandomColor();
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        if (MerlinUtil.test(options, 1)) {
            return PROP_TYPES;
        }
        return super.getPropTypes(options);
    }

    public String createNewGroupName() {
        this.initNewGroupNameGenerator();
        String name = this.newGroupNameGenerator.generateName();
        this.newGroupNameGenerator.registerName(name);
        return name;
    }

    private void initNewGroupNameGenerator() {
        if (this.newGroupNameGenerator != null) {
            return;
        }
        this.newGroupNameGenerator = new NameGenerator(this.getName() + "_");
    }

    @Override
    public OccGroupTypeObj clone() {
        OccGroupTypeObj clone = (OccGroupTypeObj)super.clone();
        clone.newGroupNameGenerator = null;
        clone.initNewGroupNameGenerator();
        return clone;
    }

    public boolean mightCreateNonSingularGroups() {
        OccGroupTypeObj gt = this;
        if (!gt.getProperty(PROP_SPECIFY_PROFILES).booleanValue()) {
            UnitDouble one = new UnitDouble(1.0, Unit.ONE);
            BiPredicate<ICurve, ICurve> testCounts = (pref, min) -> pref != null && pref.getMax().gt(one, 0.0) || min != null && min.getMax().gt(one, 0.0);
            return testCounts.test(gt.getProperty(PROP_PREF_NUMBER_OF_MEMBERS), gt.getProperty(PROP_MIN_NUMBER_OF_MEMBERS));
        }
        Map<OccProfile, GroupCreationDataObj> profData = gt.getProperty(PROP_PROFILE_DATA);
        return profData.values().stream().filter(data -> data.prefNumberOfMembers != null).mapToDouble(data -> data.prefNumberOfMembers.getMax().get(Unit.ONE)).sum() > 1.0 || profData.values().stream().filter(data -> data.minNumberOfMembers != null).mapToDouble(data -> data.minNumberOfMembers.getMax().get(Unit.ONE)).sum() > 1.0;
    }

    public GroupCreationDataObj getGroupCreationData(Random rnd) {
        if (this.getProperty(PROP_SPECIFY_PROFILES).booleanValue()) {
            int prefNumberOfMembers = 0;
            int minNumberOfMembers = 0;
            Map<OccProfile, GroupCreationDataObj> map = this.discretizeCurves(this.getProperty(PROP_PROFILE_DATA));
            LinkedIdentityHashMap<OccProfile, Integer> profPrefCounts = new LinkedIdentityHashMap<OccProfile, Integer>();
            LinkedIdentityHashMap<OccProfile, Integer> profMinCounts = new LinkedIdentityHashMap<OccProfile, Integer>();
            for (OccProfile prof : map.keySet()) {
                GroupCreationDataObj data = map.get(prof);
                int prefNumOfMembers = (int)Math.round(data.prefNumberOfMembers.getValue(rnd).get(Unit.ONE));
                int minNumOfMembers = data.allowSmallerGroups ? Math.min((int)Math.round(data.minNumberOfMembers.getValue(rnd).get(Unit.ONE)), prefNumberOfMembers += prefNumOfMembers) : prefNumOfMembers;
                minNumberOfMembers += minNumOfMembers;
                profPrefCounts.put(prof, prefNumOfMembers);
                profMinCounts.put(prof, minNumOfMembers);
            }
            GroupCreationDataObj data = new GroupCreationDataObj(new ConstantCurve(new UnitDouble(prefNumberOfMembers, Unit.ONE)), prefNumberOfMembers != minNumberOfMembers, new ConstantCurve(new UnitDouble(minNumberOfMembers, Unit.ONE)));
            data.profilePrefCounts = profPrefCounts;
            data.profileMinCounts = profMinCounts;
            return data;
        }
        return new GroupCreationDataObj(this.getProperty(PROP_PREF_NUMBER_OF_MEMBERS), this.getProperty(PROP_ALLOW_SMALLER_GROUPS), this.getProperty(PROP_MIN_NUMBER_OF_MEMBERS));
    }

    private Map<OccProfile, GroupCreationDataObj> discretizeCurves(Map<OccProfile, GroupCreationDataObj> map) {
        if (map == null) {
            return null;
        }
        LinkedHashMap<OccProfile, GroupCreationDataObj> newMap = new LinkedHashMap<OccProfile, GroupCreationDataObj>();
        for (OccProfile prof : map.keySet()) {
            GroupCreationDataObj data = map.get(prof);
            ICurve prefNumberOfMembers = OccGroupTypeObj.discretizeCurve(data.prefNumberOfMembers);
            ICurve minNumberOfMembers = OccGroupTypeObj.discretizeCurve(data.minNumberOfMembers);
            GroupCreationDataObj newData = new GroupCreationDataObj(prefNumberOfMembers, data.allowSmallerGroups, minNumberOfMembers);
            newMap.put(prof, newData);
        }
        return newMap;
    }

    private static ICurve discretizeCurve(ICurve curve) {
        if (curve == null) {
            return null;
        }
        if (curve instanceof ConstantCurve) {
            return curve;
        }
        Unit unit = curve.getAvg().getUnit();
        double min = curve.getMin().get(unit);
        double max = curve.getMax().get(unit);
        min = min == Math.floor(min) ? min - 0.5 : Math.floor(min) + 0.5;
        max = Math.floor(max) + 0.5;
        UnitDouble minUD = new UnitDouble(min, unit);
        UnitDouble maxUD = new UnitDouble(max, unit);
        if (curve instanceof UniformCurve) {
            return new UniformCurve(minUD, maxUD);
        }
        if (curve instanceof StdNormCurve) {
            return new StdNormCurve(minUD, maxUD, curve.getAvg(), ((StdNormCurve)curve).getStdDev());
        }
        if (curve instanceof LogNormCurve) {
            return new LogNormCurve(minUD, maxUD, curve.getAvg(), ((LogNormCurve)curve).getStdDev());
        }
        assert (false);
        return null;
    }

    @Override
    public void setName(String name) {
        this.initNewGroupNameGenerator();
        this.newGroupNameGenerator.setBaseName(name + "_");
        super.setName(name);
    }

    public Set<OccProfile> getAllProfiles() {
        if (!this.getProperty(PROP_SPECIFY_PROFILES).booleanValue()) {
            return Collections.emptySet();
        }
        LinkedHashSet<OccProfile> allProfiles = new LinkedHashSet<OccProfile>();
        Map<OccProfile, GroupCreationDataObj> profileData = this.getProperty(PROP_PROFILE_DATA);
        for (Map.Entry<OccProfile, GroupCreationDataObj> entry : profileData.entrySet()) {
            double maxCount = entry.getValue().prefNumberOfMembers.getMax().get(Unit.ONE);
            if (!theUtil.gt0(maxCount, 0.0)) continue;
            allProfiles.add(entry.getKey());
        }
        return allProfiles;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        deps.add(DLink.WEAK, this.getProperty(PROP_LEADER_PROFILE));
        deps.add(DLink.WEAK, this.getProperty(PROP_PROFILE_DATA).keySet());
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        assert (old != null);
        Map<OccProfile, GroupCreationDataObj> profileData = this.getProperty(PROP_PROFILE_DATA);
        if (old instanceof OccProfile) {
            if (((OccProfile)old).surrogateEquals(this.getProperty(PROP_LEADER_PROFILE))) {
                this.setProperty((Object)PROP_LEADER_PROFILE, replacement);
            }
            if (profileData.get(old) != null) {
                profileData.put((OccProfile)replacement, profileData.get(old));
                profileData.remove(old);
            }
        }
        this.setProperty(PROP_PROFILE_DATA, profileData);
    }

    @Override
    public boolean surrogateEquals(Object comparable) {
        if (comparable == this) {
            return true;
        }
        if (comparable == null || !comparable.getClass().equals(this.getClass())) {
            return false;
        }
        OccGroupTypeObj occGroupTypeObj = (OccGroupTypeObj)comparable;
        return Objects.equals(this.getName(), occGroupTypeObj.getName()) && theUtil.equal(this.getProperty(PROP_LEADER_PROFILE), occGroupTypeObj.getProperty(PROP_LEADER_PROFILE)) && theUtil.surrogateMapsEqual(this.getProperty(PROP_PROFILE_DATA), occGroupTypeObj.getProperty(PROP_PROFILE_DATA), false) && Objects.equals(this.getProperty(PROP_MIN_NUMBER_OF_MEMBERS), occGroupTypeObj.getProperty(PROP_MIN_NUMBER_OF_MEMBERS)) && Objects.equals(this.getProperty(PROP_PREF_NUMBER_OF_MEMBERS), occGroupTypeObj.getProperty(PROP_PREF_NUMBER_OF_MEMBERS)) && Objects.equals(this.getProperty(PROP_HEIGHT_MULTIPLIER), occGroupTypeObj.getProperty(PROP_HEIGHT_MULTIPLIER)) && Objects.equals(this.getProperty(PROP_ALLOW_SMALLER_GROUPS), occGroupTypeObj.getProperty(PROP_ALLOW_SMALLER_GROUPS)) && Objects.equals(this.getProperty(PROP_USE_EXACT_DIST_CALCULATION), occGroupTypeObj.getProperty(PROP_USE_EXACT_DIST_CALCULATION)) && Objects.equals(this.getProperty(PROP_SPECIFY_PROFILES), occGroupTypeObj.getProperty(PROP_SPECIFY_PROFILES));
    }

    static {
        PROP_TYPES.addAll(IPropertySet.getAllDeclaredPublicStaticProps(OccGroupObj.class));
    }

    public static class OccGroupTypeComp
    extends Composite<OccGroupTypeObj> {
        static final long serialVersionUID = 4200385297076337319L;
        public OccGroupTypeObj NO_GROUP_TYPE;

        public OccGroupTypeComp() {
            this(Intl.intl("Movement Group Templates"));
        }

        public OccGroupTypeComp(String name) {
            super(name);
            this.initNoGroupType();
        }

        public void initNoGroupType() {
            this.NO_GROUP_TYPE = new OccGroupTypeObj();
            this.NO_GROUP_TYPE.setName(Intl.intl("Ungrouped"));
            this.NO_GROUP_TYPE.setProperty(PROP_PREF_NUMBER_OF_MEMBERS, new ConstantCurve(new UnitDouble(1.0, Unit.ONE)));
        }

        @Override
        public Composite<?> newGroup(String name) {
            return new OccGroupTypeComp(name);
        }

        @Override
        public Object getProperty(Object property) {
            if (property == OccGroupObj.PROP_NAME) {
                return this.getName();
            }
            return super.getProperty(property);
        }

        @Override
        public String getNewGroupName() {
            return Intl.intl("Movement Group Template Group");
        }

        @Override
        public void loadFrom(Composite<OccGroupTypeObj> obj) {
            assert (obj instanceof OccGroupTypeComp);
            this.loadFrom((OccGroupTypeComp)obj);
        }

        public void loadFrom(OccGroupTypeComp root) {
            this.pauseUpdates();
            super.loadFrom(root);
            this.NO_GROUP_TYPE = root.NO_GROUP_TYPE;
            if (this.NO_GROUP_TYPE == null) {
                this.initNoGroupType();
            }
            this.resumeUpdates();
        }
    }

    public static class GroupCreationDataObj
    implements Serializable,
    ISurrogate,
    IDirectDependent<MerlinData> {
        static final long serialVersionUID = 1L;
        public final ICurve prefNumberOfMembers;
        public final boolean allowSmallerGroups;
        public final ICurve minNumberOfMembers;
        public Map<OccProfile, Integer> profilePrefCounts;
        public Map<OccProfile, Integer> profileMinCounts;

        public GroupCreationDataObj(ICurve prefNumberOfMembers, boolean allowSmallerGroups, ICurve minNumberOfMembers) {
            this.prefNumberOfMembers = prefNumberOfMembers;
            this.allowSmallerGroups = allowSmallerGroups;
            this.minNumberOfMembers = minNumberOfMembers;
        }

        public GroupCreationDataObj(OccGroupTypeObj dataObj) {
            this.prefNumberOfMembers = dataObj.getProperty(PROP_PREF_NUMBER_OF_MEMBERS);
            this.allowSmallerGroups = dataObj.getProperty(PROP_ALLOW_SMALLER_GROUPS);
            this.minNumberOfMembers = dataObj.getProperty(PROP_MIN_NUMBER_OF_MEMBERS);
            this.profilePrefCounts = null;
        }

        public GroupCreationDataObj(OccProfile prof) {
            this.prefNumberOfMembers = new ConstantCurve(new UnitDouble(0.0, Unit.ONE));
            this.allowSmallerGroups = false;
            this.minNumberOfMembers = new ConstantCurve(new UnitDouble(0.0, Unit.ONE));
            this.profilePrefCounts = null;
        }

        @Override
        public void takeDepSnapshot(DepList deps) {
            if (this.profilePrefCounts != null) {
                deps.add(DLink.WEAK, this.profilePrefCounts.keySet());
            }
            if (this.profileMinCounts != null) {
                deps.add(DLink.WEAK, this.profileMinCounts.keySet());
            }
        }

        @Override
        public void replaceDependency(MerlinData md, Object old, Object replacement) {
            assert (old != null);
            if (old instanceof OccProfile) {
                if (this.profilePrefCounts.get(old) != null) {
                    this.profilePrefCounts.put((OccProfile)replacement, this.profilePrefCounts.get(old));
                    this.profilePrefCounts.remove(old);
                }
                if (this.profileMinCounts.get(old) != null) {
                    this.profilePrefCounts.put((OccProfile)replacement, this.profilePrefCounts.get(old));
                    this.profilePrefCounts.remove(old);
                }
            }
        }

        @Override
        public boolean surrogateEquals(Object comparable) {
            if (comparable == this) {
                return true;
            }
            if (comparable == null || !comparable.getClass().equals(this.getClass())) {
                return false;
            }
            GroupCreationDataObj creationDataObj = (GroupCreationDataObj)comparable;
            return Objects.equals(this.prefNumberOfMembers, creationDataObj.prefNumberOfMembers) && Objects.equals(this.minNumberOfMembers, creationDataObj.minNumberOfMembers) && this.allowSmallerGroups == creationDataObj.allowSmallerGroups && theUtil.surrogateMapsEqual(this.profilePrefCounts, creationDataObj.profilePrefCounts, false) && theUtil.surrogateMapsEqual(this.profileMinCounts, creationDataObj.profileMinCounts, false);
        }
    }
}

