/*
 * Decompiled with CFR 0.152.
 */
package merlin.data;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Set;
import javax.vecmath.Vector3d;
import merlin.data.ICompElement;
import merlin.data.IRestorable;
import merlin.data.ImportType;
import merlin.data.MerlinData;
import merlin.data.NamedMerlinObj;
import merlin.geom.GeomUtil;
import merlin.geom.IMerlinGeomSrc;
import merlin.io.MerlinIO;
import merlin.io.MerlinOIS;
import thunderheadeng.cad.bim.BIMCoveringType;
import thunderheadeng.cad.bim.BIMTransportType;
import thunderheadeng.cad.bim.BIMType;
import thunderheadeng.dependencies.DepList;
import thunderheadeng.dependencies.IDirectDependent;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.PropertySet;
import thunderheadeng.util.Sets;

public class ImportedGeom
extends NamedMerlinObj
implements IMerlinGeomSrc,
ICompElement,
IRestorable,
IDirectDependent<MerlinData> {
    static final long serialVersionUID = 1L;
    @Deprecated
    private static final int OPT_EXCLUDE_FROM_ROOM_EXTRACTION = 1;
    public static final Object PROP_OPTIONS = "OPTIONS";
    public static final Object PROP_MATERIAL = MerlinData.MATERIAL;
    public static final Object PROP_DISPLAY_PROPS = "DISPLAY_PROPS";
    public static final Object PROP_GEOM = "GEOM";
    public static final IPropertySet.Prop<BIMType> PROP_BIM_TYPE = new IPropertySet.Prop<BIMType>("BIM_TYPE", BIMType.UNKNOWN);
    public static final IPropertySet.Prop<String> PROP_OBJECT_TYPE = new IPropertySet.Prop<String>("OBJECT_TYPE", "");
    public static final IPropertySet.Prop<ImportType> PROP_IMPORTED_TYPE = new IPropertySet.Prop<ImportType>("IMPORTED_TYPE", ImportType.OBSTRUCTION);
    public static final IPropertySet.Prop<UnitDouble> PROP_DOOR_WIDTH = new IPropertySet.Prop<Object>("DOOR_WIDTH", null);
    public static final IPropertySet.Prop<UnitDouble> PROP_DOOR_HEIGHT = new IPropertySet.Prop<Object>("DOOR_HEIGHT", null);
    public static final IPropertySet.Prop<IGeomNode> PROP_DOOR_VOID = new IPropertySet.Prop<Object>("DOOR_VOID", null);
    public static final IPropertySet.Prop<Vector3d> PROP_DOOR_DIR = new IPropertySet.Prop<Object>("DOOR_DIR", null);
    public static final IPropertySet.Prop<Boolean> PROP_DOOR_IS_ACCESSIBLE = new IPropertySet.Prop<Object>("DOOR_IS_ACCESSIBLE", null);
    public static final IPropertySet.Prop<UnitDouble> PROP_DOOR_FLOWRATE = new IPropertySet.Prop<Object>("DOOR_FLOWRATE", null);
    public static final IPropertySet.Prop<BIMCoveringType> PROP_COVERING_TYPE = new IPropertySet.Prop<BIMCoveringType>("PROP_COVERING_TYPE", BIMCoveringType.UNKNOWN);
    public static final IPropertySet.Prop<BIMTransportType> PROP_TRANSPORT_TYPE = new IPropertySet.Prop<BIMTransportType>("PROP_TRANSPORT_TYPE", BIMTransportType.UNKNOWN);
    public static final IPropertySet.Prop<Integer> PROP_SPACE_OCCUPANCY_NUMBER = new IPropertySet.Prop<Object>("SPACE_OCCUPANCY_NUMBER", null);
    public static final IPropertySet.Prop<UnitDouble> PROP_SPACE_AREA_PER_OCCUPANT = new IPropertySet.Prop<Object>("SPACE_AREA_PER_OCCUPANT", null);
    public static final IPropertySet.Prop<Integer> PROP_SPACE_OCCUPANCY_NUMBER_PEAK = new IPropertySet.Prop<Object>("SPACE_OCCUPANCY_NUMBER_PEAK", null);
    public static final IPropertySet.Prop<String> PROP_BUILDING_PRE_EVACUATION_TIME = new IPropertySet.Prop<Object>("BUILDING_PRE_EVACUATION_TIME", null);
    public static final IPropertySet.Prop<String> PROP_BUILDING_OCC_PROFILES_LIST = new IPropertySet.Prop<Object>("BUILDING_OCC_PROFILES_LIST", null);
    public static final Set<Object> PROP_TYPES = Sets.fromArrayLHS(MerlinData.VISIBILITY, NamedMerlinObj.NAME, PROP_OPTIONS, PROP_MATERIAL, PROP_GEOM, PROP_BIM_TYPE, PROP_OBJECT_TYPE, PROP_IMPORTED_TYPE, PROP_DOOR_WIDTH, PROP_DOOR_HEIGHT, PROP_DOOR_VOID, PROP_DOOR_IS_ACCESSIBLE, PROP_DOOR_FLOWRATE, PROP_COVERING_TYPE, PROP_TRANSPORT_TYPE, PROP_SPACE_OCCUPANCY_NUMBER, PROP_SPACE_AREA_PER_OCCUPANT, PROP_SPACE_OCCUPANCY_NUMBER_PEAK, PROP_BUILDING_PRE_EVACUATION_TIME, PROP_BUILDING_OCC_PROFILES_LIST, MerlinData.COLOR, MerlinData.OPACITY);
    private Object d_geom;
    private IPropsSrc d_propsSrc;
    private Object d_uv;
    private int d_options;
    private boolean d_visible;
    private BIMType d_bimType;
    private PropertySet d_props;

    public ImportedGeom(String name) {
        this(name, DisplayGeom.EMPTY);
    }

    public ImportedGeom(String name, DisplayGeom dg) {
        this(name, dg.node, dg.props);
    }

    public ImportedGeom(String name, IGeomNode geom, IPropsSrc propsSrc) {
        super(name);
        this.d_geom = geom;
        this.d_propsSrc = propsSrc;
        this.d_visible = true;
        this.d_options = 0;
        this.d_bimType = BIMType.UNKNOWN;
        this.d_props = new PropertySet();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        boolean prior110 = MerlinOIS.isPrior(in, MerlinIO.Version.VER_0110);
        if (this.d_uv == null && prior110) {
            this.d_uv = Elements.NO_UV;
        }
        if (prior110) {
            IElemSource uvSrc = (IElemSource)this.d_uv;
            this.d_uv = null;
            if (this.d_geom instanceof IGeom) {
                this.d_geom = GeomNodeUtil.newNode((IGeom)this.d_geom, Elements.NONE);
            } else assert (this.d_geom instanceof IGeomNode);
            if (uvSrc != Elements.NO_UV) {
                IElemSource uv = uvSrc;
                this.d_geom = ((IGeomNode)this.d_geom).applyUVElements("uvset", (pix, oldUV) -> uv.getPrimSource((int)pix));
            }
            this.d_geom = ((IGeomNode)this.d_geom).prune();
        }
        if (this.d_bimType == null) {
            this.d_bimType = BIMType.UNKNOWN;
        }
        if (this.d_props == null) {
            this.d_props = new PropertySet();
        }
        if (MerlinOIS.isPrior(in, MerlinIO.Version.VER_0133)) {
            if ((this.d_options & 1) == 1) {
                this.setImportedType(ImportType.IGNORED);
                this.d_options &= 0xFFFFFFFE;
            } else {
                this.setImportedType(this.getImportedTypeFromBIMType());
            }
        }
    }

    public ImportType getImportedTypeFromBIMType() {
        switch (this.d_bimType) {
            case Ramp: 
            case RampFlight: {
                return ImportType.RAMP;
            }
            case Slab: {
                return ImportType.FLOOR;
            }
            case Covering: {
                return this.get(PROP_COVERING_TYPE) == BIMCoveringType.FLOORING ? ImportType.FLOOR : ImportType.OBSTRUCTION;
            }
            case Stair: 
            case StairFlight: {
                return ImportType.STAIR;
            }
            case Door: {
                return ImportType.DOOR;
            }
            case TransportElement: {
                switch (this.get(PROP_TRANSPORT_TYPE)) {
                    case ESCALATOR: {
                        return ImportType.ESCALATOR;
                    }
                    case MOVINGWALKWAY: {
                        return ImportType.MOVING_WALKWAY;
                    }
                }
                return ImportType.OBSTRUCTION;
            }
            case Space: {
                return this.getDisplayGeom().node == DisplayGeom.EMPTY.node ? ImportType.IGNORED : ImportType.ROOM;
            }
            case Building: {
                return ImportType.BUILDING;
            }
        }
        return this.isA(BIMType.Element) || this.isA(BIMType.UNKNOWN) ? ImportType.OBSTRUCTION : ImportType.IGNORED;
    }

    public void setBIMType(BIMType type) {
        if (this.d_bimType == type) {
            return;
        }
        this.d_bimType = type;
        this.changedEvt(new Object[0]);
    }

    public BIMType getBIMType() {
        return this.d_bimType;
    }

    public ImportType getImportedType() {
        return this.get(PROP_IMPORTED_TYPE);
    }

    public void setImportedType(ImportType type) {
        this.set(PROP_IMPORTED_TYPE, type);
    }

    public <T> void set(IPropertySet.Prop<T> prop, T val) {
        if (prop == PROP_BIM_TYPE) {
            this.setBIMType((BIMType)((Object)val));
            return;
        }
        this.d_props.set(prop, val);
        this.changedEvt(prop);
    }

    public <T> T get(IPropertySet.Prop<T> prop) {
        if (prop == PROP_BIM_TYPE) {
            return (T)((Object)this.getBIMType());
        }
        return this.d_props.get(prop);
    }

    public boolean isA(BIMType type) {
        return type.isAncestorOf(this.getBIMType());
    }

    public boolean isA(ImportType type) {
        return this.getImportedType() == type;
    }

    public boolean isIgnoredInModelGeneration() {
        return this.getImportedType() == ImportType.IGNORED;
    }

    public void setOptions(boolean state, int options) {
        int newOpts;
        int n = newOpts = state ? this.d_options | options : this.d_options & ~options;
        if (newOpts == this.d_options) {
            return;
        }
        this.d_options = newOpts;
        this.changedEvt(new Object[0]);
    }

    public boolean getOptions(int options) {
        return (this.d_options & options) == options;
    }

    @Override
    public ImportedGeom clone() {
        ImportedGeom clone = (ImportedGeom)super.clone();
        clone.d_props = this.d_props.clone();
        return clone;
    }

    @Override
    public void restoreFrom(Object obj) {
        if (!(obj instanceof ImportedGeom)) {
            return;
        }
        ImportedGeom ig = (ImportedGeom)obj;
        this.pauseUpdates();
        this.setName(ig.getName());
        this.d_geom = ig.d_geom;
        this.d_propsSrc = ig.d_propsSrc;
        this.d_visible = ig.d_visible;
        this.d_bimType = ig.d_bimType;
        this.d_props = ig.d_props;
        this.resumeUpdates();
    }

    @Override
    public Object getRestoreObj() {
        return this.clone();
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        return new DisplayGeom((IGeomNode)this.d_geom, this.d_propsSrc);
    }

    public DisplayGeom getDisplayGeom() {
        return this.getDisplayGeom(null);
    }

    public void setDisplayGeom(DisplayGeom dg) {
        this.pauseUpdates();
        this.setGeom(dg.node);
        this.setDisplayProps(dg.props);
        this.resumeUpdates();
    }

    @Override
    public DisplayGeom getPickGeom(IDisplayProps dispProps, Runnable validateProgress) {
        IGeomNode pickable = this.getGeom().getPickable(validateProgress, dispProps.isWireframe(this));
        return new DisplayGeom(pickable, this.d_propsSrc);
    }

    @Override
    public IGeomNode getGeom() {
        return (IGeomNode)this.d_geom;
    }

    @Override
    public void setGeom(IGeomNode geom) {
        if (this.d_geom == geom) {
            return;
        }
        this.d_geom = geom;
        this.changedEvt(new Object[0]);
    }

    public void setDisplayProps(IPropsSrc props) {
        if (this.d_propsSrc == props) {
            return;
        }
        this.d_propsSrc = props;
        this.changedEvt(new Object[0]);
    }

    public IPropsSrc getDisplayProps() {
        return this.d_propsSrc;
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.d_visible = visible;
        this.changedEvt(MerlinData.VISIBILITY);
    }

    @Override
    public Set<Object> getPropTypes(int options) {
        return PROP_TYPES;
    }

    @Override
    public Object getProperty(Object property) {
        if (property == MerlinData.VISIBILITY) {
            return this.isVisible();
        }
        if (property == NamedMerlinObj.NAME) {
            return this.getName();
        }
        if (property == PROP_OPTIONS) {
            return this.d_options;
        }
        if (property == PROP_DISPLAY_PROPS) {
            return this.getDisplayProps();
        }
        if (property == PROP_GEOM) {
            return this.getGeom();
        }
        if (GeomUtil.CAD_GEOM_PROPS.contains(property)) {
            return GeomUtil.getCadGeomProp(this.getGeom(), this.d_propsSrc, property);
        }
        if (property instanceof IPropertySet.Prop) {
            return this.get((IPropertySet.Prop)property);
        }
        return NOT_SUPPORTED;
    }

    @Override
    public <T> void setProperty(Object property, T value) {
        if (property == MerlinData.VISIBILITY) {
            this.setVisible((Boolean)value);
        } else if (property == NamedMerlinObj.NAME) {
            this.setName((String)value);
        } else if (property == PROP_OPTIONS) {
            int options = (Integer)value;
            if (options != this.d_options) {
                this.d_options = options;
                this.changedEvt(new Object[0]);
            }
        } else if (property == PROP_DISPLAY_PROPS) {
            this.setDisplayProps((IPropsSrc)value);
        } else if (property == PROP_GEOM) {
            this.setGeom((IGeomNode)value);
        } else if (GeomUtil.CAD_GEOM_PROPS.contains(property)) {
            DisplayGeom dg = GeomUtil.setCadGeomProp(this.getGeom(), this.d_propsSrc, property, value);
            assert (dg != null);
            this.setDisplayGeom(dg);
        } else if (property instanceof IPropertySet.Prop) {
            this.set((IPropertySet.Prop)property, value);
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        GeomUtil.takeDepSnapshotCadGeom(deps, this.getGeom(), this.d_propsSrc);
    }

    @Override
    public void replaceDependency(MerlinData md, Object old, Object replacement) {
        DisplayGeom dg = GeomUtil.replaceDependency(md, old, replacement, this.getGeom(), this.d_propsSrc);
        if (dg != null) {
            this.setDisplayGeom(dg);
        }
    }
}

