/*
 * Decompiled with CFR 0.152.
 */
package merlin.builders;

import java.awt.Component;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import merlin.Intl;
import merlin.MerlinApp;
import merlin.actions.AMerlinOp;
import merlin.actions.UIHook;
import merlin.actions.Undo;
import merlin.builders.CorridorUtil;
import merlin.builders.NewCompUtil;
import merlin.data.MerlinData;
import merlin.data.egress.geom.EgressCorridor;
import merlin.data.egress.geom.IEgressOccupiable;
import merlin.geom.Geometry;
import merlin.util.MerlinProps;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import thunderheadeng.units.UnitDouble;

public abstract class CorridorBuilder
extends MerlinProps {
    public static final Object NAME_CHANGED = "CorrBuilder.NAME_CHANGED";
    public static final Object COMPLETED = "CorrBuilder.COMPLETED";
    public static final Object CANCELLED = "CorrBuilder.CANCELLED";
    public static final Object WIDTH_CHANGED = "CorrBuilder.WIDTH_CHANGED";
    public static final Object DOOR1_WIDTH_CHANGED = "CorrBuilder.DOOR1_WIDTH_CHANGED";
    public static final Object DOOR2_WIDTH_CHANGED = "CorrBuilder.DOOR2_WIDTH_CHANGED";
    public static final Object POINT_SET = "CorrBuilder.POINT_SET";
    public static final Object TERM_CRITERIA_CHANGED = "CorrBuilder.TERM_CRITERIA_CHANGED";
    public static final Object[] VALIDITY_CHANGES = new Object[]{WIDTH_CHANGED, POINT_SET, TERM_CRITERIA_CHANGED};
    protected final MerlinData d_data;
    public final Mode d_mode;
    private UnitDouble d_width;
    private UnitDouble d_door1Width;
    private UnitDouble d_door2Width;
    private UnitDouble d_maxEdgeAngle;
    private int d_pointIx;
    private Point3d[] d_points;
    private CorridorUtil.ITermCriteria d_termCriteria;
    protected EgressCorridor d_corr = null;

    public CorridorBuilder(MerlinData data, Mode mode, CorridorUtil.ITermCriteria defCriteria) {
        this.d_data = data;
        this.d_mode = mode;
        this.d_width = new UnitDouble(48.0, NonSI.INCH);
        this.d_maxEdgeAngle = CorridorUtil.DEF_MAX_EDGE_ANGLE;
        this.d_door1Width = this.d_door2Width = EgressCorridor.DOOR_STAIR_WIDTH;
        this.d_pointIx = 0;
        this.d_points = new Point3d[3];
        this.d_termCriteria = defCriteria;
    }

    protected CorridorUtil.IBoundaryGen getBoundaryGen() {
        return new CorridorUtil.SlopedBoundaryGen(0.0);
    }

    protected EgressCorridor build(EgressCorridor.CorridorGeom geom, IEgressOccupiable room1, IEgressOccupiable room2) {
        return new EgressCorridor(Intl.intl("Corridor"), room1, room2, geom);
    }

    protected abstract String getActionName();

    protected abstract String generateNextName(MerlinData var1);

    public Mode getMode() {
        return this.d_mode;
    }

    public EgressCorridor build() {
        if (this.d_corr == null) {
            this.d_data.beginRead();
            CorridorUtil.SearchResult search = this.d_mode == Mode.ONE_POINT ? this.findOnePoint() : this.findTwoPoint();
            this.d_data.endRead();
            if (search == null) {
                this.d_corr = null;
            } else {
                this.d_corr = this.build(search.geom, search.room1, search.room2);
                this.d_corr.getDoor1().setWidth(this.d_door1Width);
                this.d_corr.getDoor2().setWidth(this.d_door2Width);
            }
        }
        return this.d_corr;
    }

    private CorridorUtil.SearchResult findOnePoint() {
        if (this.d_points[0] != null && this.d_points[1] != null) {
            return CorridorUtil.findCorr(this.d_data, this.d_points[0], this.d_points[1], 1.0E-6, this.d_termCriteria, this.getBoundaryGen(), 0);
        }
        if (this.d_points[0] != null) {
            return CorridorUtil.findCorr(this.d_data, this.d_points[0], this.d_width, 1.0E-6, this.d_termCriteria, this.getBoundaryGen(), 0);
        }
        return null;
    }

    private CorridorUtil.SearchResult findTwoPoint() {
        if (this.d_points[0] != null && this.d_points[2] != null) {
            Predicate<CorridorUtil.SearchResult> corrTest = r -> r.geom.boundary.length == 4;
            if (this.d_points[1] == null) {
                return CorridorUtil.findCorr(this.d_data, this.d_points[0], this.d_points[2], this.d_width, this.d_maxEdgeAngle.getValue(SI.RADIAN), 1.0E-6, true, 0, corrTest);
            }
            return CorridorUtil.findCorr(this.d_data, this.d_points[0], this.d_points[1], this.d_points[2], this.d_maxEdgeAngle.getValue(SI.RADIAN), 1.0E-6, true, 0, corrTest);
        }
        return null;
    }

    private void reset() {
        if (this.d_mode == Mode.TWO_POINT) {
            this.d_pointIx = 0;
            Arrays.fill(this.d_points, null);
        }
        this.markDirty();
    }

    public int getCurrentStep() {
        return this.d_pointIx;
    }

    public void cancel() {
        this.reset();
        this.firePropChanged(CANCELLED);
    }

    private boolean isValidIndex(int index) {
        return index >= 0 && this.d_mode == Mode.ONE_POINT && index <= 1 || this.d_mode == Mode.TWO_POINT && index <= 2;
    }

    public Point3d getPoint(int index) {
        assert (this.isValidIndex(index));
        return this.d_points[index];
    }

    public void setPoint(int index, Point3d p, boolean commit) {
        if (!this.lock()) {
            return;
        }
        assert (this.isValidIndex(index));
        Point3d point3d = this.d_points[index] = p == null ? null : new Point3d(p);
        if (commit) {
            this.commitLastPoint();
        }
        this.markDirty();
        this.firePropChanged(POINT_SET);
        this.release();
    }

    public void commitLastPoint() {
        this.d_pointIx = (this.d_pointIx + 1) % this.d_points.length;
    }

    protected void markDirty() {
        this.d_corr = null;
    }

    public boolean isValid() {
        return this.build() != null;
    }

    public UnitDouble getWidth() {
        return this.d_width;
    }

    public void setWidth(UnitDouble width) {
        if (!this.lock()) {
            return;
        }
        this.pause();
        this.d_width = width;
        this.markDirty();
        this.firePropChanged(WIDTH_CHANGED);
        this.release();
        if (this.d_door1Width != EgressCorridor.DOOR_STAIR_WIDTH && this.d_door1Width.compareTo(this.d_width.abs()) > 0) {
            this.setDoor1Width(this.d_width.abs());
        }
        if (this.d_door2Width != EgressCorridor.DOOR_STAIR_WIDTH && this.d_door2Width.compareTo(this.d_width.abs()) > 0) {
            this.setDoor2Width(this.d_width.abs());
        }
        this.resume();
    }

    public UnitDouble getDoor1Width() {
        return this.d_door1Width;
    }

    public void setDoor1Width(UnitDouble width) {
        if (width != EgressCorridor.DOOR_STAIR_WIDTH && width.compareTo(this.d_width.abs()) > 0) {
            width = this.d_width.abs();
        }
        this.setProperty(CorridorBuilder.class, "d_door1Width", width, true, DOOR1_WIDTH_CHANGED);
    }

    public UnitDouble getDoor2Width() {
        return this.d_door2Width;
    }

    public void setDoor2Width(UnitDouble width) {
        if (width != EgressCorridor.DOOR_STAIR_WIDTH && width.compareTo(this.d_width.abs()) > 0) {
            width = this.d_width.abs();
        }
        this.setProperty(CorridorBuilder.class, "d_door2Width", width, true, DOOR2_WIDTH_CHANGED);
    }

    protected void setProperty(Class<? extends CorridorBuilder> clazz, String fieldName, Object value, boolean dirty, Object changeFlag) {
        if (!this.lock()) {
            return;
        }
        try {
            Field field = clazz.getDeclaredField(fieldName);
            boolean acc = field.isAccessible();
            field.setAccessible(true);
            field.set(this, value);
            field.setAccessible(acc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (dirty) {
            this.markDirty();
        }
        this.firePropChanged(changeFlag);
        this.release();
    }

    public void finish(Component e) {
        final EgressCorridor corr = this.build();
        if (corr == null) {
            return;
        }
        corr.setName(this.generateNextName(this.d_data));
        AMerlinOp op = new AMerlinOp(){

            @Override
            public void run(MerlinApp app, MerlinData md) {
                md.beginWrite();
                try {
                    Undo.begin(CorridorBuilder.this.getActionName());
                    NewCompUtil.addEgressComp(md, corr);
                    Undo.end(md);
                }
                finally {
                    md.endWrite();
                }
            }
        };
        UIHook.run(e, "CorridorBuilder.finish", op, 4);
        this.reset();
        this.resetShifts();
        this.firePropChanged(COMPLETED);
    }

    protected void resetShifts() {
        this.setWidth(this.getWidth().abs());
    }

    public CorridorUtil.ITermCriteria getTermCriteria() {
        return this.d_termCriteria;
    }

    public void setTermCriteria(CorridorUtil.ITermCriteria crit) {
        this.setProperty(CorridorBuilder.class, "d_termCriteria", crit, true, TERM_CRITERIA_CHANGED);
    }

    public boolean areStartPointsValid3() {
        if (this.d_points[0] == null || this.d_points[1] == null) {
            return false;
        }
        this.d_data.beginRead();
        try {
            boolean bl = !CorridorUtil.getValidStartingSegs(this.d_data, this.d_points[0], this.d_points[1], 1.0E-6, 0).isEmpty();
            return bl;
        }
        finally {
            this.d_data.endRead();
        }
    }

    public Point3d[] getStartPoints3() {
        if (this.d_points[0] == null || this.d_points[1] == null) {
            return null;
        }
        return new Point3d[]{this.d_points[0], this.d_points[1]};
    }

    public Point3d[] getStartPoints2() {
        if (this.d_points[0] == null) {
            return null;
        }
        this.d_data.beginRead();
        try {
            Point3d[] point3dArray = CorridorUtil.getBeginningPointsFromSide(this.d_data, this.d_points[0], this.getWidth().getValue(Geometry.LENGTH_UNIT), true, 0);
            return point3dArray;
        }
        finally {
            this.d_data.endRead();
        }
    }

    public static enum Mode {
        ONE_POINT,
        TWO_POINT;

    }
}

